/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.util.AMAuthUtils;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AuthenticateToRealmCondition
implements Condition {
    private static final Debug DEBUG = Debug.getInstance("amPolicy");
    private static final boolean debugMessageEnabled = DEBUG.messageEnabled();
    public static final String AUTHENTICATE_TO_REALM_CONDITION_ADVICE = "AuthenticateToRealmConditionAdvice";
    private Map properties;
    private String authenticateToRealm = null;
    private static List propertyNames = new ArrayList(1);

    public List getPropertyNames() {
        return new ArrayList(propertyNames);
    }

    public Syntax getPropertySyntax(String property) {
        return Syntax.NONE;
    }

    public String getDisplayName(String property, Locale locale) throws PolicyException {
        return property;
    }

    public Set getValidValues(String property) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map properties) throws PolicyException {
        this.properties = properties;
        this.validateProperties();
    }

    public Map getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    /*
     * Unable to fully structure code
     */
    public ConditionDecision getConditionDecision(SSOToken token, Map env) throws PolicyException, SSOException {
        allowed = false;
        requestAuthnRealms = new HashSet<E>();
        if (env != null && env.get("requestAuthenticatedToRealms") != null) {
            try {
                requestAuthnRealms = (Set)env.get("requestAuthenticatedToRealms");
                if (!AuthenticateToRealmCondition.debugMessageEnabled) ** GOTO lbl19
                AuthenticateToRealmCondition.DEBUG.message("At AuthenticateToRealmCondition.getConditionDecision(): requestAuthnRealms, from request = " + requestAuthnRealms);
            }
            catch (ClassCastException e) {
                args = new String[]{"requestAuthenticatedToRealms"};
                throw new PolicyException("amPolicy", "property_is_not_a_Set", args, e);
            }
        } else if (token != null) {
            authenticatedRealms = AMAuthUtils.getAuthenticatedRealms((SSOToken)token);
            if (authenticatedRealms != null) {
                requestAuthnRealms.addAll(authenticatedRealms);
            }
            if (AuthenticateToRealmCondition.debugMessageEnabled) {
                AuthenticateToRealmCondition.DEBUG.message("At AuthenticateToRealmCondition.getConditionDecision(): requestAuthnRealms, from ssoToken = " + requestAuthnRealms);
            }
        }
lbl19:
        // 7 sources

        allowed = true;
        adviceMessages = new HashSet<String>(1);
        if (!requestAuthnRealms.contains(this.authenticateToRealm)) {
            allowed = false;
            adviceMessages.add(this.authenticateToRealm);
            if (AuthenticateToRealmCondition.debugMessageEnabled) {
                AuthenticateToRealmCondition.DEBUG.message("At AuthenticateToRealmCondition.getConditionDecision():authenticateToRealm not satisfied = " + this.authenticateToRealm);
            }
        }
        if (AuthenticateToRealmCondition.debugMessageEnabled) {
            AuthenticateToRealmCondition.DEBUG.message("At AuthenticateToRealmCondition.getConditionDecision():authenticateToRealm = " + this.authenticateToRealm + "," + "requestAuthnRealms = " + requestAuthnRealms + ", " + " allowed = " + allowed);
        }
        advices = new HashMap<String, HashSet<String>>();
        if (!allowed) {
            advices.put("AuthenticateToRealmConditionAdvice", adviceMessages);
        }
        return new ConditionDecision(allowed, advices);
    }

    public Object clone() {
        AuthenticateToRealmCondition theClone = null;
        try {
            theClone = (AuthenticateToRealmCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.properties != null) {
            theClone.properties = new HashMap();
            Iterator it = this.properties.keySet().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                HashSet values = new HashSet();
                values.addAll((Set)this.properties.get(o));
                theClone.properties.put(o, values);
            }
            theClone.authenticateToRealm = this.authenticateToRealm;
        }
        return theClone;
    }

    private boolean validateProperties() throws PolicyException {
        if (this.properties == null || this.properties.keySet() == null) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        Set keySet = this.properties.keySet();
        if (!keySet.contains("AuthenticateToRealm")) {
            Object[] args = new String[]{"AuthenticateToRealm"};
            throw new PolicyException("amPolicy", "property_value_not_defined", args, null);
        }
        Iterator keys = keySet.iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if ("AuthenticateToRealm".equals(key)) continue;
            Object[] args = new String[]{key};
            throw new PolicyException("amPolicy", "attempt_to_set_invalid_property ", args, null);
        }
        Set authnToRealmSet = null;
        try {
            authnToRealmSet = (Set)this.properties.get("AuthenticateToRealm");
        }
        catch (ClassCastException e) {
            Object[] args = new String[]{"requestAuthenticatedToRealms"};
            throw new PolicyException("amPolicy", "property_is_not_a_Set", args, e);
        }
        if (authnToRealmSet != null) {
            this.validateAuthnToRealms(authnToRealmSet);
        }
        return true;
    }

    private boolean validateAuthnToRealms(Set authnToRealmSet) throws PolicyException {
        if (authnToRealmSet.isEmpty()) {
            Object[] args = new String[]{"AuthenticateToRealm"};
            throw new PolicyException("amPolicy", "property_does_not_allow_empty_values", args, null);
        }
        this.authenticateToRealm = null;
        Iterator authnToRealmSetIter = authnToRealmSet.iterator();
        try {
            this.authenticateToRealm = (String)authnToRealmSetIter.next();
        }
        catch (ClassCastException e) {
            Object[] args = new String[]{"AuthenticateToRealm"};
            throw new PolicyException("amPolicy", "property_is_not_a_String", args, null);
        }
        return true;
    }

    static {
        propertyNames.add("AuthenticateToRealm");
    }
}

