/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.plugins.OrgReferral;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SubOrgReferral
extends OrgReferral {
    private static Debug debug = Debug.getInstance("amPolicy");
    private static final String SUB_ORG_REFERRAL = "SubOrgReferral";

    public String getReferralTypeName() {
        return SUB_ORG_REFERRAL;
    }

    public ValidValues getValidValues(SSOToken token) throws SSOException, PolicyException {
        return this.getValidValues(token, "*");
    }

    public ValidValues getValidValues(SSOToken token, String pattern) throws SSOException, PolicyException {
        HashSet<String> values = new HashSet<String>();
        int status = 0;
        try {
            Set orgSet = (Set)this._configurationMap.get("OrganizationName");
            if (orgSet == null || orgSet.isEmpty()) {
                OrgReferral.DEBUG.error("SubOrgReferral.getValidValues():  Organization name not set");
                throw new PolicyException("amPolicy", "org_name_not_set", null, null);
            }
            Iterator iter = orgSet.iterator();
            String orgName = (String)iter.next();
            OrganizationConfigManager orgConfigManager = new OrganizationConfigManager(token, orgName);
            Set subOrgNames = orgConfigManager.getSubOrganizationNames(pattern, false);
            if (subOrgNames != null && !subOrgNames.isEmpty()) {
                Iterator subOrgsIter = subOrgNames.iterator();
                while (subOrgsIter.hasNext()) {
                    String subOrgName = (String)subOrgsIter.next();
                    OrganizationConfigManager subOrgManager = orgConfigManager.getSubOrgConfigManager(subOrgName);
                    if (subOrgManager == null) continue;
                    values.add(subOrgManager.getOrganizationName());
                }
            }
            if (debug.messageEnabled()) {
                debug.message("SubOrgReferral.getValidValues():subOrgNames=" + subOrgNames);
            }
        }
        catch (SMSException smse) {
            OrgReferral.DEBUG.error("Can not get valid values for referral " + this.getReferralTypeName() + smse);
            Object[] objs = new String[]{this.getReferralTypeName()};
            throw new PolicyException("amPolicy", "can_not_get_values_for_referral", objs, smse);
        }
        return new ValidValues(status, values);
    }
}

