/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.assertion.AuthorityBinding;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectLocality;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.shared.DateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthenticationStatement
extends SubjectStatement {
    protected String _authenticationMethod = null;
    protected Date _authenticationInstant = null;
    protected SubjectLocality _subjectLocality = null;
    protected List _authorityBinding = null;

    protected AuthenticationStatement() {
    }

    public AuthenticationStatement(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtilsCommon.debug.message("AuthenticationStatement: null input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        boolean valid = SAMLUtilsCommon.checkStatement(element, "AuthenticationStatement");
        if (!valid) {
            SAMLUtilsCommon.debug.message("AuthenticationStatement: Wrong input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        int i = 0;
        NamedNodeMap atts = element.getAttributes();
        int attCount = atts.getLength();
        for (i = 0; i < attCount; ++i) {
            Node att = atts.item(i);
            if (att.getNodeType() != 2) continue;
            String attName = att.getLocalName();
            if (attName == null || attName.length() == 0) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("AuthenticationStatement:Attribute name is either null or empty.");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
            }
            if (attName.equals("AuthenticationMethod")) {
                this._authenticationMethod = ((Attr)att).getValue().trim();
                continue;
            }
            if (!attName.equals("AuthenticationInstant")) continue;
            try {
                this._authenticationInstant = DateUtils.stringToDate(((Attr)att).getValue());
                continue;
            }
            catch (ParseException pe) {
                SAMLUtilsCommon.debug.error("AuthenticationStatement:StringToDate", pe);
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongDateFormat"));
            }
        }
        NodeList nodes = element.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount > 0) {
            for (i = 0; i < nodeCount; ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeType() != 1) continue;
                String tagName = currentNode.getLocalName();
                String tagNS = currentNode.getNamespaceURI();
                if (tagName == null || tagName.length() == 0 || tagNS == null || tagNS.length() == 0) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("AuthenticationStatement: The tag name or tag namespace of child element is either null or empty.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
                }
                if (tagName.equals("Subject") && tagNS.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    if (this._subject != null) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("AuthenticationStatement:should only contain one subject");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
                    }
                    this._subject = this.createSubject((Element)currentNode);
                    continue;
                }
                if (tagName.equals("SubjectLocality") && tagNS.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    if (this._subjectLocality != null) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("AuthenticationStatement: should at most contain one SubjectLocality.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
                    }
                    this._subjectLocality = this.createSubjectLocality((Element)currentNode);
                    continue;
                }
                if (tagName.equals("AuthorityBinding") && tagNS.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    if (this._authorityBinding == null) {
                        this._authorityBinding = new ArrayList();
                    }
                    if (this._authorityBinding.add(this.createAuthorityBinding((Element)currentNode))) continue;
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Authentication Statment: failed to add to the AuthorityBinding list.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("addListError"));
                }
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("AuthenticationStatement:Wrong element " + tagName + "included.");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
            }
        }
        if (this._subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthenticationStatement should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
    }

    public AuthenticationStatement(String authMethod, Date authInstant, Subject subject) throws SAMLException {
        this._authenticationMethod = authMethod;
        this._authenticationInstant = authInstant;
        if (subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthenticationStatement:missing the subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
        this._subject = subject;
    }

    public AuthenticationStatement(String authMethod, Date authInstant, Subject subject, SubjectLocality subjectLocality, List authorityBinding) throws SAMLException {
        this._authenticationMethod = authMethod;
        this._authenticationInstant = authInstant;
        if (subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthenticationStatement: should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
        }
        this._subject = subject;
        this._subjectLocality = subjectLocality;
        if (authorityBinding != null && !authorityBinding.isEmpty()) {
            if (this._authorityBinding == null) {
                this._authorityBinding = new ArrayList();
            }
            this._authorityBinding = authorityBinding;
        }
    }

    public SubjectLocality getSubjectLocality() {
        return this._subjectLocality;
    }

    public boolean setSubjectLocality(SubjectLocality subjectlocality) {
        if (subjectlocality == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthenticationStatement: setSubjectLocality:Input is null.");
            }
            return false;
        }
        this._subjectLocality = subjectlocality;
        return true;
    }

    public String getAuthenticaionMethod() {
        return this._authenticationMethod;
    }

    public boolean setAuthenticaionMethod(String authenticationmethod) {
        if (authenticationmethod == null || authenticationmethod.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthenticationStatement: setAuthenticationMethod:Input is null.");
            }
            return false;
        }
        this._authenticationMethod = authenticationmethod;
        return true;
    }

    public Date getAuthenticationInstant() {
        return this._authenticationInstant;
    }

    public boolean setAuthenticationInstant(Date authenticationinstant) {
        if (authenticationinstant == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthenticationStatement: setAuthenticationInstant:Input is null.");
            }
            return false;
        }
        this._authenticationInstant = authenticationinstant;
        return true;
    }

    public List getAuthorityBinding() {
        return this._authorityBinding;
    }

    public boolean setAuthorityBinding(List authoritybinding) {
        if (authoritybinding == null || authoritybinding.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthenticationStatement: setAuthorityBinding:Input is null.");
            }
            return false;
        }
        this._authorityBinding = authoritybinding;
        return true;
    }

    public int getStatementType() {
        return 1;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer result = new StringBuffer(1000);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        result.append("<").append(prefix).append("AuthenticationStatement").append(uri);
        if (this._authenticationMethod != null && this._authenticationMethod.length() != 0) {
            result.append(" AuthenticationMethod=\"").append(this._authenticationMethod).append("\"");
        }
        if (this._authenticationInstant != null && this._authenticationInstant.toString().length() != 0) {
            result.append(" AuthenticationInstant=\"").append(DateUtils.toUTCDateFormat(this._authenticationInstant)).append("\"");
        }
        result.append(">\n").append(this._subject.toString(includeNS, false));
        if (this._subjectLocality != null) {
            result.append(this._subjectLocality.toString(includeNS, false));
        }
        if (this._authorityBinding != null && !this._authorityBinding.isEmpty()) {
            Iterator iter = this.getAuthorityBinding().iterator();
            while (iter.hasNext()) {
                AuthorityBinding authBinding = (AuthorityBinding)iter.next();
                result.append(authBinding.toString(includeNS, false));
            }
        }
        result.append("</").append(prefix).append("AuthenticationStatement>\n");
        return result.toString();
    }

    protected Subject createSubject(Element subjectElement) throws SAMLException {
        return new Subject(subjectElement);
    }

    protected SubjectLocality createSubjectLocality(Element subjectLocalityElement) throws SAMLException {
        return new SubjectLocality(subjectLocalityElement);
    }

    protected AuthorityBinding createAuthorityBinding(Element authorityBindingElement) throws SAMLException {
        return new AuthorityBinding(authorityBindingElement);
    }
}

