/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.AttributeValidator;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.PluginSchemaImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class PluginConfigImpl {
    private PluginSchemaImpl ps;
    private boolean newEntry;
    private String orgName;
    private int priority;
    private Map attributes;
    private CachedSMSEntry smsEntry;
    private static Map configImpls = new HashMap();
    private static Map userPrincipals = new HashMap();
    private static final String configImplsMutex = "ConfigImplsMutex";
    private static Debug debug = SMSEntry.debug;

    private PluginConfigImpl(PluginSchemaImpl ps, CachedSMSEntry entry, String orgName) throws SMSException {
        this.ps = ps;
        this.smsEntry = entry;
        this.smsEntry.addServiceListener(this);
        this.orgName = orgName == null ? SMSEntry.baseDN : orgName;
        this.update();
    }

    String getOrganizationName() {
        return this.orgName;
    }

    int getPriority() {
        return this.priority;
    }

    Map getAttributes() {
        if (!SMSEntry.cacheSMSEntries) {
            this.update();
        }
        return SMSUtils.copyAttributes(this.attributes);
    }

    String getDN() {
        return this.smsEntry.getDN();
    }

    SMSEntry getSMSEntry() {
        return this.smsEntry.getClonedSMSEntry();
    }

    void refresh(SMSEntry e) throws SMSException {
        this.smsEntry.refresh(e);
    }

    PluginSchemaImpl getPluginSchemaImpl() {
        return this.ps;
    }

    boolean isNewEntry() {
        return this.newEntry;
    }

    void updateAndNotifyListeners() {
        this.update();
    }

    void update() {
        SMSEntry entry = this.smsEntry.getSMSEntry();
        this.newEntry = entry.isNewEntry();
        this.attributes = SMSUtils.getAttrsFromEntry(entry);
        Iterator ass = this.ps.getAttributeSchemaNames().iterator();
        while (ass.hasNext()) {
            AttributeValidator av = this.ps.getAttributeValidator((String)ass.next());
            this.attributes = av.inheritDefaults(this.attributes);
        }
        this.priority = 0;
        String[] priorities = entry.getAttributeValues("sunsmspriority");
        if (priorities != null) {
            try {
                this.priority = Integer.parseInt(priorities[0]);
            }
            catch (NumberFormatException nfe) {
                SMSEntry.debug.error("ServiceConfig::getPriority() " + nfe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PluginConfigImpl getInstance(SSOToken token, PluginSchemaImpl ps, String dn, String oName) throws SSOException, SMSException {
        String orgName;
        String cacheName;
        PluginConfigImpl answer;
        if (debug.messageEnabled()) {
            debug.message("PluginConfigImpl::getInstance: called: " + dn);
        }
        if ((answer = PluginConfigImpl.getFromCache(cacheName = PluginConfigImpl.getCacheName(ps, orgName = DNMapper.orgNameToDN(oName)), dn, token)) != null) {
            if (!SMSEntry.cacheSMSEntries) {
                answer.update();
            }
            return answer;
        }
        if (!SMSEntry.checkIfEntryExists(DNMapper.orgNameToDN(orgName), token)) {
            return null;
        }
        String string = configImplsMutex;
        synchronized (configImplsMutex) {
            answer = PluginConfigImpl.getFromCache(cacheName, dn, token);
            if (answer == null) {
                CachedSMSEntry entry = PluginConfigImpl.checkAndUpdatePermission(cacheName, dn, token);
                answer = new PluginConfigImpl(ps, entry, orgName);
                HashMap<String, PluginConfigImpl> sudoConfigImpls = new HashMap<String, PluginConfigImpl>(configImpls);
                sudoConfigImpls.put(cacheName, answer);
                configImpls = sudoConfigImpls;
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (debug.messageEnabled()) {
                debug.message("PluginConfigImpl::getInstance: return: " + dn);
            }
            return answer;
        }
    }

    static void clearCache() {
        configImpls = new HashMap();
    }

    static String getCacheName(PluginSchemaImpl ps, String orgName) {
        StringBuffer sb = new StringBuffer(100);
        sb.append(ps.getName()).append(ps.getVersion()).append(orgName);
        return sb.toString().toLowerCase();
    }

    static PluginConfigImpl getFromCache(String cacheName, String dn, SSOToken t) throws SMSException, SSOException {
        Set principals;
        PluginConfigImpl answer = (PluginConfigImpl)configImpls.get(cacheName);
        if (answer != null && !answer.smsEntry.isValid()) {
            answer = null;
        }
        if (answer != null && !(principals = (Set)userPrincipals.get(cacheName)).contains(((Object)t.getTokenID()).toString())) {
            PluginConfigImpl.checkAndUpdatePermission(cacheName, dn, t);
        }
        return answer;
    }

    static synchronized CachedSMSEntry checkAndUpdatePermission(String cacheName, String dn, SSOToken token) throws SMSException, SSOException {
        CachedSMSEntry answer = CachedSMSEntry.getInstance(token, dn, null);
        HashSet<String> sudoPrincipals = (HashSet<String>)userPrincipals.get(cacheName);
        sudoPrincipals = sudoPrincipals == null ? new HashSet<String>() : new HashSet(sudoPrincipals);
        sudoPrincipals.add(((Object)token.getTokenID()).toString());
        HashMap<String, HashSet<String>> sudoUserPrincipals = new HashMap<String, HashSet<String>>(userPrincipals);
        sudoUserPrincipals.put(cacheName, sudoPrincipals);
        userPrincipals = sudoUserPrincipals;
        return answer;
    }
}

