/*
 * Decompiled with CFR 0.152.
 */
package com.sun.liberty.jaxrpc;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.liberty.jaxrpc.LibertyClientSSOTokenListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;

public final class LibertyManagerClient {
    private static final String SERVICE_NAME = "LibertyManagerIF";
    private static SOAPClient client = new SOAPClient("LibertyManagerIF");
    public static final String DISCO_RO = "_DiscoveryResourceOffering";
    public static final String DISCO_CRED = "_DiscoveryCredential";
    public static Map bootStrapCache = Collections.synchronizedMap(new HashMap());

    public ResourceOffering getDiscoveryResourceOffering(Object token, String hostProviderID) throws FSException {
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            String tokenID = sessionProvider.getSessionID(token);
            String cacheKey = tokenID + DISCO_RO;
            ResourceOffering ro = (ResourceOffering)bootStrapCache.get(cacheKey);
            if (ro != null) {
                return ro;
            }
            Object[] objs = new String[]{tokenID, hostProviderID};
            String resourceOffering = (String)client.send("getDiscoveryResourceOffering", objs, (String)null, (String)null);
            if (resourceOffering == null || resourceOffering.length() == 0) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("LibertyManagerClient.getDiscoveryResourceOffering: ResouceOffering is null or empty");
                }
                return null;
            }
            Document doc = XMLUtils.toDOMDocument(resourceOffering, FSUtils.debug);
            ro = new ResourceOffering(doc.getDocumentElement());
            sessionProvider.addListener(token, new LibertyClientSSOTokenListener());
            bootStrapCache.put(cacheKey, ro);
            return ro;
        }
        catch (SessionException se) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("LibertyManagerClient.getDiscoveryResourceOffering: InvalidSessionToken", se);
            }
            throw new FSException(FSUtils.bundle.getString("invalidSSOToken"));
        }
        catch (DiscoveryException de) {
            FSUtils.debug.error("LibertyManagerClient.getDiscoveryResourceOffering: Invalid ResourceOffering", de);
            throw new FSException(FSUtils.bundle.getString("invalidResourceOffering"));
        }
        catch (Exception ex) {
            FSUtils.debug.error("LibertyManagerClient.getDiscoveryResourceOffering: SOAPClient Exception", ex);
            throw new FSException(FSUtils.bundle.getString("soapException"));
        }
    }

    public SecurityAssertion getDiscoveryServiceCredential(Object token, String hostProviderID) throws FSException {
        try {
            String tokenID = SessionManager.getProvider().getSessionID(token);
            String cacheKey = tokenID + DISCO_CRED;
            SecurityAssertion cred = (SecurityAssertion)bootStrapCache.get(cacheKey);
            if (cred != null) {
                return cred;
            }
            Object[] objs = new String[]{tokenID, hostProviderID};
            String credential = (String)client.send("getDiscoveryServiceCredential", objs, (String)null, (String)null);
            if (credential == null || credential.length() == 0) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("LibertyManagerClient.getDiscoveryServiceCredential: Credential is null or empty");
                }
                return null;
            }
            Document doc = XMLUtils.toDOMDocument(credential, FSUtils.debug);
            cred = new SecurityAssertion(doc.getDocumentElement());
            bootStrapCache.put(cacheKey, cred);
            return cred;
        }
        catch (SessionException se) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("LibertyManagerClient.getDiscoveryServiceCredential: InvalidSessionToken", se);
            }
            throw new FSException(FSUtils.bundle.getString("invalidSSOToken"));
        }
        catch (DiscoveryException de) {
            FSUtils.debug.error("LibertyManagerClient.getDiscoveryServiceCredential: InvalidAssertion", de);
            throw new FSException(FSUtils.bundle.getString("invalidCredential"));
        }
        catch (Exception ex) {
            FSUtils.debug.error("LibertyManagerClient.getDiscoveryResourceOffering: SOAPClient Exception", ex);
            throw new FSException(FSUtils.bundle.getString("soapException"));
        }
    }
}

