/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;

public class TypeConverter {
    public static final IRubyObject convertToType(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod, boolean raise) {
        if (!obj.respondsTo(convertMethod)) {
            return TypeConverter.handleUncoercibleObject(raise, obj, target);
        }
        return obj.callMethod(obj.getRuntime().getCurrentContext(), convertMethodIndex, convertMethod);
    }

    public static final IRubyObject convertToType(IRubyObject obj, RubyClass target, String convertMethod, boolean raise) {
        if (!obj.respondsTo(convertMethod)) {
            return TypeConverter.handleUncoercibleObject(raise, obj, target);
        }
        return obj.callMethod(obj.getRuntime().getCurrentContext(), convertMethod);
    }

    public static final IRubyObject convertToType(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethodIndex, convertMethod, true);
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    public static final IRubyObject convertToTypeWithCheck(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethodIndex, convertMethod, false);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    public static final IRubyObject convertToTypeOrRaise(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, true);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    private static IRubyObject handleUncoercibleObject(boolean raise, IRubyObject obj, RubyClass target) throws RaiseException {
        if (raise) {
            String type = obj.isNil() ? "nil" : (obj instanceof RubyBoolean ? (obj.isTrue() ? "true" : "false") : obj.getMetaClass().getRealClass().getName());
            throw obj.getRuntime().newTypeError("can't convert " + type + " into " + target);
        }
        return obj.getRuntime().getNil();
    }
}

