/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.login;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.login.FSPostLogin;
import com.sun.identity.federation.login.FSPostLoginException;
import com.sun.identity.federation.services.util.FSServiceUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSFederationHandler
extends HttpServlet {
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        if (action != null && action.trim().equalsIgnoreCase("cancel")) {
            String lrURL;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFederationHandler:: user pressed cancel proceding to lrurl");
            }
            if ((lrURL = request.getParameter("RelayState")) != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSFederationHandler::Redirecting to " + lrURL);
                }
                FSUtils.forwardRequest(request, response, lrURL);
            } else {
                FSUtils.debug.error("FSFederationHandler::LRURL is null in reqest ");
            }
        } else {
            try {
                String metaAlias = request.getParameter("metaAlias");
                String provider = request.getParameter("selectedprovider");
                if (metaAlias == null || provider == null) {
                    FSUtils.debug.error("FSFederationHandler:: No MetaAlias in request. Redirecting to error page");
                    String errorPage = FSServiceUtils.getErrorPageURL(request, null, metaAlias);
                    FSUtils.forwardRequest(request, response, errorPage);
                } else {
                    String lrURL;
                    FSPostLogin postLogin = new FSPostLogin();
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSFederationHandler::selected provider is " + provider);
                    }
                    if ((lrURL = postLogin.doFederation(request, response)) != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSFederationHandler:: Redirecting to" + lrURL + " after postLogin");
                        }
                        response.sendRedirect(lrURL);
                    } else {
                        FSUtils.debug.error("FSFederationHandler::  LRURL is null from postlogin ");
                    }
                }
            }
            catch (FSPostLoginException fsPostExp) {
                FSUtils.debug.error("FSFederationHandler::FSPostLogin Exception:", (Throwable)((Object)fsPostExp));
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }
}

