/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AbstractRequest;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSFederationTerminationNotification
extends AbstractRequest {
    private String providerId;
    private NameIdentifier nameIdentifier;
    protected String xmlString;
    protected String signatureString;
    protected String id;
    private String relayState;

    public FSFederationTerminationNotification() {
        block2: {
            try {
                this.setIssueInstant(new Date());
                this.providerId = new String();
                this.nameIdentifier = new NameIdentifier("Test", "Test");
            }
            catch (SAMLException e) {
                if (!FSUtils.debug.messageEnabled()) break block2;
                FSUtils.debug.message("FSFederationTerminationNotification.constructor:", (Throwable)((Object)e));
            }
        }
    }

    public FSFederationTerminationNotification(Element root) throws FSMsgException {
        String tag = null;
        if (root == null) {
            FSUtils.debug.message("FSFederationTerminationNotification(Element):null input.");
            throw new FSMsgException("nullInput", null);
        }
        tag = root.getLocalName();
        if (tag == null || !tag.equals("FederationTerminationNotification")) {
            FSUtils.debug.message("FSFederationTerminationNotification(Element):wrong input");
            throw new FSMsgException("wrongInput", null);
        }
        String instantString = root.getAttribute("IssueInstant");
        if (instantString == null || instantString.length() == 0) {
            FSUtils.debug.message("FederationTerminationNotification(Element): missing IssueInstant");
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        try {
            this.issueInstant = DateUtils.stringToDate((String)instantString);
        }
        catch (ParseException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FederationTerminationNotification  (Element): could not parse IssueInstant", (Throwable)e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        int length = 0;
        this.id = root.getAttribute("id");
        this.requestID = root.getAttribute("RequestID");
        this.parseMajorVersion(root.getAttribute("MajorVersion"));
        this.parseMinorVersion(root.getAttribute("MinorVersion"));
        NodeList contentnl = root.getChildNodes();
        length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            String nodeName = child.getLocalName();
            if (nodeName == null) continue;
            if (nodeName.equals("RespondWith")) {
                if (this.respondWiths == Collections.EMPTY_LIST) {
                    this.respondWiths = new ArrayList();
                }
                this.respondWiths.add(XMLUtils.getElementValue((Element)((Element)child)));
                continue;
            }
            if (nodeName.equals("Signature")) continue;
            if (nodeName.equals("ProviderID")) {
                if (this.providerId != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSFederationTerminationNotification(Element : should contain only one ProviderID.");
                    }
                    throw new FSMsgException("wrongInput", null);
                }
                this.providerId = XMLUtils.getElementValue((Element)((Element)child));
                continue;
            }
            if (nodeName.equals("NameIdentifier")) {
                try {
                    this.nameIdentifier = new NameIdentifier((Element)child);
                    continue;
                }
                catch (SAMLException ex) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSFederationTerminationNotification (Element): SAMLException while constructing nameidentifier");
                    }
                    throw new FSMsgException("nameIdentifierCreateError", null);
                }
            }
            if (nodeName.equals("RelayState")) {
                if (this.relayState != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSFederationTerminationNotification (Element) :should contain only one relayState.");
                    }
                    throw new FSMsgException("wrongInput", null);
                }
                this.relayState = XMLUtils.getElementValue((Element)((Element)child));
                continue;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFederationTerminationNotification(Element):  invalid node" + nodeName);
            }
            throw new FSMsgException("wrongInput", null);
        }
        List signs = XMLUtils.getElementsByTagNameNS1((Element)root, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            Element elem = (Element)signs.get(0);
            this.setSignature(elem);
            this.xmlString = XMLUtils.print((Node)root);
            this.signed = true;
        } else if (signsSize != 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFederationTerminationNotification(Element):included more than one Signature element.");
            }
            throw new FSMsgException("moreElement", null);
        }
    }

    public FSFederationTerminationNotification(String requestId, String providerID, NameIdentifier nameId) throws FSMsgException {
        int length = 0;
        int i = 0;
        this.setIssueInstant(new Date());
        if (this.respondWiths != null && this.respondWiths != Collections.EMPTY_LIST) {
            length = this.respondWiths.size();
            for (i = 0; i < length; ++i) {
                Object temp = this.respondWiths.get(i);
                if (temp instanceof String) continue;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSFederationTerminationNotification:wrong input for RespondWith");
                }
                throw new FSMsgException("wrongInput", null);
            }
            this.respondWiths = this.respondWiths;
        }
        if (requestId != null && requestId.length() != 0) {
            this.requestID = requestId;
        } else {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSFederationTerminationNotification: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        this.providerId = providerID;
        this.nameIdentifier = nameId;
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        if (this.providerId == null || this.providerId.length() == 0) {
            FSUtils.debug.error("FSFederationTerminationNotification.toXMLString: providerId is null in the request with requestId:" + this.requestID);
            Object[] args = new String[]{this.requestID};
            throw new FSMsgException("nullProviderIdWRequestId", args);
        }
        if (this.requestID == null || this.requestID.length() == 0) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSFederationTerminationNotification.toXMLString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer xml = new StringBuffer(300);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("\"").append(" ").append('?').append(">");
        }
        String prefix = "";
        String uriSAML = "";
        String uri = "";
        if (includeNS) {
            prefix = "lib:";
        }
        if (declareNS) {
            uri = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            if (this.minorVersion == 2) {
                uri = " xmlns:lib=\"urn:liberty:iff:2003-08\"";
            }
            uriSAML = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        String instantString = DateUtils.toUTCDateFormat((Date)this.issueInstant);
        if (this.requestID != null) {
            xml.append("<").append(prefix).append("FederationTerminationNotification").append(uri).append(uriSAML).append(" ");
            if (this.minorVersion == 0 && this.id != null && this.id.length() != 0) {
                xml.append(" ").append("id").append('=').append("\"").append(this.id).append("\"").append(" ");
            }
            xml.append("RequestID").append('=').append("\"").append(this.requestID).append("\"").append(" ").append("MajorVersion").append('=').append("\"").append(this.majorVersion).append("\"").append(" ").append("MinorVersion").append('=').append("\"").append(this.minorVersion).append("\"").append(" ").append("IssueInstant").append('=').append("\"").append(instantString).append("\"").append(">");
            if (this.respondWiths != null && this.respondWiths != Collections.EMPTY_LIST) {
                Iterator i = this.respondWiths.iterator();
                while (i.hasNext()) {
                    xml.append("<").append(prefix).append("RespondWith").append(">").append((String)i.next()).append("</").append(prefix).append("RespondWith").append("<");
                }
            }
            if (this.signed) {
                if (this.signatureString != null) {
                    xml.append(this.signatureString);
                } else if (this.signature != null) {
                    this.signatureString = XMLUtils.print((Node)this.signature);
                    xml.append(this.signatureString);
                }
            }
            xml.append("<").append(prefix).append("ProviderID").append(uri).append(">").append(this.providerId).append("</").append(prefix).append("ProviderID").append(">");
            if (this.nameIdentifier != null) {
                xml.append(this.nameIdentifier.toString());
            }
            if (this.relayState != null) {
                xml.append("<").append(prefix).append("RelayState").append(uri).append(">").append(this.providerId).append("</").append(prefix).append("RelayState").append(">");
            }
        } else {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFederationTerminationNotification.toString: requestID is null ");
            }
            throw new FSMsgException("nullRequestID", null);
        }
        xml.append("</").append(prefix).append("FederationTerminationNotification").append(">");
        return xml.toString();
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public static FSFederationTerminationNotification parseXML(String xml) throws FSMsgException {
        Document doc = XMLUtils.toDOMDocument((String)xml, (Debug)FSUtils.debug);
        if (doc == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFederationTerminationNotification.parseXML:Error while parsing input xml string");
            }
            throw new FSMsgException("parseError", null);
        }
        Element root = doc.getDocumentElement();
        return new FSFederationTerminationNotification(root);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int version) {
        this.minorVersion = version;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerID) {
        this.providerId = providerID;
    }

    public NameIdentifier getNameIdentifier() {
        return this.nameIdentifier;
    }

    public void setNameIdentifier(NameIdentifier nameId) {
        this.nameIdentifier = nameId;
    }

    public String toURLEncodedQueryString() throws FSMsgException {
        if (this.providerId == null || this.providerId.length() == 0) {
            FSUtils.debug.error("FSFederationTerminationNotification.toURLEncodedQueryString: providerId is null in the request with requestId: " + this.requestID);
            Object[] args = new String[]{this.requestID};
            throw new FSMsgException("nullProviderIdWRequestId", args);
        }
        if (this.requestID == null || this.requestID.length() == 0) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSFederationTerminationNotification.toURLEncodedQueryString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer urlEncodedAuthnReq = new StringBuffer(300);
        urlEncodedAuthnReq.append("RequestID").append('=').append(URLEncDec.encode((String)this.requestID)).append('&');
        urlEncodedAuthnReq.append("MajorVersion").append('=').append(this.majorVersion).append('&');
        urlEncodedAuthnReq.append("MinorVersion").append('=').append(this.minorVersion).append('&');
        if (this.issueInstant == null) {
            FSUtils.debug.error("FSFederationTerminationNotification.toURLEncodedQueryString: issueInstant missing");
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        urlEncodedAuthnReq.append("IssueInstant").append('=').append(URLEncDec.encode((String)DateUtils.toUTCDateFormat((Date)this.issueInstant))).append('&');
        if (this.providerId != null && this.providerId.length() != 0) {
            urlEncodedAuthnReq.append("ProviderID").append('=').append(URLEncDec.encode((String)this.providerId)).append('&');
        }
        if (this.nameIdentifier != null) {
            if (this.nameIdentifier.getName() != null && this.nameIdentifier.getName().length() != 0) {
                urlEncodedAuthnReq.append("Name").append('=').append(URLEncDec.encode((String)this.nameIdentifier.getName())).append('&').append("NameIdentifier").append('=').append(URLEncDec.encode((String)this.nameIdentifier.getName())).append('&');
            }
            if (this.nameIdentifier.getNameQualifier() != null && this.nameIdentifier.getNameQualifier().length() != 0) {
                urlEncodedAuthnReq.append("NameQualifier").append('=').append(URLEncDec.encode((String)this.nameIdentifier.getNameQualifier())).append('&');
            }
            if (this.nameIdentifier.getFormat() != null && this.nameIdentifier.getFormat().length() != 0) {
                urlEncodedAuthnReq.append("NameFormat").append('=').append(URLEncDec.encode((String)this.nameIdentifier.getFormat())).append('&');
            }
        }
        if (this.relayState != null) {
            urlEncodedAuthnReq.append("RelayState").append('=').append(URLEncDec.encode((String)this.relayState)).append('&');
        }
        return urlEncodedAuthnReq.toString();
    }

    public String toBASE64EncodedString() throws FSMsgException {
        if (this.providerId == null || this.providerId.length() == 0) {
            FSUtils.debug.error("FSFederationTerminationNotification.toURLEncodedQueryString: providerId is null in the request with requestId:" + this.requestID);
            Object[] args = new String[]{this.requestID};
            throw new FSMsgException("nullProviderIdWRequestId", args);
        }
        if (this.requestID == null || this.requestID.length() == 0) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSFederationTerminationNotification.toURLEncodedQueryString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        return Base64.encode((byte[])this.toXMLString().getBytes());
    }

    public static FSFederationTerminationNotification parseURLEncodedRequest(HttpServletRequest request) throws FSMsgException, SAMLException {
        FSFederationTerminationNotification retFederationTerminationNotification = new FSFederationTerminationNotification();
        try {
            FSUtils.debug.message("checking minor version");
            retFederationTerminationNotification.majorVersion = Integer.parseInt(request.getParameter("MajorVersion"));
            retFederationTerminationNotification.minorVersion = Integer.parseInt(request.getParameter("MinorVersion"));
        }
        catch (NumberFormatException ex) {
            throw new FSMsgException("invalidNumber", null);
        }
        String requestID = request.getParameter("RequestID");
        if (request == null) {
            Object[] args = new String[]{"RequestID"};
            throw new FSMsgException("missingAttribute", args);
        }
        retFederationTerminationNotification.requestID = requestID;
        String instantString = request.getParameter("IssueInstant");
        if (instantString == null || instantString.length() == 0) {
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        try {
            retFederationTerminationNotification.issueInstant = DateUtils.stringToDate((String)instantString);
        }
        catch (ParseException e) {
            throw new FSMsgException("parseError", null);
        }
        String providerID = request.getParameter("ProviderID");
        if (providerID == null) {
            throw new FSMsgException("missingElement", null);
        }
        retFederationTerminationNotification.providerId = providerID;
        String nameFormat = request.getParameter("NameFormat");
        String nameQualifier = request.getParameter("NameQualifier");
        String name = request.getParameter("Name");
        if (name == null) {
            throw new FSMsgException("missingNameIdentifier", null);
        }
        String relayState = request.getParameter("RelayState");
        if (relayState != null) {
            retFederationTerminationNotification.relayState = relayState;
        }
        retFederationTerminationNotification.nameIdentifier = new NameIdentifier(name, nameQualifier, nameFormat);
        FSUtils.debug.message("Returning Termination Object");
        return retFederationTerminationNotification;
    }

    private void parseMajorVersion(String majorVer) throws FSMsgException {
        try {
            this.majorVersion = Integer.parseInt(majorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFederationTerminationNotification(Element): invalid MajorVersion", (Throwable)e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSFederationTerminationNotification(Element):  MajorVersion of the FederationTerminationNotification is too high.");
                }
                throw new FSMsgException("requestVersionTooHigh", null);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFederationTerminationNotification(Element): MajorVersion of the FederationTerminationNotification is too low.");
            }
            throw new FSMsgException("requestVersionTooLow", null);
        }
    }

    private void parseMinorVersion(String minorVer) throws FSMsgException {
        try {
            this.minorVersion = Integer.parseInt(minorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFederationTerminationNotification(Element): invalid MinorVersion", (Throwable)e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.minorVersion != 2 && this.minorVersion != 0) {
            if (this.minorVersion > 2) {
                FSUtils.debug.error("FSFedTerminationNot(Element): MinorVersion of the Response is too high.");
                throw new FSMsgException("responseVersionTooHigh", null);
            }
            FSUtils.debug.error("FSFedTerminationNot(Element):  MinorVersion of the Response is too low:" + this.minorVersion);
            throw new FSMsgException("responseVersionTooLow", null);
        }
    }

    public void signXML() throws SAMLException {
        throw new SAMLException("libIDFF", "unsupportedOperation", null);
    }

    public void signXML(String certAlias) throws SAMLException {
        FSUtils.debug.message("FSFederationTerminationNotification.signXML: Called");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFederationTerminationNotification.signXML: the assertion is already signed.");
            }
            throw new SAMLResponderException("libIDFF", "alreadySigned", null);
        }
        if (certAlias == null || certAlias.length() == 0) {
            throw new SAMLResponderException("libIDFF", "cannotFindCertAlias", null);
        }
        try {
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            if (this.minorVersion == 0) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, (String)null, "id", this.id, false);
            } else if (this.minorVersion == 2) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, (String)null, "RequestID", this.getRequestID(), false);
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            this.signature = XMLUtils.toDOMDocument((String)this.signatureString, (Debug)FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception e) {
            throw new SAMLResponderException("libIDFF", "signFailed", null);
        }
    }

    public boolean setSignature(Element elem) {
        this.signatureString = XMLUtils.print((Node)elem);
        return super.setSignature(elem);
    }
}

