/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.jaxb.entityconfig.SPDescriptorConfigElement;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSIDPList;
import com.sun.identity.federation.message.FSScoping;
import com.sun.identity.federation.message.common.IDPEntries;
import com.sun.identity.federation.message.common.IDPEntry;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.plugins.FederationSPAdapter;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureException;
import com.sun.identity.federation.services.util.FSSignatureManager;
import com.sun.identity.liberty.ws.meta.jaxb.AffiliationDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FSIntersiteTransferService
extends HttpServlet {
    String framedLoginPageURL = null;

    private void redirectToCommonDomain(HttpServletRequest request, HttpServletResponse response, String requestID) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSIntersiteTransferService.redirectToCommonDomain: Called");
        }
        String metaAlias = request.getParameter("metaAlias");
        String realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
        try {
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            HttpSession session = request.getSession(true);
            Set cotSet = (Set)session.getAttribute("CotSet");
            CircleOfTrustManager cotManager = new CircleOfTrustManager();
            if (cotSet == null) {
                cotSet = cotManager.getAllCirclesOfTrust(realm);
                if (cotSet != null) {
                    session.setAttribute("CotSet", (Object)cotSet);
                }
                if (cotSet == null || cotSet.isEmpty()) {
                    FSUtils.debug.error("FSIntersiteTransferService. redirectToCommonDomain: No CommonDomain metadata found");
                    String[] data = new String[]{FSUtils.bundle.getString("noCommonDomainMetadata")};
                    LogUtil.error(Level.INFO, "COMMON_DOMAIN_META_DATA_NOT_FOUND", data);
                    FSUtils.forwardRequest(request, response, this.framedLoginPageURL);
                    return;
                }
            }
            if (cotSet.isEmpty()) {
                FSUtils.debug.error("FSIntersiteTransferService.redirectToCommonDomain: No more CommonDomain left");
                String[] data = new String[]{FSUtils.bundle.getString("noCommonDomainMetadata")};
                LogUtil.error(Level.INFO, "COMMON_DOMAIN_META_DATA_NOT_FOUND", data);
                FSUtils.forwardRequest(request, response, this.framedLoginPageURL);
                return;
            }
            Iterator iter = cotSet.iterator();
            String cotName = (String)iter.next();
            cotSet.remove(cotName);
            session.setAttribute("CotSet", (Object)cotSet);
            String readerServiceURL = cotManager.getCircleOfTrust(realm, cotName).getIDFFReaderServiceURL();
            if (readerServiceURL != null) {
                StringBuffer redirectURL = new StringBuffer(300);
                StringBuffer returnURL = request.getRequestURL();
                returnURL.append("?").append("RequestID").append("=").append(URLEncDec.encode((String)requestID));
                returnURL.append("&").append("metaAlias").append("=").append(URLEncDec.encode((String)metaAlias));
                redirectURL.append(readerServiceURL);
                redirectURL.append("?");
                redirectURL.append("RelayState");
                redirectURL.append("=");
                redirectURL.append(URLEncDec.encode((String)returnURL.toString()));
                String url = redirectURL.toString();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSIntersiteTransferService.redirectToCommonDomain: Redirecting to check for PrefferedIDP @:" + url);
                }
                response.setHeader("Location", url);
                response.sendRedirect(url);
                return;
            }
        }
        catch (COTException e) {
            FSUtils.debug.error("FSIntersiteTransferService.redirectToCommonDomain: COTException occured while trying to redirect to the CommonDomain: ", (Throwable)((Object)e));
            try {
                FSUtils.forwardRequest(request, response, this.framedLoginPageURL);
            }
            catch (Exception ex) {
                FSUtils.debug.error("FSIntersiteTransferService.redirectToCommonDomain: IOException : ", (Throwable)ex);
            }
            return;
        }
        catch (IOException e) {
            FSUtils.debug.error("FSIntersiteTransferService.redirectToCommonDomain: IOException occured while trying to redirect to the CommonDomain: ", (Throwable)e);
            return;
        }
    }

    private String findRequestID(HttpServletRequest request) {
        FSUtils.debug.message("FSIntersiteTransferService.findRequestID: Called");
        String requestID = request.getParameter("RequestID");
        if (requestID == null || requestID.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.findRequestID:No requestID in the query string");
            }
            return null;
        }
        return requestID;
    }

    private String signAndReturnQueryString(String queryString, String certAlias) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSIntersiteTransferService.signAndReturnQueryString: Called");
        }
        if (queryString == null || queryString.length() == 0) {
            FSUtils.debug.error("FSIntersiteTransferService.signAndReturnQueryString: " + FSUtils.bundle.getString("nullInput"));
            return null;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSIntersiteTransferService.signAndReturnQueryString: certAlias: " + certAlias);
        }
        if (queryString == null || queryString.length() == 0) {
            FSUtils.debug.error("FSIntersiteTransferService.signAndReturnQueryString: " + FSUtils.bundle.getString("nullInput"));
            return null;
        }
        FSSignatureManager manager = FSSignatureManager.getInstance();
        String sigAlg = "SHA1withRSA";
        if (manager.getKeyProvider().getPrivateKey(certAlias).getAlgorithm().equals("RSA")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.signAndReturnQueryString: private key algorithm is: RSA");
            }
            sigAlg = "SHA1withRSA";
        } else if (manager.getKeyProvider().getPrivateKey(certAlias).getAlgorithm().equals("DSA")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.signAndReturnQueryString: private key algorithm is: DSA");
            }
            sigAlg = "SHA1withDSA";
        } else {
            FSUtils.debug.error("FSIntersiteTransferService.signAndReturnQueryString: private key algorithm is not supported");
            return null;
        }
        byte[] signature = null;
        if (sigAlg == null || sigAlg.length() == 0) {
            sigAlg = "SHA1withRSA";
        }
        if (queryString.charAt(queryString.length() - 1) != '&') {
            queryString = queryString + "&";
        }
        String algoId = null;
        if (sigAlg.equals("SHA1withDSA")) {
            algoId = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        } else if (sigAlg.equals("SHA1withRSA")) {
            algoId = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else {
            FSUtils.debug.error("FSIntersiteTransferService.signAndReturnQueryString: Invalid signature algorithim");
            return null;
        }
        queryString = queryString + "SigAlg=" + URLEncDec.encode((String)algoId);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSIntersiteTransferService.signAndReturnQueryString: Querystring to be signed: " + queryString);
        }
        try {
            signature = manager.signBuffer(queryString, certAlias, sigAlg);
        }
        catch (FSSignatureException se) {
            FSUtils.debug.error("FSIntersiteTransferService.signAndReturnQueryString: FSSignatureException occured while signing query string: " + se.getMessage());
            return null;
        }
        if (signature == null) {
            FSUtils.debug.error("FSIntersiteTransferService.signAndReturnQueryString: Signature generated is null");
            return null;
        }
        String encodedSig = Base64.encode((byte[])signature);
        queryString = queryString + "&" + "Signature=" + URLEncDec.encode((String)encodedSig);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSIntersiteTransferService.signAndReturnQueryString:Signed Querystring: " + queryString);
        }
        return queryString;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FSUtils.debug.message("FSIntersiteTransferService.doGet: Called");
        try {
            Set affiliations;
            FSSessionManager sessionMgr;
            FSAuthnRequest authnRequest;
            String requestID;
            IDPDescriptorType idpDescriptor = null;
            String metaAlias = request.getParameter("metaAlias");
            if (metaAlias == null || metaAlias.length() == 0) {
                metaAlias = FSServiceUtils.getMetaAlias(request);
            }
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            String hostEntityId = metaManager.getEntityIDByMetaAlias(metaAlias);
            String realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
            if (request == null || response == null) {
                response.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
                return;
            }
            String qs = request.getQueryString();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.doGet: QueryString Received from CommonDomain: " + qs);
            }
            if ((requestID = this.findRequestID(request)) == null) {
                FSUtils.debug.error("FSIntersiteTransferService.doGet: " + FSUtils.bundle.getString("nullInputParameter"));
                response.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.doGet: RequestID found: " + requestID);
            }
            if ((authnRequest = (sessionMgr = FSSessionManager.getInstance(metaAlias)).getAuthnRequest(requestID)) == null) {
                FSUtils.debug.error("FSIntersiteTransferService.doGet: " + FSUtils.bundle.getString("invalidRequestId"));
                String[] data = new String[]{FSUtils.bundle.getString("invalidRequestId")};
                LogUtil.error(Level.INFO, "INVALID_AUTHN_REQUEST", data);
                response.sendError(500, FSUtils.bundle.getString("invalidRequestId"));
                return;
            }
            String resourceUrl = authnRequest.getRelayState();
            String baseURL = FSServiceUtils.getBaseURL(request);
            this.framedLoginPageURL = FSServiceUtils.getCommonLoginPageURL(metaAlias, resourceUrl, null, request, baseURL);
            String idpID = FSUtils.findPreferredIDP(realm, request);
            if (idpID == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSIntersiteTransferService.doGet: No Preffered IDP found in this Common Domain. Try to find PrefferedIDP in other common domains");
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSIntersiteTransferService.doGet: RequestID :" + requestID);
                }
                this.redirectToCommonDomain(request, response, requestID);
                return;
            }
            idpDescriptor = metaManager.getIDPDescriptor(realm, idpID);
            if (idpDescriptor == null) {
                FSUtils.debug.error("FSIntersiteTransferService.doGet: " + FSUtils.bundle.getString("noTrust"));
                String[] data = new String[]{idpID};
                LogUtil.error(Level.INFO, "PROVIDER_NOT_TRUSTED", data);
                response.sendError(500, FSUtils.bundle.getString("noTrust"));
                return;
            }
            HttpSession session = request.getSession(true);
            session.removeAttribute("CotSet");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.doGet: Preffered IDP found:" + idpID);
            }
            sessionMgr.setIDPEntityID(requestID, idpID);
            int minorVersion = FSServiceUtils.getMinorVersion(idpDescriptor.getProtocolSupportEnumeration());
            authnRequest.setMinorVersion(minorVersion);
            authnRequest.getAuthnContext().setMinorVersion(minorVersion);
            SPDescriptorType hostDesc = metaManager.getSPDescriptor(realm, hostEntityId);
            SPDescriptorConfigElement hostConfig = metaManager.getSPDescriptorConfig(realm, hostEntityId);
            if (IDFFMetaUtils.getBooleanAttributeValueFromConfig(hostConfig, "enableAffiliation") && (affiliations = metaManager.getAffiliateEntity(realm, idpID)) != null && !affiliations.isEmpty()) {
                AffiliationDescriptorType affiliateDescriptor = (AffiliationDescriptorType)affiliations.iterator().next();
                authnRequest.setAffiliationID(affiliateDescriptor.getAffiliationID());
            }
            if (minorVersion == 2 && IDFFMetaUtils.getBooleanAttributeValueFromConfig(hostConfig, "enableIDPProxy")) {
                FSScoping scoping = new FSScoping();
                scoping.setProxyCount(Integer.parseInt(IDFFMetaUtils.getFirstAttributeValueFromConfig(hostConfig, "idpProxyCount")));
                List proxyIDPs = IDFFMetaUtils.getAttributeValueFromConfig(hostConfig, "idpProxyList");
                if (proxyIDPs != null && !proxyIDPs.isEmpty()) {
                    Iterator iter = proxyIDPs.iterator();
                    ArrayList<IDPEntry> list = new ArrayList<IDPEntry>();
                    while (iter.hasNext()) {
                        IDPEntry entry = new IDPEntry((String)iter.next(), null, null);
                        list.add(entry);
                    }
                    IDPEntries entries = new IDPEntries(list);
                    FSIDPList idpList = new FSIDPList(entries, null);
                    scoping.setIDPList(idpList);
                }
                authnRequest.setScoping(scoping);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.doGet: AuthnRequest:" + authnRequest.toXMLString(true, true));
            }
            if (authnRequest.getProtocolProfile().equals("http://projectliberty.org/profiles/brws-art") || authnRequest.getProtocolProfile().equals("http://projectliberty.org/profiles/brws-post")) {
                this.handleBrowserArtifactPOSTIST(request, response, authnRequest, idpDescriptor, hostDesc, hostConfig);
                return;
            }
            if (authnRequest.getProtocolProfile().equals("http://projectliberty.org/profiles/wml-post")) {
                this.handleWMLIST(request, response, authnRequest, idpDescriptor);
                return;
            }
            FSUtils.debug.error("FSIntersiteTransferService.doGet: Unknown Protocol Profile");
            String[] data = new String[]{FSUtils.bundle.getString("invalidAuthnRequest")};
            LogUtil.error(Level.INFO, "INVALID_AUTHN_REQUEST", data);
            response.sendError(500, FSUtils.bundle.getString("invalidAuthnRequest"));
            return;
        }
        catch (Exception e) {
            block22: {
                FSUtils.debug.error("FSIntersiteTransferService.doGet: ", (Throwable)e);
                try {
                    response.sendError(500, FSUtils.bundle.getString("Exception"));
                }
                catch (IOException ioe) {
                    if (!FSUtils.debug.messageEnabled()) break block22;
                    FSUtils.debug.message("FSIntersiteTransferService.doGet: " + FSUtils.bundle.getString("sendFailed") + ioe.getMessage());
                }
            }
            return;
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void handleBrowserArtifactPOSTIST(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, IDPDescriptorType idpDescriptor, SPDescriptorType hostDesc, BaseConfigType hostConfig) {
        FSUtils.debug.message("FSIntersiteTransferService.handleBrowserArtifactPOSTIST: Called");
        try {
            FederationSPAdapter spAdapter;
            if (request == null || response == null || authnRequest == null || idpDescriptor == null) {
                FSUtils.debug.error("FSIntersiteTransferService.doGet: " + FSUtils.bundle.getString("nullInputParameter"));
                response.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
                return;
            }
            String targetURL = idpDescriptor.getSingleSignOnServiceURL();
            if (targetURL == null) {
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.handleBrowserArtifactPOSTIST: Destination URL to send AuthnRequest: " + targetURL);
            }
            if ((spAdapter = FSServiceUtils.getSPAdapter(authnRequest.getProviderId(), hostConfig)) != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSIntersiteTransferService, GET, call spAdapter.preSSOFederationRequest");
                }
                try {
                    spAdapter.preSSOFederationRequest(authnRequest.getProviderId(), idpDescriptor.getId(), request, response, authnRequest);
                }
                catch (Exception e) {
                    FSUtils.debug.error("FSIntersiteTransferService,GET SPAdapter.preSSOFederationRequest:", (Throwable)e);
                }
            }
            StringBuffer tmp = new StringBuffer(1000);
            String queryString = authnRequest.toURLEncodedQueryString();
            if (queryString == null) {
                FSUtils.debug.error("FSIntersiteTransferService.handleBrowserArtifactPOSTIST: " + FSUtils.bundle.getString("invalidRequest"));
                String[] data = new String[]{FSUtils.bundle.getString("invalidRequest")};
                LogUtil.error(Level.INFO, "INVALID_AUTHN_REQUEST", data);
                response.sendError(500, FSUtils.bundle.getString("invalidRequest"));
                return;
            }
            String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostConfig, "signingCertAlias");
            boolean authnRequestSigned = hostDesc.isAuthnRequestsSigned();
            if (FSServiceUtils.isSigningOn() && authnRequestSigned && (queryString = this.signAndReturnQueryString(queryString, certAlias)) == null) {
                FSUtils.debug.error("FSIntersiteTransferService.handleBrowserArtifactPOSTIST: AuthnRequest signing failed");
                response.sendError(500, FSUtils.bundle.getString("signFailed"));
                return;
            }
            if (targetURL.indexOf("?") != -1) {
                tmp.append(targetURL).append("&").append(queryString);
            } else {
                tmp.append(targetURL).append("?").append(queryString);
            }
            String[] data = new String[]{targetURL};
            LogUtil.access(Level.FINER, "REDIRECT_TO", data);
            String redirecto = tmp.toString();
            if (redirecto.length() > 1256) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSIntersiteTransferService.handleBrowserArtifactPOSTIST: Redirection URL length exceeding the URL MAX length restriction. Switching to form post");
                }
                if (authnRequestSigned) {
                    authnRequest.signXML(certAlias);
                }
                this.sendAuthnRequestPost(response, targetURL, authnRequest);
                return;
            }
            response.setStatus(302);
            response.setHeader("Location", redirecto);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.handleBrowserArtifactPOSTIST: Sending AuthnRequest by http-redirect to: " + targetURL);
            }
            response.sendRedirect(redirecto);
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSIntersiteTransferService.handleBrowserArtifactPOSTIST:", (Throwable)ex);
            try {
                response.sendError(500, FSUtils.bundle.getString("Exception"));
            }
            catch (IOException ioe) {
                FSUtils.debug.error("FSIntersiteTransferService.handleBrowserArtifactPOSTIST: " + FSUtils.bundle.getString("sendFailed"), (Throwable)ioe);
            }
            return;
        }
    }

    private void handleWMLIST(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, IDPDescriptorType idpDescriptor) {
        try {
            FSUtils.debug.message("FSIntersiteTransferService.handleWMLIST: Called");
            if (request == null || response == null || authnRequest == null || idpDescriptor == null) {
                FSUtils.debug.error("FSIntersiteTransferService.handleWMLIST: " + FSUtils.bundle.getString("nullInputParameter"));
                response.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
                return;
            }
            String targetURL = idpDescriptor.getSingleSignOnServiceURL();
            if (targetURL == null) {
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.handleWMLIST: Destination URL to send AuthnRequest: " + targetURL);
            }
            String[] data = new String[]{targetURL};
            LogUtil.access(Level.INFO, "REDIRECT_TO", data);
            this.sendWMLB64Post(response, targetURL, authnRequest);
            return;
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSIntersiteTransferService.handleWMLIST: " + FSUtils.bundle.getString("Exception"), (Throwable)ex);
            try {
                response.sendError(500, FSUtils.bundle.getString("Exception"));
            }
            catch (IOException ioe) {
                FSUtils.debug.error("FSIntersiteTransferService.handleWMLIST: " + FSUtils.bundle.getString("sendFailed"), (Throwable)ioe);
            }
            return;
        }
    }

    private boolean sendWMLB64Post(HttpServletResponse response, String destination, FSAuthnRequest authnRequest) {
        FSUtils.debug.message("FSIntersiteTransferService:sendWMLB64Post: Called");
        try {
            response.setContentType("text/vnd.wap.wml");
            PrintWriter out = response.getWriter();
            out.println("<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">");
            out.println("<wml>");
            out.println("<card id=\"request\" title=\"SP Request\">");
            out.println("<onevent type=\"onenterforward\">");
            out.println("<go method=\"post\" href=\"" + destination + "\">");
            out.println("<postfield name=\"LAREQ\" value=\"" + authnRequest.toBASE64EncodedString() + "\"/>");
            out.println("</go>");
            out.println("</onevent>");
            out.println("<onevent type=\"onenterbackward\">");
            out.println("<prev/>");
            out.println("</onevent>");
            out.println("<p>");
            out.println("Contacting IdP. Please wait....");
            out.println("</p>");
            out.println("</card>");
            out.println("</wml>");
            out.close();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService:sendWMLB64Post: Base64 Encoded AuthnRequest at the Sender: " + authnRequest.toBASE64EncodedString());
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService:sendWMLB64Post: AuthnRequest sent successfully to: " + destination);
            }
            return true;
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSIntersiteTransferService:sendWMLB64Post:", (Throwable)ex);
            return false;
        }
    }

    protected void sendAuthnRequestPost(HttpServletResponse response, String destination, FSAuthnRequest authnRequest) {
        FSUtils.debug.message("FSIntersiteTransferService.sendAuthnRequestPost: Called");
        try {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println("<HTML>");
            out.println("<BODY Onload=\"document.Request.submit()\">");
            out.println("<FORM NAME=\"Request\" METHOD=\"POST\" ACTION=\"" + destination + "\">");
            out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"LAREQ\" VALUE=\"" + authnRequest.toBASE64EncodedString() + "\"/>");
            out.println("</FORM>");
            out.println("</BODY></HTML>");
            out.close();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService:sendAuthnRequestPost: Base64 Encoded AuthnRequest at the Sender: " + authnRequest.toBASE64EncodedString() + "\nFSIntersiteTransferService:sendAuthnRequestPost: " + "AuthnRequest sent successfully to: " + destination);
            }
            return;
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSIntersiteTransferService:sendAuthnRequestPost:", (Throwable)ex);
            return;
        }
    }
}

