/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSRedirectException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.jaxb.entityconfig.SPDescriptorConfigElement;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSResponse;
import com.sun.identity.federation.message.FSSAMLRequest;
import com.sun.identity.federation.message.FSScoping;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSAssertionManager;
import com.sun.identity.federation.services.FSAuthContextResult;
import com.sun.identity.federation.services.FSAuthnDecisionHandler;
import com.sun.identity.federation.services.FSIDPProxy;
import com.sun.identity.federation.services.FSRealmIDPProxy;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.logout.FSTokenListener;
import com.sun.identity.federation.services.util.FSNameIdentifierHelper;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureManager;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml2.xmlsig.SigManager;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class FSSSOAndFedHandler {
    private static FSIDPProxy proxyFinder = null;
    private static FSRealmIDPProxy realmProxyFinder = null;
    protected static IDFFMetaManager metaManager = null;
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected SPDescriptorType spDescriptor = null;
    protected BaseConfigType spConfig = null;
    protected String spEntityId = null;
    protected String relayState = null;
    protected FSAuthnRequest authnRequest = null;
    protected Object ssoToken = null;
    protected String metaAlias = null;
    protected IDPDescriptorType hostedDesc = null;
    protected BaseConfigType hostedConfig = null;
    protected String realm = null;
    protected String hostedEntityId = null;
    protected Status noFedStatus = null;
    protected FSAccountManager accountManager = null;

    public void setMetaAlias(String metaAlias) {
        this.metaAlias = metaAlias;
        try {
            this.accountManager = FSAccountManager.getInstance(metaAlias);
        }
        catch (FSAccountMgmtException e) {
            FSUtils.debug.error("FSSSOAndFedHandler: couldn't obtain account manager:", (Throwable)((Object)e));
        }
    }

    public void setHostedEntityId(String hostedEntityId) {
        this.hostedEntityId = hostedEntityId;
    }

    public void setHostedDescriptor(IDPDescriptorType hostedDesc) {
        this.hostedDesc = hostedDesc;
    }

    public void setHostedDescriptorConfig(BaseConfigType hostedConfig) {
        this.hostedConfig = hostedConfig;
    }

    public String getHostedEntityId() {
        return this.hostedEntityId;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    protected FSSSOAndFedHandler() {
    }

    public FSSSOAndFedHandler(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, SPDescriptorType spDescriptor, BaseConfigType spConfig, String spEntityId, String relayState, Object ssoToken) {
        this.request = request;
        this.response = response;
        this.relayState = relayState;
        this.authnRequest = authnRequest;
        this.spDescriptor = spDescriptor;
        this.spConfig = spConfig;
        this.spEntityId = spEntityId;
        this.ssoToken = ssoToken;
    }

    public FSSSOAndFedHandler(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, SPDescriptorType spDescriptor, BaseConfigType spConfig, String spEntityId, String relayState) {
        this.request = request;
        this.response = response;
        this.authnRequest = authnRequest;
        this.spDescriptor = spDescriptor;
        this.spConfig = spConfig;
        this.spEntityId = spEntityId;
        this.relayState = relayState;
    }

    public FSSSOAndFedHandler(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public boolean processPreAuthnSSO(FSAuthnRequest authnRequest) {
        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: Called");
        String loginURL = null;
        ArrayList<String> authenticationContextClassRef = null;
        String currentAuthnContextRef = null;
        String authType = null;
        FSAuthContextResult authnResult = null;
        FSSessionManager sessionMgr = FSSessionManager.getInstance(this.metaAlias);
        if (authnRequest.getAuthnContext() != null) {
            authenticationContextClassRef = authnRequest.getAuthnContext().getAuthnContextClassRefList();
            if (authenticationContextClassRef == null) {
                String authCtxRefDefault = "http://www.projectliberty.org/schemas/authctx/classes/Password";
                authenticationContextClassRef = new ArrayList<String>();
                authenticationContextClassRef.add(authCtxRefDefault);
            }
            authType = authnRequest.getAuthContextCompType();
            currentAuthnContextRef = null;
        }
        boolean authenticated = true;
        Object ssoToken = null;
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            ssoToken = sessionProvider.getSession(this.request);
            if (ssoToken == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: session is null. User is not authenticated.");
                }
                authenticated = false;
            } else if (!sessionProvider.isValid(ssoToken)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: session is not valid. User is not authenticated.");
                }
                authenticated = false;
            } else {
                FSSession ssoSession = sessionMgr.getSession(ssoToken);
                if (ssoSession != null) {
                    currentAuthnContextRef = ssoSession.getAuthnContext();
                    if (currentAuthnContextRef != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User has an existing valid session with authnContext: " + currentAuthnContextRef);
                        }
                    } else {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context information not found using default authentication context");
                        }
                        currentAuthnContextRef = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "defaultAuthnContext");
                    }
                } else {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authenticated session information is not present in FSSessionManager. using default authentication context");
                    }
                    currentAuthnContextRef = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "defaultAuthnContext");
                }
                authenticated = true;
            }
            if (authenticated) {
                try {
                    sessionProvider.addListener(ssoToken, new FSTokenListener(this.metaAlias));
                }
                catch (Exception e) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: Couldn't add listener to session:", (Throwable)e);
                    }
                }
            }
        }
        catch (SessionException se) {
            FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: SSOException Occured: User does not have session " + se.getMessage());
            authenticated = false;
        }
        if (!authenticated) {
            try {
                String preferredIDP;
                boolean isProxy = this.isIDPProxyEnabled(authnRequest);
                if (isProxy && !authnRequest.getFederate() && (preferredIDP = this.getPreferredIDP(authnRequest)) != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO:IDP to be proxied" + preferredIDP);
                    }
                    this.sendProxyAuthnRequest(authnRequest, preferredIDP);
                    return true;
                }
            }
            catch (FSRedirectException re) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandle.processPreAuthnSSO:Redirecting for the proxy handling.");
                }
                return true;
            }
            catch (Exception ex) {
                FSUtils.debug.error("FSSSOAndFedHandler.processPreAuthnSSO:Exception occured while processing for the proxy.", (Throwable)ex);
                return false;
            }
        }
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication status: " + authenticated);
            }
            FSAuthnDecisionHandler authnDecisionHandler = new FSAuthnDecisionHandler(this.realm, this.hostedEntityId, this.request);
            ArrayList<String> defAuthnCxtList = new ArrayList<String>();
            defAuthnCxtList.add(IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "defaultAuthnContext"));
            if (authnRequest.getIsPassive()) {
                if (authnRequest.getForceAuthn()) {
                    if (FSUtils.debug.warningEnabled()) {
                        FSUtils.debug.warning("FSSSOAndFedHandler.PreAuthnSSO: IDP is passive can't force authentication.");
                    }
                    return false;
                }
                if (authenticated) {
                    if (authenticationContextClassRef != null) {
                        authnResult = authnDecisionHandler.decideAuthnContext(authenticationContextClassRef, currentAuthnContextRef, authType);
                    } else {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context is default");
                        }
                        authnResult = authnDecisionHandler.getURLForAuthnContext(defAuthnCxtList, authType);
                    }
                    if (authnResult == null) {
                        return false;
                    }
                    if (authnResult.getLoginURL() != null) {
                        loginURL = authnResult.getLoginURL();
                        loginURL = this.formatLoginURL(loginURL, authnResult.getAuthContextRef());
                        FSUtils.forwardRequest(this.request, this.response, loginURL);
                        return true;
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context is evaluated to be valid");
                    }
                    return this.processPostAuthnSSO(authnRequest);
                }
                if (FSUtils.debug.warningEnabled()) {
                    FSUtils.debug.warning("FSSSOAndFedHandler.processPreAuthnSSO: IDP is passive and user is not authenticated");
                }
                this.noFedStatus = new Status(new StatusCode("samlp:Responder", new StatusCode("lib:NoPassive", null)), FSUtils.bundle.getString("AuthnRequestProcessingFailed"), null);
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: AuthnRequest is active");
            }
            if (authnRequest.getForceAuthn()) {
                authnResult = authenticationContextClassRef != null ? authnDecisionHandler.getURLForAuthnContext(authenticationContextClassRef, authType) : authnDecisionHandler.getURLForAuthnContext(defAuthnCxtList);
                if (authnResult == null || authnResult.getLoginURL() == null || authnResult.getLoginURL().length() == 0) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO:AuthnDecision engine failed to take a authn decision");
                    }
                    return false;
                }
                if (ssoToken != null) {
                    try {
                        SessionManager.getProvider().invalidateSession(ssoToken, this.request, this.response);
                    }
                    catch (SessionException ssoe) {
                        FSUtils.debug.error("FSSSOAndFedHandler.processPreAuthnSSO:Unable to invalidate the sso session.");
                    }
                    ssoToken = null;
                }
                loginURL = authnResult.getLoginURL();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: AuthnDecision engine returned: " + loginURL);
                }
                loginURL = this.formatLoginURL(loginURL, authnResult.getAuthContextRef());
                FSUtils.forwardRequest(this.request, this.response, loginURL);
                this.response.flushBuffer();
                return true;
            }
            if (authenticated) {
                if (authenticationContextClassRef != null) {
                    authnResult = authnDecisionHandler.decideAuthnContext(authenticationContextClassRef, currentAuthnContextRef, authType);
                } else {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context is default");
                    }
                    authnResult = authnDecisionHandler.getURLForAuthnContext(defAuthnCxtList, authType);
                }
                if (authnResult == null) {
                    return false;
                }
                if (authnResult.getLoginURL() == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context is evaluated to be valid");
                    }
                    return this.processPostAuthnSSO(authnRequest);
                }
                if (authnResult.getLoginURL().length() == 0) {
                    return false;
                }
                loginURL = authnResult.getLoginURL();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: AuthnDecision engine returned: " + loginURL);
                }
                loginURL = this.formatLoginURL(loginURL, authnResult.getAuthContextRef());
                FSUtils.forwardRequest(this.request, this.response, loginURL);
                return true;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: AuthnRequest is active");
            }
            if (authenticationContextClassRef != null) {
                authnResult = authnDecisionHandler.getURLForAuthnContext(authenticationContextClassRef, authType);
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context is default");
                }
                authnResult = authnDecisionHandler.getURLForAuthnContext(defAuthnCxtList, authType);
            }
            if (authnResult == null || authnResult.getLoginURL() == null || authnResult.getLoginURL().length() == 0) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler. processPreAuthnSSO:  AuthnDecision engine failed to take a decision");
                }
                this.noFedStatus = new Status(new StatusCode("samlp:Responder", new StatusCode("lib:NoAuthnContext", null)), FSUtils.bundle.getString("AuthnRequestProcessingFailed"), null);
                return false;
            }
            loginURL = authnResult.getLoginURL();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: AuthnDecision engine returned: " + loginURL);
            }
            loginURL = this.formatLoginURL(loginURL, authnResult.getAuthContextRef());
            FSUtils.forwardRequest(this.request, this.response, loginURL);
            return true;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSSOAndFedHandler.processPreAuthnSSO: Exception occured");
            return this.processPostAuthnSSO(authnRequest);
        }
    }

    public String formatLoginURL(String loginUrl, String authnContext) {
        FSUtils.debug.message("FSSSOAndFedHandler.formatLoginURL: Called");
        try {
            if (loginUrl == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.formatLoginURL: ");
                return null;
            }
            String ssoUrl = this.hostedDesc.getSingleSignOnServiceURL();
            StringBuffer returnUrl = new StringBuffer(ssoUrl);
            if (ssoUrl.indexOf(63) == -1) {
                returnUrl.append("?");
            } else {
                returnUrl.append("&");
            }
            returnUrl.append("Authn").append("=").append("true").append("&").append("AuthnContext").append("=").append(URLEncDec.encode((String)authnContext)).append("&").append("realm").append("=").append(URLEncDec.encode((String)this.realm)).append("&").append("_liberty_idp").append("=").append(URLEncDec.encode((String)this.hostedEntityId)).append("&").append("metaAlias").append("=").append(URLEncDec.encode((String)this.metaAlias)).append("&").append("RequestID").append("=").append(URLEncDec.encode((String)this.authnRequest.getRequestID()));
            String postLoginUrl = FSServiceUtils.getBaseURL(this.request) + "/postLogin";
            StringBuffer gotoUrl = new StringBuffer(postLoginUrl);
            if (postLoginUrl.indexOf(63) == -1) {
                gotoUrl.append("?");
            } else {
                gotoUrl.append("&");
            }
            gotoUrl.append("RelayState").append("=").append(URLEncDec.encode((String)returnUrl.toString())).append("&").append("sso").append("=").append("true").append("&").append("metaAlias").append("=").append(this.metaAlias);
            StringBuffer redirectUrl = new StringBuffer(100);
            redirectUrl.append(loginUrl);
            if (loginUrl.indexOf(63) == -1) {
                redirectUrl.append("?");
            } else {
                redirectUrl.append("&");
            }
            redirectUrl.append("goto").append("=").append(URLEncDec.encode((String)gotoUrl.toString()));
            redirectUrl.append("&").append("org").append("=").append(URLEncDec.encode((String)this.realm));
            int len = redirectUrl.length() - 1;
            if (redirectUrl.charAt(len) == '&') {
                redirectUrl = redirectUrl.deleteCharAt(len);
            }
            return redirectUrl.toString();
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSSOAndFedHandler.formatLoginURL: Exception: ", (Throwable)e);
            return null;
        }
    }

    public boolean processPostAuthnSSO(FSAuthnRequest authnRequest) {
        FSUtils.debug.message("FSSSOAndFedHandler.processPostAuthnSSO: Called");
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = SessionManager.getProvider();
            if (this.ssoToken == null) {
                this.ssoToken = sessionProvider.getSession(this.request);
            }
            if (this.ssoToken == null || !sessionProvider.isValid(this.ssoToken)) {
                FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: session is not valid.");
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPostAuthnSSO: session is valid.");
            }
        }
        catch (SessionException se) {
            FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: ", (Throwable)((Object)se));
            return false;
        }
        String userID = null;
        String sessionID = null;
        try {
            userID = sessionProvider.getPrincipalName(this.ssoToken);
            sessionID = sessionProvider.getSessionID(this.ssoToken);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPostAuthnSSO: UserID of the principal in the session: " + userID + "sessionID of the session: " + sessionID);
            }
        }
        catch (SessionException ex) {
            FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: SessionException occured. Principal information not found in the session: ", (Throwable)((Object)ex));
            return false;
        }
        FSSessionManager sessionManager = FSSessionManager.getInstance(this.metaAlias);
        FSSession session = sessionManager.getSession(userID, sessionID);
        if (session != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPostAuthnSSO: An existing SSO session found with ID:" + session.getSessionID());
            }
            session.addSessionPartner(new FSSessionPartner(this.spEntityId, false));
            sessionManager.addSession(userID, session);
        } else {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPostAuthnSSO: No existing SSO session found. Entering a new session to the session manager with ID: " + sessionID);
            }
            session = new FSSession(sessionID);
            String sessionIndex = SAMLUtils.generateID();
            session.setSessionIndex(sessionIndex);
            session.addSessionPartner(new FSSessionPartner(this.spEntityId, false));
            sessionManager.addSession(userID, session);
        }
        String autoFedStr = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "enableAutoFederation");
        if (authnRequest.getFederate() || autoFedStr != null && autoFedStr.equalsIgnoreCase("true")) {
            FSAccountFedInfo fedInfo = this.doAccountFederation(this.ssoToken, authnRequest, session);
            NameIdentifier spNI = null;
            NameIdentifier idpNI = null;
            if (fedInfo == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: Accountfederation failed");
                return false;
            }
            spNI = fedInfo.getRemoteNameIdentifier();
            idpNI = fedInfo.getLocalNameIdentifier();
            if (idpNI == null && (idpNI = fedInfo.getRemoteNameIdentifier()) == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: Opaque handle not found");
                return false;
            }
            if (spNI == null) {
                spNI = idpNI;
            }
            return this.doSingleSignOn(this.ssoToken, authnRequest.getRequestID(), spNI, idpNI);
        }
        return this.doSingleSignOn(this.ssoToken, authnRequest.getRequestID());
    }

    protected FSAuthnResponse createAuthnResponse(Object ssoToken, String inResponseTo, NameIdentifier userHandle, NameIdentifier idpHandle) {
        FSUtils.debug.message("FSSSOAndFedHandler.createAuthnResponse:  Called");
        FSAuthnResponse authnResponse = null;
        try {
            String requestID = this.authnRequest.getRequestID();
            FSAssertionManager am = FSAssertionManager.getInstance(this.metaAlias);
            FSAssertion assertion = null;
            SessionProvider sessionProvider = SessionManager.getProvider();
            assertion = am.createFSAssertion(sessionProvider.getSessionID(ssoToken), null, this.realm, this.spEntityId, userHandle, idpHandle, inResponseTo, this.authnRequest.getMinorVersion());
            StatusCode statusCode = new StatusCode("samlp:Success");
            Status status = new Status(statusCode);
            ArrayList<FSAssertion> contents = new ArrayList<FSAssertion>();
            contents.add(assertion);
            authnResponse = new FSAuthnResponse(null, requestID, status, contents, this.relayState);
            authnResponse.setMinorVersion(this.authnRequest.getMinorVersion());
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.createAuthnResponse: CHECK1: " + this.hostedEntityId);
            }
            authnResponse.setProviderId(this.hostedEntityId);
        }
        catch (FSException se) {
            FSUtils.debug.error("FSSSOAndFedHandler.createAuthnResponse: FSException: ", (Throwable)((Object)se));
            return null;
        }
        catch (SAMLException se) {
            FSUtils.debug.error("FSSSOAndFedHandler.createAuthnResponse: SAMLException: ", (Throwable)((Object)se));
            return null;
        }
        catch (SessionException se) {
            FSUtils.debug.error("FSSSOAndFedHandler.createAuthnResponse: SessionException: ", (Throwable)((Object)se));
            return null;
        }
        return authnResponse;
    }

    protected boolean doSingleSignOn(Object ssoToken, String inResponseTo, NameIdentifier spHandle, NameIdentifier idpHandle) {
        return false;
    }

    protected boolean doSingleSignOn(Object ssoToken, String inResponseTo) {
        FSUtils.debug.message("FSSSOAndFedHandler.doSingleSignOn(2):  Called");
        try {
            NameIdentifier spNI;
            NameIdentifier idpNI;
            NameIdentifier localNI;
            String qualifier;
            FSAccountFedInfo accountInfo;
            String securityDomain = this.authnRequest.getProviderId();
            String affiliationID = this.authnRequest.getAffiliationID();
            if (affiliationID != null) {
                securityDomain = affiliationID;
            }
            SessionProvider sessionProvider = SessionManager.getProvider();
            String userID = sessionProvider.getPrincipalName(ssoToken);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.doSingleSignOn: Initiating SSO for user with ID: " + userID);
            }
            if ((accountInfo = this.accountManager.readAccountFedInfo(userID, securityDomain)) == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.doSingleSignOn: Account Federation Information not found for user with ID: " + userID);
                this.noFedStatus = new Status(new StatusCode("samlp:Responder", new StatusCode("lib:FederationDoesNotExist", null)), FSUtils.bundle.getString("AuthnRequestProcessingFailed"), null);
                String[] data = new String[]{userID};
                LogUtil.error(Level.INFO, "USER_ACCOUNT_FEDERATION_INFO_NOT_FOUND", data);
                return false;
            }
            if (accountInfo != null && accountInfo.isFedStatusActive() && accountInfo.getLocalNameIdentifier() != null && (qualifier = (localNI = accountInfo.getLocalNameIdentifier()).getNameQualifier()) != null && qualifier.equals(this.hostedEntityId)) {
                localNI = new NameIdentifier(localNI.getName(), securityDomain);
                NameIdentifier remoteNI = accountInfo.getRemoteNameIdentifier();
                if (remoteNI != null) {
                    remoteNI = new NameIdentifier(remoteNI.getName(), securityDomain);
                }
                FSAccountFedInfoKey newFedKey = new FSAccountFedInfoKey(securityDomain, localNI.getName());
                accountInfo = new FSAccountFedInfo(securityDomain, localNI, remoteNI, false);
                this.accountManager.writeAccountFedInfo(userID, newFedKey, accountInfo);
                FSAccountFedInfoKey oldFedKey = new FSAccountFedInfoKey(this.hostedEntityId, localNI.getName());
                this.accountManager.removeAccountFedInfoKey(userID, oldFedKey);
            }
            if ((idpNI = accountInfo.getLocalNameIdentifier()) == null) {
                idpNI = accountInfo.getRemoteNameIdentifier();
                if (idpNI == null) {
                    FSUtils.debug.error("FSSSOAndFedHandler.doSingleSignOn: NameIdentifier not found");
                    return false;
                }
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.doSingleSignOn: IDP generated opaque handle: " + idpNI.getName());
            }
            if ((spNI = accountInfo.getRemoteNameIdentifier()) == null) {
                spNI = idpNI;
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.doSingleSignOn: SP generated opaque handle: " + spNI.getName());
            }
            return this.doSingleSignOn(ssoToken, inResponseTo, spNI, idpNI);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSSOAndFedHandler.doSingleSignOn: Exception during Single Sign-On:", (Throwable)e);
            return false;
        }
    }

    protected FSAccountFedInfo doAccountFederation(Object ssoToken, FSAuthnRequest authnRequest, FSSession session) {
        boolean isAffiliationFed;
        String affiliationID;
        String nameIDPolicy;
        block17: {
            FSUtils.debug.message("FSSSOAndFedHandler.doAccountFederation: Called");
            nameIDPolicy = authnRequest.getNameIDPolicy();
            affiliationID = authnRequest.getAffiliationID();
            isAffiliationFed = false;
            if (affiliationID != null) {
                try {
                    isAffiliationFed = metaManager.isAffiliateMember(this.realm, this.hostedEntityId, affiliationID);
                }
                catch (Exception e) {
                    if (!FSUtils.debug.messageEnabled()) break block17;
                    FSUtils.debug.message("FSSSOAndFedHandler.doAccountFederation:Error in checking for the affiliation:", (Throwable)e);
                }
            }
        }
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            String userID = sessionProvider.getPrincipalName(ssoToken);
            FSAccountFedInfo existActInfo = null;
            if (isAffiliationFed && (existActInfo = this.accountManager.readAccountFedInfo(userID, affiliationID)) != null && existActInfo.isFedStatusActive()) {
                return existActInfo;
            }
            String nameQualifier = authnRequest.getProviderId();
            existActInfo = this.accountManager.readAccountFedInfo(userID, nameQualifier);
            if (existActInfo != null && existActInfo.isFedStatusActive()) {
                return existActInfo;
            }
            FSNameIdentifierHelper nameHelper = new FSNameIdentifierHelper(this.hostedConfig);
            String opaqueHandle = nameHelper.createNameIdentifier();
            if (opaqueHandle == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.doAccountFederation: Could not generate handle");
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.doAccountFederation: Generated handle: " + opaqueHandle);
            }
            if (isAffiliationFed) {
                nameQualifier = affiliationID;
            }
            NameIdentifier ni = new NameIdentifier(opaqueHandle, nameQualifier);
            if (authnRequest.getMinorVersion() == 2) {
                if (nameIDPolicy == null || !nameIDPolicy.equals("onetime")) {
                    ni.setFormat("urn:liberty:iff:nameid:federated");
                } else {
                    ni.setFormat("urn:liberty:iff:nameid:one-time");
                }
            }
            FSAccountFedInfo accountInfo = new FSAccountFedInfo(authnRequest.getProviderId(), ni, null, false);
            FSAccountFedInfoKey fedKey = null;
            if (isAffiliationFed) {
                fedKey = new FSAccountFedInfoKey(affiliationID, opaqueHandle);
                accountInfo.setAffiliation(true);
            } else {
                fedKey = new FSAccountFedInfoKey(authnRequest.getProviderId(), opaqueHandle);
            }
            if (nameIDPolicy == null || !nameIDPolicy.equals("onetime")) {
                this.accountManager.writeAccountFedInfo(userID, fedKey, accountInfo);
            } else {
                session.setOneTime(true);
                session.setAccountFedInfo(accountInfo);
                session.setUserID(userID);
            }
            return accountInfo;
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSSSOAndFedHandler.doAccountFederation: Exception when doing account federation", (Throwable)ex);
            return null;
        }
    }

    protected void returnErrorResponse() {
    }

    public FSResponse processSAMLRequest(FSSAMLRequest samlRequest) {
        FSUtils.debug.error("FSSSOAndFedHandler.processSAMLRequest: Call should not resolve here, abstract class.");
        return null;
    }

    public void processAuthnRequest(FSAuthnRequest authnRequest, boolean bPostAuthn) {
        FSUtils.debug.message("FSSSOAndFedHandler.processAuthnRequest: Called");
        this.authnRequest = authnRequest;
        String message = null;
        String inResponseTo = authnRequest.getRequestID();
        Status status = null;
        FSAuthnResponse errResponse = null;
        this.spEntityId = authnRequest.getProviderId();
        try {
            this.spDescriptor = metaManager.getSPDescriptor(this.realm, this.spEntityId);
            this.spConfig = metaManager.getSPDescriptorConfig(this.realm, this.spEntityId);
            if (!metaManager.isTrustedProvider(this.realm, this.hostedEntityId, this.spEntityId)) {
                FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: RemoteProvider is not trusted");
                message = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
                status = new Status(new StatusCode("samlp:Responder"), message, null);
                errResponse = new FSAuthnResponse(null, inResponseTo, status, null, this.relayState);
                errResponse.setMinorVersion(authnRequest.getMinorVersion());
                this.sendAuthnResponse(errResponse);
                return;
            }
            if (bPostAuthn) {
                if (this.processPostAuthnSSO(authnRequest)) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processAuthnRequest: AuthnRequest Processing successful");
                    }
                    return;
                }
                if (FSUtils.debug.warningEnabled()) {
                    FSUtils.debug.warning("FSSSOAndFedHandler.processAuthnRequest: AuthnRequest Processing failed");
                }
                message = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
                status = this.noFedStatus != null ? this.noFedStatus : new Status(new StatusCode("samlp:Responder"), message, null);
                errResponse = new FSAuthnResponse(null, inResponseTo, status, null, this.relayState);
                errResponse.setMinorVersion(authnRequest.getMinorVersion());
                this.sendAuthnResponse(errResponse);
                return;
            }
            boolean authnRequestSigned = this.spDescriptor.isAuthnRequestsSigned();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processAuthnRequest: ProviderID : " + this.spEntityId + " AuthnRequestSigned :this is for testing " + authnRequestSigned);
            }
            if (FSServiceUtils.isSigningOn() && authnRequestSigned) {
                if (!this.verifyRequestSignature(authnRequest)) {
                    FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: AuthnRequest Signature Verification Failed");
                    message = FSUtils.bundle.getString("signatureVerificationFailed");
                    String[] data = new String[]{message};
                    LogUtil.error(Level.INFO, "SIGNATURE VERIFICATION FAILED", data);
                    status = new Status(new StatusCode("samlp:Responder", new StatusCode("lib:UnsignedAuthnRequest", null)), message, null);
                    errResponse = new FSAuthnResponse(null, inResponseTo, status, null, this.relayState);
                    errResponse.setMinorVersion(authnRequest.getMinorVersion());
                    this.sendAuthnResponse(errResponse);
                    return;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler. processAuthnRequest: AuthnRequest Signature Verified");
                }
            }
            if (this.processPreAuthnSSO(authnRequest)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processAuthnRequest: AuthnRequest Processing successful");
                }
                return;
            }
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("FSSSOAndFedHandler.processAuthnRequest: AuthnRequest Processing failed");
            }
            String[] data = new String[]{FSUtils.bundle.getString("AuthnRequestProcessingFailed")};
            LogUtil.error(Level.INFO, "AUTHN_REQUEST_PROCESSING_FAILED", data);
            message = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
            status = new Status(new StatusCode("samlp:Responder"), message, null);
            if (this.noFedStatus != null) {
                status = this.noFedStatus;
            }
            errResponse = new FSAuthnResponse(null, inResponseTo, status, null, this.relayState);
            errResponse.setMinorVersion(authnRequest.getMinorVersion());
            this.sendAuthnResponse(errResponse);
            return;
        }
        catch (Exception e) {
            block17: {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(out));
                FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: Exception Occured: " + e.getMessage() + "Stack trace is " + out.toString());
                message = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
                try {
                    status = new Status(new StatusCode("samlp:Responder"), message, null);
                    errResponse = new FSAuthnResponse(null, inResponseTo, status, null, this.relayState);
                    errResponse.setMinorVersion(authnRequest.getMinorVersion());
                    this.sendAuthnResponse(errResponse);
                }
                catch (Exception ex) {
                    if (!FSUtils.debug.messageEnabled()) break block17;
                    FSUtils.debug.message("FSSSOAndFedHandler.processAuthnRequest: Exception Occured: ", (Throwable)ex);
                }
            }
            return;
        }
    }

    protected void sendAuthnResponse(FSAuthnResponse authnResponse) {
        FSUtils.debug.error("FSSSOAndFedHandler.sendAuthnResponse: Call should not resolve here. error");
    }

    public void setSPDescriptor(SPDescriptorType spDescriptor) {
        this.spDescriptor = spDescriptor;
    }

    public SPDescriptorType getProvider() {
        return this.spDescriptor;
    }

    protected boolean verifyRequestSignature(FSAuthnRequest authnRequest) {
        FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: Called");
        try {
            int minorVersion;
            X509Certificate cert = KeyUtil.getVerificationCert(this.spDescriptor, this.spEntityId, false);
            if (cert == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: couldn't obtain this site's cert.");
                }
                throw new FSException("cannot-find-cert", null);
            }
            if (this.request.getMethod().equals("GET")) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: Request is sent by GET");
                }
                String sigAlg = this.request.getParameter("SigAlg");
                String encSig = this.request.getParameter("Signature");
                if (sigAlg == null || sigAlg.length() == 0 || encSig == null || encSig.length() == 0) {
                    return false;
                }
                String algoId = null;
                if (sigAlg.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                    algoId = "SHA1withDSA";
                } else if (sigAlg.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                    algoId = "SHA1withRSA";
                } else {
                    FSUtils.debug.error("FSSSOAndFedHandler.signAndReturnQueryString: Invalid signature algorithim");
                    return false;
                }
                String queryString = this.request.getQueryString();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: queryString:" + queryString);
                }
                int sigIndex = queryString.indexOf("&Signature");
                String newQueryString = queryString.substring(0, sigIndex);
                byte[] signature = null;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: Signature: " + encSig + "Algorithm: " + algoId);
                }
                signature = Base64.decode((String)encSig);
                FSSignatureManager fsmanager = FSSignatureManager.getInstance();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: String to be verified: " + newQueryString);
                }
                return fsmanager.verifySignature(newQueryString, signature, algoId, cert);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: Request is sent by POST ");
            }
            if ((minorVersion = authnRequest.getMinorVersion()) == 0) {
                return SigManager.getSigInstance().verify(authnRequest.getSignedXMLString(), "id", cert);
            }
            if (minorVersion == 2) {
                return SigManager.getSigInstance().verify(authnRequest.getSignedXMLString(), "RequestID", cert);
            }
            FSUtils.debug.message("invalid minor version.");
            return false;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSSOAndFedHandler.verifyRequestSignature: Exception occured while verifying SP's signature:", (Throwable)e);
            return false;
        }
    }

    public static String cleanMetaAlias(HttpServletRequest request) {
        FSUtils.debug.message("FSSSOAndFedHandler.cleanMetaAlias: Called");
        Enumeration paramEnum = request.getParameterNames();
        String returnString = new String();
        while (paramEnum.hasMoreElements()) {
            String paramKey = (String)paramEnum.nextElement();
            if (paramKey.equalsIgnoreCase("metaAlias")) {
                FSUtils.debug.message("FSSSOAndFedHandler.cleanMetaAlias: found metaAlias");
                continue;
            }
            String paramValue = request.getParameter(paramKey);
            if (returnString == null || returnString.length() < 1) {
                returnString = paramKey + "=" + URLEncDec.encode((String)paramValue);
                continue;
            }
            returnString = returnString + "&" + paramKey + "=" + URLEncDec.encode((String)paramValue);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOAndFedHandler.cleanMetaAlias:  returning with " + returnString);
        }
        return returnString;
    }

    protected void sendProxyAuthnRequest(FSAuthnRequest authnRequest, String preferredIDP) throws FSException, IOException {
        FSAuthnRequest newAuthnRequest = this.getNewAuthnRequest(authnRequest);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOAndFedHandler.sendProxyAuthnRequest:New Authentication request:" + newAuthnRequest.toXMLString());
        }
        FSSessionManager sessManager = FSSessionManager.getInstance(this.metaAlias);
        String requestID = newAuthnRequest.getRequestID();
        sessManager.setAuthnRequest(requestID, newAuthnRequest);
        sessManager.setProxySPDescriptor(requestID, this.spDescriptor);
        sessManager.setProxySPAuthnRequest(requestID, authnRequest);
        sessManager.setIDPEntityID(requestID, preferredIDP);
        String targetURL = null;
        SPDescriptorType localDescriptor = null;
        SPDescriptorConfigElement localDescriptorConfig = null;
        try {
            IDPDescriptorType idpDescriptor = metaManager.getIDPDescriptor(this.realm, preferredIDP);
            targetURL = idpDescriptor.getSingleSignOnServiceURL();
            if (targetURL == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.sendProxyAuthnRequest: Single Sign-on service is not found for the proxying IDP");
                return;
            }
            localDescriptor = metaManager.getSPDescriptor(this.realm, this.hostedEntityId);
            localDescriptorConfig = metaManager.getSPDescriptorConfig(this.realm, this.hostedEntityId);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSSOAndFedHandler.sendProxyAuthnRequest:", (Throwable)e);
            return;
        }
        String queryString = newAuthnRequest.toURLEncodedQueryString();
        if (FSServiceUtils.isSigningOn()) {
            String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(localDescriptorConfig, "signingCertAlias");
            if (localDescriptor.isAuthnRequestsSigned()) {
                queryString = FSSignatureUtil.signAndReturnQueryString(queryString, certAlias);
            }
        }
        StringBuffer tmpURL = new StringBuffer(1000);
        if (targetURL.indexOf("?") != -1) {
            tmpURL.append(targetURL).append("&").append(queryString);
        } else {
            tmpURL.append(targetURL).append("?").append(queryString);
        }
        String redirectURL = tmpURL.toString();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOAndFedHandler.sendProxyAuthnRequest:SSO URL to be redirected" + redirectURL);
        }
        this.response.setStatus(302);
        this.response.setHeader("Location", redirectURL);
        this.response.sendRedirect(redirectURL);
    }

    protected boolean isIDPProxyEnabled(FSAuthnRequest authnRequest) throws FSException {
        if (authnRequest.getMinorVersion() != 2) {
            return false;
        }
        FSScoping scoping = authnRequest.getScoping();
        if (scoping != null && scoping.getProxyCount() == 0) {
            return false;
        }
        String enabledString = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.spConfig, "enableIDPProxy");
        return enabledString != null && enabledString.equalsIgnoreCase("true");
    }

    private String getPreferredIDP(FSAuthnRequest authnRequest) throws FSRedirectException {
        if (realmProxyFinder != null) {
            return realmProxyFinder.getPreferredIDP(authnRequest, this.realm, this.hostedEntityId, this.request, this.response);
        }
        return proxyFinder.getPreferredIDP(authnRequest, this.hostedEntityId, this.request, this.response);
    }

    private FSAuthnRequest getNewAuthnRequest(FSAuthnRequest origRequest) throws FSException {
        try {
            int proxyCount;
            FSAuthnRequest newRequest = new FSAuthnRequest(null, origRequest.getRespondWith(), this.hostedEntityId, origRequest.getForceAuthn(), origRequest.getIsPassive(), false, origRequest.getNameIDPolicy(), origRequest.getProtocolProfile(), origRequest.getAuthnContext(), origRequest.getRelayState(), origRequest.getAuthContextCompType());
            newRequest.setMinorVersion(2);
            FSScoping scoping = origRequest.getScoping();
            if (scoping != null && (proxyCount = scoping.getProxyCount()) > 0) {
                FSScoping newScoping = new FSScoping();
                newScoping.setProxyCount(proxyCount - 1);
                newScoping.setIDPList(scoping.getIDPList());
                newRequest.setScoping(newScoping);
            }
            return newRequest;
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSSSOAndFedHandler.getNewAuthnRequest:Error in creating new authn request.", (Throwable)ex);
            throw new FSException(ex);
        }
    }

    static {
        metaManager = FSUtils.getIDFFMetaManager();
        try {
            String proxyFinderClass = SystemConfigurationUtil.getProperty("com.sun.identity.federation.proxyfinder");
            if (proxyFinderClass != null && proxyFinderClass.length() != 0) {
                Object proxyClass = Thread.currentThread().getContextClassLoader().loadClass(proxyFinderClass).newInstance();
                if (proxyClass instanceof FSRealmIDPProxy) {
                    realmProxyFinder = (FSRealmIDPProxy)proxyClass;
                } else if (proxyClass instanceof FSIDPProxy) {
                    proxyFinder = (FSIDPProxy)proxyClass;
                }
            }
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSSSOAndFedHandler:Static Init Failed", (Throwable)ex);
        }
    }
}

