/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.termination;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.message.FSFederationTerminationNotification;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.plugins.FederationSPAdapter;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.encode.CookieUtils;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;

public class FSFedTerminationHandler {
    protected HttpServletResponse response;
    protected HttpServletRequest request;
    protected String locale = null;
    protected Object ssoToken = null;
    protected String userID = null;
    protected FSAccountFedInfo acctInfo = null;
    protected ProviderDescriptorType remoteDescriptor = null;
    protected ProviderDescriptorType hostedDescriptor = null;
    protected BaseConfigType hostedConfig = null;
    protected String relayState = "";
    protected FSAccountManager managerInst = null;
    protected static String termination_done_url = null;
    protected static String error_page_url = null;
    protected static final String FEDERATE_COOKIE_NAME = SystemConfigurationUtil.getProperty("com.sun.identity.federation.fedCookieName");
    protected static final String RELAY_STATE = "RelayState";
    protected String realm = "";
    protected String hostedEntityId = "";
    protected String remoteEntityId = "";
    protected String metaAlias = "";
    protected String hostedProviderRole = null;

    public FSFedTerminationHandler() {
        FSUtils.debug.message("FSFedTerminationHandler Constructor...");
    }

    protected void setTerminationURL() {
        termination_done_url = FSServiceUtils.getTerminationDonePageURL(this.request, this.hostedConfig, this.metaAlias);
        error_page_url = FSServiceUtils.getErrorPageURL(this.request, this.hostedConfig, this.metaAlias);
    }

    public void setHostedDescriptor(ProviderDescriptorType hostedDescriptor) {
        FSUtils.debug.message("Entered FSSPFedTerminationHandler::setHostedDescriptor");
        this.hostedDescriptor = hostedDescriptor;
    }

    public void setHostedDescriptorConfig(BaseConfigType hostedConfig) {
        this.hostedConfig = hostedConfig;
    }

    public void setHostedEntityId(String hostedId) {
        this.hostedEntityId = hostedId;
    }

    public void setHostedProviderRole(String hostedProviderRole) {
        this.hostedProviderRole = hostedProviderRole;
    }

    public void setMetaAlias(String metaAlias) {
        this.metaAlias = metaAlias;
        try {
            this.managerInst = FSAccountManager.getInstance(metaAlias);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSFedTerminationHandler " + FSUtils.bundle.getString("federation-failed-account-instance"));
            this.managerInst = null;
        }
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setRemoteEntityId(String remoteId) {
        this.remoteEntityId = remoteId;
    }

    public void setRemoteDescriptor(ProviderDescriptorType remoteDescriptor) {
        FSUtils.debug.message("Entered FSFedTerminationHandler::setRemoteDescriptor");
        this.remoteDescriptor = remoteDescriptor;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public void setAccountInfo(FSAccountFedInfo acctInfo) {
        this.acctInfo = acctInfo;
    }

    public boolean setUserID(FSFederationTerminationNotification reqTermination) {
        try {
            String sourceProviderId = "";
            if (this.managerInst != null) {
                sourceProviderId = reqTermination.getProviderId();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("sourceProviderId : " + sourceProviderId);
                }
                String opaqueHandle = reqTermination.getNameIdentifier().getName().trim();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("processTerminationRequest Handle : " + opaqueHandle);
                }
                String associatedDomain = reqTermination.getNameIdentifier().getNameQualifier().trim();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Name Qualifier : " + associatedDomain);
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Realm : " + this.realm);
                }
                String searchDomain = this.hostedEntityId;
                if (associatedDomain != null && associatedDomain.length() != 0 && !sourceProviderId.equals(associatedDomain)) {
                    searchDomain = associatedDomain;
                }
                FSAccountFedInfoKey acctkey = new FSAccountFedInfoKey(searchDomain, opaqueHandle);
                HashMap<String, FSFederationTerminationNotification> env = new HashMap<String, FSFederationTerminationNotification>();
                env.put("FSFederationTerminationNotification", reqTermination);
                this.userID = this.managerInst.getUserID(acctkey, this.realm, env);
                if (this.userID == null) {
                    acctkey = new FSAccountFedInfoKey(this.remoteEntityId, opaqueHandle);
                    this.userID = this.managerInst.getUserID(acctkey, this.realm, env);
                    if (this.userID == null) {
                        FSUtils.debug.message("UserID is null");
                        return false;
                    }
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("user id is " + this.userID);
                }
                return true;
            }
        }
        catch (FSAccountMgmtException e) {
            FSUtils.debug.error("In FSAccountMgmtException :: ", (Throwable)((Object)e));
        }
        this.userID = null;
        return false;
    }

    public boolean handleFederationTermination(HttpServletRequest request, HttpServletResponse response, Object ssoToken) {
        FSUtils.debug.message("Entered FSFedTerminationHandler::handleFederationTermination");
        this.request = request;
        this.locale = FSServiceUtils.getLocale(request);
        this.response = response;
        this.ssoToken = ssoToken;
        this.setTerminationURL();
        if (this.managerInst == null) {
            FSUtils.debug.error("FSSPFedTerminationHandler Account Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSPFedTerminationHandler::handleFederationTerminationfailed to get Account Manager instance");
            }
            FSServiceUtils.returnLocallyAfterOperation(response, termination_done_url, false, "termSuccess", "termFailure");
            return false;
        }
        try {
            this.userID = SessionManager.getProvider().getPrincipalName(ssoToken);
        }
        catch (SessionException e) {
            FSUtils.debug.error("FSFedTerminationHandler::handleFederationTermination:", (Throwable)((Object)e));
            LogUtil.error(Level.INFO, "USER_NOT_FOUND", null, ssoToken);
            return false;
        }
        boolean bStatus = this.updateAccountInformation(null);
        FSUtils.debug.message("After updateAccountInformation");
        if (!bStatus) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSPFedTerminationHandler::handleFederationTermination Federation Termination failed locally. Cannot update account");
            }
            String[] data = new String[]{this.userID};
            LogUtil.error(Level.INFO, "TERMINATION_FAILED", data);
            FSServiceUtils.returnLocallyAfterOperation(response, termination_done_url, false, "termSuccess", "termFailure");
            return false;
        }
        FSUtils.debug.message("Status of local update true");
        String[] data = new String[]{this.userID};
        LogUtil.access(Level.FINER, "TERMINATION_SUCCESS", data);
        this.resetFederateCookie();
        boolean bRemoteStatus = this.doFederationTermination(request, response, this.acctInfo);
        return bRemoteStatus;
    }

    protected boolean updateAccountInformation(NameIdentifier ni) {
        try {
            FSUtils.debug.message("FSFedTerminationHandler::updateAccountInformation: start");
            String searchDomain = this.remoteEntityId;
            String nameId = null;
            String nameQualifier = null;
            if (ni != null) {
                nameQualifier = ni.getNameQualifier();
                if (nameQualifier != null && nameQualifier.length() != 0 && !nameQualifier.equals(this.remoteEntityId)) {
                    searchDomain = nameQualifier;
                }
                nameId = ni.getName();
            }
            if (nameId == null && this.acctInfo != null) {
                FSUtils.debug.message("FSAccountManager: getnameId in accInfo");
                NameIdentifier temp = this.acctInfo.getLocalNameIdentifier();
                if (temp != null) {
                    nameId = temp.getName();
                    nameQualifier = temp.getNameQualifier();
                } else {
                    temp = this.acctInfo.getRemoteNameIdentifier();
                    if (temp != null) {
                        nameId = temp.getName();
                        nameQualifier = temp.getNameQualifier();
                    }
                }
            }
            FSAccountFedInfoKey fedInfoKey = new FSAccountFedInfoKey(nameQualifier, nameId);
            this.managerInst.removeAccountFedInfo(this.userID, fedInfoKey, searchDomain);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFedTerminationHandler:: updateAccountInformation deactivate successfully completed");
            }
        }
        catch (FSAccountMgmtException e) {
            FSUtils.debug.error("FSFedTerminationHandler::updateAccountInformation " + FSUtils.bundle.getString("termination-failed-locally"));
            String[] data = new String[]{this.userID};
            LogUtil.error(Level.INFO, "TERMINATION_FAILED", data);
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Cleaning Session manager for user : " + this.userID);
            FSUtils.debug.message("Cleaning Session manager for remote provider: " + this.remoteEntityId);
            FSUtils.debug.message("Cleaning Session manager for hosted provider: " + this.hostedEntityId);
        }
        FSLogoutUtil.cleanSessionMapPartnerList(this.userID, this.remoteEntityId, this.metaAlias, null);
        return true;
    }

    public void processTerminationRequest(HttpServletRequest request, HttpServletResponse response, FSFederationTerminationNotification reqTermination) {
        FederationSPAdapter spAdapter;
        FSUtils.debug.message("Entered FSFedTerminationHandler::processTerminationRequest...");
        this.request = request;
        this.locale = FSServiceUtils.getLocale(request);
        this.response = response;
        this.relayState = reqTermination.getRelayState();
        this.setTerminationURL();
        if (this.managerInst == null) {
            FSUtils.debug.error("FSSPFedTerminationHandler " + FSUtils.bundle.getString("federation-failed-account-instance"));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSPFedTerminationHandler::handleFederationTerminationfailed to get Account Manager instance");
            }
            this.returnToSource();
            return;
        }
        boolean bStatus = this.updateAccountInformation(reqTermination.getNameIdentifier());
        if (!bStatus) {
            FSUtils.debug.message("Termination request processing failed");
            String[] data = new String[]{FSUtils.bundle.getString("termination-request-processing-failed")};
            LogUtil.error(Level.INFO, "TERMINATION_FAILED", data);
            this.returnToSource();
            return;
        }
        FSUtils.debug.message("User sucessfully defederated");
        String[] data = new String[]{FSUtils.bundle.getString("federation-termination-successful")};
        LogUtil.access(Level.FINER, "TERMINATION_SUCCESS", data);
        if (this.hostedProviderRole != null && this.hostedProviderRole.equalsIgnoreCase("SP") && (spAdapter = FSServiceUtils.getSPAdapter(this.hostedEntityId, this.hostedConfig)) != null) {
            FSUtils.debug.message("FSFedTerminationHandler.HTTP");
            try {
                spAdapter.postTerminationNotificationSuccess(this.hostedEntityId, request, response, this.userID, reqTermination, "http://projectliberty.org/profiles/fedterm-idp-http");
            }
            catch (Exception e) {
                FSUtils.debug.error("postTermNotification.IDP/HTTP", (Throwable)e);
            }
        }
        this.returnToSource();
    }

    public boolean processSOAPTerminationRequest(HttpServletRequest request, HttpServletResponse response, FSFederationTerminationNotification reqTermination) {
        FSUtils.debug.message("Entered FSFedTerminationHandler::processSOAPTerminationRequest");
        if (this.managerInst == null) {
            FSUtils.debug.error("FSSPFedTerminationHandler Account Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSPFedTerminationHandler::handleFederationTerminationfailed to get Account Manager instance");
            }
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Begin processTerminationRequest SOAP profile...");
        }
        boolean bStatus = false;
        if (reqTermination != null) {
            boolean bUserStatus = this.setUserID(reqTermination);
            if (bUserStatus) {
                FederationSPAdapter spAdapter;
                bStatus = this.updateAccountInformation(reqTermination.getNameIdentifier());
                if (!bStatus) {
                    FSUtils.debug.error("FSFedTerminationHandler " + FSUtils.bundle.getString("termination-request-processing-failed"));
                    return false;
                }
                FSUtils.debug.message("User sucessfully defederated");
                if (this.hostedProviderRole != null && this.hostedProviderRole.equalsIgnoreCase("SP") && (spAdapter = FSServiceUtils.getSPAdapter(this.hostedEntityId, this.hostedConfig)) != null) {
                    FSUtils.debug.message("FSFedTerminationHandler.SOAP");
                    try {
                        spAdapter.postTerminationNotificationSuccess(this.hostedEntityId, request, response, this.userID, reqTermination, "http://projectliberty.org/profiles/fedterm-idp-soap");
                    }
                    catch (Exception e) {
                        FSUtils.debug.error("postTerm.IDP/SOAP", (Throwable)e);
                    }
                }
                return true;
            }
            FSUtils.debug.message("Failed to get UserDN. Invalid termination request");
            return false;
        }
        FSUtils.debug.error("FSFedTerminationHandler::processTerminationRequest Federation termination request is improper");
        return false;
    }

    public void resetFederateCookie() {
        try {
            String cookieValue;
            if (this.userID == null || this.userID.length() < 1) {
                return;
            }
            if (this.managerInst.hasAnyActiveFederation(this.userID)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("User : " + this.userID + " Federation Exists : " + "yes");
                }
                cookieValue = "yes";
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("User : " + this.userID + " Federation Exists : " + "no");
                }
                cookieValue = "no";
            }
            FSUtils.debug.message("Setting Path to /");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Setting Age to 31536000 Age");
            }
            List cookieDomainList = FSServiceUtils.getCookieDomainList();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Provider cookie domain list is " + cookieDomainList);
            }
            Iterator iter = null;
            if (cookieDomainList != null) {
                iter = cookieDomainList.iterator();
                while (iter != null && iter.hasNext()) {
                    Cookie fedCookie = CookieUtils.newCookie((String)FEDERATE_COOKIE_NAME, (String)cookieValue, (int)31536000, (String)"/", (String)((String)iter.next()));
                    this.response.addCookie(fedCookie);
                }
            } else {
                Cookie fedCookie = CookieUtils.newCookie((String)FEDERATE_COOKIE_NAME, (String)cookieValue, (int)31536000, (String)"/", null);
                this.response.addCookie(fedCookie);
            }
        }
        catch (FSAccountMgmtException e) {
            FSUtils.debug.error("Unable to read user federation information", (Throwable)((Object)e));
            return;
        }
    }

    private void returnToSource() {
        FSUtils.debug.message("Entered FSFedTerminationHandler::returnToSource");
        try {
            StringBuffer finalReturnURL = new StringBuffer();
            String retURL = this.remoteDescriptor.getFederationTerminationServiceReturnURL();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Redirecting to : " + retURL);
            }
            this.resetFederateCookie();
            FSUtils.debug.message("Checking retURL for null value");
            if (retURL == null || retURL.length() < 1) {
                FSUtils.debug.error("Return URL is null");
                FSServiceUtils.showErrorPage(this.response, error_page_url, "termination-invalid-redirect-url", "metadata-error-check");
                return;
            }
            finalReturnURL.append(retURL);
            if (this.relayState != null && this.relayState.length() >= 1) {
                char delimiter = retURL.indexOf(63) < 0 ? (char)'?' : '&';
                finalReturnURL.append(delimiter).append(RELAY_STATE).append('=').append(URLEncDec.encode((String)this.relayState));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Now sendRedirecting to : " + finalReturnURL.toString());
            }
            this.response.sendRedirect(finalReturnURL.toString());
            return;
        }
        catch (IOException e) {
            FSUtils.debug.error("Unable to get LRURL. No location to redirect. processing completed", (Throwable)e);
            FSUtils.debug.message("After exception calling response.sendError");
            FSServiceUtils.showErrorPage(this.response, error_page_url, "termination-invalid-redirect-url", "metadata-error-check");
            return;
        }
    }

    protected SOAPMessage signTerminationRequest(SOAPMessage msg, String idAttrName, String id) throws SAMLException {
        FSUtils.debug.message("FSSPFedTerminationHandler.signTerminationRequest: Called");
        String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "signingCertAlias");
        if (certAlias == null || certAlias.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSPFedTerminationHandler.signTerminationRequest: couldn'tobtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSPFedTerminationHandler.signTerminationRequest: Provider's certAlias is found: " + certAlias);
        }
        XMLSignatureManager manager = XMLSignatureManager.getInstance();
        Document doc = (Document)FSServiceUtils.createSOAPDOM(msg);
        String xpath = "//*[local-name()='ProviderID']";
        manager.signXML(doc, certAlias, SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.xmlSigAlgorithm"), idAttrName, id, false, xpath);
        return FSServiceUtils.convertDOMToSOAP(doc);
    }

    private FSFederationTerminationNotification createFederationTerminationRequest(FSAccountFedInfo acctInfo) {
        FSUtils.debug.message("FSFedTerminationHandler::createFederationTerminationRequest:");
        FSFederationTerminationNotification reqName = new FSFederationTerminationNotification();
        if (reqName != null) {
            NameIdentifier nameIdentifier = acctInfo.getRemoteNameIdentifier();
            if (nameIdentifier == null) {
                nameIdentifier = acctInfo.getLocalNameIdentifier();
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("SP Provider Id : " + this.hostedEntityId);
            }
            reqName.setProviderId(this.hostedEntityId);
            reqName.setNameIdentifier(nameIdentifier);
            return reqName;
        }
        FSUtils.debug.message("failed to create termination request");
        FSUtils.debug.error("FSFedTerminationHandler::createFederationTerminationRequest " + FSUtils.bundle.getString("termination-request-creation-failed"));
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doFederationTermination(HttpServletRequest request, HttpServletResponse response, FSAccountFedInfo acctInfo) {
        FSUtils.debug.message("Entered FSFedTerminationHandler::doFederationTermination");
        try {
            FederationSPAdapter spAdapter;
            String profile;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFedTerminationHandler::doFederationTermination create request start");
            }
            FSFederationTerminationNotification reqFedTermination = this.createFederationTerminationRequest(acctInfo);
            reqFedTermination.setMinorVersion(FSServiceUtils.getMinorVersion(this.remoteDescriptor.getProtocolSupportEnumeration()));
            if (reqFedTermination == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSIDPFedTerminationHandler::Termination request could not be formed");
                }
                FSServiceUtils.returnLocallyAfterOperation(response, termination_done_url, true, "termSuccess", "termFailure");
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIDPFedTerminationHandler::Termination request formedsuccessfully");
            }
            boolean isSOAPProfile = true;
            if (acctInfo.isRoleIDP()) {
                List hostProfiles = this.hostedDescriptor.getFederationTerminationNotificationProtocolProfile();
                if (hostProfiles == null || hostProfiles.isEmpty()) {
                    FSUtils.debug.error("FSFedTerminationHandler::doFederationTermination no termination profile cannot process request");
                    FSServiceUtils.returnLocallyAfterOperation(response, termination_done_url, true, "termSuccess", "termFailure");
                    return false;
                }
                profile = (String)hostProfiles.iterator().next();
                if (profile.equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-sp-soap") || profile.equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-idp-soap")) {
                    isSOAPProfile = true;
                } else {
                    if (!profile.equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-sp-http") && !profile.equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-idp-http")) {
                        FSUtils.debug.error("FSFedTerminationHandler::doFederationTermination Invalid termination profile cannot process request");
                        FSServiceUtils.returnLocallyAfterOperation(response, termination_done_url, true, "termSuccess", "termFailure");
                        return false;
                    }
                    isSOAPProfile = false;
                }
            } else {
                List remoteProfiles = this.remoteDescriptor.getFederationTerminationNotificationProtocolProfile();
                if (remoteProfiles == null || remoteProfiles.isEmpty()) {
                    FSUtils.debug.error("FSFedTerminationHandler::doFederationTermination no termination profile cannot process request");
                    FSServiceUtils.returnLocallyAfterOperation(response, termination_done_url, true, "termSuccess", "termFailure");
                    return false;
                }
                profile = (String)remoteProfiles.iterator().next();
                if (profile.equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-sp-soap") || profile.equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-idp-soap")) {
                    isSOAPProfile = true;
                } else {
                    if (!profile.equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-sp-http") && !profile.equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-idp-http")) {
                        FSUtils.debug.error("FSFedTerminationHandler::doFederationTermination Invalid termination profile cannot process request");
                        FSServiceUtils.returnLocallyAfterOperation(response, termination_done_url, true, "termSuccess", "termFailure");
                        return false;
                    }
                    isSOAPProfile = false;
                }
            }
            if (isSOAPProfile) {
                FSSOAPService instSOAP = FSSOAPService.getInstance();
                if (instSOAP != null) {
                    FSUtils.debug.message("Signing suceeded. To call bindTerminationRequest");
                    reqFedTermination.setID("term-Sig-ID");
                    SOAPMessage msgTermination = instSOAP.bind(reqFedTermination.toXMLString(true, true));
                    if (msgTermination != null) {
                        try {
                            FederationSPAdapter spAdapter2;
                            if (FSServiceUtils.isSigningOn()) {
                                int minorVersion = reqFedTermination.getMinorVersion();
                                if (minorVersion == 0) {
                                    msgTermination = this.signTerminationRequest(msgTermination, "id", reqFedTermination.getID());
                                } else if (minorVersion == 2) {
                                    msgTermination = this.signTerminationRequest(msgTermination, "RequestID", reqFedTermination.getRequestID());
                                } else {
                                    FSUtils.debug.message("invalid minor version.");
                                }
                            }
                            boolean sendStatus = instSOAP.sendTerminationMessage(msgTermination, this.remoteDescriptor.getSoapEndpoint());
                            if (this.hostedProviderRole != null && this.hostedProviderRole.equalsIgnoreCase("SP") && (spAdapter2 = FSServiceUtils.getSPAdapter(this.hostedEntityId, this.hostedConfig)) != null) {
                                try {
                                    spAdapter2.postTerminationNotificationSuccess(this.hostedEntityId, request, response, this.userID, reqFedTermination, "http://projectliberty.org/profiles/fedterm-sp-soap");
                                }
                                catch (Exception e) {
                                    FSUtils.debug.error("postTerm.SP/SOAP", (Throwable)e);
                                }
                            }
                            FSServiceUtils.returnLocallyAfterOperation(response, termination_done_url, true, "termSuccess", "termFailure");
                            return sendStatus;
                        }
                        catch (Exception e) {
                            FSUtils.debug.error("FSFedTerminationHandler::doFederationTermination " + FSUtils.bundle.getString("termination-failed-send-remote"));
                            FSServiceUtils.returnLocallyAfterOperation(response, termination_done_url, true, "termSuccess", "termFailure");
                            return false;
                        }
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSPFedTerminationHandler::doFederationTermination failed. Error in forming Message");
                    }
                    FSUtils.debug.error("FSSPFedTerminationHandler.doFederationTermination " + FSUtils.bundle.getString("termination-failed-send-remote"));
                    FSServiceUtils.returnLocallyAfterOperation(response, termination_done_url, true, "termSuccess", "termFailure");
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSFedTerminationHandler::doFederationTermination failed. Cannot get Service Manager instance");
                }
                FSUtils.debug.error("FSSPFedTerminationHandler::doFederationTermination " + FSUtils.bundle.getString("termination-failed-send-remote"));
                FSServiceUtils.returnLocallyAfterOperation(response, termination_done_url, true, "termSuccess", "termFailure");
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFedTerminationHandler::doFederationTermination In Redirect profile");
            }
            String urlEncodedRequest = reqFedTermination.toURLEncodedQueryString();
            if (FSServiceUtils.isSigningOn()) {
                String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "signingCertAlias");
                if (certAlias == null || certAlias.length() == 0) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSBrowserArtifactConsumerHandler:: signSAMLRequest:couldn't obtain this site's cert alias.");
                    }
                    throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
                }
                urlEncodedRequest = FSSignatureUtil.signAndReturnQueryString(urlEncodedRequest, certAlias);
            }
            StringBuffer redirectURL = new StringBuffer();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request to be sent : " + urlEncodedRequest);
            }
            String retURL = this.remoteDescriptor.getFederationTerminationServiceURL();
            redirectURL.append(retURL);
            if (retURL.indexOf(63) == -1) {
                redirectURL.append('?');
            } else {
                redirectURL.append('&');
            }
            redirectURL.append(urlEncodedRequest);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFedTerminationHandler::Redirect URL is " + redirectURL.toString());
            }
            if (this.hostedProviderRole != null && this.hostedProviderRole.equalsIgnoreCase("SP") && (spAdapter = FSServiceUtils.getSPAdapter(this.hostedEntityId, this.hostedConfig)) != null) {
                try {
                    spAdapter.postTerminationNotificationSuccess(this.hostedEntityId, request, response, this.userID, reqFedTermination, "http://projectliberty.org/profiles/fedterm-sp-http");
                }
                catch (Exception e) {
                    FSUtils.debug.error("postTerm.SP/HTTP", (Throwable)e);
                }
            }
            response.sendRedirect(redirectURL.toString());
            return true;
        }
        catch (IOException e) {
            FSUtils.debug.error("FSFedTerminationHandler" + FSUtils.bundle.getString("federation-redirection-failed"));
        }
        catch (FSMsgException e) {
            FSUtils.debug.error("FSFedTerminationHandler::doFederationTermination " + FSUtils.bundle.getString("termination-failed-send-remote"));
        }
        catch (SAMLResponderException e) {
            FSUtils.debug.error("FSFedTerminationHandler::doFederationTermination " + FSUtils.bundle.getString("termination-failed-send-remote"));
        }
        FSServiceUtils.returnLocallyAfterOperation(response, termination_done_url, true, "termSuccess", "termFailure");
        return false;
    }
}

