/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.util;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.services.util.FSSignatureException;
import com.sun.identity.federation.services.util.FSSignatureProvider;
import com.sun.identity.federation.services.util.SignatureProviderSPI;
import com.sun.identity.saml.xmlsig.KeyProvider;
import java.security.cert.X509Certificate;

public class FSSignatureManager {
    private static FSSignatureManager instance = null;
    private SignatureProviderSPI sp = null;

    protected FSSignatureManager() {
        this.sp = new FSSignatureProvider();
    }

    protected FSSignatureManager(KeyProvider keyProvider, SignatureProviderSPI sigProvider) {
        sigProvider.initialize(keyProvider);
        this.sp = sigProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSSignatureManager getInstance() {
        if (instance == null) {
            Class clazz = FSSignatureManager.class;
            synchronized (clazz) {
                if (instance == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Constructing a new instance of FSSignatureManager");
                    }
                    instance = new FSSignatureManager();
                }
            }
        }
        return instance;
    }

    public static FSSignatureManager getInstance(KeyProvider keyProvider, SignatureProviderSPI sigProvider) {
        return new FSSignatureManager(keyProvider, sigProvider);
    }

    public byte[] signBuffer(String data, String certAlias) throws FSSignatureException {
        return this.sp.signBuffer(data, certAlias);
    }

    public byte[] signBuffer(String data, String certAlias, String algorithm) throws FSSignatureException {
        return this.sp.signBuffer(data, certAlias, algorithm);
    }

    public boolean verifySignature(String data, byte[] signature, String algorithm, X509Certificate cert) throws FSSignatureException {
        return this.sp.verifySignature(data, signature, algorithm, cert);
    }

    public KeyProvider getKeyProvider() {
        return this.sp.getKeyProvider();
    }
}

