/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.common;

import com.sun.identity.liberty.ws.common.Status;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.jaxb11.ObjectFactory;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DiscoSDKUtils {
    private static com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory discoFac = new com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory();
    private static ObjectFactory disco11Fac = new ObjectFactory();
    private static com.sun.identity.liberty.ws.disco.plugins.jaxb.ObjectFactory entryFac = new com.sun.identity.liberty.ws.disco.plugins.jaxb.ObjectFactory();
    private static JAXBContext jc;
    public static ResourceBundle bundle;
    public static Debug debug;
    public static final String OFFERINGS = "offerings";
    public static final String CREDENTIALS = "credentials";
    public static final String CREDENTIALS_OBJ = "credentialsObj";
    public static final String RES_STMT = "ResourceAccess";
    public static final String RES_SESSION_STMT = "ResourceAccess_Session";
    public static final String SESSION_STMT = "SessionContext";
    public static final String AUTHN_STMT = "Authentication";

    protected DiscoSDKUtils() {
    }

    public static com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory getDiscoFactory() {
        return discoFac;
    }

    public static ObjectFactory getDisco11Factory() {
        return disco11Fac;
    }

    public static com.sun.identity.liberty.ws.disco.plugins.jaxb.ObjectFactory getDiscoEntryFactory() {
        return entryFac;
    }

    public static Marshaller getDiscoMarshaller() throws JAXBException {
        return jc.createMarshaller();
    }

    public static Unmarshaller getDiscoUnmarshaller() throws JAXBException {
        return jc.createUnmarshaller();
    }

    public static Status parseStatus(Element elem) throws DiscoveryException {
        if (elem == null) {
            debug.message("DiscoUtils.parseStatus: nullInput");
            throw new DiscoveryException(bundle.getString("nullInput"));
        }
        String nameSpaceURI = elem.getNamespaceURI();
        String prefix = elem.getPrefix();
        Status status = new Status(nameSpaceURI, prefix);
        String code = elem.getAttribute("code");
        if (code == null || code.length() == 0) {
            debug.message("DiscoUtils.parseStatus: missing status code.");
            throw new DiscoveryException(bundle.getString("missingStatusCode"));
        }
        String codeNS = nameSpaceURI;
        String codePrefix = prefix;
        String localPart = code;
        if (code.indexOf(":") != -1) {
            StringTokenizer st = new StringTokenizer(code, ":");
            if (st.countTokens() != 2) {
                debug.message("DiscoUtils.parseStatus: wrong status code.");
                throw new DiscoveryException(bundle.getString("wrongInput"));
            }
            codePrefix = st.nextToken();
            localPart = st.nextToken();
        }
        if (codePrefix != null && prefix != null && !codePrefix.equals(prefix)) {
            codeNS = elem.getAttribute("xmlns:" + codePrefix);
        }
        if (codeNS != null && codeNS.length() != 0) {
            if (codePrefix != null && codePrefix.length() != 0) {
                status.setCode(new QName(codeNS, localPart, codePrefix));
            } else {
                status.setCode(new QName(codeNS, localPart));
            }
        } else {
            status.setCode(new QName(localPart));
        }
        status.setComment(elem.getAttribute("comment"));
        status.setRef(elem.getAttribute("ref"));
        List subStatusL = XMLUtils.getElementsByTagNameNS1((Element)elem, (String)"urn:liberty:disco:2003-08", (String)"Status");
        int num = subStatusL.size();
        if (num != 0) {
            if (num == 1) {
                status.setSubStatus(DiscoSDKUtils.parseStatus((Element)subStatusL.get(0)));
            } else {
                if (debug.messageEnabled()) {
                    debug.message("DiscoUtils.parseStatus: included more than one sub status.");
                }
                throw new DiscoveryException(bundle.getString("moreElement"));
            }
        }
        return status;
    }

    public static List parseOptions(Element child) throws DiscoveryException {
        ArrayList<String> options = new ArrayList<String>();
        NodeList optionnl = child.getChildNodes();
        int len = optionnl.getLength();
        for (int j = 0; j < len; ++j) {
            Node option = optionnl.item(j);
            String nName = option.getLocalName();
            if (nName == null) continue;
            String nameSpaceURI = child.getNamespaceURI();
            if (nameSpaceURI == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
                if (debug.messageEnabled()) {
                    debug.message("DiscoUtils.parseOption(Element): invalid namespace for node " + nName);
                }
                throw new DiscoveryException(bundle.getString("wrongInput"));
            }
            if (nName.equals("Option")) {
                options.add(XMLUtils.getElementValue((Element)((Element)option)));
                continue;
            }
            if (debug.messageEnabled()) {
                debug.message("DiscoUtils.parseOption(Element): invalid node" + nName);
            }
            throw new DiscoveryException(bundle.getString("wrongInput"));
        }
        return options;
    }

    public static Element parseXML(String xmlString) throws DiscoveryException {
        try {
            debug.message("DiscoUtils.parseXML: xmlString=" + xmlString);
            Document doc = XMLUtils.toDOMDocument((String)xmlString, (Debug)debug);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            debug.error("DiscoUtils.parseXML: Parsing error.", (Throwable)ex);
            throw new DiscoveryException(ex);
        }
    }

    static {
        bundle = Locale.getInstallResourceBundle((String)"libDisco");
        debug = Debug.getInstance((String)"libDisco");
        try {
            jc = JAXBContext.newInstance((String)Utils.getJAXBPackages());
        }
        catch (Exception e) {
            debug.error("DiscoUtils:static: Initialization failed.", (Throwable)e);
        }
    }
}

