/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.plugins;

import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.EncryptedNameIdentifier;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.liberty.ws.disco.plugins.NameIdentifierMapper;
import com.sun.identity.liberty.ws.util.ProviderManager;
import com.sun.identity.liberty.ws.util.ProviderUtil;
import com.sun.identity.saml.assertion.NameIdentifier;
import java.security.Key;

public class IDFFNameIdentifierMapper
implements NameIdentifierMapper {
    public NameIdentifier getNameIdentifier(String spProviderID, String idpProviderID, NameIdentifier nameId, String userID) {
        try {
            String nameQualifier;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("IDFFNameIdentifierMapper, enter spProviderID=" + spProviderID + ", idpProviderID=" + idpProviderID + ", userID=" + userID);
                if (nameId != null) {
                    FSUtils.debug.message("IDFFNameIdentifierMapper, enter name identifier=" + nameId.toString());
                }
            }
            if (spProviderID == null || idpProviderID == null || userID == null) {
                return null;
            }
            if (spProviderID.equals(idpProviderID)) {
                return nameId;
            }
            if (nameId != null && (nameQualifier = nameId.getNameQualifier()) != null && nameQualifier.equals(spProviderID)) {
                return nameId;
            }
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            String metaAlias = metaManager.getIDPDescriptorConfig("/", idpProviderID).getMetaAlias();
            FSAccountManager fsaccountmgr = FSAccountManager.getInstance(metaAlias);
            FSAccountFedInfo accountinfo = fsaccountmgr.readAccountFedInfo(userID, spProviderID);
            if (accountinfo != null) {
                NameIdentifier ni = accountinfo.getLocalNameIdentifier();
                FSUtils.debug.message("IDFFNameIdentifierMapper : new Ni");
                ProviderManager pm = ProviderUtil.getProviderManager();
                if (pm != null) {
                    Key encKey = pm.getEncryptionKey(spProviderID);
                    if (encKey != null) {
                        return EncryptedNameIdentifier.getEncryptedNameIdentifier(ni, spProviderID, encKey, pm.getEncryptionKeyAlgorithm(spProviderID), pm.getEncryptionKeyStrength(spProviderID));
                    }
                    return ni;
                }
                return ni;
            }
            return nameId;
        }
        catch (FSAccountMgmtException e) {
            FSUtils.debug.message("IDFFNameIdentifierMapper, account error", (Throwable)((Object)e));
        }
        catch (FSException e) {
            FSUtils.debug.message("IDFFNameIdentifierMapper, encrypt error", (Throwable)((Object)e));
        }
        catch (IDFFMetaException e) {
            FSUtils.debug.message("IDFFNameIdentifierMapper, meta error", (Throwable)((Object)e));
        }
        return null;
    }
}

