/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.sun.identity.liberty.ws.common.Status;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DSTUtils {
    public static Debug debug = Debug.getInstance((String)"libDSTService");
    public static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"libDSTService");

    public static Element parseXML(String xml) throws DSTException {
        try {
            Document doc = XMLUtils.toDOMDocument((String)xml, (Debug)debug);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            debug.error("DSTUtils.parseXML: Parsing error.", (Throwable)ex);
            throw new DSTException(ex);
        }
    }

    public static Status parseStatus(Element element) throws DSTException {
        String codePrefix;
        String localPart;
        if (element == null) {
            debug.error("DSTUtils.parseStatus: nullInputParams");
            throw new DSTException(bundle.getString("nullInputParams"));
        }
        String nameSpaceURI = element.getNamespaceURI();
        String prefix = element.getPrefix();
        Status status = new Status(nameSpaceURI, prefix);
        String code = element.getAttribute("code");
        if (code != null && code.length() != 0) {
            localPart = null;
            codePrefix = "";
            if (code.indexOf(":") != -1) {
                StringTokenizer st = new StringTokenizer(code, ":");
                if (st.countTokens() != 2) {
                    throw new DSTException(bundle.getString("invalidStatus"));
                }
                codePrefix = st.nextToken();
                localPart = st.nextToken();
            } else {
                localPart = code;
            }
        } else {
            throw new DSTException(bundle.getString("invalidStatus"));
        }
        QName qName = new QName(nameSpaceURI, localPart, codePrefix);
        status.setCode(qName);
        status.setComment(element.getAttribute("comment"));
        status.setRef(element.getAttribute("ref"));
        return status;
    }
}

