/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.common;

import com.sun.identity.liberty.ws.idpp.IDPPServiceManager;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.jaxb.ObjectFactory;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryElement;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryResponseElement;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryType;
import com.sun.identity.liberty.ws.idpp.jaxb.ResourceIDElement;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.plugin.datastore.DataStoreProviderManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

public class IDPPUtils {
    private static final String IDPP = "idpp";
    public static Debug debug = Debug.getInstance((String)"libPersonalProfile");
    public static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"libPersonalProfile");
    private static ObjectFactory idppFactory = new ObjectFactory();
    private static final String idppPrefix = "pp";
    private static HashMap idppElementTypes = new HashMap();
    public static HashMap idppIDSMap = new HashMap();
    private static DocumentBuilderFactory dbf = null;
    private static DocumentBuilder documentBuilder = null;
    private static Marshaller marshaller = null;
    private static Unmarshaller unmarshaller = null;
    private static DataStoreProvider userProvider = null;

    private static void getIDPPElementsMap() {
        idppElementTypes.put("PP", new Integer(1));
        idppElementTypes.put("InformalName", new Integer(2));
        idppElementTypes.put("LInformalName", new Integer(3));
        idppElementTypes.put("CommonName", new Integer(4));
        idppElementTypes.put("LegalIdentity", new Integer(5));
        idppElementTypes.put("EmploymentIdentity", new Integer(6));
        idppElementTypes.put("AddressCard", new Integer(7));
        idppElementTypes.put("MsgContact", new Integer(8));
        idppElementTypes.put("Facade", new Integer(9));
        idppElementTypes.put("Demographics", new Integer(10));
        idppElementTypes.put("SignKey", new Integer(11));
        idppElementTypes.put("EncryptKey", new Integer(12));
        idppElementTypes.put("EmergencyContact", new Integer(13));
        idppElementTypes.put("LEmergencyContact", new Integer(14));
        idppElementTypes.put("FN", new Integer(15));
        idppElementTypes.put("SN", new Integer(19));
        idppElementTypes.put("CN", new Integer(17));
        idppElementTypes.put("MN", new Integer(16));
        idppElementTypes.put("AltCN", new Integer(21));
        idppElementTypes.put("PersonalTitle", new Integer(18));
        idppElementTypes.put("AnalyzedName", new Integer(20));
        idppElementTypes.put("InformalName", new Integer(2));
        idppElementTypes.put("LegalName", new Integer(22));
        idppElementTypes.put("DOB", new Integer(23));
        idppElementTypes.put("MaritalStatus", new Integer(25));
        idppElementTypes.put("Gender", new Integer(24));
        idppElementTypes.put("AltID", new Integer(26));
        idppElementTypes.put("IDType", new Integer(27));
        idppElementTypes.put("IDValue", new Integer(28));
        idppElementTypes.put("VAT", new Integer(29));
        idppElementTypes.put("JobTitle", new Integer(30));
        idppElementTypes.put("O", new Integer(31));
        idppElementTypes.put("AltO", new Integer(32));
        idppElementTypes.put("Extension", new Integer(33));
    }

    public static QueryElement createQueryElement(List queryExpressions, String resourceID, boolean includeCommonAttr) throws JAXBException, IDPPException {
        QueryElement query = idppFactory.createQueryElement();
        if (queryExpressions == null || resourceID == null || queryExpressions.size() == 0) {
            debug.error("IDPPUtils:createQueryElement: Either query expressions or resource id is null.");
            throw new IDPPException("ResourceID or query expressions are null");
        }
        query.setResourceID(IDPPUtils.createResourceIDElement(resourceID));
        query.setId(SAMLUtils.generateID());
        for (int i = 0; i < queryExpressions.size(); ++i) {
            QueryType.QueryItemType item = idppFactory.createQueryTypeQueryItemType();
            item.setId(SAMLUtils.generateID());
            item.setIncludeCommonAttributes(includeCommonAttr);
            item.setItemID(SAMLUtils.generateID());
            item.setSelect(IDPPUtils.addIDPPPrefix((String)queryExpressions.get(i)));
            query.getQueryItem().add(item);
        }
        return query;
    }

    public static List getQueryDataElements(QueryResponseElement response) throws JAXBException, IDPPException {
        if (response == null) {
            debug.error("IDPPUtils:getQueryDataElements:response is null");
            throw new IDPPException("response is null");
        }
        return response.getData();
    }

    public static ResourceIDElement createResourceIDElement(String resourceID) throws JAXBException, IDPPException {
        if (resourceID == null) {
            debug.error("IDPPUtils:ResourceIDType: Resource id is null");
            throw new IDPPException("ResourceID is null");
        }
        ResourceIDElement resourceIDElement = idppFactory.createResourceIDElement();
        resourceIDElement.setValue(resourceID);
        return resourceIDElement;
    }

    private static String addIDPPPrefix(String expression) {
        if (expression == null || expression.length() == 0) {
            return expression;
        }
        if (expression.indexOf("/") == -1) {
            debug.error("IDPPUtils:addIDPPPrefix:Not a valid expression");
            return expression;
        }
        StringBuffer sb = new StringBuffer(100);
        StringTokenizer st = new StringTokenizer(expression, "/");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            String prefixedStr = "/pp:" + temp;
            sb.append(prefixedStr);
        }
        return sb.toString();
    }

    public static String getExpressionContext(String select) {
        if (select == null || select.indexOf("/") == -1) {
            return null;
        }
        int i = select.lastIndexOf("/");
        if (i != -1) {
            select = select.substring(i + 1);
        }
        if ((i = select.indexOf(":")) == -1) {
            return select;
        }
        return select.substring(i + 1);
    }

    public static Map getUserAttributes(String userDN, Set requiredSet) throws IDPPException {
        try {
            return userProvider.getAttributes(userDN, requiredSet);
        }
        catch (DataStoreProviderException dspe) {
            debug.error("IDPPUtils:getUserAttributes: Error retrieving user attributes.", (Throwable)((Object)dspe));
            throw new IDPPException((Throwable)((Object)dspe));
        }
    }

    public static void setUserAttributes(String userDN, Map map) throws IDPPException {
        try {
            userProvider.setAttributes(userDN, map);
        }
        catch (DataStoreProviderException dspe) {
            debug.error("IDPPUtils:setUserAttributes:Error while storinguser attributes.", (Throwable)((Object)dspe));
            throw new IDPPException((Throwable)((Object)dspe));
        }
    }

    public static boolean checkForUserAttributes(String userDN, Set set) throws IDPPException {
        try {
            Map map = userProvider.getAttributes(userDN, set);
            return map != null && !map.isEmpty();
        }
        catch (DataStoreProviderException dspe) {
            debug.error("IDPPUtils:checkForUserAttributes:Error while checking for user attributes.", (Throwable)((Object)dspe));
            throw new IDPPException((Throwable)((Object)dspe));
        }
    }

    public static int getIDPPElementType(String element) {
        if (element == null) {
            debug.error("IDPPUtils:getIDPPElementType:InvalidElementType");
            return -1;
        }
        Integer elementType = (Integer)idppElementTypes.get(element);
        if (elementType == null) {
            return -1;
        }
        return elementType;
    }

    public static boolean isUserExists(String userDN) {
        try {
            return userProvider.isUserExists(userDN);
        }
        catch (DataStoreProviderException dspe) {
            if (debug.messageEnabled()) {
                debug.message("IDPPUtils.isUserExists: Userentry is null", (Throwable)((Object)dspe));
            }
            return false;
        }
    }

    public static ObjectFactory getIDPPFactory() {
        return idppFactory;
    }

    public static Marshaller getMarshaller() {
        return marshaller;
    }

    public static Unmarshaller getUnmarshaller() {
        return unmarshaller;
    }

    public static DocumentBuilder getDocumentBuilder() {
        return documentBuilder;
    }

    public static String getResourceExpression(String select) {
        if (select == null || select.indexOf("/") == -1) {
            return select;
        }
        StringBuffer sb = new StringBuffer(100);
        StringTokenizer st = new StringTokenizer(select, "/");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf("[");
            if (index != -1) {
                token = token.substring(0, index);
            }
            if (token == null) continue;
            index = token.indexOf(":");
            if (index != -1) {
                token = token.substring(index + 1);
            }
            if (token == null) continue;
            sb.append("/").append(token);
        }
        return sb.toString();
    }

    public static String getResourceID(String userID) {
        IDPPServiceManager serviceManager = IDPPServiceManager.getInstance();
        ResourceIDMapper mapper = serviceManager.getResourceIDMapper();
        return mapper.getResourceID(serviceManager.getProviderID(), userID);
    }

    static {
        try {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            documentBuilder = dbf.newDocumentBuilder();
            JAXBContext jc = JAXBContext.newInstance((String)"com.sun.identity.liberty.ws.idpp.jaxb:com.sun.identity.liberty.ws.idpp.plugin.jaxb:com.sun.identity.liberty.ws.common.jaxb.xmlsig");
            marshaller = jc.createMarshaller();
            unmarshaller = jc.createUnmarshaller();
            IDPPUtils.getIDPPElementsMap();
            userProvider = DataStoreProviderManager.getInstance().getDataStoreProvider(IDPP);
        }
        catch (Exception e) {
            debug.error("IDPPCommonName:static initialization Failed.", (Throwable)e);
        }
    }
}

