/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.container;

import com.sun.identity.liberty.ws.idpp.IDPPServiceManager;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.container.IDPPBaseContainer;
import com.sun.identity.liberty.ws.idpp.jaxb.AnalyzedNameType;
import com.sun.identity.liberty.ws.idpp.jaxb.CNElement;
import com.sun.identity.liberty.ws.idpp.jaxb.CommonNameElement;
import com.sun.identity.liberty.ws.idpp.jaxb.CommonNameType;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTString;
import com.sun.identity.liberty.ws.idpp.jaxb.FNElement;
import com.sun.identity.liberty.ws.idpp.jaxb.MNElement;
import com.sun.identity.liberty.ws.idpp.jaxb.PPElement;
import com.sun.identity.liberty.ws.idpp.jaxb.PersonalTitleElement;
import com.sun.identity.liberty.ws.idpp.jaxb.SNElement;
import com.sun.identity.shared.datastruct.CollectionHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;

public class IDPPCommonName
extends IDPPBaseContainer {
    public IDPPCommonName() {
        IDPPUtils.debug.message("IDPPCommonName:constructor:init.");
    }

    public Object getContainerObject(Map userMap) throws IDPPException {
        IDPPUtils.debug.message("IDPPContainers:getContainerObject:Init");
        try {
            Set altCNs;
            PPElement ppType = IDPPUtils.getIDPPFactory().createPPElement();
            CommonNameElement ce = IDPPUtils.getIDPPFactory().createCommonNameElement();
            String cn = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute("CN").toLowerCase());
            if (cn != null) {
                DSTString dstString = this.getDSTString(cn);
                ce.setCN(dstString);
            }
            if ((altCNs = (Set)userMap.get(this.getAttributeMapper().getDSAttribute("AltCN").toLowerCase())) != null && altCNs.size() > 0) {
                Iterator iter = altCNs.iterator();
                while (iter.hasNext()) {
                    DSTString dstString = this.getDSTString((String)iter.next());
                    ce.getAltCN().add(dstString);
                }
            }
            AnalyzedNameType analyzedName = this.getAnalyzedName(userMap);
            ce.setAnalyzedName(analyzedName);
            ppType.setCommonName(ce);
            return ppType;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPContainers:getContainerObject: JAXB failure", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
        catch (IDPPException ie) {
            IDPPUtils.debug.error("IDPPContainers:getContainerObject:Error while creating common name.", (Throwable)ie);
            throw new IDPPException(ie);
        }
    }

    public Set getContainerAttributes() {
        IDPPUtils.debug.message("IDPPCommonName:getContainerAttributes:Init");
        HashSet<String> set = new HashSet<String>();
        set.add("FN");
        set.add("SN");
        set.add("PersonalTitle");
        String nameScheme = IDPPServiceManager.getInstance().getNameScheme();
        if (nameScheme != null && nameScheme.equals("urn:liberty:id-sis-pp:nameScheme:firstmiddlelast")) {
            set.add("MN");
        }
        set.add("CN");
        set.add("AltCN");
        return this.getMapperAttributeSet(set);
    }

    public Set getContainerAttributesForSelect(String select) {
        IDPPUtils.debug.message("IDPPCommonName:getContainerAttribSelect:Init");
        String expContext = IDPPUtils.getExpressionContext(select);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPCommonName:getContainerAttribSelect:exp context = " + expContext);
        }
        int attrType = IDPPUtils.getIDPPElementType(expContext);
        HashSet<String> set = new HashSet<String>();
        switch (attrType) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                set.add(expContext);
                break;
            }
            case 20: {
                return this.getAnalyzedNameAttributes();
            }
            case 4: {
                return this.getContainerAttributes();
            }
            default: {
                IDPPUtils.debug.error("IDPPCommonName:getContainerAttributesForSelect. Invalid select.");
            }
        }
        return this.getMapperAttributeSet(set);
    }

    public Map getDataMapForSelect(String select, List data) throws IDPPException {
        IDPPUtils.debug.message("IDPPCommonName:getDataMapForSelect:Init");
        Map map = new HashMap();
        String expContext = IDPPUtils.getExpressionContext(select);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPCommonName:getDataMapForSelect:exp context = " + expContext);
        }
        int attrType = IDPPUtils.getIDPPElementType(expContext);
        Object dataElement = null;
        if (data != null && !data.isEmpty()) {
            dataElement = data.get(0);
        }
        switch (attrType) {
            case 19: {
                if (dataElement == null || dataElement instanceof SNElement) {
                    map = this.getAttributeMap(expContext, dataElement, map);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 15: {
                if (dataElement == null || dataElement instanceof FNElement) {
                    map = this.getAttributeMap(expContext, dataElement, map);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 16: {
                if (dataElement == null || dataElement instanceof MNElement) {
                    map = this.getAttributeMap(expContext, dataElement, map);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 18: {
                if (dataElement == null || dataElement instanceof PersonalTitleElement) {
                    map = this.getAttributeMap(expContext, dataElement, map);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 17: {
                if (dataElement == null || dataElement instanceof CNElement) {
                    map = this.getAttributeMap(expContext, dataElement, map);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 21: {
                map = this.getAltCNMap(data, map);
                break;
            }
            case 20: {
                map = this.getAnalyzedNameMap(dataElement, map);
                break;
            }
            case 4: {
                map = this.getCommonNameMap(dataElement, map);
                break;
            }
            default: {
                IDPPUtils.debug.error("IDPPCommonName:getDataMapForSelectUnsupported element");
            }
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPCommonName:getDataMapForSelect:Attr map to be modified." + map);
        }
        return map;
    }

    private Map getCommonNameMap(Object obj, Map map) throws IDPPException {
        IDPPUtils.debug.message("IDPPCommonName:getCommonNameMap:Init");
        AnalyzedNameType analyzedName = null;
        DSTString cn = null;
        List altCNs = null;
        if (obj != null) {
            if (obj instanceof CommonNameType) {
                CommonNameType cnType = (CommonNameType)obj;
                analyzedName = cnType.getAnalyzedName();
                cn = cnType.getCN();
                altCNs = cnType.getAltCN();
            } else {
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
        }
        this.getAnalyzedNameMap(analyzedName, map);
        this.getAltCNMap(altCNs, map);
        this.getAttributeMap("CN", cn, map);
        return map;
    }

    private Map getAltCNMap(List dataObject, Map map) throws IDPPException {
        IDPPUtils.debug.message("IDPPCommonName:getAltCNMap:Init");
        if (dataObject == null) {
            map = this.getAttributeMap("AltCN", null, map);
            return map;
        }
        return this.getAttributeMap("AltCN", dataObject, map);
    }

    public boolean hasBinaryAttributes() {
        return false;
    }
}

