/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.container;

import com.sun.identity.liberty.ws.idpp.IDPPServiceManager;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.container.IDPPBaseContainer;
import com.sun.identity.liberty.ws.idpp.jaxb.AltIDElement;
import com.sun.identity.liberty.ws.idpp.jaxb.AltIDType;
import com.sun.identity.liberty.ws.idpp.jaxb.AnalyzedNameType;
import com.sun.identity.liberty.ws.idpp.jaxb.DOBElement;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTDate;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTString;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTURI;
import com.sun.identity.liberty.ws.idpp.jaxb.FNElement;
import com.sun.identity.liberty.ws.idpp.jaxb.GenderElement;
import com.sun.identity.liberty.ws.idpp.jaxb.IDValueElement;
import com.sun.identity.liberty.ws.idpp.jaxb.LegalIdentityElement;
import com.sun.identity.liberty.ws.idpp.jaxb.LegalIdentityType;
import com.sun.identity.liberty.ws.idpp.jaxb.LegalNameElement;
import com.sun.identity.liberty.ws.idpp.jaxb.MNElement;
import com.sun.identity.liberty.ws.idpp.jaxb.MaritalStatusElement;
import com.sun.identity.liberty.ws.idpp.jaxb.PPElement;
import com.sun.identity.liberty.ws.idpp.jaxb.PersonalTitleElement;
import com.sun.identity.liberty.ws.idpp.jaxb.SNElement;
import com.sun.identity.liberty.ws.idpp.jaxb.VATType;
import com.sun.identity.shared.datastruct.CollectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;

public class IDPPLegalIdentity
extends IDPPBaseContainer {
    public IDPPLegalIdentity() {
        IDPPUtils.debug.message("IDPPLegalIdentity:constructor:init.");
    }

    public Object getContainerObject(Map userMap) throws IDPPException {
        IDPPUtils.debug.message("IDPPLegalIdentity:getContainerObject:Init");
        try {
            AnalyzedNameType analyzedName;
            VATType vType;
            AltIDType altID;
            PPElement ppType = IDPPUtils.getIDPPFactory().createPPElement();
            LegalIdentityElement lIdentity = IDPPUtils.getIDPPFactory().createLegalIdentityElement();
            String value = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute("LegalName").toLowerCase());
            if (value != null) {
                DSTString dstString = this.getDSTString(value);
                lIdentity.setLegalName(dstString);
            }
            if ((value = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute("DOB").toLowerCase())) != null) {
                DSTDate date = this.getDSTDate(value);
                lIdentity.setDOB(date);
            }
            if ((value = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute("Gender").toLowerCase())) != null) {
                DSTURI gender = this.getDSTURI(value);
                lIdentity.setGender(gender);
            }
            if ((value = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute("MaritalStatus").toLowerCase())) != null) {
                DSTURI mStatus = this.getDSTURI(value);
                lIdentity.setMaritalStatus(mStatus);
            }
            if ((altID = this.getAltID(userMap)) != null) {
                ArrayList<AltIDType> list = new ArrayList<AltIDType>();
                list.add(altID);
                lIdentity.getAltID().addAll(list);
            }
            if ((vType = this.getVAT(userMap)) != null) {
                lIdentity.setVAT(vType);
            }
            if ((analyzedName = this.getAnalyzedName(userMap)) != null) {
                lIdentity.setAnalyzedName(analyzedName);
            }
            ppType.setLegalIdentity(lIdentity);
            return ppType;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPContainers:getContainerObject: JAXB failure", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
        catch (IDPPException ie) {
            IDPPUtils.debug.error("IDPPContainers:getContainerObject:Error while creating legal identity.", (Throwable)ie);
            throw new IDPPException(ie);
        }
    }

    private AltIDType getAltID(Map userMap) throws IDPPException {
        IDPPUtils.debug.message("IDPPLegalIdentity:getAltID:Init");
        AltIDType altID = null;
        try {
            String altIDValue;
            altID = IDPPUtils.getIDPPFactory().createAltIDType();
            String altIDType = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute("AltIDType").toLowerCase());
            if (altIDType != null) {
                DSTURI uri = this.getDSTURI(altIDType);
                altID.setIDType(uri);
            }
            if ((altIDValue = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute("AltIDValue").toLowerCase())) != null) {
                DSTString str = this.getDSTString(altIDValue);
                altID.setIDValue(str);
            }
            if (altIDType != null && altIDValue != null) {
                return altID;
            }
            return null;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPContainers:getAltID: JAXB failure", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    private VATType getVAT(Map userMap) throws IDPPException {
        IDPPUtils.debug.message("IDPPLegalIdentity:getVATType:Init");
        VATType vType = null;
        try {
            vType = IDPPUtils.getIDPPFactory().createVATType();
            String value = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute("IDType").toLowerCase());
            if (value != null) {
                DSTURI uri = this.getDSTURI(value);
                vType.setIDType(uri);
            }
            if ((value = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute("IDValue").toLowerCase())) == null) {
                IDPPUtils.debug.message("IDPPContainers:getVAT: VAT valueis not configured in legal dentity");
                return null;
            }
            DSTString str = this.getDSTString(value);
            vType.setIDValue(str);
            return vType;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPContainers:getVAT: JAXB failure", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    public Set getContainerAttributes() {
        IDPPUtils.debug.message("IDPPLegalIdentity:getContainerAttrib:Init");
        HashSet<String> set = new HashSet<String>();
        set.add("FN");
        set.add("SN");
        set.add("PersonalTitle");
        String nameScheme = IDPPServiceManager.getInstance().getNameScheme();
        if (nameScheme != null && nameScheme.equals("urn:liberty:id-sis-pp:nameScheme:firstmiddlelast")) {
            set.add("MN");
        }
        set.add("LegalName");
        set.add("AltIDType");
        set.add("AltIDValue");
        set.add("Gender");
        set.add("DOB");
        set.add("MaritalStatus");
        set.add("IDType");
        set.add("IDValue");
        return this.getMapperAttributeSet(set);
    }

    public Set getContainerAttributesForSelect(String select) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPLegalIdentity:getContainerAttributesForSelect:Init");
        }
        String expContext = IDPPUtils.getExpressionContext(select);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPLegalIdentity:getContainerAttributesForSelect:exp context = " + expContext);
        }
        int attrType = IDPPUtils.getIDPPElementType(expContext);
        HashSet<String> set = new HashSet<String>();
        switch (attrType) {
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                set.add(expContext);
                break;
            }
            case 26: {
                set.add("AltIDType");
                set.add("AltIDValue");
                break;
            }
            case 29: {
                set.add("IDValue");
                set.add("IDType");
                break;
            }
            case 20: {
                return this.getAnalyzedNameAttributes();
            }
            case 5: {
                return this.getContainerAttributes();
            }
            default: {
                IDPPUtils.debug.error("IDPPLegalIdentity:getContainerAttributesForSelect. Invalid select.");
            }
        }
        return this.getMapperAttributeSet(set);
    }

    public Map getDataMapForSelect(String select, List data) throws IDPPException {
        IDPPUtils.debug.message("IDPPLegalIdentity:getDataMapForSelect:Init");
        Map map = new HashMap();
        String expContext = IDPPUtils.getExpressionContext(select);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPLegalIdentity:getDataMapForSelect:exp context = " + expContext);
        }
        int attrType = IDPPUtils.getIDPPElementType(expContext);
        Object dataElement = null;
        if (data != null && !data.isEmpty()) {
            dataElement = data.get(0);
        }
        switch (attrType) {
            case 19: {
                if (dataElement == null || dataElement instanceof SNElement) {
                    map = this.getAttributeMap(expContext, dataElement, map);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 15: {
                if (dataElement == null || dataElement instanceof FNElement) {
                    map = this.getAttributeMap(expContext, dataElement, map);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 16: {
                if (dataElement == null || dataElement instanceof MNElement) {
                    map = this.getAttributeMap(expContext, dataElement, map);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 18: {
                if (dataElement == null || dataElement instanceof PersonalTitleElement) {
                    map = this.getAttributeMap(expContext, dataElement, map);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 24: {
                if (dataElement == null || dataElement instanceof GenderElement) {
                    map = this.getAttributeMap(expContext, dataElement, map);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 23: {
                if (dataElement == null || dataElement instanceof DOBElement) {
                    map = this.getAttributeMap(expContext, dataElement, map);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 28: {
                if (dataElement == null || dataElement instanceof IDValueElement) {
                    String idType = this.getIDType(select);
                    if (IDPPUtils.debug.messageEnabled()) {
                        IDPPUtils.debug.message("IDPPLegalIdentity.getDataMapForSelect: IDType= " + idType);
                    }
                    String idTypeKey = null;
                    String idValueKey = null;
                    DSTString idValue = dataElement;
                    if (select.indexOf("AltID") != -1) {
                        idTypeKey = this.getAttributeMapper().getDSAttribute("AltIDType");
                        idValueKey = this.getAttributeMapper().getDSAttribute("AltIDValue");
                    } else if (select.indexOf("VAT") != -1) {
                        idTypeKey = this.getAttributeMapper().getDSAttribute("IDType");
                        idValueKey = this.getAttributeMapper().getDSAttribute("IDValue");
                    } else {
                        throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
                    }
                    HashSet<String> idTypes = new HashSet<String>();
                    idTypes.add(idType);
                    map.put(idTypeKey, idTypes);
                    HashSet<String> idValues = new HashSet<String>();
                    idValues.add(idValue.getValue());
                    map.put(idValueKey, idValues);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 25: {
                if (dataElement == null || dataElement instanceof MaritalStatusElement) {
                    map = this.getAttributeMap(expContext, dataElement, map);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 22: {
                if (dataElement == null || dataElement instanceof LegalNameElement) {
                    map = this.getAttributeMap(expContext, dataElement, map);
                    break;
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
            case 26: {
                map = this.getAltIDMap(data, map);
                break;
            }
            case 29: {
                map = this.getVATMap(dataElement, map);
                break;
            }
            case 20: {
                map = this.getAnalyzedNameMap(dataElement, map);
                break;
            }
            case 5: {
                map = this.getLegalIdentityMap(dataElement, map);
                break;
            }
            default: {
                IDPPUtils.debug.error("IDPPLegalIdentity:getDataMapForSelectUnsupported element");
            }
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPLegalIdentity:getDataMapForSelect:Attr map to be modified." + map);
        }
        return map;
    }

    private Map getLegalIdentityMap(Object obj, Map map) throws IDPPException {
        IDPPUtils.debug.message("IDPPLegalIdentity:getLegalIdentityMap:Init");
        AnalyzedNameType analyzedName = null;
        VATType vat = null;
        List altIDs = null;
        DSTURI gender = null;
        DSTURI mStatus = null;
        DSTDate dob = null;
        DSTString lName = null;
        if (obj != null) {
            if (obj instanceof LegalIdentityType) {
                LegalIdentityType lType = (LegalIdentityType)obj;
                analyzedName = lType.getAnalyzedName();
                vat = lType.getVAT();
                altIDs = lType.getAltID();
                dob = lType.getDOB();
                mStatus = lType.getMaritalStatus();
                gender = lType.getGender();
                lName = lType.getLegalName();
            } else {
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
        }
        this.getAnalyzedNameMap(analyzedName, map);
        this.getVATMap(vat, map);
        this.getAltIDMap(altIDs, map);
        this.getAttributeMap("Gender", gender, map);
        this.getAttributeMap("MaritalStatus", mStatus, map);
        this.getAttributeMap("LegalName", lName, map);
        this.getAttributeMap("DOB", dob, map);
        return map;
    }

    private Map getAltIDMap(List dataObject, Map map) throws IDPPException {
        DSTURI altIDType = null;
        DSTString altIDValue = null;
        if (dataObject != null && dataObject.size() != 0) {
            int size = dataObject.size();
            for (int i = 0; i < size; ++i) {
                Object dataElement = dataObject.get(i);
                if (!(dataElement instanceof AltIDElement)) {
                    throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
                }
                AltIDType altID = (AltIDType)dataElement;
                altIDType = altID.getIDType();
                altIDValue = altID.getIDValue();
            }
        }
        this.getAttributeMap("AltIDType", altIDType, map);
        this.getAttributeMap("AltIDValue", altIDValue, map);
        return map;
    }

    private Map getVATMap(Object obj, Map map) throws IDPPException {
        IDPPUtils.debug.message("IDPPLegalIdentity:getVATMap:Init");
        DSTURI idType = null;
        DSTString idValue = null;
        if (obj != null) {
            if (obj instanceof VATType) {
                VATType vType = (VATType)obj;
                idType = vType.getIDType();
                idValue = vType.getIDValue();
            } else {
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
        }
        this.getAttributeMap("IDType", idType, map);
        this.getAttributeMap("IDValue", idValue, map);
        return map;
    }

    public boolean isSingleAttributeContainer() {
        return false;
    }

    public boolean hasBinaryAttributes() {
        return false;
    }

    private String getIDType(String select) throws IDPPException {
        if (select.indexOf("[") == -1) {
            throw new IDPPException(IDPPUtils.bundle.getString("invalidSelect"));
        }
        int index1 = select.indexOf("IDType");
        if (index1 == -1) {
            throw new IDPPException(IDPPUtils.bundle.getString("invalidSelect"));
        }
        String idType = select.substring(index1 + 7);
        int index2 = idType.indexOf("\"");
        if (index2 == -1) {
            throw new IDPPException(IDPPUtils.bundle.getString("invalidSelect"));
        }
        int index3 = (idType = idType.substring(index2 + 1, idType.length())).indexOf("\"");
        if (index3 == -1) {
            throw new IDPPException(IDPPUtils.bundle.getString("invalidSelect"));
        }
        return idType.substring(0, index3);
    }
}

