/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.util;

import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.federation.key.EncInfo;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.liberty.ws.util.ProviderManager;
import com.sun.identity.liberty.ws.util.ProviderUtil;
import java.security.Key;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;

public class IDFFProviderManager
implements ProviderManager {
    private static final String ROOT_REALM = "/";
    private static IDFFMetaManager idffMetaManager = null;

    public boolean containsProvider(String providerID) {
        SPDescriptorType spDescriptor = null;
        try {
            spDescriptor = idffMetaManager.getSPDescriptor(ROOT_REALM, providerID);
        }
        catch (IDFFMetaException imex) {
            ProviderUtil.debug.error("IDFFProviderManager.containsProvider:", (Throwable)((Object)imex));
        }
        return spDescriptor != null;
    }

    public boolean isAffiliationMember(String providerID, String affID) {
        try {
            return idffMetaManager.isAffiliateMember(ROOT_REALM, providerID, affID);
        }
        catch (IDFFMetaException imex) {
            ProviderUtil.debug.error("IDFFProviderManager.isAffiliationMember:", (Throwable)((Object)imex));
            return false;
        }
    }

    public boolean isNameIDEncryptionEnabled(String providerID) {
        EntityConfigElement entityConfig = null;
        try {
            entityConfig = idffMetaManager.getEntityConfig(ROOT_REALM, providerID);
        }
        catch (IDFFMetaException imex) {
            ProviderUtil.debug.error("IDFFProviderManager.isNameIDEncryptionEnabled:", (Throwable)((Object)imex));
        }
        if (entityConfig == null) {
            return false;
        }
        BaseConfigType baseConfig = IDFFMetaUtils.getSPDescriptorConfig(entityConfig);
        if (baseConfig == null && (baseConfig = IDFFMetaUtils.getIDPDescriptorConfig(entityConfig)) == null) {
            return false;
        }
        Map attrMap = IDFFMetaUtils.getAttributes(baseConfig);
        if (attrMap == null || attrMap.isEmpty()) {
            return false;
        }
        List values = (List)attrMap.get("enableNameIDEncryption");
        if (values == null || values.isEmpty()) {
            return false;
        }
        return ((String)values.get(0)).equalsIgnoreCase("true");
    }

    public Key getEncryptionKey(String providerID) {
        EncInfo encInfo = this.getEncInfo(providerID);
        return encInfo == null ? null : encInfo.getWrappingKey();
    }

    public int getEncryptionKeyStrength(String providerID) {
        EncInfo encInfo = this.getEncInfo(providerID);
        return encInfo == null ? 0 : encInfo.getDataEncStrength();
    }

    public String getEncryptionKeyAlgorithm(String providerID) {
        EncInfo encInfo = this.getEncInfo(providerID);
        return encInfo == null ? null : encInfo.getDataEncAlgorithm();
    }

    public PrivateKey getDecryptionKey(String providerID) {
        BaseConfigType providerConfig = null;
        try {
            providerConfig = idffMetaManager.getSPDescriptorConfig(ROOT_REALM, providerID);
            if (providerConfig == null) {
                providerConfig = idffMetaManager.getIDPDescriptorConfig(ROOT_REALM, providerID);
            }
        }
        catch (IDFFMetaException imex) {
            ProviderUtil.debug.error("IDFFProviderManager.getDecryptionKey", (Throwable)((Object)imex));
        }
        if (providerConfig == null) {
            return null;
        }
        return KeyUtil.getDecryptionKey(providerConfig);
    }

    public String getSigningKeyAlias(String providerID) {
        BaseConfigType config = null;
        try {
            config = idffMetaManager.getSPDescriptorConfig(ROOT_REALM, providerID);
            if (config == null) {
                config = idffMetaManager.getIDPDescriptorConfig(ROOT_REALM, providerID);
            }
        }
        catch (IDFFMetaException imex) {
            ProviderUtil.debug.error("IDFFProviderManager.getSigningCertificate:", (Throwable)((Object)imex));
        }
        if (config == null) {
            if (ProviderUtil.debug.messageEnabled()) {
                ProviderUtil.debug.message("IDFFProviderManager.getSigningKeyAlias:config not found.");
            }
            return null;
        }
        return KeyUtil.getSigningCertAlias(config);
    }

    private EncInfo getEncInfo(String providerID) {
        ProviderDescriptorType providerDesc = null;
        try {
            providerDesc = idffMetaManager.getSPDescriptor(ROOT_REALM, providerID);
            if (providerDesc == null) {
                providerDesc = idffMetaManager.getIDPDescriptor(ROOT_REALM, providerID);
            }
            if (providerDesc == null) {
                return null;
            }
        }
        catch (IDFFMetaException imex) {
            ProviderUtil.debug.error("IDFFProviderManager.getEncInfo:", (Throwable)((Object)imex));
            return null;
        }
        if (providerDesc == null) {
            if (ProviderUtil.debug.messageEnabled()) {
                ProviderUtil.debug.message("IDFFProviderManager.getEncInfo: Descriptor not found.");
            }
            return null;
        }
        return KeyUtil.getEncInfo(providerDesc, providerID, false);
    }

    static {
        try {
            idffMetaManager = new IDFFMetaManager(null);
        }
        catch (IDFFMetaException imex) {
            ProviderUtil.debug.error("IDFFProviderManager.static:", (Throwable)((Object)imex));
        }
    }
}

