/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.multiprotocol;

import com.sun.identity.multiprotocol.SingleLogoutManager;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MultiProtocolUtils {
    private static String RELAY_SERVLET_BLOCK = "/multiprotocolrelay/";

    private MultiProtocolUtils() {
    }

    public static String geServerBaseURL(HttpServletRequest request) {
        String uri = request.getRequestURI();
        int index = uri.indexOf("/", 1);
        if (index != -1) {
            uri = uri.substring(0, index);
        }
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + uri;
    }

    public static boolean isMultiProtocolRelayState(String relayState) {
        if (relayState == null || relayState.length() == 0) {
            return false;
        }
        SingleLogoutManager manager = SingleLogoutManager.getInstance();
        int index = relayState.indexOf(RELAY_SERVLET_BLOCK);
        if (index == -1) {
            return false;
        }
        String handler = relayState.substring(index + RELAY_SERVLET_BLOCK.length());
        return manager.containRelayState(handler);
    }

    public static void addFederationProtocol(Object session, String protocol) {
        if (SingleLogoutManager.debug.messageEnabled()) {
            SingleLogoutManager.debug.message("MPUtils.addFedProtocol: protocol=" + protocol + ", session=" + session);
        }
        try {
            SessionProvider provider = SessionManager.getProvider();
            String[] values = provider.getProperty(session, "federationprotocols");
            if (SingleLogoutManager.debug.messageEnabled()) {
                SingleLogoutManager.debug.message("MPUtils.addFedProtocol: current protocols=" + values);
            }
            if (values == null || values.length == 0) {
                values = new String[]{protocol};
                provider.setProperty(session, "federationprotocols", values);
            } else {
                HashSet<String> set = new HashSet<String>();
                for (int i = 0; i < values.length; ++i) {
                    set.add(values[i]);
                }
                set.add(protocol);
                String[] newVals = new String[set.size()];
                set.toArray(newVals);
                provider.setProperty(session, "federationprotocols", newVals);
            }
        }
        catch (UnsupportedOperationException ex) {
            SingleLogoutManager.debug.warning("MPUtils.addFedProtocol", (Throwable)ex);
        }
        catch (SessionException ex) {
            SingleLogoutManager.debug.warning("MPUtils.addFedProtocol2", (Throwable)((Object)ex));
        }
    }

    public static void removeFederationProtocol(Object session, String protocol) {
        if (SingleLogoutManager.debug.messageEnabled()) {
            SingleLogoutManager.debug.message("MPUtils.removeFedProtocol: protocol=" + protocol + ", session=" + session);
        }
        try {
            SessionProvider provider = SessionManager.getProvider();
            String[] values = provider.getProperty(session, "federationprotocols");
            if (SingleLogoutManager.debug.messageEnabled()) {
                SingleLogoutManager.debug.message("MPUtils.removeFedProtocol: current protocols=" + values);
            }
            if (values == null || values.length == 0) {
                return;
            }
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < values.length; ++i) {
                set.add(values[i]);
            }
            set.remove(protocol);
            String[] newVals = new String[set.size()];
            set.toArray(newVals);
            provider.setProperty(session, "federationprotocols", newVals);
        }
        catch (UnsupportedOperationException ex) {
            SingleLogoutManager.debug.warning("MPUtils.addFedProtocol", (Throwable)ex);
        }
        catch (SessionException ex) {
            SingleLogoutManager.debug.warning("MPUtils.addFedProtocol2", (Throwable)((Object)ex));
        }
    }

    public static boolean isMultipleProtocolSession(HttpServletRequest request, String protocol) {
        try {
            SessionProvider provider = SessionManager.getProvider();
            Object session = provider.getSession(request);
            return MultiProtocolUtils.isMultipleProtocolSession(session, protocol);
        }
        catch (SessionException ex) {
            SingleLogoutManager.debug.message("MPUtils.isMPSession?", (Throwable)((Object)ex));
            return false;
        }
    }

    public static boolean isMultipleProtocolSession(Object session, String protocol) {
        SingleLogoutManager.debug.message("MultiProtocolUtils.isMPSession");
        if (session == null || protocol == null) {
            return false;
        }
        if (SingleLogoutManager.debug.messageEnabled()) {
            SingleLogoutManager.debug.message("MultiProtocolUtils.isMPSession: protocol=" + protocol + ", session=" + session);
        }
        try {
            SessionProvider provider = SessionManager.getProvider();
            String[] vals = provider.getProperty(session, "federationprotocols");
            if (vals != null && SingleLogoutManager.debug.messageEnabled()) {
                SingleLogoutManager.debug.message("MultiProtocolUtils.isMPSession: size=" + vals.length);
                for (int i = 0; i < vals.length; ++i) {
                    SingleLogoutManager.debug.message("MultiProtocolUtils.isMPSession: protocols=" + vals[i]);
                }
            }
            if (vals == null || vals.length == 0) {
                return false;
            }
            if (vals.length > 1) {
                return true;
            }
            return !protocol.equals(vals[0]);
        }
        catch (SessionException ex) {
            SingleLogoutManager.debug.message("MPUtils.isMPSession", (Throwable)((Object)ex));
        }
        catch (UnsupportedOperationException ex) {
            SingleLogoutManager.debug.message("MPUtils.isMPSession2", (Throwable)ex);
        }
        return false;
    }

    public static boolean usedInProtocol(HttpServletRequest request, String protocol) {
        try {
            SessionProvider provider = SessionManager.getProvider();
            Object session = provider.getSession(request);
            return MultiProtocolUtils.usedInProtocol(session, protocol);
        }
        catch (SessionException ex) {
            SingleLogoutManager.debug.message("MPUtils.usedInProtocol?", (Throwable)((Object)ex));
            return false;
        }
    }

    public static boolean usedInProtocol(Object session, String protocol) {
        SingleLogoutManager.debug.message("MultiProtocolUtils.usedInProtocol");
        if (session == null || protocol == null) {
            return false;
        }
        if (SingleLogoutManager.debug.messageEnabled()) {
            SingleLogoutManager.debug.message("MultiProtocolUtils.usedInProto: protocol=" + protocol + ", session=" + session);
        }
        try {
            SessionProvider provider = SessionManager.getProvider();
            String[] vals = provider.getProperty(session, "federationprotocols");
            if (SingleLogoutManager.debug.messageEnabled()) {
                SingleLogoutManager.debug.message("MultiProtocolUtils.usedInProtocol: protocols=" + vals);
            }
            if (vals != null && vals.length != 0) {
                for (int i = 0; i < vals.length; ++i) {
                    if (!protocol.equals(vals[i])) continue;
                    return true;
                }
            }
            return false;
        }
        catch (SessionException ex) {
            SingleLogoutManager.debug.message("MPUtils.usedInProtocol", (Throwable)((Object)ex));
        }
        catch (UnsupportedOperationException ex) {
            SingleLogoutManager.debug.message("MPUtils.usedInProtocol", (Throwable)ex);
        }
        return false;
    }

    public static void invalidateSession(Object session, HttpServletRequest request, HttpServletResponse response, String protocol) throws SessionException {
        SessionProvider provider = SessionManager.getProvider();
        if (!MultiProtocolUtils.isMultipleProtocolSession(session, protocol)) {
            provider.invalidateSession(session, request, response);
        } else {
            MultiProtocolUtils.removeFederationProtocol(session, protocol);
        }
    }

    public static String getLogoutStatus(int status) {
        switch (status) {
            case 1: 
            case 2: {
                return "logoutFailure";
            }
        }
        return "logoutSuccess";
    }
}

