/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml;

import com.sun.identity.common.SystemConfigurationException;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.common.LogUtils;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.Request;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.servlet.SAMLSOAPReceiver;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLClient {
    private static void doSSO(HttpServletRequest request, HttpServletResponse response, String target, String service) throws IOException, SAMLException {
        if (request == null || response == null || target == null) {
            SAMLUtils.debug.error("SAMLClient:Input parameter is null.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!(service.equals("samlawareservlet") || service.equals("samlpostservlet") || service.equals("samlsoapreceiver"))) {
            SAMLUtils.debug.error("SAMLClient:illegal naming service name.");
            throw new SAMLException(SAMLUtils.bundle.getString("illegalNamingService"));
        }
        Object ssoToken = null;
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            ssoToken = sessionProvider.getSession(request);
            if (ssoToken == null) {
                SAMLUtils.debug.error("SAMLClient:SSOToken is null.");
                throw new SAMLException(SAMLUtils.bundle.getString("nullSSOToken"));
            }
            if (!sessionProvider.isValid(ssoToken)) {
                SAMLUtils.debug.error("SAMLClient:Session is invalid.");
                throw new SAMLException(SAMLUtils.bundle.getString("invalidSSOToken"));
            }
        }
        catch (SessionException se) {
            SAMLUtils.debug.error("SAMLClient", (Throwable)((Object)se));
            throw new SAMLException("SAMLClient:doSSO:" + se.getMessage());
        }
        URL weburl = null;
        try {
            URL serverurl = new URL(SAMLServiceManager.getServerURL());
            weburl = SystemConfigurationUtil.getServiceURL(service, serverurl.getProtocol(), serverurl.getHost(), serverurl.getPort(), serverurl.getPath());
        }
        catch (SystemConfigurationException ue) {
            SAMLUtils.debug.error("SAMLClient", (Throwable)((Object)ue));
            throw new SAMLException(SAMLUtils.bundle.getString("URLNotFoundException"));
        }
        StringBuffer redirectedurl = new StringBuffer(200);
        String tname = (String)SAMLServiceManager.getAttribute("iplanet-am-saml-target-specifier");
        redirectedurl.append(weburl).append("?").append(tname).append("=").append(target);
        response.sendRedirect(redirectedurl.toString());
    }

    public static void doWebArtifact(HttpServletRequest request, HttpServletResponse response, String target) throws IOException, SAMLException {
        SAMLClient.doSSO(request, response, target, "samlawareservlet");
    }

    public static void doWebPOST(HttpServletRequest request, HttpServletResponse response, String target) throws IOException, SAMLException {
        SAMLClient.doSSO(request, response, target, "samlpostservlet");
    }

    public static Assertion getAssertionByArtifact(AssertionArtifact artifact) throws IOException, SAMLException {
        return SAMLClient.getAssertionByArtifact(artifact.getAssertionArtifact());
    }

    public static Assertion getAssertionByArtifact(String artifact) throws IOException, SAMLException {
        if (artifact == null || artifact.length() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLClient: input is null.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        AssertionArtifact aa = new AssertionArtifact(artifact);
        String sid = aa.getSourceID();
        String ssurl = SAMLClient.getSamlSoapUrl(sid);
        URL samlsoap = null;
        try {
            if (ssurl == null) {
                Map instances = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-instance-list");
                if (instances == null || instances.size() == 0) {
                    throw new SAMLException(SAMLUtils.bundle.getString("instancemapNull"));
                }
                String server = (String)instances.get(sid);
                if (server == null || server.length() == 0) {
                    throw new SAMLException(SAMLUtils.bundle.getString("instanceNotFound"));
                }
                URL serverurl = new URL(server);
                samlsoap = SystemConfigurationUtil.getServiceURL("samlsoapreceiver", serverurl.getProtocol(), serverurl.getHost(), serverurl.getPort(), serverurl.getPath());
            } else {
                samlsoap = new URL(ssurl);
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLClient:SOAPUrl=" + samlsoap.toString());
            }
        }
        catch (SystemConfigurationException ue) {
            SAMLUtils.debug.error("SAMLClient", (Throwable)((Object)ue));
            throw new SAMLException(SAMLUtils.bundle.getString("URLNotFoundException"));
        }
        if (!SAMLClient.setLocalFlag(samlsoap)) {
            throw new SAMLException(SAMLUtils.bundle.getString("failSetLocalFlag"));
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("SAMLClient:getAssertionByArtifact: check localFlag : " + SAMLServiceManager.localFlag);
        }
        String encodedSourceid = (String)SAMLServiceManager.getAttribute("mysiteid");
        boolean isMySite = sid.equals(encodedSourceid.trim());
        if (SAMLServiceManager.localFlag && isMySite) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLClient:getAssertionByArtifact:call AssertionManager.getAssertion(AssertionArtifact)");
            }
            AssertionManager assertManager = AssertionManager.getInstance();
            Assertion assertion = assertManager.getAssertion(aa);
            return assertion;
        }
        String[] strarray = new String[]{artifact};
        List asserts = null;
        asserts = isMySite && ssurl == null ? SAMLClient.artifactQueryHandler(strarray, samlsoap.toString()) : SAMLClient.artifactQueryHandler(strarray, null);
        if (asserts == null || asserts.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLClient:getAssertionByArtifact:returned assertion list is null.");
            }
            return null;
        }
        return (Assertion)asserts.get(0);
    }

    private static String getSamlSoapUrl(String sourceid) {
        String soapurl = null;
        try {
            Map partner = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
            if (partner == null) {
                SAMLUtils.debug.error("SAMLClient:Partner URL is null.");
                return null;
            }
            SAMLServiceManager.SOAPEntry partnerdest = (SAMLServiceManager.SOAPEntry)partner.get(sourceid);
            if (partnerdest != null) {
                soapurl = partnerdest.getSOAPUrl();
            } else if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLClient: " + sourceid + " is not on trusted site list.");
            }
            return soapurl;
        }
        catch (Exception se) {
            SAMLUtils.debug.error("SAMLClient: ", (Throwable)se);
            return null;
        }
    }

    public static boolean setLocalFlag(URL url) {
        if (url == null) {
            SAMLUtils.debug.error("SAMLClient:setLocalFlag has null input.");
            return false;
        }
        try {
            Class.forName("com.sun.identity.saml.servlet.SAMLSOAPReceiver");
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("in setLocalFlag(), url : " + url.toString());
                SAMLUtils.debug.message("SAMLSOAPReceiver.localSAMLServiceID : " + SAMLSOAPReceiver.localSAMLServiceID);
            }
            if (SAMLSOAPReceiver.localSAMLServiceID != null) {
                URL samlservice = new URL(SAMLSOAPReceiver.localSAMLServiceID);
                if (url.getHost().equalsIgnoreCase(samlservice.getHost()) && url.getPort() == samlservice.getPort()) {
                    SAMLServiceManager.localFlag = true;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLClient::setLocalFlag: ", (Throwable)cnfe);
            }
            SAMLServiceManager.localFlag = false;
            return true;
        }
        catch (Exception e) {
            SAMLUtils.debug.error("SAMLClient::setLocalFlag:: ", (Throwable)e);
            return false;
        }
        SAMLServiceManager.localFlag = false;
        return true;
    }

    private static String createSOAPMessage(Request req) throws SAMLException {
        if (req == null) {
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        try {
            StringBuffer envBegin = new StringBuffer(100);
            envBegin.append("<").append("soap-env").append(":Envelope").append(" ").append("xmlns:").append("soap-env").append("=\"").append("http://schemas.xmlsoap.org/soap/envelope/").append("\">").append("\n").append("<").append("soap-env").append(":Body>").append("\n");
            StringBuffer envEnd = new StringBuffer(100);
            envEnd.append("</").append("soap-env").append(":Body>").append("\n").append("</").append("soap-env").append(":Envelope>").append("\n");
            StringBuffer sb = new StringBuffer(300);
            sb.append(envBegin).append(req.toString(true, true)).append(envEnd);
            return sb.toString();
        }
        catch (Exception e) {
            throw new SAMLException(e.getMessage());
        }
    }

    private static String createSOAPReceiverUrl(SAMLServiceManager.SOAPEntry destSite, String to) throws IOException, SAMLException {
        if (destSite == null || to == null || to.length() == 0) {
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        String authtype = destSite.getAuthType();
        String urlEndpoint = null;
        int idnx = -1;
        idnx = to.indexOf("//");
        if (idnx == -1) {
            SAMLUtils.debug.error("SAMLClient:createSOAPReceiverUrl:Illegal format of input parameter.");
            throw new SAMLException(SAMLUtils.bundle.getString("illegalFormatSOAPUrl"));
        }
        String protocol = to.substring(0, idnx - 1);
        if (authtype.equalsIgnoreCase("BASICAUTH") || authtype.equalsIgnoreCase("NOAUTH")) {
            if (!protocol.equals("http")) {
                if (SystemConfigurationUtil.isServerMode()) {
                    String[] data = new String[]{SAMLUtils.bundle.getString("mismatchAuthTypeandProtocol")};
                    LogUtils.error(Level.INFO, "AUTH_PROTOCOL_MISMATCH", data);
                }
                throw new SAMLException(SAMLUtils.bundle.getString("mismatchAuthTypeandProtocol"));
            }
        } else if (authtype.equalsIgnoreCase("SSLWITHBASICAUTH") || authtype.equalsIgnoreCase("SSL")) {
            if (!protocol.equals("https")) {
                if (SystemConfigurationUtil.isServerMode()) {
                    String[] data = new String[]{SAMLUtils.bundle.getString("mismatchAuthTypeandProtocol")};
                    LogUtils.error(Level.INFO, "AUTH_PROTOCOL_MISMATCH", data);
                }
                throw new SAMLException(SAMLUtils.bundle.getString("mismatchAuthTypeandProtocol"));
            }
        } else {
            if (SystemConfigurationUtil.isServerMode()) {
                String[] data = new String[]{SAMLUtils.bundle.getString("wrongAuthType")};
                LogUtils.error(Level.INFO, "INVALID_AUTH_TYPE", data);
            }
            throw new SAMLException(SAMLUtils.bundle.getString("wrongAuthType"));
        }
        if (authtype.equalsIgnoreCase("BASICAUTH") || authtype.equalsIgnoreCase("SSLWITHBASICAUTH")) {
            String toSOAP;
            String username = destSite.getBasicAuthUserID();
            String password = destSite.getBasicAuthPassword();
            if (username == null || password == null) {
                SAMLUtils.debug.error("SAMLClient:createSOAPReceiverUrl:PartnerSite required basic authentication. But the user name or password used for authentication is null.");
                throw new SAMLException(SAMLUtils.bundle.getString("wrongConfigBasicAuth"));
            }
            urlEndpoint = toSOAP = to.substring(0, idnx + 2) + username + ":" + password + "@" + to.substring(idnx + 2);
        } else {
            urlEndpoint = to;
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("Sending message to URL: " + urlEndpoint);
        }
        if (SystemConfigurationUtil.isServerMode()) {
            String[] data = new String[]{SAMLUtils.bundle.getString("SOAPReceiverURL"), urlEndpoint};
            LogUtils.access(Level.FINE, "SOAP_RECEIVER_URL", data);
        }
        return urlEndpoint;
    }

    private static Response getSAMLResponse(String xmlString) throws IOException, SAMLException {
        if (xmlString == null || xmlString.length() == 0) {
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        Response samlResp = null;
        Document doc = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAMLUtils.debug);
        Element root = doc.getDocumentElement();
        String rootName = root.getLocalName();
        if (rootName == null || rootName.length() == 0) {
            SAMLUtils.debug.error("Missing Envelope tag.");
            throw new SAMLException(SAMLUtils.bundle.getString("missingSOAPEnvTag"));
        }
        if (!rootName.equals("Envelope") || !root.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            SAMLUtils.debug.error("Wrong Envelope tag or namespace.");
            throw new SAMLException(SAMLUtils.bundle.getString("serverError"));
        }
        NodeList nodes = root.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount <= 0) {
            SAMLUtils.debug.error("Envelope does not contain a SOAP body.");
            throw new SAMLException(SAMLUtils.bundle.getString("missingSOAPBody"));
        }
        String tagName = null;
        String ctagName = null;
        Node currentNode = null;
        Node cnode = null;
        block0: for (int i = 0; i < nodeCount; ++i) {
            currentNode = nodes.item(i);
            if (currentNode.getNodeType() != 1) continue;
            tagName = currentNode.getLocalName();
            if (tagName == null || tagName.length() == 0) {
                SAMLUtils.debug.error("Missing tag name of child element");
                throw new SAMLException(SAMLUtils.bundle.getString("missingChildTagName"));
            }
            if (tagName.equals("Body")) {
                NodeList cNodes = currentNode.getChildNodes();
                int cnodeCount = cNodes.getLength();
                for (int j = 0; j < cnodeCount; ++j) {
                    cnode = cNodes.item(j);
                    if (cnode.getNodeType() != 1) continue;
                    ctagName = cnode.getLocalName();
                    if (ctagName == null || ctagName.length() == 0) {
                        SAMLUtils.debug.error("Missing tag name of child element of <SOAP-ENV:Body>");
                        throw new SAMLException(SAMLUtils.bundle.getString("missingChildTagName"));
                    }
                    if (ctagName.equals("Fault")) {
                        SAMLUtils.debug.error("SOAPFault error.");
                        throw new SAMLException(XMLUtils.print((Node)cnode));
                    }
                    if (ctagName.equals("Response")) {
                        samlResp = new Response((Element)cnode);
                        if (!SAMLUtils.debug.messageEnabled()) continue block0;
                        SAMLUtils.debug.message("SAML Response:" + samlResp.toString());
                        continue block0;
                    }
                    SAMLUtils.debug.error("Wrong child element in SOAPBody");
                    throw new SAMLException(SAMLUtils.bundle.getString("wrongSOAPBody"));
                }
                continue;
            }
            if (tagName.equals("Header")) {
                if (!SAMLUtils.debug.messageEnabled()) continue;
                SAMLUtils.debug.message("Inside SOAP Response: SOAP Header");
                continue;
            }
            SAMLUtils.debug.error("Wrong child element in Envelope");
            throw new SAMLException(SAMLUtils.bundle.getString("wrongSOAPElement"));
        }
        return samlResp;
    }

    private static List getAssertionList(Response samlresponse, List alist) throws SAMLException {
        if (samlresponse == null || alist == null) {
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        List assertions = new ArrayList();
        assertions = samlresponse.getAssertion();
        if (assertions == null || assertions.isEmpty()) {
            if (SystemConfigurationUtil.isServerMode()) {
                String[] data = new String[]{SAMLUtils.bundle.getString("noAssertioninResponse"), samlresponse.toString(true, true)};
                LogUtils.error(Level.INFO, "NO_ASSERTION_IN_RESPONSE", data);
            }
            throw new SAMLException(SAMLUtils.displayXML(samlresponse.getStatus().toString()));
        }
        if (assertions.size() != alist.size()) {
            SAMLUtils.debug.error("The SAML response containing assertions !=the number of artifacts in SAML request");
            if (SystemConfigurationUtil.isServerMode()) {
                String[] data = new String[]{SAMLUtils.bundle.getString("wrongNumberAssertions"), samlresponse.toString(true, true)};
                LogUtils.error(Level.INFO, "MISMATCHED_ASSERTION_AND_ARTIFACT", data);
            }
            throw new SAMLException(SAMLUtils.bundle.getString("wrongNumberAssertions"));
        }
        return assertions;
    }

    public static List artifactQueryHandler(String[] arti, String connecto) throws IOException, SAMLException {
        String[] data;
        if (arti == null || arti.length == 0) {
            SAMLUtils.debug.message("artifactQueryHandler: null input.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        String firstSourceID = null;
        SAMLServiceManager.SOAPEntry dest = null;
        Response samlresponse = null;
        ArrayList<String> al = new ArrayList<String>();
        ArrayList<AssertionArtifact> artl = new ArrayList<AssertionArtifact>();
        AssertionArtifact firstArtifact = new AssertionArtifact(arti[0]);
        firstSourceID = firstArtifact.getSourceID();
        if (SystemConfigurationUtil.isServerMode()) {
            String[] data2 = new String[]{SAMLUtils.bundle.getString("Artifact") + " " + 0, arti[0]};
            LogUtils.access(Level.INFO, "ARTIFACT_TO_SEND", data2);
        }
        artl.add(firstArtifact);
        al.add(arti[0]);
        AssertionArtifact assertArtifact = null;
        String destination = null;
        for (int k = 1; k < arti.length; ++k) {
            assertArtifact = new AssertionArtifact(arti[k]);
            destination = assertArtifact.getSourceID();
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SourceID within the Artifact is " + destination);
            }
            if (!destination.equals(firstSourceID)) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Received multiple Artifacts have different source id.");
                }
                throw new SAMLException(SAMLUtils.bundle.getString("sourceidDifferent"));
            }
            if (SystemConfigurationUtil.isServerMode()) {
                data = new String[]{SAMLUtils.bundle.getString("Artifact") + " " + k, arti[k]};
                LogUtils.access(Level.FINE, "ARTIFACT_TO_SEND", data);
            }
            artl.add(assertArtifact);
            al.add(arti[k]);
        }
        try {
            String[] data3;
            String line;
            StringTokenizer st;
            String to = null;
            Map soaps = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
            if (soaps == null) {
                SAMLUtils.debug.error(SAMLUtils.bundle.getString("nullPartnerUrl"));
                throw new SAMLException(SAMLUtils.bundle.getString("nullPartnerUrl"));
            }
            String urlEndpoint = null;
            if (soaps.containsKey(firstSourceID)) {
                dest = (SAMLServiceManager.SOAPEntry)soaps.get(firstSourceID);
                to = dest.getSOAPUrl();
                if (to == null) {
                    if (connecto == null || connecto.length() == 0) {
                        if (SystemConfigurationUtil.isServerMode()) {
                            String[] data4 = new String[]{SAMLUtils.bundle.getString("wrongPartnerSOAPUrl")};
                            LogUtils.error(Level.INFO, "WRONG_SOAP_URL", data4);
                        }
                        throw new SAMLException(SAMLUtils.bundle.getString("wrongPartnerSOAPUrl"));
                    }
                    urlEndpoint = connecto;
                } else {
                    urlEndpoint = SAMLClient.createSOAPReceiverUrl(dest, to);
                }
            } else {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("SAMLClient:artifactQueryHandler: Failed to locate SOAP-Receiver-URL using the source id from AssertionArtifact.");
                }
                if (connecto == null || connecto.length() == 0) {
                    throw new SAMLException(SAMLUtils.bundle.getString("failedLocateSOAPUrl"));
                }
                urlEndpoint = connecto;
            }
            if (urlEndpoint == null) {
                SAMLUtils.debug.error("SAMLClient:artifactQueryHandler:createSOAPReceiverURL Error!");
                if (SystemConfigurationUtil.isServerMode()) {
                    String[] data5 = new String[]{SAMLUtils.bundle.getString("wrongPartnerSOAPUrl")};
                    LogUtils.error(Level.INFO, "WRONG_SOAP_URL", data5);
                }
                throw new SAMLException(SAMLUtils.bundle.getString("wrongPartnerSOAPUrl"));
            }
            Request req = new Request(null, artl);
            String ver = dest.getVersion();
            if (ver != null && (st = new StringTokenizer(ver, ".")).countTokens() == 2) {
                req.setMajorVersion(Integer.parseInt(st.nextToken().trim()));
                req.setMinorVersion(Integer.parseInt(st.nextToken().trim()));
            }
            if (((Boolean)SAMLServiceManager.getAttribute("iplanet-am-saml-signrequest")).booleanValue()) {
                req.signXML();
            }
            String xmlString = SAMLClient.createSOAPMessage(req);
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SENDING message: \n " + xmlString);
            }
            if (SystemConfigurationUtil.isServerMode()) {
                String[] data6 = new String[]{SAMLUtils.bundle.getString("sendingSAMLRequest"), xmlString};
                LogUtils.access(Level.FINE, "SAML_ARTIFACT_QUERY", data6);
            }
            String[] urls = new String[]{urlEndpoint};
            SOAPClient client = new SOAPClient(urls);
            InputStream inbuf = client.call(xmlString, null, null);
            StringBuffer reply = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inbuf, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                reply.append(line).append("\n");
            }
            if (reply == null) {
                if (SystemConfigurationUtil.isServerMode()) {
                    String[] data7 = new String[]{SAMLUtils.bundle.getString("noReplyfromSOAPReceiver")};
                    LogUtils.error(Level.INFO, "NO_REPLY_FROM_SOAP_RECEIVER", data7);
                }
                throw new SAMLException(SAMLUtils.bundle.getString("noReplyfromSOAPReceiver"));
            }
            xmlString = reply.toString();
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("REPLIED message: \n " + xmlString);
            }
            if (SystemConfigurationUtil.isServerMode()) {
                data3 = new String[]{SAMLUtils.bundle.getString("repliedSOAPMessage"), xmlString};
                LogUtils.access(Level.FINE, "REPLIED_SOAP_MESSAGE", data3);
            }
            if ((samlresponse = SAMLClient.getSAMLResponse(xmlString)) == null) {
                SAMLUtils.debug.error("SAMLClient:artifactQueryHandler:No SAML Response contained in SOAPMessage.");
                if (SystemConfigurationUtil.isServerMode()) {
                    data3 = new String[]{SAMLUtils.bundle.getString("noSAMLResponse")};
                    LogUtils.error(Level.INFO, "NULL_SAML_RESPONSE", data3);
                }
                throw new SAMLException(SAMLUtils.bundle.getString("noSAMLResponse"));
            }
        }
        catch (Exception e) {
            SAMLUtils.debug.error("SAMLClient:artifactQueryHandler", (Throwable)e);
            throw new SAMLException(e.getMessage());
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("Start to process SAML Response...");
        }
        if (!samlresponse.isSignatureValid()) {
            if (SystemConfigurationUtil.isServerMode()) {
                String[] data8 = new String[]{SAMLUtils.bundle.getString("cannotVerifyResponse")};
                LogUtils.error(Level.INFO, "INVALID_RESPONSE_SIGNATURE", data8);
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotVerifyResponse"));
        }
        try {
            String statuscode = samlresponse.getStatus().getStatusCode().getValue();
            int idex = 0;
            idex = statuscode.indexOf(":");
            if (idex == -1) {
                throw new SAMLException(SAMLUtils.bundle.getString("wrongformatStatusCode"));
            }
            if (!statuscode.substring(idex).equals(":Success")) {
                SAMLUtils.debug.error("Error:SAML StatusCode is not Success");
                throw new SAMLException(SAMLUtils.displayXML(samlresponse.getStatus().toString()));
            }
        }
        catch (Exception e) {
            if (SystemConfigurationUtil.isServerMode()) {
                data = new String[]{SAMLUtils.bundle.getString("errorSAMLStatusCode")};
                LogUtils.error(Level.INFO, "ERROR_RESPONSE_STATUS", data);
            }
            throw new SAMLException(e.getMessage());
        }
        List asserts = new ArrayList();
        asserts = SAMLClient.getAssertionList(samlresponse, al);
        return asserts;
    }
}

