/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.assertion.AssertionBase;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AdviceBase {
    protected List _assertionIDRef = null;
    protected List _assertion = null;
    protected List _otherElements = null;

    public AdviceBase(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtilsCommon.debug.message("Advice: null input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("Advice")) {
            SAMLUtilsCommon.debug.message("Advice: wrong input");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        NodeList nodes = element.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount > 0) {
            for (int i = 0; i < nodeCount; ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeType() != 1) continue;
                String tagName = currentNode.getLocalName();
                String tagNS = currentNode.getNamespaceURI();
                if (tagName == null || tagName.length() == 0 || tagNS == null || tagNS.length() == 0) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Advice: The tag name or tag namespace of child element is either null or empty.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
                }
                if (tagName.equals("AssertionIDReference") && tagNS.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    AssertionIDReference assertionid = this.createAssertionIDReference((Element)currentNode);
                    if (this._assertionIDRef == null) {
                        this._assertionIDRef = new ArrayList();
                    }
                    if (this._assertionIDRef.add(assertionid)) continue;
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Advice:failed to add to AssertionIDReference List.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("addListError"));
                }
                if (tagName.equals("Assertion") && tagNS.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    AssertionBase assertion = this.createAssertion((Element)currentNode);
                    if (this._assertion == null) {
                        this._assertion = new ArrayList();
                    }
                    if (this._assertion.add(assertion)) continue;
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Advice:failed to add to Assertion List.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("addListError"));
                }
                if (this._otherElements == null) {
                    this._otherElements = new ArrayList();
                }
                if (this._otherElements.add((Element)currentNode)) continue;
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Advice: failed to add to other elements list.");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("addListError"));
            }
        }
    }

    public AdviceBase(List assertionidreference, List assertion, List otherelement) {
        if (assertionidreference != null && !assertionidreference.isEmpty()) {
            if (this._assertionIDRef == null) {
                this._assertionIDRef = new ArrayList();
            }
            this._assertionIDRef = assertionidreference;
        }
        if (assertion != null && !assertion.isEmpty()) {
            if (this._assertion == null) {
                this._assertion = new ArrayList();
            }
            this._assertion = assertion;
        }
        if (otherelement != null) {
            if (this._otherElements == null) {
                this._otherElements = new ArrayList();
            }
            this._otherElements = otherelement;
        }
    }

    protected abstract AssertionBase createAssertion(Element var1) throws SAMLException;

    protected abstract AssertionIDReference createAssertionIDReference(Element var1) throws SAMLException;

    public List getAssertionIDReference() {
        return this._assertionIDRef;
    }

    public List getAssertion() {
        return this._assertion;
    }

    public List getOtherElement() {
        return this._otherElements;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer result = new StringBuffer(1000);
        Iterator iter = null;
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        result.append("<").append(prefix).append("Advice").append(uri).append(">\n");
        if (this._assertionIDRef != null && !this._assertionIDRef.isEmpty()) {
            iter = this._assertionIDRef.iterator();
            while (iter.hasNext()) {
                result.append(((AssertionIDReference)iter.next()).toString(includeNS, false));
            }
        }
        if (this._assertion != null && !this._assertion.isEmpty()) {
            iter = this._assertion.iterator();
            while (iter.hasNext()) {
                result.append(((AssertionBase)iter.next()).toString(includeNS, false));
            }
        }
        if (this._otherElements != null && !this._otherElements.isEmpty()) {
            iter = this._otherElements.iterator();
            while (iter.hasNext()) {
                result.append(XMLUtils.print((Node)((Element)iter.next())));
            }
        }
        result.append("</").append(prefix).append("Advice>\n");
        return result.toString();
    }
}

