/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.servlet;

import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.common.LogUtils;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.shared.encode.Base64;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SAMLPOSTProfileServlet
extends HttpServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String[] data;
        if (request == null || response == null) {
            String[] data2 = new String[]{SAMLUtils.bundle.getString("nullInputParameter")};
            LogUtils.error(Level.INFO, "NULL_PARAMETER", data2);
            response.sendError(500, SAMLUtils.bundle.getString("nullInputParameter"));
            return;
        }
        SAMLUtils.checkHTTPContentLength(request);
        Object token = this.getSession(request);
        if (token == null) {
            response.sendRedirect(SAMLUtils.getLoginRedirectURL(request));
            return;
        }
        String target = request.getParameter("TARGET");
        if (target == null || target.length() == 0) {
            String[] data3 = new String[]{SAMLUtils.bundle.getString("missingTargetSite")};
            LogUtils.error(Level.INFO, "MISSING_TARGET", data3, token);
            response.sendError(400, SAMLUtils.bundle.getString("missingTargetSite"));
            return;
        }
        SAMLServiceManager.SiteEntry destSite = this.getDestSite(target);
        String destSiteUrl = null;
        if (destSite == null || (destSiteUrl = destSite.getPOSTUrl()) == null) {
            String[] data4 = new String[]{SAMLUtils.bundle.getString("targetForbidden"), target};
            LogUtils.error(Level.INFO, "TARGET_FORBIDDEN", data4, token);
            response.sendError(400, SAMLUtils.bundle.getString("targetForbidden") + " " + target);
            return;
        }
        Response samlResponse = null;
        try {
            StringTokenizer st;
            String version = destSite.getVersion();
            int majorVersion = 1;
            int minorVersion = SAMLConstants.PROTOCOL_MINOR_VERSION;
            if (version != null && (st = new StringTokenizer(version, ".")).countTokens() == 2) {
                majorVersion = Integer.parseInt(st.nextToken().trim());
                minorVersion = Integer.parseInt(st.nextToken().trim());
            }
            AssertionManager am = AssertionManager.getInstance();
            SessionProvider sessionProvider = SessionManager.getProvider();
            Assertion assertion = am.createSSOAssertion(sessionProvider.getSessionID(token), null, destSite.getSourceID(), target, majorVersion + "." + minorVersion);
            StatusCode statusCode = new StatusCode("samlp:Success");
            Status status = new Status(statusCode);
            ArrayList<Assertion> contents = new ArrayList<Assertion>();
            contents.add(assertion);
            samlResponse = new Response(null, status, destSiteUrl, contents);
            samlResponse.setMajorVersion(majorVersion);
            samlResponse.setMinorVersion(minorVersion);
        }
        catch (SessionException sse) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.doGet: Exception Couldn't get SessionProvider:", (Throwable)((Object)sse));
            response.sendError(500, sse.getMessage());
            return;
        }
        catch (NumberFormatException ne) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.doGet: Exception when creating Response: ", (Throwable)ne);
            response.sendError(500, ne.getMessage());
            return;
        }
        catch (SAMLException se) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.doGet: Exception when creating Response: ", (Throwable)((Object)se));
            response.sendError(500, se.getMessage());
            return;
        }
        byte[] signedBytes = null;
        try {
            samlResponse.signXML();
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLPOSTProfileServlet.doGet: signed samlResponse is" + samlResponse.toString(true, true, true));
            }
            signedBytes = SAMLUtils.getResponseBytes(samlResponse);
        }
        catch (Exception e) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.doGet: Exception when signing the response:", (Throwable)e);
            response.sendError(500, SAMLUtils.bundle.getString("errorSigningResponse"));
            return;
        }
        String encodedResponse = null;
        try {
            encodedResponse = Base64.encode((byte[])signedBytes, (int)76).trim();
        }
        catch (Exception e) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.doGet: Exception when encoding the response:", (Throwable)e);
            response.sendError(500, SAMLUtils.bundle.getString("errorEncodeResponse"));
            return;
        }
        if (LogUtils.isAccessLoggable(Level.FINE)) {
            data = new String[]{SAMLUtils.bundle.getString("redirectTo"), target, destSiteUrl, new String(signedBytes, "UTF-8")};
            LogUtils.access(Level.FINE, "REDIRECT_TO_URL", data, token);
        } else {
            data = new String[]{SAMLUtils.bundle.getString("redirectTo"), target, destSiteUrl};
            LogUtils.access(Level.INFO, "REDIRECT_TO_URL", data, token);
        }
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<HTML>");
        out.println("<BODY Onload=\"document.forms[0].submit()\">");
        out.println("<FORM METHOD=\"POST\" ACTION=\"" + destSiteUrl + "\">");
        out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"SAMLResponse\" ");
        out.println("VALUE=\"" + encodedResponse + "\">");
        out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"TARGET\" VALUE=\"" + target + "\"> </FORM>");
        out.println("</BODY></HTML>");
        out.close();
    }

    private SAMLServiceManager.SiteEntry getDestSite(String target) {
        SAMLServiceManager.SiteEntry destSite = null;
        try {
            URL targetUrl = new URL(target);
            String targetHost = targetUrl.getHost();
            int targetPort = targetUrl.getPort();
            if (targetHost == null) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.getDestSite: missing host in target.");
                return null;
            }
            SAMLServiceManager.SiteEntry serverSite = null;
            Iterator iter = ((Set)SAMLServiceManager.getAttribute("iplanet-am-saml-trusted-server-list")).iterator();
            String serverHost = null;
            int serverPort = -1;
            while (iter.hasNext()) {
                serverSite = (SAMLServiceManager.SiteEntry)iter.next();
                serverHost = serverSite.getHostName();
                serverPort = serverSite.getPort();
                if (serverHost == null || targetHost.indexOf(serverHost) == -1) continue;
                if (serverPort != -1) {
                    if (serverPort != targetPort) continue;
                    destSite = serverSite;
                    break;
                }
                destSite = serverSite;
            }
            if (destSite == null) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.getDestSite:  No destSite found from the target.");
                return null;
            }
        }
        catch (Exception e) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.getDestSite: ", (Throwable)e);
            return null;
        }
        return destSite;
    }

    private Object getSession(HttpServletRequest request) {
        Object token = null;
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            token = sessionProvider.getSession(request);
            if (token == null) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.getSession: Session is null.");
                return null;
            }
            if (!sessionProvider.isValid(token)) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.getSession: Session is invalid.");
                return null;
            }
        }
        catch (SessionException se) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.getSession: Exception when getting Session:", (Throwable)((Object)se));
            return null;
        }
        return token;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String[] data;
        boolean valid;
        response.setContentType("text/html; charset=UTF-8");
        if (request == null || response == null) {
            String[] data2 = new String[]{SAMLUtils.bundle.getString("nullInputParameter")};
            LogUtils.error(Level.INFO, "NULL_PARAMETER", data2);
            response.sendError(400, SAMLUtils.bundle.getString("nullInputParameter"));
            return;
        }
        SAMLUtils.checkHTTPContentLength(request);
        String target = request.getParameter("TARGET");
        if (target == null || target.length() == 0) {
            String[] data3 = new String[]{SAMLUtils.bundle.getString("missingTargetSite")};
            LogUtils.error(Level.INFO, "MISSING_TARGET", data3);
            response.sendError(400, SAMLUtils.bundle.getString("missingTargetSite"));
            return;
        }
        String samlResponse = request.getParameter("SAMLResponse");
        if (samlResponse == null) {
            String[] data4 = new String[]{SAMLUtils.bundle.getString("missingSAMLResponse")};
            LogUtils.error(Level.INFO, "MISSING_RESPONSE", data4);
            response.sendError(400, SAMLUtils.bundle.getString("missingSAMLResponse"));
            return;
        }
        byte[] raw = null;
        try {
            raw = Base64.decode((String)samlResponse);
        }
        catch (Exception e) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.doPost: Exception when decoding SAMLResponse:", (Throwable)e);
            response.sendError(500, SAMLUtils.bundle.getString("errorDecodeResponse"));
            return;
        }
        Response sResponse = SAMLUtils.getResponse(raw);
        if (sResponse == null) {
            String[] data5 = new String[]{SAMLUtils.bundle.getString("errorObtainResponse")};
            LogUtils.error(Level.INFO, "RESPONSE_MESSAGE_ERROR", data5);
            response.sendError(400, SAMLUtils.bundle.getString("errorObtainResponse"));
            return;
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("SAMLPOSTProfileServlet.doPost: Received " + sResponse.toString());
        }
        StringBuffer requestUrl = request.getRequestURL();
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("SAMLPOSTProfileServlet.doPost: requestUrl=" + requestUrl);
        }
        if (!(valid = SAMLUtils.verifyResponse(sResponse, requestUrl.toString(), request))) {
            String[] data6 = new String[]{SAMLUtils.bundle.getString("invalidResponse")};
            LogUtils.error(Level.INFO, "INVALID_RESPONSE", data6);
            response.sendError(400, SAMLUtils.bundle.getString("invalidResponse"));
            return;
        }
        Map attrMap = null;
        List assertions = null;
        Object authSubject = null;
        try {
            Map sessionAttr = SAMLUtils.processResponse(sResponse, target);
            Object token = SAMLUtils.generateSession(request, response, sessionAttr);
        }
        catch (Exception ex) {
            SAMLUtils.debug.error("generateSession: ", (Throwable)ex);
            String[] data7 = new String[]{SAMLUtils.bundle.getString("failedCreateSSOToken")};
            LogUtils.error(Level.INFO, "FAILED_TO_CREATE_SSO_TOKEN", data7);
            response.sendError(500, ex.getMessage());
            return;
        }
        if (LogUtils.isAccessLoggable(Level.FINE)) {
            data = new String[]{SAMLUtils.bundle.getString("accessGranted"), new String(raw, "UTF-8")};
            LogUtils.access(Level.FINE, "ACCESS_GRANTED", data);
        } else {
            data = new String[]{SAMLUtils.bundle.getString("accessGranted")};
            LogUtils.access(Level.INFO, "ACCESS_GRANTED", data);
        }
        if (SAMLUtils.postYN(target)) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("POST to target:" + target);
            }
            SAMLUtils.postToTarget(response, assertions, target, attrMap);
        } else {
            response.setHeader("Location", target);
            response.sendRedirect(target);
        }
    }
}

