/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Attribute;
import com.sun.identity.saml2.assertion.AttributeStatement;
import com.sun.identity.saml2.assertion.EncryptedAttribute;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeStatementImpl
implements AttributeStatement {
    private List attrs = null;
    private List encAttrs = null;
    private boolean mutable = true;

    private void validateData() throws SAML2Exception {
        if ((this.attrs == null || this.attrs.isEmpty()) && (this.encAttrs == null || this.encAttrs.isEmpty())) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AttributeStatementImpl.validateData: missing Attribute or EncryptedAttribute element.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingElement"));
        }
    }

    private void parseElement(Element element) throws SAML2Exception {
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AttributeStatementImpl.parseElement: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        if (!SAML2SDKUtils.checkStatement(element, "AttributeStatement")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AttributeStatementImpl.parseElement: not AttributeStatement.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("Attribute")) {
                Attribute attr = AssertionFactory.getInstance().createAttribute((Element)child);
                if (this.attrs == null) {
                    this.attrs = new ArrayList();
                }
                this.attrs.add(attr);
                continue;
            }
            if (childName.equals("EncryptedAttribute")) {
                EncryptedAttribute encAttr = AssertionFactory.getInstance().createEncryptedAttribute((Element)child);
                if (this.encAttrs == null) {
                    this.encAttrs = new ArrayList();
                }
                this.encAttrs.add(encAttr);
                continue;
            }
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AttributeStatementImpl.parse Element: Invalid element:" + childName);
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidElement"));
        }
        this.validateData();
        if (this.attrs != null) {
            this.attrs = Collections.unmodifiableList(this.attrs);
        }
        if (this.encAttrs != null) {
            this.encAttrs = Collections.unmodifiableList(this.encAttrs);
        }
        this.mutable = false;
    }

    public AttributeStatementImpl() {
    }

    public AttributeStatementImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public AttributeStatementImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2SDKUtils.debug);
        if (doc == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(doc.getDocumentElement());
    }

    public List getAttribute() {
        return this.attrs;
    }

    public void setAttribute(List value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.attrs = value;
    }

    public List getEncryptedAttribute() {
        return this.encAttrs;
    }

    public void setEncryptedAttribute(List value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.encAttrs = value;
    }

    public void makeImmutable() {
        if (this.mutable) {
            if (this.attrs != null) {
                Iterator iter = this.attrs.iterator();
                while (iter.hasNext()) {
                    Attribute attr = (Attribute)iter.next();
                    attr.makeImmutable();
                }
                this.attrs = Collections.unmodifiableList(this.attrs);
            }
            if (this.encAttrs != null) {
                this.encAttrs = Collections.unmodifiableList(this.encAttrs);
            }
            this.mutable = false;
        }
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws SAML2Exception {
        this.validateData();
        StringBuffer result = new StringBuffer(1000);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        result.append("<").append(prefix).append("AttributeStatement").append(uri).append(">");
        if (this.attrs != null) {
            Iterator iter = this.attrs.iterator();
            while (iter.hasNext()) {
                result.append(((Attribute)iter.next()).toXMLString(includeNS, declareNS));
            }
        }
        if (this.encAttrs != null) {
            Iterator iter1 = this.encAttrs.iterator();
            while (iter1.hasNext()) {
                result.append(((EncryptedAttribute)iter1.next()).toXMLString(includeNS, declareNS));
            }
        }
        result.append("</").append(prefix).append("AttributeStatement>");
        return result.toString();
    }
}

