/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Attribute;
import com.sun.identity.saml2.assertion.EncryptedAttribute;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.xmlenc.EncManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.security.Key;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptedAttributeImpl
implements EncryptedAttribute {
    private String xmlString = null;

    private void parseElement(Element element) throws SAML2Exception {
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("EncryptedAttributeImpl.parseElement: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("EncryptedAttribute")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("EncryptedAttributeImpl.parseElement: not EncryptedAttribute.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
    }

    public EncryptedAttributeImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
        this.xmlString = XMLUtils.print((Node)element);
    }

    public EncryptedAttributeImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2SDKUtils.debug);
        if (doc == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(doc.getDocumentElement());
        this.xmlString = xmlString;
    }

    public Attribute decrypt(Key recipientPrivateKey) throws SAML2Exception {
        Element el = EncManager.getEncInstance().decrypt(this.xmlString, recipientPrivateKey);
        return AssertionFactory.getInstance().createAttribute(el);
    }

    public String toXMLString() throws SAML2Exception {
        return this.xmlString;
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws SAML2Exception {
        return this.xmlString;
    }
}

