/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.common;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustDescriptor;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.plugin.datastore.DataStoreProviderManager;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Attribute;
import com.sun.identity.saml2.assertion.AudienceRestriction;
import com.sun.identity.saml2.assertion.AuthnStatement;
import com.sun.identity.saml2.assertion.Conditions;
import com.sun.identity.saml2.assertion.EncryptedAssertion;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.assertion.Subject;
import com.sun.identity.saml2.assertion.SubjectConfirmation;
import com.sun.identity.saml2.assertion.SubjectConfirmationData;
import com.sun.identity.saml2.common.AccountUtils;
import com.sun.identity.saml2.common.NameIDInfo;
import com.sun.identity.saml2.common.NameIDInfoKey;
import com.sun.identity.saml2.common.QuerySignatureUtil;
import com.sun.identity.saml2.common.SAML2ConfigService;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.XACMLAuthzDecisionQueryConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.XACMLPDPConfigElement;
import com.sun.identity.saml2.jaxb.metadata.AffiliationDescriptorType;
import com.sun.identity.saml2.jaxb.metadata.AssertionConsumerServiceElement;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.logging.LogUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.plugins.DefaultSPAuthnContextMapper;
import com.sun.identity.saml2.plugins.IDPAccountMapper;
import com.sun.identity.saml2.plugins.JMQSAML2Repository;
import com.sun.identity.saml2.plugins.SAML2IDPFinder;
import com.sun.identity.saml2.plugins.SAML2ServiceProviderAdapter;
import com.sun.identity.saml2.plugins.SPAccountMapper;
import com.sun.identity.saml2.plugins.SPAuthnContextMapper;
import com.sun.identity.saml2.profile.AuthnRequestInfo;
import com.sun.identity.saml2.profile.CacheCleanUpScheduler;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.profile.SPCache;
import com.sun.identity.saml2.protocol.AuthnRequest;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.RequestAbstract;
import com.sun.identity.saml2.protocol.RequestedAuthnContext;
import com.sun.identity.saml2.protocol.Response;
import com.sun.identity.saml2.protocol.Status;
import com.sun.identity.saml2.protocol.StatusCode;
import com.sun.identity.security.cert.CRLValidator;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAML2Utils
extends SAML2SDKUtils {
    private static SAML2MetaManager saml2MetaManager;
    private static CircleOfTrustManager cotManager;
    private static KeyProvider keyProvider;
    private static String server_protocol;
    private static String server_host;
    private static String server_port;
    private static String server_uri;
    private static String localURL;
    private static int int_server_port;
    public static SOAPConnectionFactory scf;
    private static String bufferLen;
    private static boolean checkCertStatus;
    private static boolean checkCAStatus;
    public static boolean failOver;
    public static JMQSAML2Repository jmq;
    public static MessageFactory mf;
    static AssertionFactory af;
    private static SecureRandom randomGenerator;

    public static Map verifyResponse(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Response response, String orgName, String hostEntityId, String profileBinding) throws SAML2Exception {
        boolean needAssertionSigned;
        Status status;
        String method = "SAML2Utils.verifyResponse:";
        if (response == null || orgName == null || orgName.length() == 0) {
            if (debug.messageEnabled()) {
                debug.message(method + "response or orgName is null.");
            }
            throw new SAML2Exception(bundle.getString("nullInput"));
        }
        String respID = response.getID();
        AuthnRequestInfo reqInfo = null;
        String inRespToResp = response.getInResponseTo();
        if (inRespToResp != null && inRespToResp.length() != 0 && (reqInfo = (AuthnRequestInfo)SPCache.requestHash.get((Object)inRespToResp)) == null) {
            if (debug.messageEnabled()) {
                debug.message(method + "InResponseTo attribute in Response" + " is invalid: " + inRespToResp);
            }
            String[] data = new String[]{respID};
            LogUtil.error(Level.INFO, "INVALID_INRESPONSETO_RESPONSE", data, null);
            throw new SAML2Exception(bundle.getString("invalidInResponseToInResponse"));
        }
        SAML2ServiceProviderAdapter spAdapter = SAML2Utils.getSPAdapterClass(hostEntityId, orgName);
        if (spAdapter != null) {
            AuthnRequest authnRequest = null;
            if (reqInfo != null) {
                authnRequest = reqInfo.getAuthnRequest();
            }
            spAdapter.preSingleSignOnProcess(hostEntityId, orgName, httpRequest, httpResponse, authnRequest, response, profileBinding);
        }
        String idpEntityId = null;
        Issuer respIssuer = response.getIssuer();
        if (respIssuer != null) {
            if (!SAML2Utils.isSourceSiteValid(respIssuer, orgName, hostEntityId)) {
                if (debug.messageEnabled()) {
                    debug.message(method + "Issuer in Response is not valid.");
                }
                String[] data = new String[]{hostEntityId, orgName, respID};
                LogUtil.error(Level.INFO, "INVALID_ISSUER_RESPONSE", data, null);
                throw new SAML2Exception(bundle.getString("invalidIssuerInResponse"));
            }
            idpEntityId = respIssuer.getValue();
        }
        if ((status = response.getStatus()) == null || !status.getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
            String statusCode;
            String string = statusCode = status == null ? "" : status.getStatusCode().getValue();
            if (debug.messageEnabled()) {
                debug.message(method + "Response's status code is not success." + statusCode);
            }
            String[] data = new String[]{respID, ""};
            if (LogUtil.isErrorLoggable(Level.FINE)) {
                data[1] = statusCode;
            }
            LogUtil.error(Level.INFO, "WRONG_STATUS_CODE", data, null);
            throw new SAML2Exception(bundle.getString("invalidStatusCodeInResponse"));
        }
        if (saml2MetaManager == null) {
            throw new SAML2Exception(bundle.getString("nullMetaManager"));
        }
        SPSSOConfigElement spConfig = null;
        SPSSODescriptorElement spDesc = null;
        spConfig = saml2MetaManager.getSPSSOConfig(orgName, hostEntityId);
        spDesc = saml2MetaManager.getSPSSODescriptor(orgName, hostEntityId);
        boolean needAssertionEncrypted = false;
        String assertionEncryptedAttr = SAML2Utils.getAttributeValueFromSPSSOConfig(spConfig, "wantAssertionEncrypted");
        if (assertionEncryptedAttr != null && assertionEncryptedAttr.equals("true")) {
            needAssertionEncrypted = true;
        }
        boolean bl = needAssertionSigned = profileBinding != null && profileBinding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        if (!needAssertionSigned) {
            needAssertionSigned = spDesc.isWantAssertionsSigned();
        }
        ArrayList<Assertion> assertions = response.getAssertion();
        if (needAssertionEncrypted && assertions != null && assertions.size() != 0) {
            String[] data = new String[]{respID};
            LogUtil.error(Level.INFO, "ASSERTION_NOT_ENCRYPTED", data, null);
            throw new SAML2Exception(bundle.getString("assertionNotEncrypted"));
        }
        PrivateKey decryptionKey = null;
        List encAssertions = response.getEncryptedAssertion();
        if (encAssertions != null) {
            Iterator encIter = encAssertions.iterator();
            while (encIter.hasNext()) {
                if (decryptionKey == null) {
                    decryptionKey = KeyUtil.getDecryptionKey(spConfig);
                }
                Assertion assertion = ((EncryptedAssertion)encIter.next()).decrypt(decryptionKey);
                if (assertions == null) {
                    assertions = new ArrayList<Assertion>();
                }
                assertions.add(assertion);
            }
        }
        if (assertions == null || assertions.size() == 0) {
            if (debug.messageEnabled()) {
                debug.message(method + "no assertion in the Response.");
            }
            String[] data = new String[]{respID};
            LogUtil.error(Level.INFO, "MISSING_ASSERTION", data, null);
            throw new SAML2Exception(bundle.getString("missingAssertion"));
        }
        Map smap = null;
        IDPSSODescriptorElement idp = null;
        X509Certificate cert = null;
        Iterator assertionIter = assertions.iterator();
        while (assertionIter.hasNext()) {
            List subjectConfirms;
            Subject subject;
            List authnStmts;
            String[] data;
            Assertion assertion = (Assertion)assertionIter.next();
            String assertionID = assertion.getID();
            Issuer issuer = assertion.getIssuer();
            if (!SAML2Utils.isSourceSiteValid(issuer, orgName, hostEntityId)) {
                debug.error("assertion's source site is not valid.");
                data = new String[]{assertionID};
                LogUtil.error(Level.INFO, "INVALID_ISSUER_ASSERTION", data, null);
                throw new SAML2Exception(bundle.getString("invalidIssuerInAssertion"));
            }
            if (idpEntityId == null) {
                idpEntityId = issuer.getValue();
            } else if (!idpEntityId.equals(issuer.getValue())) {
                if (debug.messageEnabled()) {
                    debug.message(method + "Issuer in Assertion doesn't " + "match the Issuer in Response or other " + "Assertions in the Response.");
                }
                data = new String[]{assertionID};
                LogUtil.error(Level.INFO, "MISMATCH_ISSUER_ASSERTION", data, null);
                throw new SAML2Exception(bundle.getString("mismatchIssuer"));
            }
            if (needAssertionSigned) {
                if (cert == null) {
                    idp = saml2MetaManager.getIDPSSODescriptor(orgName, idpEntityId);
                    cert = KeyUtil.getVerificationCert(idp, idpEntityId, "IDPRole");
                }
                if (!assertion.isSigned() || !assertion.isSignatureValid(cert)) {
                    debug.error(method + "Assertion is not signed or signature is not valid.");
                    data = new String[]{assertionID};
                    LogUtil.error(Level.INFO, "INVALID_SIGNATURE_ASSERTION", data, null);
                    throw new SAML2Exception(bundle.getString("invalidSignatureOnAssertion"));
                }
            }
            if ((authnStmts = assertion.getAuthnStatements()) == null || authnStmts.isEmpty() || (subject = assertion.getSubject()) == null || (subjectConfirms = subject.getSubjectConfirmation()) == null || subjectConfirms.isEmpty() || !SAML2Utils.isBearerSubjectConfirmation(subjectConfirms, inRespToResp, spDesc, spConfig, assertionID)) continue;
            SAML2Utils.checkAudience(assertion.getConditions(), hostEntityId, assertionID);
            if (smap != null) continue;
            smap = SAML2Utils.fillMap(authnStmts, subject, assertion, assertions, reqInfo, inRespToResp, orgName, hostEntityId, idpEntityId, spConfig);
        }
        if (smap == null) {
            debug.error("No Authentication Assertion in Response.");
            throw new SAML2Exception(bundle.getString("missingAuthnAssertion"));
        }
        return smap;
    }

    private static boolean isBearerSubjectConfirmation(List subjectConfirms, String inRespToResponse, SPSSODescriptorElement spDesc, SPSSOConfigElement spConfig, String assertionID) throws SAML2Exception {
        String method = "SAML2Utils.isBearerSubjectConfirmation:";
        boolean hasBearer = false;
        Iterator it = subjectConfirms.iterator();
        while (it.hasNext()) {
            Date notOnOrAfter;
            SubjectConfirmation subjectConfirm = (SubjectConfirmation)it.next();
            if (subjectConfirm == null || subjectConfirm.getMethod() == null || !subjectConfirm.getMethod().equals("urn:oasis:names:tc:SAML:2.0:cm:bearer")) continue;
            SubjectConfirmationData subjectConfData = subjectConfirm.getSubjectConfirmationData();
            if (subjectConfData == null) {
                if (debug.messageEnabled()) {
                    debug.message(method + "missing SubjectConfirmationData.");
                }
                String[] data = new String[]{assertionID};
                LogUtil.error(Level.INFO, "MISSING_SUBJECT_COMFIRMATION_DATA", data, null);
                throw new SAML2Exception(bundle.getString("missingSubjectConfirmationData"));
            }
            String recipient = subjectConfData.getRecipient();
            if (recipient == null || recipient.length() == 0) {
                if (debug.messageEnabled()) {
                    debug.message(method + "missing Recipient in Assertion.");
                }
                String[] data = new String[]{assertionID};
                LogUtil.error(Level.INFO, "MISSING_RECIPIENT", data, null);
                throw new SAML2Exception(bundle.getString("missingRecipient"));
            }
            boolean foundMatch = false;
            Iterator acsIter = spDesc.getAssertionConsumerService().iterator();
            while (acsIter.hasNext()) {
                AssertionConsumerServiceElement acs = (AssertionConsumerServiceElement)acsIter.next();
                if (!recipient.equals(acs.getLocation())) continue;
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                if (debug.messageEnabled()) {
                    debug.message(method + "this sp is not the intended " + "recipient.");
                }
                String[] data = new String[]{assertionID, recipient};
                LogUtil.error(Level.INFO, "WRONG_RECIPIENT", data, null);
                throw new SAML2Exception(bundle.getString("wrongRecipient"));
            }
            int timeskew = 300;
            String timeskewStr = SAML2Utils.getAttributeValueFromSPSSOConfig(spConfig, "assertionTimeSkew");
            if (timeskewStr != null && timeskewStr.trim().length() > 0 && (timeskew = Integer.parseInt(timeskewStr)) < 0) {
                timeskew = 300;
            }
            if (debug.messageEnabled()) {
                debug.message(method + "timeskew = " + timeskew);
            }
            if ((notOnOrAfter = subjectConfData.getNotOnOrAfter()) == null || notOnOrAfter.getTime() + (long)(timeskew * 1000) < System.currentTimeMillis()) {
                if (debug.messageEnabled()) {
                    debug.message(method + "Time in SubjectConfirmationData of " + "Assertion:" + assertionID + " is invalid.");
                }
                String[] data = new String[]{assertionID};
                LogUtil.error(Level.INFO, "INVALID_TIME_SUBJECT_CONFIRMATION_DATA", data, null);
                throw new SAML2Exception(bundle.getString("invalidTimeOnSubjectConfirmationData"));
            }
            if (subjectConfData.getNotBefore() != null) {
                if (debug.messageEnabled()) {
                    debug.message(method + "SubjectConfirmationData included " + "NotBefore.");
                }
                String[] data = new String[]{assertionID};
                LogUtil.error(Level.INFO, "CONTAINED_NOT_BEFORE", data, null);
                throw new SAML2Exception(bundle.getString("containedNotBefore"));
            }
            String inRespTo = subjectConfData.getInResponseTo();
            if (inRespTo != null && inRespTo.length() != 0) {
                if (!inRespTo.equals(inRespToResponse)) {
                    if (debug.messageEnabled()) {
                        debug.message(method + "InResponseTo in Assertion is " + "different from the one in Response.");
                    }
                    String[] data = new String[]{assertionID};
                    LogUtil.error(Level.INFO, "WRONG_INRESPONSETO_ASSERTION", data, null);
                    throw new SAML2Exception(bundle.getString("wrongInResponseToInAssertion"));
                }
            } else if (inRespToResponse != null && inRespToResponse.length() != 0) {
                if (debug.messageEnabled()) {
                    debug.message(method + "Assertion doesn't contain " + "InResponseTo, but Response does.");
                }
                String[] data = new String[]{assertionID};
                LogUtil.error(Level.INFO, "WRONG_INRESPONSETO_ASSERTION", data, null);
                throw new SAML2Exception(bundle.getString("wrongInResponseToInAssertion"));
            }
            hasBearer = true;
            break;
        }
        return hasBearer;
    }

    private static void checkAudience(Conditions conds, String hostEntityId, String assertionID) throws SAML2Exception {
        String method = "SAML2Utils.checkAudience:";
        if (conds == null) {
            if (debug.messageEnabled()) {
                debug.message(method + "Conditions is missing from Assertion.");
            }
            String[] data = new String[]{assertionID};
            LogUtil.error(Level.INFO, "MISSING_CONDITIONS", data, null);
            throw new SAML2Exception(bundle.getString("missingConditions"));
        }
        List restrictions = conds.getAudienceRestrictions();
        if (restrictions == null) {
            if (debug.messageEnabled()) {
                debug.message(method + "missing AudienceRestriction.");
            }
            String[] data = new String[]{assertionID};
            LogUtil.error(Level.INFO, "MISSING_AUDIENCE_RESTRICTION", data, null);
            throw new SAML2Exception(bundle.getString("missingAudienceRestriction"));
        }
        Iterator restIter = restrictions.iterator();
        boolean found = false;
        while (restIter.hasNext()) {
            List audienceList = ((AudienceRestriction)restIter.next()).getAudience();
            if (!audienceList.contains(hostEntityId)) continue;
            found = true;
            break;
        }
        if (!found) {
            if (debug.messageEnabled()) {
                debug.message(method + "This SP is not the intended audience.");
            }
            String[] data = new String[]{assertionID};
            LogUtil.error(Level.INFO, "WRONG_AUDIENCE", data, null);
            throw new SAML2Exception(bundle.getString("audienceNotMatch"));
        }
    }

    private static Map fillMap(List authnStmts, Subject subject, Assertion assertion, List assertions, AuthnRequestInfo reqInfo, String inRespToResp, String orgName, String hostEntityId, String idpEntityId, SPSSOConfigElement spConfig) throws SAML2Exception {
        long maxSessionTime;
        AuthnStatement authnStmt = (AuthnStatement)authnStmts.get(0);
        int authLevel = -1;
        String mapperClass = SAML2Utils.getAttributeValueFromSPSSOConfig(spConfig, "spAuthncontextMapper");
        SPAuthnContextMapper mapper = SAML2Utils.getSPAuthnContextMapper(orgName, hostEntityId, mapperClass);
        RequestedAuthnContext reqContext = null;
        AuthnRequest authnRequest = null;
        if (reqInfo != null) {
            reqContext = reqInfo.getAuthnRequest().getRequestedAuthnContext();
            authnRequest = reqInfo.getAuthnRequest();
        }
        authLevel = mapper.getAuthLevel(reqContext, authnStmt.getAuthnContext(), orgName, hostEntityId, idpEntityId);
        String sessionIndex = authnStmt.getSessionIndex();
        Date sessionNotOnOrAfter = authnStmt.getSessionNotOnOrAfter();
        HashMap<String, Object> smap = new HashMap<String, Object>();
        smap.put("Subject", subject);
        smap.put("assertion", assertion);
        smap.put("assertions", assertions);
        if (authnRequest != null) {
            smap.put("AuthnRequest", authnRequest);
        }
        String[] data = new String[]{assertion.getID(), "", ""};
        if (LogUtil.isAccessLoggable(Level.FINE)) {
            data[1] = subject.toXMLString();
        }
        if (sessionIndex != null && sessionIndex.length() != 0) {
            data[2] = sessionIndex;
            smap.put("SessionIndex", sessionIndex);
        }
        if (authLevel >= 0) {
            smap.put("AuthLevel", new Integer(authLevel));
        }
        if (sessionNotOnOrAfter != null && (maxSessionTime = (sessionNotOnOrAfter.getTime() - System.currentTimeMillis()) / 60000L) > 0L) {
            smap.put("maxSessionTime", new Long(maxSessionTime));
        }
        if (inRespToResp != null && inRespToResp.length() != 0) {
            smap.put("inResponseTo", inRespToResp);
        }
        if (debug.messageEnabled()) {
            debug.message("SAML2Utils.fillMap: Found valid authentication assertion.");
        }
        LogUtil.access(Level.INFO, "FOUND_AUTHN_ASSERTION", data, null);
        return smap;
    }

    public static String getAttributeValueFromSPSSOConfig(SPSSOConfigElement config, String attrName) {
        String result = null;
        if (config == null) {
            return null;
        }
        Map attrs = SAML2MetaUtils.getAttributes(config);
        List value = (List)attrs.get(attrName);
        if (value != null && value.size() != 0) {
            result = ((String)value.iterator().next()).trim();
        }
        return result;
    }

    public static List getStrAssertions(List assertions) {
        ArrayList<String> returnAssertions = new ArrayList<String>();
        if (assertions != null) {
            Iterator it = assertions.iterator();
            while (it.hasNext()) {
                Assertion assertion = (Assertion)it.next();
                try {
                    returnAssertions.add(assertion.toXMLString(true, true));
                }
                catch (SAML2Exception e) {
                    debug.error("Invalid assertion: " + assertion);
                }
            }
        }
        return returnAssertions;
    }

    public static boolean isPersistentNameID(NameID nameId) {
        boolean isPersistent = false;
        if (nameId == null) {
            return isPersistent;
        }
        String id = nameId.getFormat();
        if (id != null && (id.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent") || id.equalsIgnoreCase("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"))) {
            isPersistent = true;
        }
        if (debug.messageEnabled()) {
            debug.message("SAML2Utils:isPersistent : " + isPersistent);
        }
        return isPersistent;
    }

    public static boolean isFedInfoExists(String userName, String hostEntityID, String remoteEntityId, NameID nameID) {
        boolean exists = false;
        if (userName == null || hostEntityID == null || remoteEntityId == null || nameID == null) {
            return exists;
        }
        try {
            NameIDInfo info = AccountUtils.getAccountFederation(userName, hostEntityID, remoteEntityId);
            if (info != null && info.getNameIDValue().equals(nameID.getValue())) {
                exists = true;
            }
        }
        catch (SAML2Exception se) {
            debug.error("Failed to get DataStoreProvider " + se.toString());
            if (debug.messageEnabled()) {
                debug.message("SAML2Utils:isFedInfoExists:Stack : ", (Throwable)((Object)se));
            }
        }
        catch (Exception e) {
            debug.message("SAML2Utils:isFedInfoExists: Exception : ", (Throwable)e);
        }
        if (debug.messageEnabled()) {
            debug.message("SAML2Utils:isFedInfoExists : " + exists);
        }
        return exists;
    }

    public static Map getNameIDKeyMap(NameID nameID, String hostEntityID, String remoteEntityID, String realm, String hostEntityRole) throws SAML2Exception {
        if (nameID == null) {
            throw new SAML2Exception(bundle.getString("nullNameID"));
        }
        NameIDInfoKey infoKey = null;
        String affiliationID = nameID.getSPNameQualifier();
        if (affiliationID != null) {
            AffiliationDescriptorType affiDesc = saml2MetaManager.getAffiliationDescriptor(realm, affiliationID);
            if (affiDesc == null) {
                infoKey = new NameIDInfoKey(nameID.getValue(), hostEntityID, remoteEntityID);
            } else if ("SPRole".equals(hostEntityRole)) {
                if (!affiDesc.getAffiliateMember().contains(hostEntityID)) {
                    throw new SAML2Exception(bundle.getString("spNotAffiliationMember"));
                }
                infoKey = new NameIDInfoKey(nameID.getValue(), affiliationID, remoteEntityID);
            } else {
                if (!affiDesc.getAffiliateMember().contains(remoteEntityID)) {
                    throw new SAML2Exception(bundle.getString("spNotAffiliationMember"));
                }
                infoKey = new NameIDInfoKey(nameID.getValue(), hostEntityID, affiliationID);
            }
        } else {
            infoKey = new NameIDInfoKey(nameID.getValue(), hostEntityID, remoteEntityID);
        }
        HashSet<String> set = new HashSet<String>();
        set.add(infoKey.toValueString());
        HashMap<String, HashSet<String>> keyMap = new HashMap<String, HashSet<String>>();
        keyMap.put(AccountUtils.getNameIDInfoKeyAttribute(), set);
        if (debug.messageEnabled()) {
            debug.message("SAML2Utils.getNameIDKeyMap: " + keyMap);
        }
        return keyMap;
    }

    public static boolean isSourceSiteValid(Issuer issuer, String orgName, String hostEntityId) {
        boolean isValid = false;
        try {
            String entityID;
            if (issuer != null && (entityID = issuer.getValue().trim()) != null && entityID.length() != 0) {
                isValid = saml2MetaManager.isTrustedProvider(orgName, hostEntityId, entityID);
            }
            return isValid;
        }
        catch (Exception e) {
            debug.error("SAML2Utils.isSourceSiteValid: Exception : ", (Throwable)e);
            return false;
        }
    }

    public static DataStoreProvider getDataStoreProvider() throws SAML2Exception {
        try {
            DataStoreProviderManager dsManager = DataStoreProviderManager.getInstance();
            return dsManager.getDataStoreProvider("saml2");
        }
        catch (DataStoreProviderException dse) {
            debug.error("SAML2Utils.getDataStoreProvider: DataStoreProviderException : ", (Throwable)((Object)dse));
            throw new SAML2Exception((Throwable)((Object)dse));
        }
    }

    public static String encodeForPOST(String str) {
        String encoded = null;
        try {
            encoded = Base64.encode((byte[])str.getBytes("UTF-8"), (int)76);
        }
        catch (UnsupportedEncodingException uee) {
            debug.error("SAML2Utils.encodeForPOST", (Throwable)uee);
        }
        return encoded;
    }

    public static String encodeForRedirect(String str) {
        String classMethod = "encodeForRedirect";
        int n = str.length();
        byte[] input = null;
        try {
            input = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            debug.error("SAML2Utils.encodeForRedirect: cannot get byte array: ", (Throwable)uee);
            return null;
        }
        byte[] output = new byte[n];
        Deflater deflater = new Deflater(-1, true);
        deflater.setInput(input);
        deflater.finish();
        int len = deflater.deflate(output);
        deflater.end();
        byte[] exact = new byte[len];
        System.arraycopy(output, 0, exact, 0, len);
        String base64Str = Base64.encode((byte[])exact);
        String encoded = URLEncDec.encode((String)base64Str);
        if (debug.messageEnabled()) {
            debug.message(classMethod + "out string length : " + encoded.length());
            debug.message(classMethod + "out string is ===>" + encoded + "<===");
        }
        return encoded;
    }

    public static String decodeFromRedirect(String str) {
        byte[] input;
        String classMethod = "SAML2Utils.decodeFromRedirect: ";
        if (str == null || str.length() == 0) {
            debug.error("SAML2Utils.decodeFromRedirect: input is null.");
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("SAML2Utils.decodeFromRedirect: input string length : " + str.length());
            debug.message("SAML2Utils.decodeFromRedirect: input string is ===>" + str + "<===");
        }
        if ((input = Base64.decode((String)SAML2Utils.removeNewLineChars(str))) == null || input.length == 0) {
            debug.error("SAML2Utils.decodeFromRedirect: base 64 decoded result is null");
            return null;
        }
        Inflater inflater = new Inflater(true);
        inflater.setInput(input);
        int resultLen = 2048;
        try {
            if (bufferLen != null && !bufferLen.equals("")) {
                resultLen = Integer.parseInt(bufferLen);
            }
        }
        catch (NumberFormatException nfe) {
            debug.error("Unable to parse buffer length.", (Throwable)nfe);
        }
        byte[] result = new byte[resultLen];
        int resultLength = 0;
        try {
            resultLength = inflater.inflate(result);
        }
        catch (DataFormatException dfe) {
            debug.error("SAML2Utils.decodeFromRedirect: cannot inflate SAMLRequest: ", (Throwable)dfe);
            return null;
        }
        inflater.end();
        String outputString = null;
        try {
            outputString = new String(result, 0, resultLength, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            debug.error("SAML2Utils.decodeFromRedirect: cannot convert byte array to string.", (Throwable)uee);
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("SAML2Utils.decodeFromRedirect: Return value: \n" + outputString);
        }
        return outputString;
    }

    public static String removeNewLineChars(String s) {
        String retString = null;
        if (s != null && s.length() > 0 && s.indexOf(10) != -1) {
            char[] chars = s.toCharArray();
            int len = chars.length;
            StringBuffer sb = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                char c = chars[i];
                if (c == '\n') continue;
                sb.append(c);
            }
            retString = sb.toString();
        } else {
            retString = s;
        }
        return retString;
    }

    public static SAML2MetaManager getSAML2MetaManager() {
        return saml2MetaManager;
    }

    public static String getRealm(String realm) {
        return realm == null || realm.length() == 0 ? "/" : realm;
    }

    public static String getRealm(Map paramsMap) {
        String realm = SAML2Utils.getParameter(paramsMap, "realm");
        return realm == null || realm.length() == 0 ? "/" : realm;
    }

    public static String getParameter(Map paramsMap, String attrName) {
        String attr;
        String attrVal = null;
        if (paramsMap != null && !paramsMap.isEmpty() && (attr = (String)paramsMap.get(attrName)) != null) {
            attrVal = attr;
        }
        return attrVal;
    }

    public static Map getParamsMap(HttpServletRequest request) {
        String affiID;
        String reqBinding;
        String levelAdvice;
        String authLevel;
        String authContextClassRef;
        String authContextDeclRef;
        String authComparison;
        String attrIndex;
        String acsUrlIndex;
        String binding;
        String nameIDPolicy;
        String destination;
        String consent;
        String allowCreate;
        String forceAuthN;
        String isPassive;
        HashMap<String, List> paramsMap = new HashMap<String, List>();
        String relayState = SAML2Utils.getRelayState(request);
        if (relayState != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(relayState);
            paramsMap.put("RelayState", list);
        }
        if ((isPassive = request.getParameter("IsPassive")) != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(isPassive);
            paramsMap.put("IsPassive", list);
        }
        if ((forceAuthN = request.getParameter("ForceAuthn")) != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(forceAuthN);
            paramsMap.put("ForceAuthn", list);
        }
        if ((allowCreate = request.getParameter("AllowCreate")) != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(allowCreate);
            paramsMap.put("AllowCreate", list);
        }
        if ((consent = request.getParameter("Consent")) != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(consent);
            paramsMap.put("Consent", list);
        }
        if ((destination = request.getParameter("Destination")) != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(destination);
            paramsMap.put("Destination", list);
        }
        if ((nameIDPolicy = request.getParameter("NameIDFormat")) != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(nameIDPolicy);
            paramsMap.put("NameIDFormat", list);
        }
        if ((binding = request.getParameter("binding")) != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(binding);
            paramsMap.put("binding", list);
        }
        if ((acsUrlIndex = request.getParameter("AssertionConsumerServiceIndex")) != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(acsUrlIndex);
            paramsMap.put("AssertionConsumerServiceIndex", list);
        }
        if ((attrIndex = request.getParameter("AttributeConsumingServiceIndex")) != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(attrIndex);
            paramsMap.put("AttributeConsumingServiceIndex", list);
        }
        if ((authComparison = request.getParameter("AuthComparison")) != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(authComparison);
            paramsMap.put("AuthComparison", list);
        }
        if ((authContextDeclRef = request.getParameter("AuthContextDeclRef")) != null && authContextDeclRef.length() > 0) {
            List authDeclList = SAML2Utils.getAuthContextList(authContextDeclRef);
            paramsMap.put("AuthContextDeclRef", authDeclList);
        }
        if ((authContextClassRef = request.getParameter("AuthnContextClassRef")) != null) {
            List authClassRefList = SAML2Utils.getAuthContextList(authContextClassRef);
            paramsMap.put("AuthnContextClassRef", authClassRefList);
        }
        if ((authLevel = request.getParameter("AuthLevel")) != null && authLevel.length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(authLevel);
            paramsMap.put("AuthLevel", list);
        }
        if ((levelAdvice = request.getParameter("sunamcompositeadvice")) != null && levelAdvice.length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(levelAdvice);
            paramsMap.put("sunamcompositeadvice", list);
        }
        if ((reqBinding = request.getParameter("reqBinding")) != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(reqBinding);
            paramsMap.put("reqBinding", list);
        }
        if ((affiID = request.getParameter("affiliationID")) != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(affiID);
            paramsMap.put("affiliationID", list);
        }
        return paramsMap;
    }

    private static List getAuthContextList(String str) {
        ArrayList<String> ctxList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, "|");
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            ctxList.add(tmp);
        }
        return ctxList;
    }

    public static String generateSourceID(String entityID) {
        if (entityID == null || entityID.length() == 0) {
            return null;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            debug.error("SAML2Utils.generateSourceID: ", (Throwable)e);
            return null;
        }
        char[] chars = entityID.toCharArray();
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        md.update(bytes);
        return SAML2Utils.byteArrayToString(md.digest());
    }

    public static String getRemoteServiceURL(String id) {
        if (debug.messageEnabled()) {
            debug.message("SAML2Utils.getRemoteServiceURL: id = " + id);
        }
        if (id == null || id.length() < 2) {
            return null;
        }
        String serverID = id.substring(id.length() - 2);
        try {
            String localServerID = SystemConfigurationUtil.getServerID(server_protocol, server_host, int_server_port, server_uri);
            if (serverID.equals(localServerID)) {
                return null;
            }
            return SystemConfigurationUtil.getServerFromID(serverID);
        }
        catch (Exception ex) {
            if (debug.messageEnabled()) {
                debug.message("SAML2Utils.getRemoteServiceURL:", (Throwable)ex);
            }
            return null;
        }
    }

    public static List getRemoteServiceURLs(HttpServletRequest request) {
        List serverList;
        String requestURL;
        block8: {
            requestURL = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
            if (debug.messageEnabled()) {
                debug.message("SAML2Utils.getRemoteServiceURLs: requestURL = " + requestURL);
            }
            serverList = null;
            try {
                serverList = SystemConfigurationUtil.getServerList();
                List siteList = SystemConfigurationUtil.getSiteList();
                if (debug.messageEnabled()) {
                    debug.message("SAML2Utils.getRemoteServiceURLs: servers=" + serverList + ", siteList=" + siteList);
                }
                serverList.removeAll(siteList);
                if (debug.messageEnabled()) {
                    debug.message("SAML2Utils.getRemoteServiceURLs: new servers=" + serverList);
                }
            }
            catch (Exception ex) {
                if (!debug.messageEnabled()) break block8;
                debug.message("SAML2Utils.getRemoteServiceURLs:", (Throwable)ex);
            }
        }
        if (serverList == null) {
            return null;
        }
        ArrayList<String> remoteServiceURLs = new ArrayList<String>();
        Iterator iter = serverList.iterator();
        while (iter.hasNext()) {
            String serviceURL = (String)iter.next();
            if (serviceURL.equalsIgnoreCase(requestURL) || serviceURL.equalsIgnoreCase(localURL)) continue;
            remoteServiceURLs.add(serviceURL);
        }
        if (debug.messageEnabled()) {
            debug.message("SAML2Utils.getRemoteServiceURLs: remoteServiceURLs = " + remoteServiceURLs);
        }
        return remoteServiceURLs;
    }

    public static String generateIDWithServerID() {
        if (random == null) {
            return null;
        }
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        String id = "s2" + SAML2Utils.byteArrayToHexString(bytes);
        return SAML2Utils.embedServerID(id);
    }

    public static String generateMessageHandleWithServerID() {
        if (random == null) {
            return null;
        }
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        String id = SAML2Utils.byteArrayToString(bytes);
        return SAML2Utils.embedServerID(id);
    }

    private static String embedServerID(String id) {
        block5: {
            String serverId = null;
            try {
                serverId = SystemConfigurationUtil.getServerID(server_protocol, server_host, int_server_port, server_uri);
                if (serverId != null && serverId.length() == 2) {
                    id = id.substring(0, id.length() - 2) + serverId;
                } else if (debug.messageEnabled()) {
                    debug.message("SAML2Utils.appendServerID: invalid server id = " + serverId);
                }
            }
            catch (Exception ex) {
                if (!debug.messageEnabled()) break block5;
                debug.message("SAML2Utils.appendServerID:", (Throwable)ex);
            }
        }
        return id;
    }

    public static SOAPMessage createSOAPMessage(String xmlString) throws SOAPException, SAML2Exception {
        return SAML2Utils.createSOAPMessage(null, xmlString);
    }

    public static SOAPMessage createSOAPMessage(String header, String body) throws SOAPException, SAML2Exception {
        SOAPMessage msg = null;
        try {
            MimeHeaders mimeHeaders = new MimeHeaders();
            mimeHeaders.addHeader("Content-Type", "text/xml");
            if (debug.messageEnabled()) {
                debug.message("SAML2Utils.createSOAPMessage: header = " + header + ", body = " + body);
            }
            StringBuffer sb = new StringBuffer(500);
            sb.append("<").append("soap-env").append(":Envelope").append(" ").append("xmlns:").append("soap-env").append("=\"").append("http://schemas.xmlsoap.org/soap/envelope/").append("\">");
            if (header != null) {
                sb.append("<").append("soap-env").append(":Header>").append(header).append("</").append("soap-env").append(":Header>");
            }
            if (body != null) {
                sb.append("<").append("soap-env").append(":Body>").append(body).append("</").append("soap-env").append(":Body>");
            }
            sb.append("</").append("soap-env").append(":Envelope>").append("\n");
            if (debug.messageEnabled()) {
                debug.message("SAML2Utils.createSOAPMessage: soap message = " + sb.toString());
            }
            msg = mf.createMessage(mimeHeaders, (InputStream)new ByteArrayInputStream(sb.toString().getBytes("UTF-8")));
        }
        catch (IOException io) {
            debug.error("SAML2Utils.createSOAPMessage: IOE", (Throwable)io);
            throw new SAML2Exception(io.getMessage());
        }
        return msg;
    }

    public static String soapMessageToString(SOAPMessage message) {
        try {
            ByteArrayOutputStream bop = new ByteArrayOutputStream();
            message.writeTo((OutputStream)bop);
            return new String(bop.toByteArray());
        }
        catch (IOException ie) {
            debug.error("SAML2Utils.soapMessageToString:", (Throwable)ie);
            return null;
        }
        catch (SOAPException soapex) {
            debug.error("SAML2Utils.soapMessageToString:", (Throwable)soapex);
            return null;
        }
    }

    public static Element getSOAPBody(SOAPMessage message) throws SAML2Exception {
        String rootName;
        debug.message("SAML2Utils.getSOAPBody : start");
        ByteArrayOutputStream bop = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)bop);
        }
        catch (IOException ie) {
            debug.error("SAML2Utils.getSOAPBody : writeTo IO", (Throwable)ie);
            throw new SAML2Exception(ie.getMessage());
        }
        catch (SOAPException se) {
            debug.error("SAML2Utils.getSOAPBody : writeTo SOAP", (Throwable)se);
            throw new SAML2Exception(se.getMessage());
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(bop.toByteArray());
        Document doc = XMLUtils.toDOMDocument((InputStream)bin, (Debug)debug);
        Element root = doc.getDocumentElement();
        if (debug.messageEnabled()) {
            debug.message("SAML2Util.getSOAPBody : soap body =\n" + XMLUtils.print((Node)root));
        }
        if ((rootName = doc.getDocumentElement().getLocalName()) == null || rootName.length() == 0) {
            debug.error("SAML2Utils.getSOAPBody : no local name");
            throw new SAML2Exception(bundle.getString("missingLocalName"));
        }
        if (!rootName.equals("Envelope") || !"http://schemas.xmlsoap.org/soap/envelope/".equals(root.getNamespaceURI())) {
            debug.error("SAML2Utils.getSOAPBody : either root element is not Envelope or invalid name space or prefix");
            throw new SAML2Exception(bundle.getString("invalidSOAPElement"));
        }
        NodeList nl = root.getChildNodes();
        int length = nl.getLength();
        if (length <= 0) {
            debug.error("SAML2Utils.getSOAPBody: no msg body");
            throw new SAML2Exception(bundle.getString("missingSOAPBody"));
        }
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) {
                debug.message("SAML2Utils.getSOAPBody: " + child);
                continue;
            }
            String childName = child.getLocalName();
            if (debug.messageEnabled()) {
                debug.message("SAML2Utils.getSOAPBody: local name= " + childName);
            }
            if (!childName.equals("Body") || !"http://schemas.xmlsoap.org/soap/envelope/".equals(child.getNamespaceURI())) continue;
            return (Element)child;
        }
        throw new SAML2Exception(bundle.getString("missingSOAPBody"));
    }

    public static MimeHeaders getHeaders(HttpServletRequest req) {
        Enumeration e = req.getHeaderNames();
        MimeHeaders headers = new MimeHeaders();
        while (e.hasMoreElements()) {
            String headerName = (String)e.nextElement();
            String headerValue = req.getHeader(headerName);
            if (debug.messageEnabled()) {
                debug.message("SAML2Util.getHeaders: Header name=" + headerName + ", value=" + headerValue);
            }
            StringTokenizer values = new StringTokenizer(headerValue, ",");
            while (values.hasMoreTokens()) {
                headers.addHeader(headerName, values.nextToken().trim());
            }
        }
        if (debug.messageEnabled()) {
            debug.message("SAML2Util.getHeaders: Header=" + headers.toString());
        }
        return headers;
    }

    public static void putHeaders(MimeHeaders headers, HttpServletResponse res) {
        if (debug.messageEnabled()) {
            debug.message("SAML2Util.putHeaders: Header=" + headers.toString());
        }
        Iterator it = headers.getAllHeaders();
        while (it.hasNext()) {
            MimeHeader header = (MimeHeader)it.next();
            String[] values = headers.getHeader(header.getName());
            if (debug.messageEnabled()) {
                debug.message("SAML2Util.putHeaders: Header name=" + header.getName() + ", value=" + values);
            }
            if (values.length == 1) {
                res.setHeader(header.getName(), header.getValue());
                continue;
            }
            StringBuffer concat = new StringBuffer();
            int i = 0;
            while (i < values.length) {
                if (i != 0) {
                    concat.append(',');
                }
                concat.append(values[i++]);
            }
            res.setHeader(header.getName(), concat.toString());
        }
    }

    public static Status generateStatus(String code, String message) {
        return SAML2Utils.generateStatus(code, null, message);
    }

    public static Status generateStatus(String code, String subCode, String message) {
        Status status = null;
        try {
            status = ProtocolFactory.getInstance().createStatus();
            StatusCode statusCode = ProtocolFactory.getInstance().createStatusCode();
            statusCode.setValue(code);
            status.setStatusCode(statusCode);
            if (message != null && message.length() != 0) {
                status.setStatusMessage(message);
            }
            if (subCode != null) {
                StatusCode subStatusCode = ProtocolFactory.getInstance().createStatusCode();
                subStatusCode.setValue(subCode);
                statusCode.setStatusCode(subStatusCode);
            }
        }
        catch (SAML2Exception e) {
            debug.error("SAML2Utils.generateStatus:", (Throwable)((Object)e));
        }
        return status;
    }

    public static Response getErrorResponse(RequestAbstract request, String code, String subCode, String statusMsg, String issuerEntityID) throws SAML2Exception {
        String classMethod = "IDPSSOUtil.getErrorResponse: ";
        Response errResp = ProtocolFactory.getInstance().createResponse();
        errResp.setStatus(SAML2Utils.generateStatus(code, subCode, statusMsg));
        String responseID = SAML2Utils.generateID();
        if (responseID == null) {
            debug.error("Unable to generate response ID.");
            return null;
        }
        errResp.setID(responseID);
        if (request != null) {
            errResp.setInResponseTo(request.getID());
        }
        errResp.setVersion("2.0");
        errResp.setIssueInstant(new Date());
        if (issuerEntityID != null) {
            Issuer issuer = AssertionFactory.getInstance().createIssuer();
            issuer.setValue(issuerEntityID);
            errResp.setIssuer(issuer);
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + "Error Response is : " + errResp.toXMLString());
        }
        return errResp;
    }

    public static Element getSamlpElement(SOAPMessage message, String localName) throws SAML2Exception {
        Element body = SAML2Utils.getSOAPBody(message);
        NodeList nlBody = body.getChildNodes();
        int blength = nlBody.getLength();
        if (blength <= 0) {
            debug.error("SAML2Utils.getSamlpElement: empty body");
            throw new SAML2Exception(bundle.getString("missingBody"));
        }
        Element retElem = null;
        Node node = null;
        for (int i = 0; i < blength; ++i) {
            node = nlBody.item(i);
            if (node.getNodeType() != 1) continue;
            String nlName = node.getLocalName();
            if (debug.messageEnabled()) {
                debug.message("SAML2Utils.getSamlpElement: node=" + nlName + ", nsURI=" + node.getNamespaceURI());
            }
            if (nlName.equals("Fault")) {
                throw new SAML2Exception(bundle.getString("soapFaultInSOAPResponse"));
            }
            if (!nlName.equals(localName) || !"urn:oasis:names:tc:SAML:2.0:protocol".equals(node.getNamespaceURI())) continue;
            retElem = (Element)node;
            break;
        }
        if (retElem == null) {
            throw new SAML2Exception(bundle.getString("elementNotFound") + localName);
        }
        return retElem;
    }

    public static SOAPMessage createSOAPFault(String faultCode, String faultString, String detail) {
        SOAPMessage msg = null;
        SOAPEnvelope envelope = null;
        SOAPFault sf = null;
        SOAPBody body = null;
        DetailEntry se = null;
        try {
            msg = mf.createMessage();
            envelope = msg.getSOAPPart().getEnvelope();
            body = envelope.getBody();
            sf = body.addFault();
            Name qName = envelope.createName(faultCode, null, "http://schemas.xmlsoap.org/soap/envelope/");
            sf.setFaultCode(qName);
            sf.setFaultString(bundle.getString(faultString));
            if (detail != null && detail.length() != 0) {
                Detail det = sf.addDetail();
                se = det.addDetailEntry(envelope.createName("Problem"));
                se.addAttribute(envelope.createName("details"), bundle.getString(detail));
            }
        }
        catch (SOAPException e) {
            debug.error("createSOAPFault:", (Throwable)e);
        }
        return msg;
    }

    public static SOAPMessage getSOAPMessage(HttpServletRequest request) throws IOException, SOAPException {
        MimeHeaders headers = SAML2Utils.getHeaders(request);
        ServletInputStream is = request.getInputStream();
        return mf.createMessage(headers, (InputStream)is);
    }

    public static SOAPMessage sendSOAPMessage(String xmlMessage, String soapUrl) throws SOAPException, SAML2Exception {
        SOAPConnection con = scf.createConnection();
        SOAPMessage msg = SAML2Utils.createSOAPMessage(xmlMessage);
        return con.call(msg, (Object)soapUrl);
    }

    public static String getEncryptionCertAlias(String realm, String hostEntityId, String entityRole) {
        if (debug.messageEnabled()) {
            String method = "getEncryptionCertAlias : ";
            debug.message(method + "realm - " + realm);
            debug.message(method + "hostEntityId - " + hostEntityId);
            debug.message(method + "entityRole - " + entityRole);
        }
        return SAML2Utils.getAttributeValueFromSSOConfig(realm, hostEntityId, entityRole, "encryptionCertAlias");
    }

    public static String getSigningCertAlias(String realm, String hostEntityId, String entityRole) {
        if (debug.messageEnabled()) {
            String method = "getSigningCertAlias : ";
            debug.message(method + "realm - " + realm);
            debug.message(method + "hostEntityId - " + hostEntityId);
            debug.message(method + "entityRole - " + entityRole);
        }
        return SAML2Utils.getAttributeValueFromSSOConfig(realm, hostEntityId, entityRole, "signingCertAlias");
    }

    public static boolean getWantAssertionEncrypted(String realm, String hostEntityId, String entityRole) {
        String wantEncrypted;
        if (debug.messageEnabled()) {
            String method = "getWantAssertionEncrypted : ";
            debug.message(method + "realm - " + realm);
            debug.message(method + "hostEntityId - " + hostEntityId);
            debug.message(method + "entityRole - " + entityRole);
        }
        if ((wantEncrypted = SAML2Utils.getAttributeValueFromSSOConfig(realm, hostEntityId, entityRole, "wantAssertionEncrypted")) == null) {
            wantEncrypted = "false";
        }
        return wantEncrypted.equalsIgnoreCase("true");
    }

    public static boolean getWantAttributeEncrypted(String realm, String hostEntityId, String entityRole) {
        String wantEncrypted;
        if (debug.messageEnabled()) {
            String method = "getWantAttributeEncrypted : ";
            debug.message(method + "realm - " + realm);
            debug.message(method + "hostEntityId - " + hostEntityId);
            debug.message(method + "entityRole - " + entityRole);
        }
        if ((wantEncrypted = SAML2Utils.getAttributeValueFromSSOConfig(realm, hostEntityId, entityRole, "wantAttributeEncrypted")) == null) {
            wantEncrypted = "false";
        }
        return wantEncrypted.equalsIgnoreCase("true");
    }

    public static boolean getWantNameIDEncrypted(String realm, String hostEntityId, String entityRole) {
        String wantEncrypted;
        if (debug.messageEnabled()) {
            String method = "getWantNameIDEncrypted : ";
            debug.message(method + "realm - " + realm);
            debug.message(method + "hostEntityId - " + hostEntityId);
            debug.message(method + "entityRole - " + entityRole);
        }
        if ((wantEncrypted = SAML2Utils.getAttributeValueFromSSOConfig(realm, hostEntityId, entityRole, "wantNameIDEncrypted")) == null) {
            wantEncrypted = "false";
        }
        return wantEncrypted.equalsIgnoreCase("true");
    }

    public static boolean getWantArtifactResolveSigned(String realm, String hostEntityId, String entityRole) {
        String wantSigned;
        if (debug.messageEnabled()) {
            String method = "getWantArtifactResolveSigned : ";
            debug.message(method + "realm - " + realm);
            debug.message(method + "hostEntityId - " + hostEntityId);
            debug.message(method + "entityRole - " + entityRole);
        }
        if ((wantSigned = SAML2Utils.getAttributeValueFromSSOConfig(realm, hostEntityId, entityRole, "wantArtifactResolveSigned")) == null) {
            wantSigned = "false";
        }
        return wantSigned.equalsIgnoreCase("true");
    }

    public static boolean getWantArtifactResponseSigned(String realm, String hostEntityId, String entityRole) {
        String wantSigned;
        if (debug.messageEnabled()) {
            String method = "getWantArtifactResponseSigned : ";
            debug.message(method + "realm - " + realm);
            debug.message(method + "hostEntityId - " + hostEntityId);
            debug.message(method + "entityRole - " + entityRole);
        }
        if ((wantSigned = SAML2Utils.getAttributeValueFromSSOConfig(realm, hostEntityId, entityRole, "wantArtifactResponseSigned")) == null) {
            wantSigned = "false";
        }
        return wantSigned.equalsIgnoreCase("true");
    }

    public static boolean getWantLogoutRequestSigned(String realm, String hostEntityId, String entityRole) {
        String wantSigned;
        if (debug.messageEnabled()) {
            String method = "getWantLogoutRequestSigned : ";
            debug.message(method + "realm - " + realm);
            debug.message(method + "hostEntityId - " + hostEntityId);
            debug.message(method + "entityRole - " + entityRole);
        }
        if ((wantSigned = SAML2Utils.getAttributeValueFromSSOConfig(realm, hostEntityId, entityRole, "wantLogoutRequestSigned")) == null) {
            wantSigned = "false";
        }
        return wantSigned.equalsIgnoreCase("true");
    }

    public static boolean getWantLogoutResponseSigned(String realm, String hostEntityId, String entityRole) {
        String wantSigned;
        if (debug.messageEnabled()) {
            String method = "getWantLogoutResponseSigned : ";
            debug.message(method + "realm - " + realm);
            debug.message(method + "hostEntityId - " + hostEntityId);
            debug.message(method + "entityRole - " + entityRole);
        }
        if ((wantSigned = SAML2Utils.getAttributeValueFromSSOConfig(realm, hostEntityId, entityRole, "wantLogoutResponseSigned")) == null) {
            wantSigned = "false";
        }
        return wantSigned.equalsIgnoreCase("true");
    }

    public static boolean getWantMNIRequestSigned(String realm, String hostEntityId, String entityRole) {
        String wantSigned;
        if (debug.messageEnabled()) {
            String method = "getWantMNIRequestSigned : ";
            debug.message(method + "realm - " + realm);
            debug.message(method + "hostEntityId - " + hostEntityId);
            debug.message(method + "entityRole - " + entityRole);
        }
        if ((wantSigned = SAML2Utils.getAttributeValueFromSSOConfig(realm, hostEntityId, entityRole, "wantMNIRequestSigned")) == null) {
            wantSigned = "false";
        }
        return wantSigned.equalsIgnoreCase("true");
    }

    public static boolean getWantMNIResponseSigned(String realm, String hostEntityId, String entityRole) {
        String wantSigned;
        if (debug.messageEnabled()) {
            String method = "getWantMNIResponseSigned : ";
            debug.message(method + "realm - " + realm);
            debug.message(method + "hostEntityId - " + hostEntityId);
            debug.message(method + "entityRole - " + entityRole);
        }
        if ((wantSigned = SAML2Utils.getAttributeValueFromSSOConfig(realm, hostEntityId, entityRole, "wantMNIResponseSigned")) == null) {
            wantSigned = "false";
        }
        return wantSigned.equalsIgnoreCase("true");
    }

    public static boolean getBooleanAttributeValueFromSSOConfig(String realm, String hostEntityId, String entityRole, String attrName) {
        List value = SAML2Utils.getAllAttributeValueFromSSOConfig(realm, hostEntityId, entityRole, attrName);
        if (value == null || value.isEmpty()) {
            return false;
        }
        return "true".equalsIgnoreCase((String)value.get(0));
    }

    public static String getAttributeValueFromSSOConfig(String realm, String hostEntityId, String entityRole, String attrName) {
        if (debug.messageEnabled()) {
            String method = "getAttributeValueFromSSOConfig : ";
            debug.message(method + "realm - " + realm);
            debug.message(method + "hostEntityId - " + hostEntityId);
            debug.message(method + "entityRole - " + entityRole);
            debug.message(method + "attrName - " + attrName);
        }
        List value = SAML2Utils.getAllAttributeValueFromSSOConfig(realm, hostEntityId, entityRole, attrName);
        if (debug.messageEnabled()) {
            debug.message("getAttributeValueFromSSOConfig: values=" + value);
        }
        if (value != null && !value.isEmpty()) {
            return (String)value.get(0);
        }
        return null;
    }

    public static List getAllAttributeValueFromSSOConfig(String realm, String hostEntityId, String entityRole, String attrName) {
        if (debug.messageEnabled()) {
            String method = "getAllAttributeValueFromSSOConfig : ";
            debug.message(method + "realm - " + realm);
            debug.message(method + "hostEntityId - " + hostEntityId);
            debug.message(method + "entityRole - " + entityRole);
            debug.message(method + "attrName - " + attrName);
        }
        try {
            BaseConfigType config = null;
            if (entityRole.equalsIgnoreCase("SPRole")) {
                config = saml2MetaManager.getSPSSOConfig(realm, hostEntityId);
            } else if (entityRole.equalsIgnoreCase("IDPRole")) {
                config = saml2MetaManager.getIDPSSOConfig(realm, hostEntityId);
            } else if (entityRole.equalsIgnoreCase("AttrAuthRole")) {
                config = saml2MetaManager.getAttributeAuthorityConfig(realm, hostEntityId);
            } else if (entityRole.equalsIgnoreCase("AuthnAuthRole")) {
                config = saml2MetaManager.getAuthnAuthorityConfig(realm, hostEntityId);
            } else if (entityRole.equalsIgnoreCase("AttrQueryRole")) {
                config = saml2MetaManager.getAttributeQueryConfig(realm, hostEntityId);
            }
            if (config == null) {
                return null;
            }
            Map attrs = SAML2MetaUtils.getAttributes(config);
            if (attrs == null) {
                return null;
            }
            return (List)attrs.get(attrName);
        }
        catch (SAML2MetaException e) {
            debug.message("get SSOConfig failed:", (Throwable)((Object)e));
            return null;
        }
    }

    public static String getHostEntityRole(Map paramsMap) throws SAML2Exception {
        String roleName = SAML2Utils.getParameter(paramsMap, "role");
        if (roleName.equalsIgnoreCase("SPRole") || roleName.equalsIgnoreCase("IDPRole")) {
            return roleName;
        }
        throw new SAML2Exception(bundle.getString("unknownHostEntityRole"));
    }

    public static boolean isDualRole(String hostEntityId, String realm) {
        try {
            SPSSOConfigElement spConfig = saml2MetaManager.getSPSSOConfig(realm, hostEntityId);
            if (spConfig == null) {
                return false;
            }
            IDPSSOConfigElement idpConfig = saml2MetaManager.getIDPSSOConfig(realm, hostEntityId);
            return idpConfig != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void redirectAuthentication(HttpServletRequest request, HttpServletResponse response, String realm, String hostEntityID, String entityRole) throws IOException {
        String method = "redirectAuthentication: ";
        String authUrl = SAML2Utils.getAttributeValueFromSSOConfig(realm, hostEntityID, entityRole, "AuthUrl");
        if (authUrl == null || authUrl.trim().length() == 0) {
            String uri;
            String deploymentURI = uri = request.getRequestURI();
            int firstSlashIndex = uri.indexOf("/");
            int secondSlashIndex = uri.indexOf("/", firstSlashIndex + 1);
            if (secondSlashIndex != -1) {
                deploymentURI = uri.substring(0, secondSlashIndex);
            }
            StringBuffer sb = new StringBuffer();
            sb.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append(deploymentURI).append("/UI/Login?realm=").append(realm);
            authUrl = sb.toString();
        }
        authUrl = authUrl.indexOf("?") == -1 ? authUrl + "?goto=" : authUrl + "&goto=";
        authUrl = authUrl + URLEncDec.encode((String)(request.getRequestURL().toString() + "?" + request.getQueryString()));
        if (debug.messageEnabled()) {
            debug.message(method + "New URL for authentication: " + authUrl);
        }
        FSUtils.forwardRequest(request, response, authUrl);
    }

    public static Issuer createIssuer(String entityID) throws SAML2Exception {
        String method = "createIssuer: ";
        Issuer issuer = af.createIssuer();
        issuer.setValue(entityID);
        if (debug.messageEnabled()) {
            debug.message(method + "Issuer : " + issuer.toXMLString());
        }
        return issuer;
    }

    public static String signQueryString(String queryString, String realm, String hostEntity, String hostEntityRole) throws SAML2Exception {
        PrivateKey signingKey;
        String method = "signQueryString : ";
        if (debug.messageEnabled()) {
            debug.message(method + "queryString :" + queryString);
        }
        String alias = SAML2Utils.getSigningCertAlias(realm, hostEntity, hostEntityRole);
        if (debug.messageEnabled()) {
            debug.message(method + "realm is : " + realm);
            debug.message(method + "hostEntity is : " + hostEntity);
            debug.message(method + "Host Entity role is : " + hostEntityRole);
            debug.message(method + "Signing Cert Alias is : " + alias);
        }
        if ((signingKey = keyProvider.getPrivateKey(alias)) == null) {
            debug.error("Incorrect configuration for Signing Certificate.");
            throw new SAML2Exception(bundle.getString("metaDataError"));
        }
        return QuerySignatureUtil.sign(queryString, signingKey);
    }

    public static boolean verifyQueryString(String queryString, String realm, String hostEntityRole, String remoteEntity) throws SAML2Exception {
        String method = "verifyQueryString : ";
        if (debug.messageEnabled()) {
            debug.message(method + "queryString :" + queryString);
        }
        X509Certificate signingCert = null;
        if (hostEntityRole.equalsIgnoreCase("IDPRole")) {
            SPSSODescriptorElement spSSODesc = saml2MetaManager.getSPSSODescriptor(realm, remoteEntity);
            signingCert = KeyUtil.getVerificationCert(spSSODesc, remoteEntity, "SPRole");
        } else {
            IDPSSODescriptorElement idpSSODesc = saml2MetaManager.getIDPSSODescriptor(realm, remoteEntity);
            signingCert = KeyUtil.getVerificationCert(idpSSODesc, remoteEntity, "IDPRole");
        }
        if (debug.messageEnabled()) {
            debug.message(method + "realm is : " + realm);
            debug.message(method + "Host Entity role is : " + hostEntityRole);
            debug.message(method + "remoteEntity is : " + remoteEntity);
        }
        if (signingCert == null) {
            debug.error("Incorrect configuration for Signing Certificate.");
            throw new SAML2Exception(bundle.getString("metaDataError"));
        }
        return QuerySignatureUtil.verify(queryString, signingCert);
    }

    public static Object checkSession(HttpServletRequest request, HttpServletResponse response, String metaAlias, Map paramsMap) throws SAML2Exception {
        String method = "SAML2Utils.checkSession : ";
        Object session = null;
        try {
            session = SessionManager.getProvider().getSession(request);
        }
        catch (SessionException se) {
            if (debug.messageEnabled()) {
                debug.message(method, (Throwable)((Object)se));
            }
            session = null;
        }
        String realm = SAML2MetaUtils.getRealmByMetaAlias(metaAlias);
        String hostEntity = null;
        String hostEntityRole = SAML2Utils.getHostEntityRole(paramsMap);
        if (session == null) {
            if (debug.messageEnabled()) {
                debug.message(method + "session is missing." + "redirect to the authentication service");
            }
            try {
                hostEntity = saml2MetaManager.getEntityByMetaAlias(metaAlias);
                SAML2Utils.redirectAuthentication(request, response, realm, hostEntity, hostEntityRole);
            }
            catch (IOException ioe) {
                debug.error("Unable to redirect to authentication.");
                throw new SAML2Exception(ioe.toString());
            }
        }
        return session;
    }

    public static String createNameIdentifier() {
        String handle = null;
        try {
            byte[] handleBytes = new byte[21];
            randomGenerator.nextBytes(handleBytes);
            if (handleBytes == null) {
                debug.error("NameIdentifierImpl.createNameIdentifier:Could not generate random handle");
            } else {
                Base64 encoder = new Base64();
                handle = Base64.encode((byte[])handleBytes);
                if (debug.messageEnabled()) {
                    debug.message("createNameIdentifier String: " + handle);
                }
            }
        }
        catch (Exception e) {
            debug.message("createNameIdentifier: Exception during proccessing request" + e.getMessage());
        }
        return handle;
    }

    public static SPAuthnContextMapper getSPAuthnContextMapper(String realm, String hostEntityID, String authnCtxClassName) {
        SPAuthnContextMapper spAuthnCtx;
        block11: {
            spAuthnCtx = (SPAuthnContextMapper)SPCache.authCtxObjHash.get(hostEntityID + "|" + realm);
            if (debug.messageEnabled()) {
                debug.message("AuthContext Class Name is :" + authnCtxClassName);
            }
            if (spAuthnCtx == null && authnCtxClassName != null && authnCtxClassName.length() != 0) {
                try {
                    spAuthnCtx = (SPAuthnContextMapper)Class.forName(authnCtxClassName).newInstance();
                    SPCache.authCtxObjHash.put(hostEntityID + "|" + realm, spAuthnCtx);
                }
                catch (ClassNotFoundException ce) {
                    if (debug.messageEnabled()) {
                        debug.message("SAML2Utils: Mapper not configured using Default AuthnContext Mapper");
                    }
                }
                catch (InstantiationException ie) {
                    if (debug.messageEnabled()) {
                        debug.message("SAML2Utils: Instantiation ");
                        debug.message("SAML2Utils:Error instantiating :  using Default AuthnContext Mapper");
                    }
                }
                catch (IllegalAccessException iae) {
                    if (debug.messageEnabled()) {
                        debug.message("SAML2Utils: illegalaccess");
                        debug.message("SAML2Utils:Error :  using Default AuthnContext Mapper");
                    }
                }
                catch (Exception e) {
                    if (!debug.messageEnabled()) break block11;
                    debug.message("SAML2Utils:Error :  using Default AuthnContext Mapper");
                }
            }
        }
        if (spAuthnCtx == null) {
            spAuthnCtx = new DefaultSPAuthnContextMapper();
            SPCache.authCtxObjHash.put(hostEntityID + "|" + realm, spAuthnCtx);
        }
        return spAuthnCtx;
    }

    public static boolean verifyRequestIssuer(String realm, String hostEntity, Issuer reqIssuer, String requestId) throws SAML2Exception {
        boolean issuerValid = SAML2Utils.isSourceSiteValid(reqIssuer, realm, hostEntity);
        if (!issuerValid) {
            if (debug.messageEnabled()) {
                debug.message("SAML2Utils Issuer in Request is not valid.");
            }
            String[] data = new String[]{hostEntity, realm, requestId};
            LogUtil.error(Level.INFO, "INVALID_ISSUER_REQUEST", data, null);
            throw new SAML2Exception(bundle.getString("invalidIssuerInRequest"));
        }
        return issuerValid;
    }

    public static boolean verifyResponseIssuer(String realm, String hostEntity, Issuer resIssuer, String requestId) throws SAML2Exception {
        boolean issuerValid = SAML2Utils.isSourceSiteValid(resIssuer, realm, hostEntity);
        if (!issuerValid) {
            if (debug.messageEnabled()) {
                debug.message("SAML2Utils Issuer in Response is not valid.");
            }
            String[] data = new String[]{hostEntity, realm, requestId};
            LogUtil.error(Level.INFO, "INVALID_ISSUER_RESPONSE", data, null);
            throw new SAML2Exception(bundle.getString("invalidIssuerInResponse"));
        }
        return issuerValid;
    }

    public static String getReaderURL(String spMetaAlias) {
        String readerURL;
        block8: {
            String classMethod = "SAML2Utils:getReaderURL:";
            readerURL = null;
            try {
                String realm = SAML2MetaUtils.getRealmByMetaAlias(spMetaAlias);
                String spEntityID = saml2MetaManager.getEntityByMetaAlias(spMetaAlias);
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "metaAlias is :" + spMetaAlias);
                    debug.message(classMethod + "Realm is :" + realm);
                    debug.message(classMethod + "spEntityID is :" + spEntityID);
                }
                SPSSOConfigElement spEntityCfg = saml2MetaManager.getSPSSOConfig(realm, spEntityID);
                Map spConfigAttrsMap = null;
                if (spEntityCfg != null) {
                    spConfigAttrsMap = SAML2MetaUtils.getAttributes(spEntityCfg);
                    List cotList = (List)spConfigAttrsMap.get("cotlist");
                    String cotListStr = (String)cotList.iterator().next();
                    CircleOfTrustDescriptor cotDesc = cotManager.getCircleOfTrust(realm, cotListStr);
                    readerURL = cotDesc.getSAML2ReaderServiceURL();
                }
            }
            catch (COTException ce) {
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "Error retreiving circle of trust", (Throwable)((Object)ce));
                }
            }
            catch (SAML2Exception s2e) {
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "Error getting reader URL : ", (Throwable)((Object)s2e));
                }
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block8;
                debug.message(classMethod + "Error getting reader URL : ", (Throwable)e);
            }
        }
        return readerURL;
    }

    public static String getBaseURL(HttpServletRequest request) {
        int startIndex;
        String protocol = request.getScheme();
        String host = request.getHeader("Host");
        if (host == null) {
            host = request.getServerName() + ":" + request.getServerPort();
        }
        String baseURL = protocol + "://" + host + "/";
        String requestURL = request.getRequestURL().toString();
        String tmpurl = null;
        tmpurl = protocol.equals("http") ? requestURL.substring(8) : requestURL.substring(9);
        String deployDesc = tmpurl.substring(startIndex = tmpurl.indexOf("/") + 1);
        if (deployDesc != null && deployDesc.length() != 0) {
            baseURL = baseURL + deployDesc;
        }
        return baseURL;
    }

    public static String getPreferredIDP(HttpServletRequest request) {
        String idpList = request.getParameter("_saml_idp");
        String idpEntityID = null;
        if (idpList != null && idpList.length() > 0) {
            idpList = idpList.trim();
            StringTokenizer st = new StringTokenizer(idpList, " ");
            String preferredIDP = null;
            while (st.hasMoreTokens()) {
                preferredIDP = st.nextToken();
            }
            try {
                byte[] byteArray = Base64.decode((String)preferredIDP);
                idpEntityID = new String(byteArray);
            }
            catch (Exception e) {
                debug.message("Error decoding : ", (Throwable)e);
            }
        }
        return idpEntityID;
    }

    public static String getRedirectURL(String readerURL, String requestID, HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        sb.append(readerURL).append("?RelayState=");
        String baseURL = SAML2Utils.getBaseURL(request);
        StringBuffer retURL = new StringBuffer().append(baseURL);
        if (retURL.toString().indexOf("?") == -1) {
            retURL.append("?");
        } else {
            retURL.append("&");
        }
        retURL.append("requestID=").append(requestID);
        String retURLStr = URLEncDec.encode((String)retURL.toString());
        sb.append(retURLStr);
        String redirectURL = sb.toString();
        return redirectURL;
    }

    public static IDPAccountMapper getIDPAccountMapper(String realm, String idpEntityID) throws SAML2Exception {
        String classMethod = "SAML2Utils.getIDPAccountMapper: ";
        String idpAccountMapperName = null;
        IDPAccountMapper idpAccountMapper = null;
        try {
            idpAccountMapperName = SAML2Utils.getAttributeValueFromSSOConfig(realm, idpEntityID, "IDPRole", "idpAccountMapper");
            if (idpAccountMapperName == null) {
                idpAccountMapperName = "com.sun.identity.saml2.plugins.DefaultIDPAccountMapper";
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "use " + "com.sun.identity.saml2.plugins.DefaultIDPAccountMapper");
                }
            }
            if ((idpAccountMapper = (IDPAccountMapper)IDPCache.idpAccountMapperCache.get(idpAccountMapperName)) == null) {
                idpAccountMapper = (IDPAccountMapper)Class.forName(idpAccountMapperName).newInstance();
                IDPCache.idpAccountMapperCache.put(idpAccountMapperName, idpAccountMapper);
            } else if (debug.messageEnabled()) {
                debug.message(classMethod + "got the IDPAccountMapper from cache");
            }
        }
        catch (Exception ex) {
            debug.error(classMethod + "Unable to get IDP Account Mapper.", (Throwable)ex);
            throw new SAML2Exception(ex);
        }
        return idpAccountMapper;
    }

    public static SAML2ServiceProviderAdapter getSPAdapterClass(String spEntityID, String realm) throws SAML2Exception {
        String classMethod = "SAML2Utils.getSPAdapterClass: ";
        if (debug.messageEnabled()) {
            debug.message(classMethod + "get SPAdapter for " + spEntityID + " under realm " + realm);
        }
        String spAdapterClassName = null;
        SAML2ServiceProviderAdapter spAdapterClass = null;
        try {
            spAdapterClassName = SAML2Utils.getAttributeValueFromSSOConfig(realm, spEntityID, "SPRole", "spAdapter");
            if (debug.messageEnabled()) {
                debug.message(classMethod + "get SPAdapter class " + spAdapterClassName);
            }
            if (spAdapterClassName != null && spAdapterClassName.length() != 0) {
                spAdapterClass = (SAML2ServiceProviderAdapter)SPCache.spAdapterClassCache.get(realm + spEntityID + spAdapterClassName);
                if (spAdapterClass == null) {
                    spAdapterClass = (SAML2ServiceProviderAdapter)Class.forName(spAdapterClassName).newInstance();
                    List env = SAML2Utils.getAllAttributeValueFromSSOConfig(realm, spEntityID, "SPRole", "spAdapterEnv");
                    Map map = SAML2Utils.parseEnvList(env);
                    map.put("HOSTED_ENTITY_ID", spEntityID);
                    map.put("REALM", realm);
                    spAdapterClass.initialize(map);
                    SPCache.spAdapterClassCache.put(realm + spEntityID + spAdapterClassName, spAdapterClass);
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "create new SPAdapter " + spAdapterClassName + " for " + spEntityID + " under realm " + realm);
                    }
                } else if (debug.messageEnabled()) {
                    debug.message(classMethod + "got the SPAdapter " + spAdapterClassName + " from cache");
                }
            }
        }
        catch (InstantiationException ex) {
            debug.error(classMethod + "Unable to get SP Adapter class instance.", (Throwable)ex);
            throw new SAML2Exception(ex);
        }
        catch (ClassNotFoundException ex) {
            debug.error(classMethod + "SP Adapter class not found.", (Throwable)ex);
            throw new SAML2Exception(ex);
        }
        catch (IllegalAccessException ex) {
            debug.error(classMethod + "Unable to get SP Adapter class.", (Throwable)ex);
            throw new SAML2Exception(ex);
        }
        return spAdapterClass;
    }

    private static Map parseEnvList(List list) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (list == null || list.isEmpty()) {
            return map;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String val = (String)list.get(i);
            if (debug.messageEnabled()) {
                debug.message("SAML2Utils.parseEnvList : processing " + val);
            }
            if (val == null || val.length() == 0) continue;
            int pos = val.indexOf("=");
            if (pos == -1) {
                if (!debug.warningEnabled()) continue;
                debug.warning("SAML2Utils.parseEnvList : invalid value : " + val + ". Value must be in key=value format.");
                continue;
            }
            map.put(val.substring(0, pos), val.substring(pos + 1));
        }
        return map;
    }

    public static SPAccountMapper getSPAccountMapper(String realm, String spEntityID) throws SAML2Exception {
        String classMethod = "SAML2Utils.getSPAccountMapper: ";
        String spAccountMapperName = null;
        SPAccountMapper spAccountMapper = null;
        try {
            spAccountMapperName = SAML2Utils.getAttributeValueFromSSOConfig(realm, spEntityID, "SPRole", "spAccountMapper");
            if (spAccountMapperName == null) {
                spAccountMapperName = "com.sun.identity.saml2.plugins.DefaultSPAccountMapper";
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "use " + "com.sun.identity.saml2.plugins.DefaultSPAccountMapper");
                }
            }
            if ((spAccountMapper = (SPAccountMapper)SPCache.spAccountMapperCache.get(spAccountMapperName)) == null) {
                spAccountMapper = (SPAccountMapper)Class.forName(spAccountMapperName).newInstance();
                SPCache.spAccountMapperCache.put(spAccountMapperName, spAccountMapper);
            } else if (debug.messageEnabled()) {
                debug.message(classMethod + "got the SPAccountMapper from cache");
            }
        }
        catch (Exception ex) {
            debug.error(classMethod + "Unable to get SP Account Mapper.", (Throwable)ex);
            throw new SAML2Exception(ex);
        }
        return spAccountMapper;
    }

    public static SAML2IDPFinder getECPIDPFinder(String realm, String spEntityID) throws SAML2Exception {
        SAML2IDPFinder ecpRequestIDPListFinder;
        block7: {
            String classMethod = "SAML2Utils.getECPIDPFinder: ";
            String implClassName = null;
            ecpRequestIDPListFinder = null;
            try {
                implClassName = SAML2Utils.getAttributeValueFromSSOConfig(realm, spEntityID, "SPRole", "ECPRequestIDPListFinderImpl");
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "use " + implClassName);
                }
                if (implClassName == null || implClassName.trim().length() == 0) {
                    return null;
                }
                ecpRequestIDPListFinder = (SAML2IDPFinder)SPCache.ecpRequestIDPListFinderCache.get(implClassName);
                if (ecpRequestIDPListFinder == null) {
                    ecpRequestIDPListFinder = (SAML2IDPFinder)Class.forName(implClassName).newInstance();
                    SPCache.ecpRequestIDPListFinderCache.put(implClassName, ecpRequestIDPListFinder);
                } else if (debug.messageEnabled()) {
                    debug.message(classMethod + "got the ECP Request IDP List Finder from cache");
                }
            }
            catch (Exception ex) {
                if (!debug.warningEnabled()) break block7;
                debug.warning(classMethod + "Unable to get ECP Request IDP List Finder.", (Throwable)ex);
            }
        }
        return ecpRequestIDPListFinder;
    }

    public static String getRelayState(HttpServletRequest request) {
        String relayState = request.getParameter("RelayState");
        if (relayState == null || relayState.length() == 0) {
            String relayStateAlias = request.getParameter("RelayStateAlias");
            if (relayStateAlias != null && relayStateAlias.length() > 0) {
                String tmp;
                StringTokenizer st = new StringTokenizer(relayStateAlias, "|");
                while (st.hasMoreTokens() && ((relayState = request.getParameter(tmp = st.nextToken())) == null || relayState.length() <= 0)) {
                }
            }
            if (relayState == null) {
                relayState = request.getParameter("goto");
            }
        }
        return relayState;
    }

    public static boolean verifyDestination(String destination, String location) {
        return location != null && location.length() != 0 && destination != null && destination.length() != 0 && location.equalsIgnoreCase(destination);
    }

    public static Map getSAEAttrs(String realm, String entityId, String role, String appUrl) {
        if (appUrl == null || appUrl.length() == 0) {
            return null;
        }
        try {
            IDPSSOConfigElement idpConfig = null;
            SPSSOConfigElement spConfig = null;
            Map attrs = null;
            if (role.equalsIgnoreCase("SPRole")) {
                spConfig = saml2MetaManager.getSPSSOConfig(realm, entityId);
                if (spConfig == null) {
                    return null;
                }
                attrs = SAML2MetaUtils.getAttributes(spConfig);
            } else {
                idpConfig = saml2MetaManager.getIDPSSOConfig(realm, entityId);
                if (idpConfig == null) {
                    debug.message("SAML2Utils.getSAEAttrs: idpconfig is null");
                    return null;
                }
                attrs = SAML2MetaUtils.getAttributes(idpConfig);
            }
            if (attrs == null) {
                debug.message("SAML2Utils.getSAEAttrs: no extended attrs");
                return null;
            }
            List values = (List)attrs.get("saeAppSecretList");
            if (values != null && values.size() != 0) {
                Iterator iter = values.iterator();
                while (iter.hasNext()) {
                    String value = (String)iter.next();
                    if (debug.messageEnabled()) {
                        debug.message("SAML2Utils.getSAEAttrs: value=" + value);
                    }
                    StringTokenizer st = new StringTokenizer(value, "|");
                    HashMap<String, String> hp = null;
                    while (st.hasMoreTokens()) {
                        String tok = st.nextToken();
                        int idx = tok.indexOf("=");
                        String name = tok.substring(0, idx);
                        String val = tok.substring(idx + 1, tok.length());
                        if (debug.messageEnabled()) {
                            debug.message("SAML2Utils.getSAEAttrs: tok:name=" + name + " val=" + val);
                        }
                        if ("url".equals(name)) {
                            if (!appUrl.startsWith(val)) break;
                            hp = new HashMap<String, String>();
                        } else if ("secret".equals(name)) {
                            val = SAMLUtilsCommon.decodePassword(val);
                        }
                        hp.put(name, val);
                    }
                    if (hp == null) continue;
                    String alias = SAML2Utils.getSigningCertAlias(realm, entityId, role);
                    if (alias != null) {
                        hp.put("privatekeyalias", alias);
                    }
                    if (debug.messageEnabled()) {
                        debug.message("SAML2Utils.getSAEAttrs: PKEY=" + alias + ":");
                    }
                    return hp;
                }
            }
        }
        catch (SAML2MetaException e) {
            debug.message("get SSOConfig failed:", (Throwable)((Object)e));
        }
        return null;
    }

    public static String getNameIDStringFromResponse(Response response) {
        NameID nameID;
        Assertion assertion;
        Subject subject;
        List assertions;
        if (response != null && (assertions = response.getAssertion()) != null && assertions.size() > 0 && (subject = (assertion = (Assertion)assertions.get(0)).getSubject()) != null && (nameID = subject.getNameID()) != null) {
            return nameID.getValue();
        }
        return null;
    }

    public static void logAccess(Level lvl, String msgid, String[] data, Object tok, String ipaddr, String userid, String org, String module, Map props) {
        Map accProps = SAML2Utils.accumulateLogProps(ipaddr, userid, org, module, props);
        LogUtil.access(lvl, msgid, data, tok, accProps);
    }

    public static void logError(Level lvl, String msgid, String[] data, Object tok, String ipaddr, String userid, String org, String module, Map props) {
        Map accProps = SAML2Utils.accumulateLogProps(ipaddr, userid, org, module, props);
        LogUtil.error(lvl, msgid, data, tok, accProps);
    }

    private static Map accumulateLogProps(String ipaddr, String userid, String org, String module, Map props) {
        if (props == null) {
            props = new HashMap<String, String>();
        }
        if (ipaddr != null) {
            props.put("IPAddr", ipaddr);
        }
        if (userid != null) {
            props.put("LoginID", userid);
        }
        if (org != null) {
            props.put("Domain", org);
        }
        if (module != null) {
            props.put("ModuleName", module);
        }
        return props;
    }

    public static String getAttributeValueFromXACMLConfig(String realm, String entityRole, String entityID, String attrName) {
        String method = "SAML2Utils:getAttributeValueFromXACMLConfig : ";
        if (debug.messageEnabled()) {
            debug.message(method + "realm - " + realm);
            debug.message(method + "EntityId - " + entityID);
            debug.message(method + "entityRole - " + entityRole);
            debug.message(method + "attrName - " + attrName);
        }
        String result = null;
        try {
            List value;
            XACMLAuthzDecisionQueryConfigElement pepConfig = null;
            XACMLPDPConfigElement pdpConfig = null;
            Map attrs = null;
            if (entityRole.equalsIgnoreCase("PEPRole")) {
                pepConfig = saml2MetaManager.getPolicyEnforcementPointConfig(realm, entityID);
                if (pepConfig != null) {
                    attrs = SAML2MetaUtils.getAttributes(pepConfig);
                }
            } else {
                pdpConfig = saml2MetaManager.getPolicyDecisionPointConfig(realm, entityID);
                if (pdpConfig != null) {
                    attrs = SAML2MetaUtils.getAttributes(pdpConfig);
                }
            }
            if (attrs != null && (value = (List)attrs.get(attrName)) != null && value.size() != 0) {
                result = (String)value.get(0);
            }
        }
        catch (SAML2MetaException e) {
            debug.message("Retreiving XACML Config failed:", (Throwable)((Object)e));
        }
        if (debug.messageEnabled()) {
            debug.message("Attribute value is : " + result);
        }
        return result;
    }

    public static boolean getWantXACMLAuthzDecisionQuerySigned(String realm, String entityID, String entityRole) {
        String wantSigned;
        if (debug.messageEnabled()) {
            String method = "getWantArtifactResponseSigned : ";
            debug.message(method + "realm - " + realm);
            debug.message(method + "entityID - " + entityID);
            debug.message(method + "entityRole - " + entityRole);
        }
        if ((wantSigned = SAML2Utils.getAttributeValueFromXACMLConfig(realm, entityID, entityRole, "wantXACMLAuthzDecisionQuerySigned")) == null) {
            wantSigned = "false";
        }
        return wantSigned.equalsIgnoreCase("true");
    }

    public static boolean validateCertificate(X509Certificate cert) {
        String method = "validateCertificate : ";
        boolean certgood = true;
        if (!checkCertStatus) {
            if (debug.messageEnabled()) {
                debug.message(method + " CRL check is not configured. Just return it is good.");
            }
            certgood = true;
            return true;
        }
        certgood = CRLValidator.validateCertificate((X509Certificate)cert, (boolean)checkCAStatus);
        if (debug.messageEnabled()) {
            debug.message(method + " certificate is validated to " + certgood);
        }
        return certgood;
    }

    public static Map getConfigAttributeMap(String realm, String hostEntityID, String role) throws SAML2Exception {
        if (realm == null) {
            throw new SAML2Exception(bundle.getString("nullRealm"));
        }
        if (hostEntityID == null) {
            throw new SAML2Exception(bundle.getString("nullHostEntityID"));
        }
        if (debug.messageEnabled()) {
            debug.message("SAML2Utils.getConfigAttributeMap: DefaultAttrMapper: relam=" + realm + ", entity id=" + hostEntityID + ", role=" + role);
        }
        try {
            BaseConfigType config = null;
            if (role.equals("SPRole")) {
                config = saml2MetaManager.getSPSSOConfig(realm, hostEntityID);
            } else if (role.equals("IDPRole")) {
                config = saml2MetaManager.getIDPSSOConfig(realm, hostEntityID);
            }
            if (config == null) {
                if (debug.warningEnabled()) {
                    debug.warning("SAML2Utils.getConfigAttributeMap: configuration is not defined.");
                }
                return Collections.EMPTY_MAP;
            }
            Map attribConfig = SAML2MetaUtils.getAttributes(config);
            List mappedAttributes = (List)attribConfig.get("attributeMap");
            if (mappedAttributes == null || mappedAttributes.size() == 0) {
                if (debug.messageEnabled()) {
                    debug.message("SAML2Utils.getConfigAttributeMap:Attribute map is not defined for entity: " + hostEntityID);
                }
                return Collections.EMPTY_MAP;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator iter = mappedAttributes.iterator();
            while (iter.hasNext()) {
                String entry = (String)iter.next();
                if (entry.indexOf("=") == -1) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("SAML2Utils.getConfigAttributeMap: Invalid entry." + entry);
                    continue;
                }
                StringTokenizer st = new StringTokenizer(entry, "=");
                map.put(st.nextToken(), st.nextToken());
            }
            return map;
        }
        catch (SAML2MetaException sme) {
            debug.error("SAML2Utils.getConfigAttributeMap: ", (Throwable)((Object)sme));
            throw new SAML2Exception(sme.getMessage());
        }
    }

    public static Attribute getSAMLAttribute(String name, String[] values) throws SAML2Exception {
        if (name == null) {
            throw new SAML2Exception(bundle.getString("nullInput"));
        }
        AssertionFactory factory = AssertionFactory.getInstance();
        Attribute attribute = factory.createAttribute();
        attribute.setName(name);
        attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        if (values != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < values.length; ++i) {
                list.add(XMLUtils.escapeSpecialCharacters((String)values[i]));
            }
            attribute.setAttributeValueString(list);
        }
        return attribute;
    }

    public static void postToTarget(HttpServletResponse response, String SAMLmessageName, String SAMLmessageValue, String relayStateName, String relayStateValue, String targetURL) throws IOException {
        PrintWriter out = response.getWriter();
        out.println("<HTML>");
        out.println("<HEAD>\n");
        out.println("<TITLE>Access rights validated</TITLE>\n");
        out.println("</HEAD>\n");
        out.println("<BODY Onload=\"document.forms[0].submit()\">");
        out.println("<FORM METHOD=\"POST\" ACTION=\"" + targetURL + "\">");
        out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"" + SAMLmessageName + "\" " + "VALUE=\"" + SAMLmessageValue + "\">");
        if (relayStateValue != null && relayStateValue.length() != 0) {
            out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"" + relayStateName + "\" " + "VALUE=\"" + relayStateValue + "\">");
        }
        out.println("</FORM></BODY></HTML>");
        out.close();
    }

    public static String verifyNameIDFormat(String nameIDFormat, SPSSODescriptorElement spsso, IDPSSODescriptorElement idpsso) throws SAML2Exception {
        List spNameIDFormatList = spsso.getNameIDFormat();
        if (spNameIDFormatList.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("SAML2Utils.verifyNameIDFormat: NameIDFormat not supported by SP: " + nameIDFormat);
            }
            Object[] args = new Object[]{nameIDFormat};
            throw new SAML2Exception("libSAML2", "unsupportedNameIDFormatSP", args);
        }
        List idpNameIDFormatList = idpsso.getNameIDFormat();
        if (idpNameIDFormatList.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("SAML2Utils.verifyNameIDFormat: NameIDFormat not supported by IDP: " + nameIDFormat);
            }
            Object[] args = new Object[]{nameIDFormat};
            throw new SAML2Exception("libSAML2", "unsupportedNameIDFormatIDP", args);
        }
        if (nameIDFormat == null || nameIDFormat.length() == 0) {
            nameIDFormat = null;
            Iterator iter = spNameIDFormatList.iterator();
            while (iter.hasNext()) {
                String spNameIDFormat = (String)iter.next();
                if (!idpNameIDFormatList.contains(spNameIDFormat)) continue;
                nameIDFormat = spNameIDFormat;
                break;
            }
            if (nameIDFormat == null) {
                throw new SAML2Exception(bundle.getString("unsupportedNameIDFormatIDPSP"));
            }
        } else {
            if (nameIDFormat.equals("persistent") || nameIDFormat.equals("transient")) {
                nameIDFormat = "urn:oasis:names:tc:SAML:2.0:nameid-format:" + nameIDFormat;
            }
            if (!spNameIDFormatList.contains(nameIDFormat)) {
                if (debug.messageEnabled()) {
                    debug.message("SAML2Utils.verifyNameIDFormat: NameIDFormat not supported by SP: " + nameIDFormat);
                }
                Object[] args = new Object[]{nameIDFormat};
                throw new SAML2Exception("libSAML2", "unsupportedNameIDFormatSP", args);
            }
            if (!idpNameIDFormatList.contains(nameIDFormat)) {
                if (debug.messageEnabled()) {
                    debug.message("SAML2Utils.verifyNameIDFormat: NameIDFormat not supported by IDP: " + nameIDFormat);
                }
                Object[] args = new Object[]{nameIDFormat};
                throw new SAML2Exception("libSAML2", "unsupportedNameIDFormatIDP", args);
            }
        }
        return nameIDFormat;
    }

    public static boolean isAuthnContextMatching(List requestedACClassRefs, String acClassRef, String comparison, Map acClassRefLevelMap) {
        Integer levelInt = (Integer)acClassRefLevelMap.get(acClassRef);
        if (levelInt == null) {
            if (debug.messageEnabled()) {
                debug.message("SAML2Utils.isAuthnContextMatching: AuthnContextClassRef " + acClassRef + " is not supported.");
            }
            return false;
        }
        int level = levelInt;
        if (comparison == null || comparison.length() == 0 || comparison.equals("exact")) {
            Iterator iter = requestedACClassRefs.iterator();
            while (iter.hasNext()) {
                String requstedACClassRef = (String)iter.next();
                if (!requstedACClassRef.equals(acClassRef)) continue;
                return true;
            }
            return false;
        }
        if (debug.messageEnabled()) {
            debug.message("SAML2Utils.isAuthnContextMatching: acClassRef = " + acClassRef + ", level = " + level + ", comparison = " + comparison);
        }
        if (comparison.equals("minimum")) {
            Iterator iter = requestedACClassRefs.iterator();
            while (iter.hasNext()) {
                int requestedLevel;
                String requstedACClassRef = (String)iter.next();
                Integer requestedLevelInt = (Integer)acClassRefLevelMap.get(requstedACClassRef);
                int n = requestedLevel = requestedLevelInt == null ? 0 : requestedLevelInt;
                if (debug.messageEnabled()) {
                    debug.message("SAML2Utils.isAuthnContextMatching: requstedACClassRef = " + requstedACClassRef + ", level = " + requestedLevel);
                }
                if (level < requestedLevel) continue;
                return true;
            }
            return false;
        }
        if (comparison.equals("better")) {
            Iterator iter = requestedACClassRefs.iterator();
            while (iter.hasNext()) {
                int requestedLevel;
                String requstedACClassRef = (String)iter.next();
                Integer requestedLevelInt = (Integer)acClassRefLevelMap.get(requstedACClassRef);
                int n = requestedLevel = requestedLevelInt == null ? 0 : requestedLevelInt;
                if (debug.messageEnabled()) {
                    debug.message("SAML2Utils.isAuthnContextMatching: requstedACClassRef = " + requstedACClassRef + ", level = " + requestedLevel);
                }
                if (level > requestedLevel) continue;
                return false;
            }
            return true;
        }
        if (comparison.equals("maximum")) {
            Iterator iter = requestedACClassRefs.iterator();
            while (iter.hasNext()) {
                int requestedLevel;
                String requstedACClassRef = (String)iter.next();
                Integer requestedLevelInt = (Integer)acClassRefLevelMap.get(requstedACClassRef);
                int n = requestedLevel = requestedLevelInt == null ? 0 : requestedLevelInt;
                if (debug.messageEnabled()) {
                    debug.message("SAML2Utils.isAuthnContextMatching: requstedACClassRef = " + requstedACClassRef + ", level = " + requestedLevel);
                }
                if (level > requestedLevel) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    static {
        String enableFailOver;
        saml2MetaManager = null;
        cotManager = null;
        keyProvider = KeyUtil.getKeyProviderInstance();
        server_protocol = SystemPropertiesManager.get((String)"com.iplanet.am.server.protocol");
        server_host = SystemPropertiesManager.get((String)"com.iplanet.am.server.host");
        server_port = SystemPropertiesManager.get((String)"com.iplanet.am.server.port");
        server_uri = SystemPropertiesManager.get((String)"com.iplanet.am.services.deploymentDescriptor");
        localURL = server_protocol + "://" + server_host + ":" + server_port + server_uri;
        int_server_port = 0;
        scf = null;
        bufferLen = (String)SAML2ConfigService.getAttribute("bufferLength");
        checkCertStatus = false;
        checkCAStatus = false;
        failOver = false;
        jmq = null;
        try {
            scf = SOAPConnectionFactory.newInstance();
        }
        catch (SOAPException se) {
            debug.error("Unable to obtain SOAPConnectionFactory.", (Throwable)se);
        }
        try {
            int_server_port = Integer.parseInt(server_port);
        }
        catch (NumberFormatException nfe) {
            debug.error("Unable to parse port " + server_port, (Throwable)nfe);
        }
        String checkCertStatusStr = SystemConfigurationUtil.getProperty("com.sun.identity.saml2.crl.check", null);
        if (checkCertStatusStr != null) {
            checkCertStatus = Boolean.valueOf(checkCertStatusStr);
            checkCAStatus = Boolean.valueOf(SystemConfigurationUtil.getProperty("com.sun.identity.saml2.crl.check.ca", "false"));
            if (debug.messageEnabled()) {
                debug.message("SAML2 :  CRL check is configured to " + checkCertStatus);
                debug.message("SAML2 :  CRL check for CA is configured to " + checkCAStatus);
            }
        } else {
            checkCertStatus = CRLValidator.isCRLCheckEnabled();
            if (debug.messageEnabled()) {
                debug.message("SAML2 : CRL check is configured with old config style.");
            }
        }
        try {
            jmq = (JMQSAML2Repository)Class.forName("com.sun.identity.saml2.plugins.DefaultJMQSAML2Repository").newInstance();
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("JMQSAML2Repository is not available.");
            }
            jmq = null;
        }
        mf = null;
        try {
            mf = MessageFactory.newInstance();
        }
        catch (SOAPException se) {
            debug.error("SAML2Utils: Unable to create SOAP MessageFactory", (Throwable)se);
        }
        try {
            saml2MetaManager = new SAML2MetaManager();
        }
        catch (SAML2MetaException sme) {
            debug.error("Error retreiving metadata", (Throwable)((Object)sme));
        }
        try {
            cotManager = new CircleOfTrustManager();
        }
        catch (COTException sme) {
            debug.error("Error retreiving COT ", (Throwable)((Object)sme));
        }
        if (SystemConfigurationUtil.isServerMode()) {
            CacheCleanUpScheduler.doSchedule();
        }
        if ((enableFailOver = (String)SAML2ConfigService.getAttribute("failOverEnabled")) != null && enableFailOver.equalsIgnoreCase("true") && jmq != null) {
            failOver = true;
        }
        af = AssertionFactory.getInstance();
        randomGenerator = new SecureRandom();
    }
}

