/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.plugins;

import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.Attribute;
import com.sun.identity.saml2.assertion.AttributeStatement;
import com.sun.identity.saml2.assertion.EncryptedAttribute;
import com.sun.identity.saml2.assertion.EncryptedID;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.plugins.DefaultAccountMapper;
import com.sun.identity.saml2.plugins.DefaultSPAttributeMapper;
import com.sun.identity.saml2.plugins.SPAccountMapper;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultLibrarySPAccountMapper
extends DefaultAccountMapper
implements SPAccountMapper {
    private PrivateKey decryptionKey = null;

    public DefaultLibrarySPAccountMapper() {
        debug.message("DefaultLibrarySPAccountMapper.constructor: ");
        this.role = "SPRole";
    }

    public String getIdentity(Assertion assertion, String hostEntityID, String realm) throws SAML2Exception {
        if (assertion == null) {
            throw new SAML2Exception(bundle.getString("nullAssertion"));
        }
        if (hostEntityID == null) {
            throw new SAML2Exception(bundle.getString("nullHostEntityID"));
        }
        if (realm == null) {
            throw new SAML2Exception(bundle.getString("nullRealm"));
        }
        NameID nameID = null;
        EncryptedID encryptedID = assertion.getSubject().getEncryptedID();
        if (encryptedID != null) {
            this.decryptionKey = KeyUtil.getDecryptionKey(SAML2Utils.getSAML2MetaManager().getSPSSOConfig(realm, hostEntityID));
            nameID = encryptedID.decrypt(this.decryptionKey);
        } else {
            nameID = assertion.getSubject().getNameID();
        }
        String userID = null;
        String format = nameID.getFormat();
        boolean transientFormat = false;
        if (format != null && format.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:transient")) {
            transientFormat = true;
            userID = this.getTransientUser(realm, hostEntityID);
        }
        if (userID != null && userID.length() != 0) {
            return userID;
        }
        if (!transientFormat) {
            String remoteEntityID = assertion.getIssuer().getValue();
            if (debug.messageEnabled()) {
                debug.message("DefaultLibrarySPAccountMapper.getIdentity(Assertion): realm = " + realm + " hostEntityID = " + hostEntityID);
            }
            try {
                userID = dsProvider.getUserID(realm, SAML2Utils.getNameIDKeyMap(nameID, hostEntityID, remoteEntityID, realm, this.role));
            }
            catch (DataStoreProviderException dse) {
                debug.error("DefaultLibrarySPAccountMapper.getIdentity(Assertion): DataStoreProviderException", (Throwable)((Object)dse));
                throw new SAML2Exception(dse.getMessage());
            }
            if (userID != null) {
                return userID;
            }
        }
        return this.getAutoFedUser(realm, hostEntityID, assertion);
    }

    protected String getTransientUser(String realm, String entityID) {
        return this.getAttribute(realm, entityID, "transientUser");
    }

    protected String getAutoFedUser(String realm, String entityID, Assertion assertion) throws SAML2Exception {
        block18: {
            String autoFedMapAttribute;
            AttributeStatement statement;
            List attributeStatements = assertion.getAttributeStatements();
            if (attributeStatements == null || attributeStatements.size() == 0) {
                if (debug.messageEnabled()) {
                    debug.message("DefaultLibrarySPAccountMapper.getAutoFedUser: Assertion does not have attribute statements.");
                }
                return null;
            }
            String autoFedEnable = this.getAttribute(realm, entityID, "autofedEnabled");
            if (autoFedEnable == null || autoFedEnable.equals("false")) {
                if (debug.messageEnabled()) {
                    debug.message("DefaultLibrarySPAccountMapper.getAutoFedUser: Auto federation is disabled.");
                }
                return null;
            }
            String autoFedAttribute = this.getAttribute(realm, entityID, "autofedAttribute");
            if (autoFedAttribute == null || autoFedAttribute.length() == 0) {
                if (debug.messageEnabled()) {
                    debug.message("DefaultLibrarySPAccountMapper.getAutoFedUser: Auto federation attribute is not configured.");
                }
                return null;
            }
            Set autoFedAttributeValue = null;
            Iterator iter = attributeStatements.iterator();
            while (iter.hasNext() && ((autoFedAttributeValue = this.getAttribute(statement = (AttributeStatement)iter.next(), autoFedAttribute, realm, entityID)) == null || autoFedAttributeValue.isEmpty())) {
            }
            if (autoFedAttributeValue == null || autoFedAttributeValue.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("DefaultLibrarySPAccountMapper.getAutoFedUser: Auto federation attribute is not specified in the assertion.");
                }
                return null;
            }
            DefaultSPAttributeMapper attributeMapper = new DefaultSPAttributeMapper();
            Map attributeMap = attributeMapper.getConfigAttributeMap(realm, entityID, "SPRole");
            if (attributeMap == null && attributeMap.isEmpty() && debug.messageEnabled()) {
                debug.message("DefaultLibrarySPAccountMapper.getAutoFedUser: attribute map is not configured.");
            }
            if ((autoFedMapAttribute = (String)attributeMap.get(autoFedAttribute)) == null) {
                if (debug.messageEnabled()) {
                    debug.message("DefaultLibrarySPAccountMapper.getAutoFedUser: Auto federation attribute map is not specified in config.");
                }
                return null;
            }
            try {
                String userId;
                HashMap<String, Set> map = new HashMap<String, Set>();
                map.put(autoFedMapAttribute, autoFedAttributeValue);
                if (debug.messageEnabled()) {
                    debug.message("DefaultLibrarySPAccountMapper.getAutoFedUser: Search map: " + map);
                }
                if ((userId = dsProvider.getUserID(realm, map)) != null && userId.length() != 0) {
                    return userId;
                }
                if (this.isDynamicalOrIgnoredProfile(realm)) {
                    if (debug.messageEnabled()) {
                        debug.message("DefaultLibrarySPAccountMapper: dynamical user creation or ignore profile enabled : uid=" + autoFedAttributeValue);
                    }
                    return (String)autoFedAttributeValue.iterator().next();
                }
            }
            catch (DataStoreProviderException dse) {
                if (!debug.warningEnabled()) break block18;
                debug.warning("DefaultLibrarySPAccountMapper.getAutoFedUser: Datastore provider exception", (Throwable)((Object)dse));
            }
        }
        return null;
    }

    protected boolean isDynamicalOrIgnoredProfile(String realm) {
        return true;
    }

    private Set getAttribute(AttributeStatement statement, String attributeName, String realm, String hostEntityID) {
        if (debug.messageEnabled()) {
            debug.message("DefaultLibrarySPAccountMapper.getAttribute: attributeName =" + attributeName);
        }
        ArrayList list = statement.getAttribute();
        List encList = statement.getEncryptedAttribute();
        if (encList != null && encList.size() != 0) {
            ArrayList allList = new ArrayList();
            if (list != null && !list.isEmpty()) {
                allList.addAll(list);
            }
            list = allList;
            Iterator encIter = encList.iterator();
            while (encIter.hasNext()) {
                try {
                    if (this.decryptionKey == null) {
                        this.decryptionKey = KeyUtil.getDecryptionKey(SAML2Utils.getSAML2MetaManager().getSPSSOConfig(realm, hostEntityID));
                    }
                    list.add(((EncryptedAttribute)encIter.next()).decrypt(this.decryptionKey));
                }
                catch (SAML2Exception se) {
                    debug.error("Decryption error:", (Throwable)((Object)se));
                    return null;
                }
            }
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Attribute attribute = (Attribute)iter.next();
            if (!attributeName.equalsIgnoreCase(attribute.getName())) continue;
            List values = attribute.getAttributeValueString();
            if (values == null || values.size() == 0) {
                return null;
            }
            HashSet set = new HashSet();
            set.addAll(values);
            return set;
        }
        return null;
    }
}

