/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.logging.LogUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.profile.IDPSSOUtil;
import com.sun.identity.saml2.profile.SPSSOFederate;
import com.sun.identity.saml2.protocol.Artifact;
import com.sun.identity.saml2.protocol.ArtifactResolve;
import com.sun.identity.saml2.protocol.ArtifactResponse;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.Response;
import com.sun.identity.saml2.protocol.Status;
import com.sun.identity.saml2.protocol.StatusCode;
import com.sun.identity.shared.datastruct.OrderedSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;

public class IDPArtifactResolution {
    static MessageFactory messageFactory = null;

    private IDPArtifactResolution() {
    }

    public static void doArtifactResolution(HttpServletRequest request, HttpServletResponse response) {
        block13: {
            String classMethod = "IDPArtifactResolution.doArtifactResolution: ";
            try {
                String idpMetaAlias = request.getParameter("metaAlias");
                if (idpMetaAlias == null || idpMetaAlias.trim().length() == 0) {
                    idpMetaAlias = SAML2MetaUtils.getMetaAliasByUri(request.getRequestURI());
                }
                if (idpMetaAlias == null || idpMetaAlias.trim().length() == 0) {
                    if (SAML2Utils.debug.messageEnabled()) {
                        SAML2Utils.debug.message(classMethod + "unable to get IDP meta alias from request.");
                    }
                    String[] data = new String[]{idpMetaAlias};
                    LogUtil.error(Level.INFO, "IDP_METADATA_ERROR", data, null);
                    response.sendError(500, SAML2Utils.bundle.getString("nullIDPMetaAlias"));
                    return;
                }
                String idpEntityID = null;
                String realm = null;
                try {
                    idpEntityID = IDPSSOUtil.metaManager.getEntityByMetaAlias(idpMetaAlias);
                    if (idpEntityID == null || idpEntityID.trim().length() == 0) {
                        SAML2Utils.debug.error(classMethod + "Unable to get IDP Entity ID from meta.");
                        String[] data = new String[]{idpEntityID};
                        LogUtil.error(Level.INFO, "INVALID_IDP", data, null);
                        response.sendError(500, SAML2Utils.bundle.getString("nullIDPEntityID"));
                        return;
                    }
                    realm = SAML2MetaUtils.getRealmByMetaAlias(idpMetaAlias);
                }
                catch (SAML2MetaException sme) {
                    SAML2Utils.debug.error(classMethod + "Unable to get IDP Entity ID from meta.");
                    String[] data = new String[]{idpMetaAlias};
                    LogUtil.error(Level.INFO, "IDP_METADATA_ERROR", data, null);
                    response.sendError(500, SAML2Utils.bundle.getString("metaDataError"));
                    return;
                }
                try {
                    MimeHeaders headers = IDPArtifactResolution.getHeaders(request);
                    ServletInputStream is = request.getInputStream();
                    SOAPMessage msg = messageFactory.createMessage(headers, (InputStream)is);
                    SOAPMessage reply = null;
                    reply = IDPArtifactResolution.onMessage(msg, request, realm, idpEntityID);
                    if (reply != null) {
                        if (reply.saveRequired()) {
                            reply.saveChanges();
                        }
                        response.setStatus(200);
                        IDPArtifactResolution.putHeaders(reply.getMimeHeaders(), response);
                        ServletOutputStream outputStream = response.getOutputStream();
                        reply.writeTo((OutputStream)outputStream);
                        outputStream.flush();
                        break block13;
                    }
                    response.setStatus(204);
                }
                catch (SOAPException ex) {
                    SAML2Utils.debug.error(classMethod + "SOAP error", (Throwable)ex);
                    String[] data = new String[]{idpEntityID};
                    LogUtil.error(Level.INFO, "INVALID_SOAP_MESSAGE", data, null);
                    response.sendError(500, SAML2Utils.bundle.getString("invalidSOAPMessage"));
                }
                catch (SAML2Exception se) {
                    SAML2Utils.debug.error(classMethod + "SAML2 error", (Throwable)((Object)se));
                    response.sendError(500, SAML2Utils.bundle.getString("unableToCreateArtifactResponse"));
                }
            }
            catch (IOException ioe) {
                SAML2Utils.debug.error(classMethod + "I/O rrror", (Throwable)ioe);
            }
        }
    }

    public static SOAPMessage onMessage(SOAPMessage message, HttpServletRequest request, String realm, String idpEntityID) throws SAML2Exception {
        boolean signAssertion;
        Artifact art;
        String classMethod = "IDPArtifactResolution.onMessage: ";
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "Entering onMessage().");
        }
        Element reqElem = SAML2Utils.getSamlpElement(message, "ArtifactResolve");
        ArtifactResolve artResolve = ProtocolFactory.getInstance().createArtifactResolve(reqElem);
        if (artResolve == null) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "no valid ArtifactResolve node found in SOAP body.");
            }
            return SAML2Utils.createSOAPFault("Client", "noArtifactResolve", null);
        }
        String spEntityID = artResolve.getIssuer().getValue();
        SPSSODescriptorElement spSSODescriptor = null;
        try {
            spSSODescriptor = IDPSSOUtil.metaManager.getSPSSODescriptor(realm, spEntityID);
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error(classMethod, (Throwable)((Object)sme));
            spSSODescriptor = null;
        }
        if (spSSODescriptor == null) {
            SAML2Utils.debug.error(classMethod + "Unable to get SP SSO Descriptor from meta.");
            return SAML2Utils.createSOAPFault("Server", "metaDataError", null);
        }
        OrderedSet acsSet = SPSSOFederate.getACSUrl(spSSODescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact");
        String acsURL = (String)acsSet.get(0);
        String protocolBinding = (String)acsSet.get(1);
        String isArtifactResolveSigned = SAML2Utils.getAttributeValueFromSSOConfig(realm, idpEntityID, "IDPRole", "wantArtifactResolveSigned");
        if (isArtifactResolveSigned != null && isArtifactResolveSigned.equals("true")) {
            if (!artResolve.isSigned()) {
                SAML2Utils.debug.error(classMethod + "The artifact resolve is not signed " + "when it is expected to be signed.");
                return SAML2Utils.createSOAPFault("Client", "ArtifactResolveNotSigned", null);
            }
            X509Certificate spCert = KeyUtil.getVerificationCert(spSSODescriptor, spEntityID, "SPRole");
            if (!artResolve.isSignatureValid(spCert)) {
                SAML2Utils.debug.error(classMethod + "artifact resolve verification failed.");
                return SAML2Utils.createSOAPFault("Client", "invalidArtifact", null);
            }
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "artifact resolve signature verification is successful.");
            }
        }
        if ((art = artResolve.getArtifact()) == null) {
            SAML2Utils.debug.error(classMethod + "Unable to get an artifact from ArtifactResolve.");
            return SAML2Utils.createSOAPFault("Client", "invalidArtifactSignature", null);
        }
        String artStr = art.getArtifactValue();
        Response res = (Response)IDPCache.responsesByArtifacts.remove((Object)artStr);
        String remoteArtURL = null;
        if (res == null) {
            block34: {
                String remoteServiceURL = SAML2Utils.getRemoteServiceURL(art.getMessageHandle());
                if (remoteServiceURL != null) {
                    remoteArtURL = remoteServiceURL + SAML2Utils.removeDeployUri(request.getRequestURI());
                    try {
                        SOAPConnection con = SAML2Utils.scf.createConnection();
                        SOAPMessage resMsg = con.call(message, (Object)remoteArtURL);
                        return resMsg;
                    }
                    catch (Exception ex) {
                        if (!SAML2Utils.debug.messageEnabled()) break block34;
                        SAML2Utils.debug.message(classMethod + "unable to forward request to remote server. " + "remote url = " + remoteArtURL, (Throwable)ex);
                    }
                }
            }
            try {
                if (SAML2Utils.failOver) {
                    if (SAML2Utils.debug.messageEnabled()) {
                        SAML2Utils.debug.message("Artifact=" + artStr);
                    }
                    String tmp = (String)SAML2Utils.jmq.retrieve(artStr);
                    res = ProtocolFactory.getInstance().createResponse(tmp);
                }
            }
            catch (Exception e) {
                SAML2Utils.debug.error(classMethod + "DB ERROR!!!");
            }
        }
        if (res == null) {
            return SAML2Utils.createSOAPFault("Server", "UnableToFindResponse", null);
        }
        try {
            if (SAML2Utils.failOver) {
                SAML2Utils.jmq.delete(artStr);
            }
        }
        catch (Exception e) {
            SAML2Utils.debug.error(classMethod + "DB ERROR!!!");
        }
        HashMap<String, String> props = new HashMap<String, String>();
        String nameIDString = SAML2Utils.getNameIDStringFromResponse(res);
        if (nameIDString != null) {
            props.put("NameID", nameIDString);
        }
        if ((signAssertion = spSSODescriptor.isWantAssertionsSigned()) && SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "signing the assertion.");
        }
        IDPSSOUtil.signAndEncryptResponseComponents(realm, spEntityID, idpEntityID, res, signAssertion);
        ArtifactResponse artResponse = ProtocolFactory.getInstance().createArtifactResponse();
        Status status = ProtocolFactory.getInstance().createStatus();
        StatusCode statusCode = ProtocolFactory.getInstance().createStatusCode();
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        status.setStatusCode(statusCode);
        Issuer issuer = AssertionFactory.getInstance().createIssuer();
        issuer.setValue(idpEntityID);
        artResponse.setStatus(status);
        artResponse.setID(SAML2Utils.generateID());
        artResponse.setInResponseTo(artResolve.getID());
        artResponse.setVersion("2.0");
        artResponse.setIssueInstant(new Date());
        artResponse.setAny(res.toXMLString(true, true));
        artResponse.setIssuer(issuer);
        artResponse.setDestination(acsURL);
        String wantArtifactResponseSigned = SAML2Utils.getAttributeValueFromSSOConfig(realm, spEntityID, "SPRole", "wantArtifactResponseSigned");
        if (wantArtifactResponseSigned != null && wantArtifactResponseSigned.equals("true")) {
            KeyProvider kp = KeyUtil.getKeyProviderInstance();
            if (kp == null) {
                SAML2Utils.debug.error(classMethod + "Unable to get a key provider instance.");
                return SAML2Utils.createSOAPFault("Server", "nullKeyProvider", null);
            }
            String idpSignCertAlias = SAML2Utils.getSigningCertAlias(realm, idpEntityID, "IDPRole");
            if (idpSignCertAlias == null) {
                SAML2Utils.debug.error(classMethod + "Unable to get the hosted IDP signing certificate alias.");
                return SAML2Utils.createSOAPFault("Server", "missingSigningCertAlias", null);
            }
            artResponse.sign(kp.getPrivateKey(idpSignCertAlias), kp.getX509Certificate(idpSignCertAlias));
        }
        String str = artResponse.toXMLString(true, true);
        String[] logdata = new String[]{idpEntityID, artStr, str};
        LogUtil.access(Level.INFO, "ARTIFACT_RESPONSE", logdata, null, props);
        if (str != null) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "ArtifactResponse message:\n" + str);
            }
        } else if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "Unable to print ArtifactResponse message.");
        }
        SOAPMessage msg = null;
        try {
            msg = SAML2Utils.createSOAPMessage(str);
        }
        catch (SOAPException se) {
            SAML2Utils.debug.error(classMethod + "Unable to create a SOAPMessage and add a document ", (Throwable)se);
            return SAML2Utils.createSOAPFault("Server", "unableToCreateSOAPMessage", null);
        }
        return msg;
    }

    private static MimeHeaders getHeaders(HttpServletRequest req) {
        Enumeration enumerator = req.getHeaderNames();
        MimeHeaders headers = new MimeHeaders();
        while (enumerator.hasMoreElements()) {
            String headerName = (String)enumerator.nextElement();
            String headerValue = req.getHeader(headerName);
            StringTokenizer values = new StringTokenizer(headerValue, ",");
            while (values.hasMoreTokens()) {
                headers.addHeader(headerName, values.nextToken().trim());
            }
        }
        return headers;
    }

    private static void putHeaders(MimeHeaders headers, HttpServletResponse res) {
        Iterator it = headers.getAllHeaders();
        while (it.hasNext()) {
            MimeHeader header = (MimeHeader)it.next();
            String[] values = headers.getHeader(header.getName());
            if (values.length == 1) {
                res.setHeader(header.getName(), header.getValue());
                continue;
            }
            StringBuffer concat = new StringBuffer();
            int i = 0;
            while (i < values.length) {
                if (i != 0) {
                    concat.append(',');
                }
                concat.append(values[i++]);
            }
            res.setHeader(header.getName(), concat.toString());
        }
    }

    static {
        try {
            messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException se) {
            SAML2Utils.debug.error("Unable to obtain SOAPFactory.", (Throwable)se);
        }
    }
}

