/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.multiprotocol.MultiProtocolUtils;
import com.sun.identity.multiprotocol.SingleLogoutManager;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.logging.LogUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.profile.IDPProxyUtil;
import com.sun.identity.saml2.profile.IDPSession;
import com.sun.identity.saml2.profile.IDPSessionCopy;
import com.sun.identity.saml2.profile.LogoutUtil;
import com.sun.identity.saml2.profile.NameIDandSPpair;
import com.sun.identity.saml2.protocol.LogoutRequest;
import com.sun.identity.saml2.protocol.LogoutResponse;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.Status;
import com.sun.identity.saml2.protocol.StatusCode;
import com.sun.identity.shared.debug.Debug;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IDPSingleLogout {
    static SAML2MetaManager sm = null;
    static Debug debug = SAML2Utils.debug;
    static SessionProvider sessionProvider = null;
    static final Status SUCCESS_STATUS = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Success", SAML2Utils.bundle.getString("requestSuccess"));
    static final Status PARTIAL_LOGOUT_STATUS = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", SAML2Utils.bundle.getString("partialLogout"));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initiateLogoutRequest(HttpServletRequest request, HttpServletResponse response, String binding, Map paramsMap) throws SAML2Exception {
        if (debug.messageEnabled()) {
            debug.message("in initiateLogoutRequest");
            debug.message("binding : " + binding);
            debug.message("logoutAll : " + (String)paramsMap.get("logoutAll"));
            debug.message("paramsMap : " + paramsMap);
        }
        boolean logoutall = false;
        String logoutAllValue = (String)paramsMap.get("logoutAll");
        if (logoutAllValue != null && logoutAllValue.equalsIgnoreCase("true")) {
            logoutall = true;
        }
        String metaAlias = (String)paramsMap.get("IDPMetaAlias");
        try {
            String[] values;
            Object session = sessionProvider.getSession(request);
            String sessUser = sessionProvider.getPrincipalName(session);
            if (session == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("nullSSOToken"));
            }
            if (metaAlias == null && (values = sessionProvider.getProperty(session, "IDPMetaAlias")) != null && values.length != 0) {
                metaAlias = values[0];
            }
            if (metaAlias == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("nullIDPMetaAlias"));
            }
            paramsMap.put("metaAlias", metaAlias);
            String realm = SAML2Utils.getRealm(SAML2MetaUtils.getRealmByMetaAlias(metaAlias));
            String idpEntityID = sm.getEntityByMetaAlias(metaAlias);
            if (idpEntityID == null) {
                debug.error("Identity Provider ID is missing");
                String[] data = new String[]{idpEntityID};
                LogUtil.error(Level.INFO, "INVALID_IDP", data, null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("nullIDPEntityID"));
            }
            String tokenID = sessionProvider.getSessionID(session);
            Enumeration keys = IDPCache.idpSessionsByIndices.keys();
            String idpSessionIndex = null;
            IDPSession idpSession = null;
            Object idpToken = null;
            while (keys.hasMoreElements()) {
                idpSessionIndex = (String)keys.nextElement();
                idpSession = (IDPSession)IDPCache.idpSessionsByIndices.get(idpSessionIndex);
                if (idpSession != null) {
                    idpToken = idpSession.getSession();
                    if (idpToken != null && tokenID.equals(sessionProvider.getSessionID(idpToken))) {
                        break;
                    }
                } else {
                    IDPCache.idpSessionsByIndices.remove(idpSessionIndex);
                    try {
                        if (SAML2Utils.failOver) {
                            SAML2Utils.jmq.delete(idpSessionIndex);
                        }
                    }
                    catch (Exception e) {
                        debug.error("Error while deleting idpSessionIndex from Persistent DB.", (Throwable)e);
                    }
                    IDPCache.authnContextCache.remove(idpSessionIndex);
                }
                idpSessionIndex = null;
            }
            if (idpSessionIndex == null) {
                if (debug.messageEnabled()) {
                    debug.message("No SP session participant(s)");
                }
                MultiProtocolUtils.invalidateSession(session, request, response, "saml2");
                return;
            }
            if (debug.messageEnabled()) {
                debug.message("idpSessionIndex=" + idpSessionIndex);
            }
            List list = idpSession.getNameIDandSPpairs();
            int n = list.size();
            if (debug.messageEnabled()) {
                debug.message("IDPSingleLogout.initiateLogoutReq: NameIDandSPpairs=" + list + ", size=" + n);
            }
            if (n == 0) {
                if (debug.messageEnabled()) {
                    debug.message("No SP session participant(s)");
                }
                IDPCache.idpSessionsByIndices.remove(idpSessionIndex);
                try {
                    if (SAML2Utils.failOver) {
                        SAML2Utils.jmq.delete(idpSessionIndex);
                    }
                }
                catch (Exception e) {
                    debug.error("Error while deleting idpSessionIndex from Persistent DB.", (Throwable)e);
                }
                IDPCache.authnContextCache.remove(idpSessionIndex);
                MultiProtocolUtils.invalidateSession(session, request, response, "saml2");
                return;
            }
            String relayState = (String)paramsMap.get("RelayState");
            int soapFailCount = 0;
            for (int i = 0; i < n; ++i) {
                SPSSODescriptorElement spsso;
                NameIDandSPpair pair = null;
                if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
                    pair = (NameIDandSPpair)list.remove(0);
                } else if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
                    pair = (NameIDandSPpair)list.remove(0);
                } else if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
                    pair = (NameIDandSPpair)list.get(i);
                } else {
                    debug.error("IDPSingleLogout. unsuported binding" + binding);
                    throw new SAML2Exception(SAML2Utils.bundle.getString("unsupportedSloBinding"));
                }
                String spEntityID = pair.getSPEntityID();
                if (debug.messageEnabled()) {
                    debug.message("IDPSingleLogout.initLogoutReq: processing spEntityID " + spEntityID);
                }
                if ((spsso = sm.getSPSSODescriptor(realm, spEntityID)) == null) {
                    String[] data = new String[]{spEntityID};
                    LogUtil.error(Level.INFO, "SP_METADATA_ERROR", data, null);
                    throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
                }
                List extensionsList = LogoutUtil.getExtensionsList(paramsMap);
                List slosList = spsso.getSingleLogoutService();
                if (slosList == null) {
                    String[] data = new String[]{idpEntityID};
                    LogUtil.error(Level.INFO, "SLO_NOT_FOUND", data, null);
                    throw new SAML2Exception(SAML2Utils.bundle.getString("sloServiceListNotfound"));
                }
                SPSSOConfigElement spConfig = null;
                if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
                    spConfig = sm.getSPSSOConfig(realm, spEntityID);
                    if (i == 0) {
                        if (logoutall) {
                            String userID = sessionProvider.getPrincipalName(idpSession.getSession());
                            IDPSingleLogout.destroyAllTokenForUser(userID, request, response);
                        } else {
                            MultiProtocolUtils.invalidateSession(idpSession.getSession(), request, response, "saml2");
                            IDPCache.idpSessionsByIndices.remove(idpSessionIndex);
                            IDPCache.authnContextCache.remove(idpSessionIndex);
                        }
                    }
                }
                if (logoutall) {
                    idpSessionIndex = null;
                }
                StringBuffer requestID = null;
                try {
                    requestID = LogoutUtil.doLogout(metaAlias, spEntityID, slosList, extensionsList, binding, relayState, idpSessionIndex, pair.getNameID(), request, response, paramsMap, spConfig);
                }
                catch (SAML2Exception ex) {
                    if (!binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) throw ex;
                    debug.error("IDPSingleLogout.initiateLogoutRequest:", (Throwable)((Object)ex));
                    ++soapFailCount;
                    continue;
                }
                String requestIDStr = requestID.toString();
                if (debug.messageEnabled()) {
                    debug.message("\nIDPSLO.requestIDStr = " + requestIDStr + "\nbinding = " + binding);
                }
                if (requestIDStr == null || requestIDStr.length() == 0 || !binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") && !binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) continue;
                idpSession.setPendingLogoutRequestID(requestIDStr);
                idpSession.setLogoutAll(logoutall);
                Map logoutMap = (Map)paramsMap.get("LogoutMap");
                if (logoutMap == null || logoutMap.isEmpty()) break;
                IDPCache.logoutResponseCache.put(requestIDStr, (Map)paramsMap.get("LogoutMap"));
                break;
            }
            if (!binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) return;
            int logoutStatus = 0;
            boolean isMultiProtocol = MultiProtocolUtils.isMultipleProtocolSession(request, "saml2");
            if (soapFailCount == n) {
                if (!isMultiProtocol) throw new SAML2Exception(SAML2Utils.bundle.getString("sloFailed"));
                logoutStatus = 2;
            } else if (soapFailCount > 0) {
                if (!isMultiProtocol) throw new SAML2Exception(SAML2Utils.bundle.getString("partialLogout"));
                logoutStatus = 1;
            }
            if (!isMultiProtocol) return;
            HashSet<Object> set = new HashSet<Object>();
            set.add(session);
            boolean isSOAPInitiated = binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
            int retStat = 0;
            try {
                debug.message("IDPSingleLogout.initLogReq: MP");
                retStat = SingleLogoutManager.getInstance().doIDPSingleLogout(set, sessUser, request, response, isSOAPInitiated, true, "saml2", realm, idpEntityID, null, relayState, null, null, logoutStatus);
            }
            catch (Exception ex) {
                debug.warning("IDPSingleLogout.initiateLoogutReq: MP", (Throwable)ex);
                throw new SAML2Exception(ex.getMessage());
            }
            if (debug.messageEnabled()) {
                debug.message("IDPSingleLogout.initLogoutRequest: SLOManager return status = " + retStat);
            }
            switch (retStat) {
                case 2: {
                    throw new SAML2Exception(SAML2Utils.bundle.getString("sloFailed"));
                }
                case 1: {
                    throw new SAML2Exception(SAML2Utils.bundle.getString("partialLogout"));
                }
            }
            return;
        }
        catch (SAML2MetaException sme) {
            debug.error("Error retreiving metadata", (Throwable)((Object)sme));
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        catch (SessionException ssoe) {
            debug.error("SessionException: ", (Throwable)((Object)ssoe));
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
    }

    public static void processLogoutRequest(HttpServletRequest request, HttpServletResponse response, String samlRequest, String relayState) throws SAML2Exception, SessionException {
        LogoutResponse logoutRes;
        String method = "processLogoutRequest : ";
        if (debug.messageEnabled()) {
            debug.message(method + "IDPSingleLogout:processLogoutRequest");
            debug.message(method + "samlRequest : " + samlRequest);
            debug.message(method + "relayState : " + relayState);
        }
        String rmethod = request.getMethod();
        String binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
        LogoutRequest logoutReq = null;
        if (rmethod.equals("POST")) {
            binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
            logoutReq = LogoutUtil.getLogoutRequestFromPost(samlRequest, response);
        } else if (rmethod.equals("GET")) {
            String decodedStr = SAML2Utils.decodeFromRedirect(samlRequest);
            if (decodedStr == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("nullDecodedStrFromSamlRequest"));
            }
            logoutReq = ProtocolFactory.getInstance().createLogoutRequest(decodedStr);
        }
        String metaAlias = SAML2MetaUtils.getMetaAliasByUri(request.getRequestURI());
        String realm = SAML2Utils.getRealm(SAML2MetaUtils.getRealmByMetaAlias(metaAlias));
        String idpEntityID = sm.getEntityByMetaAlias(metaAlias);
        String spEntityID = logoutReq.getIssuer().getValue();
        boolean needToVerify = SAML2Utils.getWantLogoutRequestSigned(realm, idpEntityID, "IDPRole");
        if (debug.messageEnabled()) {
            debug.message(method + "metaAlias : " + metaAlias);
            debug.message(method + "realm : " + realm);
            debug.message(method + "idpEntityID : " + idpEntityID);
            debug.message(method + "spEntityID : " + spEntityID);
        }
        if (needToVerify) {
            List sloList;
            boolean valid = false;
            if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
                String queryString = request.getQueryString();
                valid = SAML2Utils.verifyQueryString(queryString, realm, "IDPRole", spEntityID);
            } else {
                valid = LogoutUtil.verifySLORequest(logoutReq, realm, spEntityID, idpEntityID, "IDPRole");
            }
            if (!valid) {
                debug.error("Invalid signature in SLO Request.");
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignInRequest"));
            }
            IDPSSODescriptorElement idpsso = sm.getIDPSSODescriptor(realm, idpEntityID);
            String loc = null;
            if (!(idpsso == null || (sloList = idpsso.getSingleLogoutService()) == null || sloList.isEmpty() || (loc = LogoutUtil.getSLOResponseServiceLocation(sloList, binding)) != null && loc.length() != 0)) {
                loc = LogoutUtil.getSLOServiceLocation(sloList, binding);
            }
            if (!SAML2Utils.verifyDestination(logoutReq.getDestination(), loc)) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidDestination"));
            }
        }
        if ((logoutRes = IDPSingleLogout.processLogoutRequest(logoutReq, request, response, binding, relayState, idpEntityID, realm, true)) == null) {
            return;
        }
        String location = IDPSingleLogout.getSingleLogoutLocation(spEntityID, realm, binding);
        logoutRes.setDestination(location);
        boolean isMultiProtocolSession = false;
        int retStatus = 0;
        Object session = null;
        SessionProvider provider = null;
        try {
            provider = SessionManager.getProvider();
            session = provider.getSession(request);
            if (session != null && provider.isValid(session) && MultiProtocolUtils.isMultipleProtocolSession(session, "saml2")) {
                isMultiProtocolSession = true;
                SingleLogoutManager sloManager = SingleLogoutManager.getInstance();
                HashSet<Object> set = new HashSet<Object>();
                set.add(session);
                String uid = provider.getPrincipalName(session);
                debug.message("IDPSingleLogout.processLogReq: MP/SPinit/Http");
                retStatus = sloManager.doIDPSingleLogout(set, uid, request, response, false, false, "saml2", realm, idpEntityID, spEntityID, relayState, logoutReq.toString(), logoutRes.toXMLString(), IDPSingleLogout.getLogoutStatus(logoutRes));
            }
        }
        catch (SessionException e) {
            debug.message("IDPSingleLogout.processLogoutRequest: session", (Throwable)((Object)e));
        }
        catch (Exception e) {
            debug.message("IDPSingleLogout.processLogoutRequest: MP2", (Throwable)e);
            retStatus = 2;
        }
        if (!isMultiProtocolSession || retStatus != 3) {
            logoutRes = IDPSingleLogout.updateLogoutResponse(logoutRes, retStatus);
            List partners = IDPProxyUtil.getSessionPartners(request);
            if (partners != null && !partners.isEmpty()) {
                IDPProxyUtil.sendProxyLogoutRequest(request, response, logoutReq, partners, binding, relayState);
            } else {
                LogoutUtil.sendSLOResponse(response, logoutRes, location, relayState, realm, idpEntityID, "IDPRole", spEntityID, binding);
            }
        }
    }

    public static String getSingleLogoutLocation(String spEntityID, String realm, String binding) throws SAML2Exception {
        SPSSODescriptorElement spsso = sm.getSPSSODescriptor(realm, spEntityID);
        if (spsso == null) {
            String[] data = new String[]{spEntityID};
            LogUtil.error(Level.INFO, "SP_METADATA_ERROR", data, null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        List slosList = spsso.getSingleLogoutService();
        String location = LogoutUtil.getSLOResponseServiceLocation(slosList, binding);
        if (location == null || location.length() == 0) {
            location = LogoutUtil.getSLOServiceLocation(slosList, binding);
            if (location == null || location.length() == 0) {
                debug.error("Unable to find the IDP's single logout response service with the HTTP-Redirect binding");
                throw new SAML2Exception(SAML2Utils.bundle.getString("sloResponseServiceLocationNotfound"));
            }
            if (debug.messageEnabled()) {
                debug.message("SP's single logout response service location = " + location);
            }
        } else if (debug.messageEnabled()) {
            debug.message("IDP's single logout response service location = " + location);
        }
        if (debug.messageEnabled()) {
            debug.message("IDPSingleLogout.getSLOLocation: loc=" + location);
        }
        return location;
    }

    private static int getLogoutStatus(LogoutResponse logoutRes) {
        StatusCode statusCode = logoutRes.getStatus().getStatusCode();
        String code = statusCode.getValue();
        if (code.equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
            return 0;
        }
        return 2;
    }

    public static boolean processLogoutResponse(HttpServletRequest request, HttpServletResponse response, String samlResponse, String relayState) throws SAML2Exception, SessionException {
        String method = "processLogoutResponse : ";
        if (debug.messageEnabled()) {
            debug.message(method + "samlResponse : " + samlResponse);
            debug.message(method + "relayState : " + relayState);
        }
        String rmethod = request.getMethod();
        LogoutResponse logoutRes = null;
        String binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
        if (rmethod.equals("POST")) {
            binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
            logoutRes = LogoutUtil.getLogoutResponseFromPost(samlResponse, response);
        } else if (rmethod.equals("GET")) {
            String decodedStr = SAML2Utils.decodeFromRedirect(samlResponse);
            if (decodedStr == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("nullDecodedStrFromSamlResponse"));
            }
            logoutRes = ProtocolFactory.getInstance().createLogoutResponse(decodedStr);
        }
        String metaAlias = SAML2MetaUtils.getMetaAliasByUri(request.getRequestURI());
        String realm = SAML2Utils.getRealm(SAML2MetaUtils.getRealmByMetaAlias(metaAlias));
        String idpEntityID = sm.getEntityByMetaAlias(metaAlias);
        String spEntityID = logoutRes.getIssuer().getValue();
        Issuer resIssuer = logoutRes.getIssuer();
        String requestId = logoutRes.getInResponseTo();
        SAML2Utils.verifyResponseIssuer(realm, idpEntityID, resIssuer, requestId);
        boolean needToVerify = SAML2Utils.getWantLogoutResponseSigned(realm, idpEntityID, "IDPRole");
        if (debug.messageEnabled()) {
            debug.message(method + "metaAlias : " + metaAlias);
            debug.message(method + "realm : " + realm);
            debug.message(method + "idpEntityID : " + idpEntityID);
            debug.message(method + "spEntityID : " + spEntityID);
        }
        if (needToVerify) {
            List sloList;
            boolean valid = false;
            if (rmethod.equals("POST")) {
                valid = LogoutUtil.verifySLOResponse(logoutRes, realm, spEntityID, idpEntityID, "IDPRole");
            } else {
                String queryString = request.getQueryString();
                valid = SAML2Utils.verifyQueryString(queryString, realm, "IDPRole", spEntityID);
            }
            if (!valid) {
                debug.error("Invalid signature in SLO Response.");
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignInResponse"));
            }
            IDPSSODescriptorElement idpsso = sm.getIDPSSODescriptor(realm, idpEntityID);
            String loc = null;
            if (!(idpsso == null || (sloList = idpsso.getSingleLogoutService()) == null || sloList.isEmpty() || (loc = LogoutUtil.getSLOResponseServiceLocation(sloList, binding)) != null && loc.length() != 0)) {
                loc = LogoutUtil.getSLOServiceLocation(sloList, binding);
            }
            if (!SAML2Utils.verifyDestination(logoutRes.getDestination(), loc)) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidDestination"));
            }
        }
        boolean doRelayState = IDPSingleLogout.processLogoutResponse(request, response, logoutRes, relayState, metaAlias, idpEntityID, spEntityID, realm, binding);
        Map logoutResponseMap = (Map)IDPCache.logoutResponseCache.get(requestId);
        if (logoutResponseMap != null && !logoutResponseMap.isEmpty()) {
            LogoutResponse logoutResp = (LogoutResponse)logoutResponseMap.get("LogoutResponse");
            String location = (String)logoutResponseMap.get("Location");
            String spEntity = (String)logoutResponseMap.get("spEntityID");
            String idpEntity = (String)logoutResponseMap.get("idpEntityID");
            if (logoutResp != null && location != null && spEntity != null && idpEntity != null) {
                LogoutUtil.sendSLOResponse(response, logoutResp, location, relayState, "/", spEntity, "SPRole", idpEntity, binding);
                return true;
            }
        }
        return doRelayState;
    }

    static boolean processLogoutResponse(HttpServletRequest request, HttpServletResponse response, LogoutResponse logoutRes, String relayState, String metaAlias, String idpEntityID, String spEntityID, String realm, String binding) throws SAML2Exception, SessionException {
        Object session = sessionProvider.getSession(request);
        String tokenID = sessionProvider.getSessionID(session);
        Enumeration keys = IDPCache.idpSessionsByIndices.keys();
        String idpSessionIndex = null;
        IDPSession idpSession = null;
        Object idpToken = null;
        while (keys.hasMoreElements()) {
            idpSessionIndex = (String)keys.nextElement();
            idpSession = (IDPSession)IDPCache.idpSessionsByIndices.get(idpSessionIndex);
            if (idpSession != null) {
                idpToken = idpSession.getSession();
                if (idpToken != null && tokenID.equals(sessionProvider.getSessionID(idpToken))) {
                    break;
                }
            } else {
                IDPCache.idpSessionsByIndices.remove(idpSessionIndex);
                try {
                    if (SAML2Utils.failOver) {
                        SAML2Utils.jmq.delete(idpSessionIndex);
                    }
                }
                catch (Exception e) {
                    debug.error("Error while deleting idpSessionIndex from Persistent DB.", (Throwable)e);
                }
                IDPCache.authnContextCache.remove(idpSessionIndex);
            }
            idpSessionIndex = null;
        }
        if (idpSessionIndex == null) {
            if (debug.messageEnabled()) {
                debug.message("No SP session participant(s)");
            }
            MultiProtocolUtils.invalidateSession(session, request, response, "saml2");
            return false;
        }
        if (debug.messageEnabled()) {
            debug.message("idpSessionIndex=" + idpSessionIndex);
        }
        List list = idpSession.getNameIDandSPpairs();
        debug.message("idpSession.getNameIDandSPpairs()=" + list);
        if (list.size() == 0) {
            String originatingRequestID;
            String requestID = idpSession.getPendingLogoutRequestID();
            String inResponseTo = logoutRes.getInResponseTo();
            if (inResponseTo != null && requestID != null && inResponseTo.equals(requestID) && debug.messageEnabled()) {
                debug.message("LogoutRespone's inResponseTo matches the previous LogoutRequest's ID.");
            }
            if ((originatingRequestID = idpSession.getOriginatingLogoutRequestID()) == null) {
                if (idpSession.getLogoutAll()) {
                    String userID = sessionProvider.getPrincipalName(idpSession.getSession());
                    IDPSingleLogout.destroyAllTokenForUser(userID, request, response);
                } else {
                    IDPCache.idpSessionsByIndices.remove(idpSessionIndex);
                    try {
                        if (SAML2Utils.failOver) {
                            SAML2Utils.jmq.delete(idpSessionIndex);
                        }
                    }
                    catch (Exception e) {
                        debug.error("Error while deleting idpSessionIndex from Persistent DB.", (Throwable)e);
                    }
                    IDPCache.authnContextCache.remove(idpSessionIndex);
                    if (!MultiProtocolUtils.isMultipleProtocolSession(idpSession.getSession(), "saml2")) {
                        sessionProvider.invalidateSession(idpSession.getSession(), request, response);
                    } else {
                        MultiProtocolUtils.removeFederationProtocol(idpSession.getSession(), "saml2");
                        SingleLogoutManager sloManager = SingleLogoutManager.getInstance();
                        HashSet<Object> set = new HashSet<Object>();
                        set.add(session);
                        SessionProvider provider = SessionManager.getProvider();
                        String uid = provider.getPrincipalName(session);
                        debug.message("IDPSingleLogout.processLogRes: MP/Http");
                        int retStatus = 0;
                        try {
                            retStatus = sloManager.doIDPSingleLogout(set, uid, request, response, false, true, "saml2", realm, idpEntityID, spEntityID, relayState, null, null, IDPSingleLogout.getLogoutStatus(logoutRes));
                        }
                        catch (SAML2Exception ex) {
                            throw ex;
                        }
                        catch (Exception ex) {
                            debug.error("IDPSIngleLogout.processLogoutResponse: MP/IDP initiated HTTP", (Throwable)ex);
                            throw new SAML2Exception(ex.getMessage());
                        }
                        if (retStatus == 3) {
                            return true;
                        }
                    }
                }
                debug.message("IDP initiated SLO Success");
                return false;
            }
            String originatingLogoutSPEntityID = idpSession.getOriginatingLogoutSPEntityID();
            SPSSODescriptorElement spsso = null;
            spsso = sm.getSPSSODescriptor(realm, originatingLogoutSPEntityID);
            if (spsso == null) {
                String[] data = new String[]{originatingLogoutSPEntityID};
                LogUtil.error(Level.INFO, "SP_METADATA_ERROR", data, null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
            }
            List slosList = spsso.getSingleLogoutService();
            String location = LogoutUtil.getSLOResponseServiceLocation(slosList, binding);
            if (location == null || location.length() == 0) {
                location = LogoutUtil.getSLOServiceLocation(slosList, binding);
                if (location == null || location.length() == 0) {
                    debug.error("Unable to find the IDP's single logout response service with the HTTP-Redirect binding");
                    throw new SAML2Exception(SAML2Utils.bundle.getString("sloResponseServiceLocationNotfound"));
                }
                if (debug.messageEnabled()) {
                    debug.message("SP's single logout response service location = " + location);
                }
            } else if (debug.messageEnabled()) {
                debug.message("IDP's single logout response service location = " + location);
            }
            Status status = IDPSingleLogout.destroyTokenAndGenerateStatus(idpSessionIndex, idpSession.getSession(), request, response, true);
            logoutRes = LogoutUtil.generateResponse(status, originatingRequestID, SAML2Utils.createIssuer(idpEntityID), realm, "IDPRole", logoutRes.getIssuer().getValue());
            if (location != null && logoutRes != null) {
                logoutRes.setDestination(location);
                IDPCache.idpSessionsByIndices.remove(idpSessionIndex);
                try {
                    if (SAML2Utils.failOver) {
                        SAML2Utils.jmq.delete(idpSessionIndex);
                    }
                }
                catch (Exception e) {
                    debug.error("Error while deleting idpSessionIndex from Persistent DB.", (Throwable)e);
                }
                IDPCache.authnContextCache.remove(idpSessionIndex);
                boolean isMultiProtocolSession = false;
                int retStatus = 0;
                try {
                    SessionProvider provider = SessionManager.getProvider();
                    session = idpSession.getSession();
                    if (session != null && provider.isValid(session) && MultiProtocolUtils.isMultipleProtocolSession(session, "saml2")) {
                        isMultiProtocolSession = true;
                        SingleLogoutManager sloManager = SingleLogoutManager.getInstance();
                        HashSet<Object> set = new HashSet<Object>();
                        set.add(session);
                        String uid = provider.getPrincipalName(session);
                        debug.message("IDPSingleLogout.processLogRes: MP/Http");
                        retStatus = sloManager.doIDPSingleLogout(set, uid, request, response, false, true, "saml2", realm, idpEntityID, spEntityID, relayState, null, logoutRes.toXMLString(), IDPSingleLogout.getLogoutStatus(logoutRes));
                    }
                }
                catch (SessionException e) {
                    debug.message("IDPSingleLogout.processLogoutRequest: session", (Throwable)((Object)e));
                }
                catch (Exception e) {
                    debug.message("IDPSingleLogout.processLogoutRequest: MP2", (Throwable)e);
                    retStatus = 2;
                }
                if (!isMultiProtocolSession || retStatus != 3) {
                    logoutRes = IDPSingleLogout.updateLogoutResponse(logoutRes, retStatus);
                    LogoutUtil.sendSLOResponse(response, logoutRes, location, relayState, realm, idpEntityID, "IDPRole", spEntityID, binding);
                    return true;
                }
                return false;
            }
            IDPCache.idpSessionsByIndices.remove(idpSessionIndex);
            try {
                if (SAML2Utils.failOver) {
                    SAML2Utils.jmq.delete(idpSessionIndex);
                }
            }
            catch (Exception e) {
                debug.error("Error while deleting idpSessionIndex from Persistent DB.", (Throwable)e);
            }
            IDPCache.authnContextCache.remove(idpSessionIndex);
            return false;
        }
        NameIDandSPpair pair = (NameIDandSPpair)list.remove(0);
        spEntityID = pair.getSPEntityID();
        SPSSODescriptorElement spsso = null;
        spsso = sm.getSPSSODescriptor(realm, spEntityID);
        if (spsso == null) {
            String[] data = new String[]{spEntityID};
            LogUtil.error(Level.INFO, "SP_METADATA_ERROR", data, null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        List slosList = spsso.getSingleLogoutService();
        List extensionsList = LogoutUtil.getExtensionsList(request.getParameterMap());
        HashMap<String, String> paramsMap = new HashMap<String, String>(request.getParameterMap());
        paramsMap.put("role", "IDPRole");
        StringBuffer requestID = LogoutUtil.doLogout(metaAlias, spEntityID, slosList, extensionsList, binding, relayState, idpSessionIndex, pair.getNameID(), request, response, paramsMap, null);
        String requestIDStr = requestID.toString();
        if (debug.messageEnabled()) {
            debug.message("IDPSingleLogout.processLogoutRequest: requestIDStr = " + requestIDStr + "\nbinding = " + binding);
        }
        if (requestIDStr != null && requestIDStr.length() != 0) {
            idpSession.setPendingLogoutRequestID(requestIDStr);
        }
        return true;
    }

    public static LogoutResponse processLogoutRequest(LogoutRequest logoutReq, HttpServletRequest request, HttpServletResponse response, String binding, String relayState, String idpEntityID, String realm, boolean isVerified) throws SAML2Exception {
        Object session;
        String spEntity;
        Status status;
        block44: {
            status = null;
            spEntity = logoutReq.getIssuer().getValue();
            session = null;
            String tmpStr = request.getParameter("isLBReq");
            boolean isLBReq = tmpStr == null || !tmpStr.equals("false");
            try {
                IDPSession idpSession;
                String requestId = logoutReq.getID();
                SAML2Utils.verifyRequestIssuer(realm, idpEntityID, logoutReq.getIssuer(), requestId);
                List siList = logoutReq.getSessionIndex();
                if (siList == null) {
                    debug.error("IDPSingleLogout.processLogoutRequest: session index are null in logout request");
                    status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", "");
                    break block44;
                }
                int numSI = siList.size();
                Iterator siIter = siList.iterator();
                String sessionIndex = null;
                if (siIter.hasNext()) {
                    sessionIndex = (String)siIter.next();
                }
                if (debug.messageEnabled()) {
                    debug.message("IDPLogoutUtil.processLogoutRequest: idpEntityID=" + idpEntityID + ", sessionIndex=" + sessionIndex);
                }
                if (sessionIndex == null) {
                    debug.error("IDPLogoutUtil.processLogoutRequest: No session index in logout request");
                    status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", "");
                    break block44;
                }
                String remoteServiceURL = null;
                if (isLBReq) {
                    String serverId = sessionIndex.substring(sessionIndex.length() - 2);
                    if (debug.messageEnabled()) {
                        debug.message("IDPSingleLogout.processLogoutRequest: sessionIndex=" + sessionIndex + ", id=" + serverId);
                    }
                    remoteServiceURL = SAML2Utils.getRemoteServiceURL(serverId);
                }
                if ((idpSession = (IDPSession)IDPCache.idpSessionsByIndices.get(sessionIndex)) == null && SAML2Utils.failOver) {
                    IDPSessionCopy idpSessionCopy = (IDPSessionCopy)SAML2Utils.jmq.retrieve(sessionIndex);
                    if (idpSessionCopy != null) {
                        idpSession = new IDPSession(idpSessionCopy);
                    } else {
                        SAML2Utils.debug.error("IDPSessionCopy is NULL!!!");
                    }
                }
                if (idpSession == null) {
                    if (remoteServiceURL != null) {
                        boolean peerError = false;
                        String remoteLogoutURL = remoteServiceURL + SAML2Utils.removeDeployUri(request.getRequestURI());
                        String queryString = request.getQueryString();
                        remoteLogoutURL = queryString == null ? remoteLogoutURL + "?isLBReq=false" : remoteLogoutURL + "?" + queryString + "&isLBReq=false";
                        LogoutResponse logoutRes = LogoutUtil.forwardToRemoteServer(logoutReq, remoteLogoutURL);
                        if (logoutRes != null && !IDPSingleLogout.isNameNotFound(logoutRes)) {
                            if (IDPSingleLogout.isSuccess(logoutRes) && numSI > 0 && ((siList = LogoutUtil.getSessionIndex(logoutRes)) == null || siList.isEmpty())) {
                                peerError = false;
                                break block44;
                            }
                        } else {
                            peerError = true;
                        }
                        status = peerError || siList != null && siList.size() > 0 ? PARTIAL_LOGOUT_STATUS : SUCCESS_STATUS;
                        break block44;
                    }
                    debug.error("IDPLogoutUtil.processLogoutRequest: IDP no longer has this session index " + sessionIndex);
                    status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", SAML2Utils.bundle.getString("invalidSessionIndex"));
                    break block44;
                }
                if (!isVerified && !LogoutUtil.verifySLORequest(logoutReq, realm, logoutReq.getIssuer().getValue(), idpEntityID, "IDPRole")) {
                    throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignInRequest"));
                }
                session = idpSession.getSession();
                List list = idpSession.getNameIDandSPpairs();
                int n = list.size();
                if (debug.messageEnabled()) {
                    debug.message("IDPLogoutUtil.processLogoutRequest: NameIDandSPpair for " + sessionIndex + " is " + list + ", size=" + n);
                }
                NameIDandSPpair pair = null;
                String spIssuer = logoutReq.getIssuer().getValue();
                for (int i = 0; i < n; ++i) {
                    pair = (NameIDandSPpair)list.get(i);
                    if (!pair.getSPEntityID().equals(spIssuer)) continue;
                    list.remove(i);
                    break;
                }
                List partners = idpSession.getSessionPartners();
                boolean cleanUp = true;
                if (partners != null && !partners.isEmpty()) {
                    cleanUp = false;
                }
                if ((n = list.size()) == 0) {
                    status = IDPSingleLogout.destroyTokenAndGenerateStatus(sessionIndex, idpSession.getSession(), request, response, cleanUp);
                    if (cleanUp) {
                        IDPCache.idpSessionsByIndices.remove(sessionIndex);
                        if (SAML2Utils.failOver) {
                            SAML2Utils.jmq.delete(sessionIndex);
                        }
                        IDPCache.authnContextCache.remove(sessionIndex);
                    }
                    break block44;
                }
                if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") || binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
                    idpSession.setOriginatingLogoutRequestID(logoutReq.getID());
                    idpSession.setOriginatingLogoutSPEntityID(logoutReq.getIssuer().getValue());
                }
                int soapFailCount = 0;
                for (int i = 0; i < n; ++i) {
                    pair = binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") || binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST") ? (NameIDandSPpair)list.remove(0) : (NameIDandSPpair)list.get(i);
                    String spEntityID = pair.getSPEntityID();
                    if (debug.messageEnabled()) {
                        debug.message("IDPLogoutUtil.processLogoutRequest: SP for " + sessionIndex + " is " + spEntityID);
                    }
                    SPSSODescriptorElement sp = null;
                    sp = SAML2Utils.getSAML2MetaManager().getSPSSODescriptor(realm, spEntityID);
                    List slosList = sp.getSingleLogoutService();
                    SPSSOConfigElement spConfig = null;
                    if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
                        spConfig = SAML2Utils.getSAML2MetaManager().getSPSSOConfig(realm, spEntityID);
                    }
                    String uri = request.getRequestURI();
                    String metaAlias = SAML2MetaUtils.getMetaAliasByUri(uri);
                    HashMap<String, String> paramsMap = new HashMap<String, String>();
                    paramsMap.put("role", "IDPRole");
                    StringBuffer requestID = null;
                    try {
                        requestID = LogoutUtil.doLogout(metaAlias, spEntityID, slosList, null, binding, relayState, sessionIndex, pair.getNameID(), request, response, paramsMap, spConfig);
                    }
                    catch (SAML2Exception ex) {
                        if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
                            debug.error("IDPSingleLogout.initiateLogoutRequest:", (Throwable)((Object)ex));
                            ++soapFailCount;
                            continue;
                        }
                        throw ex;
                    }
                    if (!binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") && !binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) continue;
                    String requestIDStr = requestID.toString();
                    if (requestIDStr != null && requestIDStr.length() != 0) {
                        idpSession.setPendingLogoutRequestID(requestIDStr);
                    }
                    return null;
                }
                if (soapFailCount == n) {
                    throw new SAML2Exception(SAML2Utils.bundle.getString("sloFailed"));
                }
                if (soapFailCount > 0) {
                    throw new SAML2Exception(SAML2Utils.bundle.getString("partialLogout"));
                }
                status = IDPSingleLogout.destroyTokenAndGenerateStatus(sessionIndex, idpSession.getSession(), request, response, true);
                if (cleanUp) {
                    IDPCache.idpSessionsByIndices.remove(sessionIndex);
                    if (SAML2Utils.failOver) {
                        SAML2Utils.jmq.delete(sessionIndex);
                    }
                    IDPCache.authnContextCache.remove(sessionIndex);
                }
            }
            catch (SessionException ssoe) {
                debug.error("IDPLogoutUtil : unable to get meta for ", (Throwable)((Object)ssoe));
                status = SAML2Utils.generateStatus(idpEntityID, ssoe.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                SAML2Utils.debug.error("DB ERROR!!!");
            }
        }
        boolean isMultiProtocol = false;
        try {
            SessionProvider provider = SessionManager.getProvider();
            if (session != null && provider.isValid(session) && MultiProtocolUtils.isMultipleProtocolSession(session, "saml2")) {
                isMultiProtocol = true;
            }
        }
        catch (SessionException ex) {
            // empty catch block
        }
        LogoutResponse logRes = LogoutUtil.generateResponse(status, logoutReq.getID(), SAML2Utils.createIssuer(idpEntityID), realm, "IDPRole", spEntity);
        if (!isMultiProtocol) {
            return logRes;
        }
        try {
            HashSet<Object> set = new HashSet<Object>();
            set.add(session);
            String sessUser = SessionManager.getProvider().getPrincipalName(session);
            boolean isSOAPInitiated = binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
            logRes.setDestination(IDPSingleLogout.getSingleLogoutLocation(spEntity, realm, binding));
            debug.message("IDPSingleLogout.processLogReq : call MP");
            int retStat = SingleLogoutManager.getInstance().doIDPSingleLogout(set, sessUser, request, response, isSOAPInitiated, false, "saml2", realm, idpEntityID, spEntity, relayState, logoutReq.toXMLString(true, true), logRes.toXMLString(true, true), 0);
            if (retStat != 3) {
                logRes = IDPSingleLogout.updateLogoutResponse(logRes, retStat);
                return logRes;
            }
            return null;
        }
        catch (SessionException ex) {
            debug.error("IDPSingleLogout.ProcessLogoutRequest: SP initiated SOAP logout", (Throwable)((Object)ex));
            throw new SAML2Exception(ex.getMessage());
        }
        catch (Exception ex) {
            debug.error("IDPSingleLogout.ProcessLogoutRequest: SP initiated SOAP logout (MP)", (Throwable)ex);
            throw new SAML2Exception(ex.getMessage());
        }
    }

    private static LogoutResponse updateLogoutResponse(LogoutResponse logRes, int retStat) throws SAML2Exception {
        if (debug.messageEnabled()) {
            debug.message("IDPSingleLogout.updateLogoutResponse: response=" + logRes.toXMLString() + "\nstatus = " + retStat);
        }
        if (retStat == 0) {
            return logRes;
        }
        StatusCode code = logRes.getStatus().getStatusCode();
        if (code.getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
            code.setValue("urn:oasis:names:tc:SAML:2.0:status:Responder");
        }
        return logRes;
    }

    private static Status destroyTokenAndGenerateStatus(String sessionIndex, Object session, HttpServletRequest request, HttpServletResponse response, boolean cleanUp) throws SAML2Exception {
        Status status = null;
        if (session != null) {
            try {
                if (cleanUp) {
                    MultiProtocolUtils.invalidateSession(session, request, response, "saml2");
                }
                if (debug.messageEnabled()) {
                    debug.message("IDPLogoutUtil.destroyTAGR: Local session destroyed.");
                }
                status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Success", "");
            }
            catch (Exception e) {
                debug.error("IDPLogoutUtil.destroyTAGR: ", (Throwable)e);
                status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "");
            }
        } else {
            if (debug.messageEnabled()) {
                debug.message("IDPLogoutUtil.destroyTAGR: No such session with index " + sessionIndex + " exists.");
            }
            status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Success", "");
        }
        return status;
    }

    private static void destroyAllTokenForUser(String userToLogout, HttpServletRequest request, HttpServletResponse response) {
        Enumeration keys = IDPCache.idpSessionsByIndices.keys();
        String idpSessionIndex = null;
        IDPSession idpSession = null;
        Object idpToken = null;
        if (debug.messageEnabled()) {
            debug.message("IDPLogoutUtil.destroyAllTokenForUser: User to logoutAll : " + userToLogout);
        }
        while (keys.hasMoreElements()) {
            idpSessionIndex = (String)keys.nextElement();
            idpSession = (IDPSession)IDPCache.idpSessionsByIndices.get(idpSessionIndex);
            if (idpSession != null) {
                idpToken = idpSession.getSession();
                if (idpToken == null) continue;
                try {
                    String userID = sessionProvider.getPrincipalName(idpToken);
                    if (!userToLogout.equalsIgnoreCase(userID)) continue;
                    MultiProtocolUtils.invalidateSession(idpToken, request, response, "saml2");
                    IDPCache.idpSessionsByIndices.remove(idpSessionIndex);
                    IDPCache.authnContextCache.remove(idpSessionIndex);
                }
                catch (SessionException e) {
                    debug.error(SAML2Utils.bundle.getString("invalidSSOToken"), (Throwable)((Object)e));
                }
                continue;
            }
            IDPCache.idpSessionsByIndices.remove(idpSessionIndex);
            try {
                if (SAML2Utils.failOver) {
                    SAML2Utils.jmq.delete(idpSessionIndex);
                }
            }
            catch (Exception e) {
                debug.error("Error while deleting idpSessionIndex from Persistent DB.", (Throwable)e);
            }
            IDPCache.authnContextCache.remove(idpSessionIndex);
        }
    }

    static boolean isSuccess(LogoutResponse logoutRes) {
        return logoutRes.getStatus().getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Success");
    }

    static boolean isNameNotFound(LogoutResponse logoutRes) {
        Status status = logoutRes.getStatus();
        String statusMessage = status.getStatusMessage();
        return status.getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Responder") && statusMessage != null && statusMessage.equals(SAML2Utils.bundle.getString("invalid_name_identifier"));
    }

    private static LogoutRequest copyAndMakeMutable(LogoutRequest src) {
        LogoutRequest dest = ProtocolFactory.getInstance().createLogoutRequest();
        try {
            dest.setNotOnOrAfter(src.getNotOnOrAfter());
            dest.setReason(src.getReason());
            dest.setEncryptedID(src.getEncryptedID());
            dest.setNameID(src.getNameID());
            dest.setBaseID(src.getBaseID());
            dest.setSessionIndex(src.getSessionIndex());
            dest.setIssuer(src.getIssuer());
            dest.setExtensions(src.getExtensions());
            dest.setID(src.getID());
            dest.setVersion(src.getVersion());
            dest.setIssueInstant(src.getIssueInstant());
            dest.setDestination(src.getDestination());
            dest.setConsent(src.getConsent());
        }
        catch (SAML2Exception ex) {
            debug.error("IDPSingleLogout.copyAndMakeMutable:", (Throwable)((Object)ex));
        }
        return dest;
    }

    static {
        try {
            sm = new SAML2MetaManager();
        }
        catch (SAML2MetaException sme) {
            debug.error("Error retreiving metadata", (Throwable)((Object)sme));
        }
        try {
            sessionProvider = SessionManager.getProvider();
        }
        catch (SessionException se) {
            debug.error("Error retreiving session provider.", (Throwable)((Object)se));
        }
    }
}

