/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.Extensions;
import com.sun.identity.saml2.protocol.Status;
import com.sun.identity.saml2.protocol.StatusResponse;
import com.sun.identity.saml2.xmlsig.SigManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class StatusResponseImpl
implements StatusResponse {
    protected String version = null;
    protected Date issueInstant = null;
    protected String destination = null;
    protected String signatureString = null;
    protected Extensions extensions = null;
    protected String consent = null;
    protected String inResponseTo = null;
    protected Status status = null;
    protected String responseId = null;
    protected Issuer issuer = null;
    protected boolean isSigned = false;
    protected Boolean isSignatureValid = null;
    protected boolean isMutable = false;
    protected PublicKey publicKey = null;
    protected String signedXMLString = null;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.version = value;
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(Date value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.issueInstant = value;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.destination = value;
    }

    public String getSignature() {
        return this.signatureString;
    }

    public void sign(PrivateKey privateKey, X509Certificate cert) throws SAML2Exception {
        Element signatureEle = SigManager.getSigInstance().sign(this.toXMLString(true, true), this.getID(), privateKey, cert);
        this.signatureString = XMLUtils.print((Node)signatureEle);
        this.signedXMLString = XMLUtils.print((Node)signatureEle.getOwnerDocument().getDocumentElement(), (String)"UTF-8");
        this.isSigned = true;
        this.makeImmutable();
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Extensions value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.extensions = value;
    }

    public String getConsent() {
        return this.consent;
    }

    public void setConsent(String value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.consent = value;
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }

    public void setInResponseTo(String value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.inResponseTo = value;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.status = value;
    }

    public String getID() {
        return this.responseId;
    }

    public void setID(String value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.responseId = value;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public void setIssuer(Issuer value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.issuer = value;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isSignatureValid(X509Certificate senderCert) throws SAML2Exception {
        if (this.isSignatureValid == null) {
            this.isSignatureValid = SigManager.getSigInstance().verify(this.signedXMLString, this.getID(), senderCert);
        }
        return this.isSignatureValid;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        StringBuffer xmlString = new StringBuffer(1000);
        if (declareNS) {
            xmlString.append(" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"").append("\n");
        }
        xmlString.append("ID").append("=").append("\"").append(this.responseId).append("\"").append(" ").append("Version").append("=").append("\"").append(this.version).append("\"").append(" ").append("IssueInstant").append("=").append("\"").append(DateUtils.toUTCDateFormat((Date)this.issueInstant)).append("\"");
        if (this.destination != null && this.destination.length() > 0) {
            xmlString.append(" ").append("Destination").append("=").append("\"").append(this.destination).append("\"");
        }
        if (this.consent != null && this.consent.length() > 0) {
            xmlString.append(" ").append("Consent").append("=").append("\"").append(this.consent).append("\"");
        }
        if (this.inResponseTo != null && this.inResponseTo.length() > 0) {
            xmlString.append(" ").append("InResponseTo").append("=").append("\"").append(this.inResponseTo).append("\"");
        }
        xmlString.append(">");
        if (this.issuer != null) {
            String issuerString = this.issuer.toXMLString(includeNSPrefix, declareNS);
            xmlString.append("\n").append(issuerString);
        }
        if (this.signatureString != null && this.signatureString.length() > 0) {
            xmlString.append("\n").append(this.signatureString);
        }
        if (this.extensions != null) {
            xmlString.append("\n").append(this.extensions.toXMLString(includeNSPrefix, declareNS));
        }
        if (this.status != null) {
            xmlString.append("\n").append(this.status.toXMLString(includeNSPrefix, declareNS));
        }
        return xmlString.toString();
    }

    public void makeImmutable() {
        if (this.isMutable) {
            if (this.issuer != null && this.issuer.isMutable()) {
                this.issuer.makeImmutable();
            }
            if (this.extensions != null && this.extensions.isMutable()) {
                this.extensions.makeImmutable();
            }
            if (this.status != null && this.status.isMutable()) {
                this.status.makeImmutable();
            }
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    protected void validateID(String responseId) throws SAML2Exception {
        if (responseId == null || responseId.length() == 0) {
            SAML2SDKUtils.debug.message("ID is missing in the SAMLResponse");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingIDAttr"));
        }
    }

    protected void validateVersion(String version) throws SAML2Exception {
        if (version == null || version.length() == 0) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingVersion"));
        }
        if (!version.equals("2.0")) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("incorrectVersion"));
        }
    }

    protected void validateIssueInstant(String issueInstantStr) throws SAML2Exception {
        if (issueInstantStr == null || issueInstantStr.length() == 0) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingIssueInstant"));
        }
        try {
            this.issueInstant = DateUtils.stringToDate((String)issueInstantStr);
        }
        catch (ParseException e) {
            SAML2SDKUtils.debug.message("Error parsing IssueInstant", (Throwable)e);
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("incorrectIssueInstant"));
        }
    }

    protected void validateStatus() throws SAML2Exception {
        if (this.status == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingStatus"));
        }
    }

    protected void validateData() throws SAML2Exception {
        this.validateID(this.responseId);
        this.validateVersion(this.version);
        if (this.issueInstant == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("incorrectIssueInstant"));
        }
        this.validateIssueInstant(DateUtils.dateToString((Date)this.issueInstant));
        this.validateStatus();
    }
}

