/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.servlet;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.profile.AssertionIDRequestUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AssertionIDRequestServiceURI
extends HttpServlet {
    public void init() throws ServletException {
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGetPost(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGetPost(req, resp);
    }

    private void doGetPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AssertionIDRequestServiceSOAP.doGetPost: pathInfo is null.");
            }
            resp.sendError(500, null);
            return;
        }
        String role = null;
        int index = pathInfo.indexOf("metaAlias");
        if (index > 2) {
            role = pathInfo.substring(1, index - 1);
        }
        String samlAuthorityMetaAlias = SAML2MetaUtils.getMetaAliasByUri(req.getRequestURI());
        String samlAuthorityEntityID = null;
        String realm = null;
        try {
            samlAuthorityEntityID = SAML2Utils.getSAML2MetaManager().getEntityByMetaAlias(samlAuthorityMetaAlias);
            realm = SAML2MetaUtils.getRealmByMetaAlias(samlAuthorityMetaAlias);
        }
        catch (SAML2Exception sme) {
            SAML2Utils.debug.error("AssertionIDRequestServiceSOAP.doGetPost", (Throwable)((Object)sme));
            resp.sendError(500, sme.getMessage());
            return;
        }
        AssertionIDRequestUtil.processAssertionIDRequestURI(req, resp, samlAuthorityEntityID, role, realm);
    }
}

