/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.servlet;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.profile.LogoutUtil;
import com.sun.identity.saml2.profile.SPSingleLogout;
import com.sun.identity.saml2.protocol.LogoutRequest;
import com.sun.identity.saml2.protocol.LogoutResponse;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;

public class SPSingleLogoutServiceSOAP
extends HttpServlet {
    public void init() throws ServletException {
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            SAMLUtils.checkHTTPContentLength(req);
            String spMetaAlias = SAML2MetaUtils.getMetaAliasByUri(req.getRequestURI());
            String spEntityID = SAML2Utils.getSAML2MetaManager().getEntityByMetaAlias(spMetaAlias);
            String realm = SAML2MetaUtils.getRealmByMetaAlias(spMetaAlias);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("SPSLOSOAP.doPost : uri =" + req.getRequestURI() + ", spMetaAlias=" + spMetaAlias + ", spEntityID=" + spEntityID);
            }
            MimeHeaders headers = SAML2Utils.getHeaders(req);
            ServletInputStream is = req.getInputStream();
            SOAPMessage msg = SAML2Utils.mf.createMessage(headers, (InputStream)is);
            SOAPMessage reply = null;
            reply = this.onMessage(msg, req, resp, realm, spEntityID);
            if (reply != null) {
                if (reply.saveRequired()) {
                    reply.saveChanges();
                }
                resp.setStatus(200);
                SAML2Utils.putHeaders(reply.getMimeHeaders(), resp);
                ServletOutputStream os = resp.getOutputStream();
                reply.writeTo((OutputStream)os);
                os.flush();
            } else {
                resp.setStatus(204);
            }
        }
        catch (SAML2Exception ex) {
            SAML2Utils.debug.error("SPSingleLogoutServiceSOAP", (Throwable)((Object)ex));
            resp.sendError(500, ex.getMessage());
        }
        catch (SOAPException soap) {
            SAML2Utils.debug.error("SPSingleLogoutServiceSOAP", (Throwable)soap);
            resp.sendError(500, soap.getMessage());
        }
    }

    public SOAPMessage onMessage(SOAPMessage message, HttpServletRequest request, HttpServletResponse response, String realm, String spEntityID) {
        SAML2Utils.debug.message("SPSLOServiceSOAP.onMessage: starting");
        LogoutRequest logoutReq = null;
        String tmpStr = request.getParameter("isLBReq");
        boolean isLBReq = tmpStr == null || !tmpStr.equals("false");
        try {
            Element reqElem = SAML2Utils.getSamlpElement(message, "LogoutRequest");
            logoutReq = ProtocolFactory.getInstance().createLogoutRequest(reqElem);
        }
        catch (SAML2Exception se) {
            SAML2Utils.debug.error("SPSingleLogoutServiceSOAP.onMessage: unable to get LogoutRequest from message", (Throwable)((Object)se));
            return SAML2Utils.createSOAPFault("Client", "errorLogoutRequest", se.getMessage());
        }
        if (logoutReq == null) {
            SAML2Utils.debug.error("SPSLOServiceSOAP.onMessage: null request");
            return SAML2Utils.createSOAPFault("Client", "nullLogoutRequest", null);
        }
        LogoutResponse loRes = SPSingleLogout.processLogoutRequest(logoutReq, spEntityID, realm, request, response, isLBReq, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", false);
        if (loRes == null) {
            SAML2Utils.debug.error("SPSLOSOAP.onMessage: null LogoutResponse");
            return SAML2Utils.createSOAPFault("Server", "errorLogoutResponse", null);
        }
        SOAPMessage msg = null;
        try {
            LogoutUtil.signSLOResponse(loRes, realm, spEntityID, "SPRole", logoutReq.getIssuer().getValue());
            msg = SAML2Utils.createSOAPMessage(loRes.toXMLString(true, true));
        }
        catch (SAML2Exception se) {
            SAML2Utils.debug.error("SPSingleLogoutServiceSOAP.onMessage: Unable to create SOAP message:", (Throwable)((Object)se));
            return SAML2Utils.createSOAPFault("Server", "errorLogoutResponseSOAP", se.getMessage());
        }
        catch (SOAPException ex) {
            SAML2Utils.debug.error("SPSingleLogoutServiceSOAP.onMessage: Unable to create SOAP message:", (Throwable)ex);
            return SAML2Utils.createSOAPFault("Server", "errorLogoutResponseSOAP", ex.getMessage());
        }
        return msg;
    }
}

