/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.soapbinding;

import com.sun.identity.plugin.configuration.ConfigurationActionEvent;
import com.sun.identity.plugin.configuration.ConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationListener;
import com.sun.identity.plugin.configuration.ConfigurationManager;
import com.sun.identity.shared.debug.Debug;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SOAPBindingService
implements ConfigurationListener {
    static final String CONFIG_NAME = "SAML2_SOAP_BINDING";
    static final String SERVICE_NAME = "sunfmSAML2SOAPBindingService";
    static final String REQUEST_HANDLER_LIST_ATTR = "sunSAML2RequestHandlerList";
    static Debug debug = Debug.getInstance((String)"libSAML2SOAPBinding");
    static ConfigurationInstance ci = null;
    static HashMap handlers = new HashMap();

    private SOAPBindingService() {
    }

    public void configChanged(ConfigurationActionEvent e) {
        if (debug.messageEnabled()) {
            debug.message("SOAPBindingService: configChanged");
        }
        SOAPBindingService.setValues();
    }

    private static void setValues() {
        String classMethod = "SOAPBindingService.setValues:";
        Map attrMap = null;
        try {
            attrMap = ci.getConfiguration(null, null);
        }
        catch (ConfigurationException ce) {
            debug.error(classMethod, (Throwable)((Object)ce));
            return;
        }
        handlers.clear();
        Set values = (Set)attrMap.get(REQUEST_HANDLER_LIST_ATTR);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            String value = (String)iter.next();
            StringTokenizer stz = new StringTokenizer(value, "|");
            String key = null;
            String handlerClass = null;
            while (stz.hasMoreTokens()) {
                String token = stz.nextToken();
                if (token.startsWith("key=")) {
                    key = token.substring(4);
                    continue;
                }
                if (!token.startsWith("class=")) continue;
                handlerClass = token.substring(6);
            }
            if (key != null && handlerClass != null) {
                try {
                    handlers.put(key, Class.forName(handlerClass).newInstance());
                }
                catch (Throwable t) {
                    debug.error(classMethod + "class=" + handlerClass, t);
                }
                continue;
            }
            if (!debug.warningEnabled()) continue;
            debug.warning(classMethod + "Invalid syntax for " + "Request Handler List: " + value);
        }
    }

    static {
        try {
            ci = ConfigurationManager.getConfigurationInstance(CONFIG_NAME);
            ci.addListener(new SOAPBindingService());
            SOAPBindingService.setValues();
        }
        catch (ConfigurationException ce) {
            debug.error("SOAPBindingService.static:", (Throwable)((Object)ce));
        }
    }
}

