/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.plugins;

import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml2.common.NameIDInfoKey;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wsfederation.common.AccountUtils;
import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.wsfederation.key.KeyUtil;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class DefaultAccountMapper {
    protected static Debug debug = WSFederationUtils.debug;
    protected static ResourceBundle bundle = WSFederationUtils.bundle;
    protected static DataStoreProvider dsProvider = null;
    protected static final String IDP = "IDPRole";
    protected static final String SP = "SPRole";
    protected String role = null;
    protected static KeyProvider keyProvider = KeyUtil.getKeyProviderInstance();

    public DefaultAccountMapper() {
        debug.message("DefaultAccountMapper.constructor: ");
    }

    protected Map getSearchParameters(NameIdentifier nameID, String hostEntityID, String remoteEntityID) throws WSFederationException {
        if (nameID == null) {
            throw new WSFederationException(bundle.getString("nullNameID"));
        }
        NameIDInfoKey infoKey = null;
        try {
            infoKey = new NameIDInfoKey(nameID.getName(), hostEntityID, remoteEntityID);
        }
        catch (SAML2Exception se) {
            throw new WSFederationException((Throwable)((Object)se));
        }
        HashSet<String> set = new HashSet<String>();
        set.add(infoKey.toValueString());
        HashMap<String, HashSet<String>> keyMap = new HashMap<String, HashSet<String>>();
        keyMap.put(AccountUtils.getNameIDInfoKeyAttribute(), set);
        if (debug.messageEnabled()) {
            debug.message("DefaultAccountMapper.getNameIDKeyMap: " + keyMap);
        }
        return keyMap;
    }

    protected String getAttribute(String realm, String entityID, String attributeName) {
        if (realm == null || entityID == null || attributeName == null) {
            if (debug.messageEnabled()) {
                debug.message("DefaultAccountMapper.getAttribute: null input parameters.");
            }
            return null;
        }
        try {
            BaseConfigType config = null;
            config = this.role.equals(IDP) ? WSFederationMetaManager.getIDPSSOConfig(realm, entityID) : WSFederationMetaManager.getSPSSOConfig(realm, entityID);
            Map<String, List<String>> attributes = WSFederationMetaUtils.getAttributes(config);
            if (attributes == null || attributes.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("DefaultAccountMapper.getAttribute: attribute configuration is not defined for Entity " + entityID + " realm =" + realm + " role=" + this.role);
                }
                return null;
            }
            List<String> list = attributes.get(attributeName);
            if (list != null && list.size() > 0) {
                return list.iterator().next();
            }
            if (debug.messageEnabled()) {
                debug.message("DefaultSPAccountMapper.getAttribute: " + attributeName + " is not configured.");
            }
            return null;
        }
        catch (WSFederationMetaException sme) {
            if (debug.warningEnabled()) {
                debug.warning("DefaultSPAccountMapper.getAttribute:Meta Exception", (Throwable)((Object)sme));
            }
            return null;
        }
    }

    static {
        try {
            dsProvider = WSFederationUtils.dsProvider;
        }
        catch (Exception se) {
            debug.error("DefaultAccountMapper.static intialization failed", (Throwable)se);
            throw new ExceptionInInitializerError(se);
        }
    }
}

