/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.profile;

import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.profile.RequestedSecurityToken;
import com.sun.identity.wsfederation.profile.SAML11RequestedSecurityToken;
import org.w3c.dom.Node;

public class RequestedSecurityTokenFactory {
    private RequestedSecurityTokenFactory() {
    }

    public static RequestedSecurityToken createToken(Node element) throws WSFederationException {
        if (!element.getLocalName().equals("RequestedSecurityToken")) {
            WSFederationUtils.debug.error("Got node " + element.getLocalName() + " (expecting " + "RequestedSecurityToken" + ")");
            throw new WSFederationException(WSFederationUtils.bundle.getString("invalidToken"));
        }
        Node token = element.getFirstChild();
        if (token.getNamespaceURI().equals("urn:oasis:names:tc:SAML:1.0:assertion") && token.getLocalName().equals("Assertion")) {
            return new SAML11RequestedSecurityToken(element);
        }
        return null;
    }
}

