/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.servlet;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.servlet.IPRPSignoutRequest;
import com.sun.identity.wsfederation.servlet.IPSigninRequest;
import com.sun.identity.wsfederation.servlet.RPSigninRequest;
import com.sun.identity.wsfederation.servlet.RPSigninResponse;
import com.sun.identity.wsfederation.servlet.WSFederationAction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WSFederationActionFactory {
    private static Debug debug = WSFederationUtils.debug;

    private WSFederationActionFactory() {
    }

    public static WSFederationAction createAction(HttpServletRequest request, HttpServletResponse response) {
        String wctx;
        String wct;
        String wreply;
        String wtrealm;
        String whr;
        String wresult;
        String classMethod = "WSFederationActionFactory.createAction: ";
        WSFederationAction action = null;
        String wa = request.getParameter("wa");
        if (wa != null && debug.messageEnabled()) {
            debug.message(classMethod + "wa" + "=" + wa);
        }
        if ((wresult = request.getParameter("wresult")) != null && debug.messageEnabled()) {
            debug.message(classMethod + "wresult" + "=" + wresult);
        }
        if ((whr = request.getParameter("whr")) != null && debug.messageEnabled()) {
            debug.message(classMethod + "whr" + "=" + whr);
        }
        if ((wtrealm = request.getParameter("wtrealm")) != null && debug.messageEnabled()) {
            debug.message(classMethod + "wtrealm" + "=" + wtrealm);
        }
        if ((wreply = request.getParameter("goto")) == null || wreply.length() == 0) {
            wreply = request.getParameter("wreply");
        }
        if (wreply != null && debug.messageEnabled()) {
            debug.message(classMethod + "wreply" + "=" + wreply);
        }
        if ((wct = request.getParameter("wct")) != null && debug.messageEnabled()) {
            debug.message(classMethod + "wct" + "=" + wct);
        }
        if ((wctx = request.getParameter("wctx")) != null && debug.messageEnabled()) {
            debug.message(classMethod + "wctx" + "=" + wctx);
        }
        if (request.getMethod().equals("GET")) {
            if (wa == null || wa.equals("wsignin1.0")) {
                if (wtrealm != null && wtrealm.length() > 0) {
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "initiating IP signin request");
                    }
                    action = new IPSigninRequest(request, response, whr, wtrealm, wct, wctx, wreply);
                } else {
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "initiating SP signin request");
                    }
                    action = new RPSigninRequest(request, response, whr, wct, wctx, wreply);
                }
            } else if (wa.equals("wsignout1.0") || wa.equals("wsignoutcleanup1.0")) {
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "initiating signout request");
                }
                action = new IPRPSignoutRequest(request, response, wreply);
            }
        } else if (request.getMethod().equals("POST") && wa.equals("wsignin1.0") && wresult != null) {
            if (debug.messageEnabled()) {
                debug.message(classMethod + "initiating SP signin response");
            }
            action = new RPSigninResponse(request, response, wresult, wctx);
        }
        return action;
    }
}

