/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.context.impl;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.context.ContextFactory;
import com.sun.identity.xacml.context.Response;
import com.sun.identity.xacml.context.Result;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResponseImpl
implements Response {
    private List results = new ArrayList();
    private boolean mutable = true;

    public ResponseImpl() {
    }

    public ResponseImpl(String xml) throws XACMLException {
        Document document = XMLUtils.toDOMDocument((String)xml, (Debug)XACMLSDKUtils.debug);
        if (document == null) {
            XACMLSDKUtils.debug.error("ResponseImpl.processElement(): invalid XML input");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public ResponseImpl(Element element) throws XACMLException {
        this.processElement(element);
        this.makeImmutable();
    }

    public List getResults() {
        return this.results;
    }

    public void setResults(List values) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (values != null) {
            Iterator iter = values.iterator();
            this.results = new ArrayList();
            while (iter.hasNext()) {
                Result value = (Result)iter.next();
                this.results.add(value);
            }
        } else {
            this.results = null;
        }
    }

    public void addResult(Result result) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (this.results == null) {
            this.results = new ArrayList();
        }
        this.results.add(result);
    }

    public String toXMLString() throws XACMLException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws XACMLException {
        StringBuffer sb = new StringBuffer(2000);
        String nsPrefix = "";
        String nsDeclaration = "";
        if (includeNSPrefix) {
            nsPrefix = XACMLConstants.CONTEXT_NS_PREFIX + ":";
        }
        if (declareNS) {
            nsDeclaration = XACMLConstants.CONTEXT_NS_DECLARATION;
        }
        sb.append("<").append(nsPrefix).append("Response").append(nsDeclaration).append(">\n");
        int length = 0;
        if (this.results != null) {
            length = this.results.size();
            for (int i = 0; i < length; ++i) {
                Result result = (Result)this.results.get(i);
                sb.append(result.toXMLString(includeNSPrefix, false));
            }
        }
        sb.append("</").append(nsPrefix).append("Response").append(">\n");
        return sb.toString();
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void makeImmutable() {
        if (this.mutable) {
            if (this.results != null) {
                int length = this.results.size();
                for (int i = 0; i < length; ++i) {
                    Result result = (Result)this.results.get(i);
                    result.makeImmutable();
                }
                this.results = Collections.unmodifiableList(this.results);
            }
            this.mutable = false;
        }
    }

    private void processElement(Element element) throws XACMLException {
        if (element == null) {
            XACMLSDKUtils.debug.error("ResponseImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            XACMLSDKUtils.debug.error("ResponseImpl.processElement(): local name missing");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_local_name"));
        }
        if (!elemName.equals("Response")) {
            XACMLSDKUtils.debug.error("ResponseImpl.processElement(): invalid local name " + elemName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_local_name"));
        }
        NodeList nodes = element.getChildNodes();
        int numOfNodes = nodes.getLength();
        for (int nextElem = 0; nextElem < numOfNodes; ++nextElem) {
            String childName;
            Node child = nodes.item(nextElem);
            if (child.getNodeType() != 1 || (childName = child.getLocalName()) == null) continue;
            if (childName.equals("Result")) {
                this.results.add(ContextFactory.getInstance().createResult((Element)child));
                continue;
            }
            XACMLSDKUtils.debug.error("ResponseImpl.processElement():  invalid child element: " + elemName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_child_name"));
        }
    }
}

