/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testing.core.configuration;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.drools.testing.core.configuration.PropertyNotFoundException;

public class ApplicationProperties {
    private static ApplicationProperties s_AppProperties;
    private Properties m_Properties;
    private String m_FileName;
    public static final String SYSTEM_PROPERTY = "rtl.properties.file";
    public static final String ENVIRONMENT_PROPERTY = "environment";
    public static final String DELIMETER = "_";
    static Log log;
    static /* synthetic */ Class class$org$drools$testing$core$configuration$ApplicationProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ApplicationProperties() {
        block11: {
            this.m_FileName = "/org/drools/testing/core/resources/rtl/rtl.properties";
            String methodName = "ApplicationProperties()";
            BufferedInputStream bis = null;
            this.m_Properties = new Properties();
            log.info((Object)("AppProperties - using property file: " + this.m_FileName));
            bis = new BufferedInputStream((class$org$drools$testing$core$configuration$ApplicationProperties == null ? (class$org$drools$testing$core$configuration$ApplicationProperties = ApplicationProperties.class$("org.drools.testing.core.configuration.ApplicationProperties")) : class$org$drools$testing$core$configuration$ApplicationProperties).getResourceAsStream(this.m_FileName));
            this.m_Properties.load(bis);
            Object var5_3 = null;
            try {
                if (bis != null) {
                    bis.close();
                }
                break block11;
            }
            catch (IOException ex2) {}
            break block11;
            {
                catch (Exception ex) {
                    log.error((Object)ex);
                    Object var5_4 = null;
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                        break block11;
                    }
                    catch (IOException ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ApplicationProperties(String fileName) {
        block19: {
            this.m_FileName = "/org/drools/testing/core/resources/rtl/rtl.properties";
            String methodName = "ApplicationProperties()";
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            this.m_Properties = new Properties();
            log.info((Object)("AppProperties - using property file: " + fileName));
            fis = new FileInputStream(fileName);
            bis = new BufferedInputStream((class$org$drools$testing$core$configuration$ApplicationProperties == null ? (class$org$drools$testing$core$configuration$ApplicationProperties = ApplicationProperties.class$("org.drools.testing.core.configuration.ApplicationProperties")) : class$org$drools$testing$core$configuration$ApplicationProperties).getResourceAsStream(this.m_FileName));
            this.m_Properties.load(bis);
            Object var7_5 = null;
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            try {
                if (fis != null) {
                    fis.close();
                }
                break block19;
            }
            catch (IOException ex2) {}
            break block19;
            {
                catch (Exception ex) {
                    log.error((Object)ex);
                    Object var7_6 = null;
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block19;
                    }
                    catch (IOException ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public String getProperty(String propertyName) throws PropertyNotFoundException {
        String result = this.m_Properties.getProperty(propertyName);
        if (result == null) {
            throw new PropertyNotFoundException("Could not find property " + propertyName + " in file " + this.m_FileName);
        }
        return result;
    }

    public String getEnvironmentSpecificProperty(String propertyName) throws PropertyNotFoundException {
        String environment = System.getProperty(ENVIRONMENT_PROPERTY);
        if (environment == null) {
            throw new IllegalStateException("The System parameter: environment must be set");
        }
        String result = this.m_Properties.getProperty(environment + DELIMETER + propertyName);
        if (result == null) {
            throw new PropertyNotFoundException("Could not find environement specific property " + environment + DELIMETER + propertyName + " in file " + this.m_FileName);
        }
        return result;
    }

    public String[] getPropertyEntries(String propertyName, String separatorString) throws PropertyNotFoundException {
        String prop = this.m_Properties.getProperty(propertyName);
        if (prop == null) {
            throw new PropertyNotFoundException("Could not find property " + propertyName + " in file " + this.m_FileName);
        }
        StringTokenizer tokeniser = new StringTokenizer(prop, separatorString);
        String[] result = new String[tokeniser.countTokens()];
        int i = 0;
        while (tokeniser.hasMoreElements()) {
            result[i++] = tokeniser.nextToken();
        }
        return result;
    }

    public Iterator getPropertyNames() {
        return ((Hashtable)this.m_Properties).keySet().iterator();
    }

    public void loadProprtyFile(String fileName) {
        String methodName = "loadProprtyFile(String fileName)";
        if (fileName == null) {
            log.error((Object)"File name is null");
        } else {
            s_AppProperties = new ApplicationProperties(fileName);
        }
    }

    public String propertiesToString() {
        if (this.m_Properties == null) {
            return "Properties have not been initialised";
        }
        String props = "";
        Iterator propertyKeys = this.getPropertyNames();
        while (propertyKeys.hasNext()) {
            String currentKey = (String)propertyKeys.next();
            props = props + currentKey + "=" + ((Hashtable)this.m_Properties).get(currentKey) + "\n";
        }
        return props;
    }

    public static ApplicationProperties getInstance() {
        if (s_AppProperties == null) {
            s_AppProperties = new ApplicationProperties();
        }
        return s_AppProperties;
    }

    public String getFileName() {
        return this.m_FileName;
    }

    public static void flushProperties() {
        String methodName = "flushProperties()";
        s_AppProperties = null;
    }

    public String getPropertyWithDefault(String property, String defaultValue) {
        try {
            return this.getProperty(property);
        }
        catch (PropertyNotFoundException e) {
            return defaultValue;
        }
    }

    public int getPropertyAsInt(String property) throws PropertyNotFoundException {
        try {
            return new Integer(this.getProperty(property));
        }
        catch (NumberFormatException e) {
            throw new PropertyNotFoundException("Property was found but could not converted to an int");
        }
    }

    public int getPropertyAsIntWithDefault(String property, int defaultValue) {
        try {
            return new Integer(this.getProperty(property));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = LogFactory.getLog((Class)(class$org$drools$testing$core$configuration$ApplicationProperties == null ? (class$org$drools$testing$core$configuration$ApplicationProperties = ApplicationProperties.class$("org.drools.testing.core.configuration.ApplicationProperties")) : class$org$drools$testing$core$configuration$ApplicationProperties));
    }
}

