/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding.jbossxb;

import java.io.InputStream;
import java.util.HashMap;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBSupport;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBUnmarshaller;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.UnmarshalException;
import org.jboss.ws.extensions.xop.jaxrpc.XOPUnmarshallerImpl;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.xop.XOPUnmarshaller;

public class JBossXBUnmarshallerImpl
implements JBossXBUnmarshaller {
    private HashMap<String, Object> properties = new HashMap();

    public Object unmarshal(InputStream is) throws UnmarshalException {
        this.assertRequiredProperties();
        Unmarshaller unm = UnmarshallerFactory.newInstance().newUnmarshaller();
        SchemaBinding schemaBinding = JBossXBSupport.getOrCreateSchemaBinding(this.properties);
        XOPUnmarshallerImpl xopUnmarshaller = new XOPUnmarshallerImpl();
        schemaBinding.setXopUnmarshaller((XOPUnmarshaller)xopUnmarshaller);
        try {
            return unm.unmarshal(is, schemaBinding);
        }
        catch (JBossXBException e) {
            throw new UnmarshalException(e.getMessage(), e);
        }
    }

    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        this.properties.put(name, value);
    }

    private void assertRequiredProperties() {
        if (this.getProperty("org.jboss.xb.xsd.xsmodel") == null) {
            throw new WSException("Cannot find required property: org.jboss.xb.xsd.xsmodel");
        }
        if (this.getProperty("org.jboss.xb.java.mapping") == null) {
            throw new WSException("Cannot find required property: org.jboss.xb.java.mapping");
        }
    }
}

