/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bytes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;

public class ByteBlockChopper {
    private static final Log log = LogFactory.getLog((Class)ByteBlockChopper.class);

    private ByteBlockChopper() {
    }

    public static List chopItUp(byte[] byteArray) {
        List<Object> bytes = null;
        if (byteArray != null) {
            int byteCount = byteArray.length;
            int blockSize = JbpmConfiguration.Configs.getInt("jbpm.byte.block.size");
            if (byteCount > blockSize) {
                log.debug((Object)("chopping " + byteCount + " bytes"));
                bytes = new ArrayList();
                int offset = 0;
                while (byteCount - offset > blockSize) {
                    bytes.add(ByteBlockChopper.subArray(byteArray, offset, blockSize));
                    offset += blockSize;
                }
                bytes.add(ByteBlockChopper.subArray(byteArray, offset, byteCount - offset));
            } else if (byteCount > 0) {
                log.debug((Object)("no need to chop " + byteCount + " bytes"));
                bytes = Collections.singletonList(byteArray);
            }
        }
        return bytes;
    }

    private static byte[] subArray(byte[] array, int offset, int length) {
        byte[] subArray = new byte[length];
        System.arraycopy(array, offset, subArray, 0, length);
        log.debug((Object)("chopped " + length + " bytes beggining at " + offset));
        return subArray;
    }

    public static byte[] glueChopsBackTogether(List byteBlocks) {
        byte[] byteArray = null;
        if (byteBlocks != null) {
            int blockCount = byteBlocks.size();
            switch (blockCount) {
                case 0: {
                    break;
                }
                case 1: {
                    byteArray = (byte[])byteBlocks.get(0);
                    log.debug((Object)("no need to glue " + byteArray.length + " bytes"));
                    break;
                }
                default: {
                    int blockSize = JbpmConfiguration.Configs.getInt("jbpm.byte.block.size");
                    byte[] lastBlock = (byte[])byteBlocks.get(blockCount - 1);
                    int byteCount = blockSize * (blockCount - 1) + lastBlock.length;
                    log.debug((Object)("gluing " + byteCount + " bytes"));
                    byteArray = new byte[byteCount];
                    int offset = 0;
                    int n = blockCount;
                    for (int i = 0; i < n; ++i) {
                        byte[] block = (byte[])byteBlocks.get(i);
                        int length = block.length;
                        System.arraycopy(block, 0, byteArray, offset, length);
                        log.debug((Object)("glued " + length + " bytes beggining at " + offset));
                        if (length < blockSize && i < n - 1) {
                            Arrays.fill(byteArray, offset + length, offset + blockSize, (byte)0);
                            log.debug((Object)("zero filled " + (blockSize - length) + " trailing bytes"));
                            offset += blockSize;
                            continue;
                        }
                        offset += length;
                    }
                }
            }
        }
        return byteArray;
    }
}

