/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.util.EqualsUtil;

public class Event
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EVENTTYPE_TRANSITION = "transition";
    public static final String EVENTTYPE_BEFORE_SIGNAL = "before-signal";
    public static final String EVENTTYPE_AFTER_SIGNAL = "after-signal";
    public static final String EVENTTYPE_PROCESS_START = "process-start";
    public static final String EVENTTYPE_PROCESS_END = "process-end";
    public static final String EVENTTYPE_NODE_ENTER = "node-enter";
    public static final String EVENTTYPE_NODE_LEAVE = "node-leave";
    public static final String EVENTTYPE_SUPERSTATE_ENTER = "superstate-enter";
    public static final String EVENTTYPE_SUPERSTATE_LEAVE = "superstate-leave";
    public static final String EVENTTYPE_SUBPROCESS_CREATED = "subprocess-created";
    public static final String EVENTTYPE_SUBPROCESS_END = "subprocess-end";
    public static final String EVENTTYPE_TASK_CREATE = "task-create";
    public static final String EVENTTYPE_TASK_ASSIGN = "task-assign";
    public static final String EVENTTYPE_TASK_START = "task-start";
    public static final String EVENTTYPE_TASK_END = "task-end";
    public static final String EVENTTYPE_TIMER_CREATE = "timer-create";
    public static final String EVENTTYPE_TIMER = "timer";
    long id = 0L;
    protected String eventType = null;
    protected GraphElement graphElement = null;
    protected List actions = null;

    public Event() {
    }

    public Event(String eventType) {
        this.eventType = eventType;
    }

    public Event(GraphElement graphElement, String eventType) {
        this.graphElement = graphElement;
        this.eventType = eventType;
    }

    public List getActions() {
        return this.actions;
    }

    public boolean hasActions() {
        return this.actions != null && this.actions.size() > 0;
    }

    public Action addAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("can't add a null action to an event");
        }
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        this.actions.add(action);
        action.event = this;
        return action;
    }

    public void removeAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("can't remove a null action from an event");
        }
        if (this.actions != null && this.actions.remove(action)) {
            action.event = null;
        }
    }

    public String toString() {
        return this.eventType;
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public String getEventType() {
        return this.eventType;
    }

    public GraphElement getGraphElement() {
        return this.graphElement;
    }

    public long getId() {
        return this.id;
    }
}

