/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.job.executor.JobExecutorThread;
import org.jbpm.job.executor.LockMonitorThread;

public class JobExecutor
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected JbpmConfiguration jbpmConfiguration;
    protected String name;
    protected int nbrOfThreads;
    protected int idleInterval;
    protected int maxIdleInterval;
    protected int historyMaxSize;
    protected int maxLockTime;
    protected int lockMonitorInterval;
    protected int lockBufferTime;
    protected Map threads = new HashMap();
    protected LockMonitorThread lockMonitorThread;
    protected Map monitoredJobIds = new Hashtable();
    protected boolean isStarted = false;
    protected static String hostName;
    private static Log log;

    public synchronized void start() {
        if (!this.isStarted) {
            log.debug((Object)("starting thread group '" + this.name + "'..."));
            for (int i = 0; i < this.nbrOfThreads; ++i) {
                this.startThread();
            }
            this.lockMonitorThread = new LockMonitorThread(this.getLockMonitorThreadName(), this);
            this.lockMonitorThread.start();
            this.isStarted = true;
        } else {
            log.debug((Object)("ignoring start: thread group '" + this.name + "' is already started'"));
        }
    }

    public synchronized List stop() {
        ArrayList<Thread> stoppedThreads;
        if (this.isStarted) {
            log.debug((Object)("stopping thread group '" + this.name + "'..."));
            this.isStarted = false;
            stoppedThreads = new ArrayList<Thread>(this.threads.size());
            for (int i = 0; i < this.nbrOfThreads; ++i) {
                stoppedThreads.add(this.stopThread());
            }
            if (this.lockMonitorThread != null) {
                this.lockMonitorThread.deactivate();
            }
        } else {
            log.debug((Object)("ignoring stop: thread group '" + this.name + "' not started"));
            stoppedThreads = Collections.EMPTY_LIST;
        }
        return stoppedThreads;
    }

    public void stopAndJoin() throws InterruptedException {
        Iterator i = this.stop().iterator();
        while (i.hasNext()) {
            Thread thread = (Thread)i.next();
            thread.join();
        }
        if (this.lockMonitorThread != null) {
            this.lockMonitorThread.join();
        }
    }

    public void ensureThreadsAreActive() {
        ArrayList<String> deadThreads = new ArrayList<String>();
        Iterator i = this.threads.values().iterator();
        while (i.hasNext()) {
            Thread thread = (Thread)i.next();
            if (thread.isAlive()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("detected dead thread '" + thread.getName() + "'"));
            }
            deadThreads.add(thread.getName());
            i.remove();
        }
        for (int i2 = 0; i2 < deadThreads.size(); ++i2) {
            this.startThread((String)deadThreads.get(i2));
        }
    }

    protected void startThread() {
        this.startThread(this.getNextThreadName());
    }

    protected synchronized void startThread(String threadName) {
        Thread thread = this.createThread(threadName);
        this.threads.put(threadName, thread);
        log.debug((Object)("starting new job executor thread '" + threadName + "'"));
        thread.start();
    }

    protected Thread createThread(String threadName) {
        return new JobExecutorThread(threadName, this);
    }

    protected String getNextThreadName() {
        return this.getThreadName(this.threads.size() + 1);
    }

    protected String getLastThreadName() {
        return this.getThreadName(this.threads.size());
    }

    private String getThreadName(int index) {
        return this.name + ":" + JobExecutor.getHostAddress() + ":" + index;
    }

    private String getLockMonitorThreadName() {
        return this.name + ':' + "LockMonitorThread" + '@' + JobExecutor.getHostAddress();
    }

    private static String getHostAddress() {
        if (hostName == null) {
            try {
                hostName = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                hostName = "127.0.0.1";
            }
        }
        return hostName;
    }

    protected synchronized Thread stopThread() {
        String threadName = this.getLastThreadName();
        log.debug((Object)("removing job executor thread '" + threadName + "'"));
        Thread thread = (Thread)this.threads.remove(threadName);
        if (thread instanceof JobExecutorThread) {
            JobExecutorThread jobThread = (JobExecutorThread)thread;
            jobThread.deactivate();
        }
        return thread;
    }

    public Set getMonitoredJobIds() {
        return new HashSet(this.monitoredJobIds.values());
    }

    public void addMonitoredJobId(String threadName, long jobId) {
        this.monitoredJobIds.put(threadName, new Long(jobId));
    }

    public void removeMonitoredJobId(String threadName) {
        this.monitoredJobIds.remove(threadName);
    }

    public void setMonitoredJobIds(Map monitoredJobIds) {
        throw new UnsupportedOperationException();
    }

    public int getHistoryMaxSize() {
        return this.historyMaxSize;
    }

    public void setHistoryMaxSize(int historyMaxSize) {
        this.historyMaxSize = historyMaxSize;
    }

    public int getIdleInterval() {
        return this.idleInterval;
    }

    public void setIdleInterval(int idleInterval) {
        this.idleInterval = idleInterval;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void setStarted(boolean isStarted) {
        throw new UnsupportedOperationException();
    }

    public JbpmConfiguration getJbpmConfiguration() {
        return this.jbpmConfiguration;
    }

    public void setJbpmConfiguration(JbpmConfiguration jbpmConfiguration) {
        this.jbpmConfiguration = jbpmConfiguration;
    }

    public int getMaxIdleInterval() {
        return this.maxIdleInterval;
    }

    public void setMaxIdleInterval(int maxIdleInterval) {
        this.maxIdleInterval = maxIdleInterval;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSize() {
        return this.nbrOfThreads;
    }

    public void setSize(int nbrOfThreads) {
        this.nbrOfThreads = nbrOfThreads;
    }

    public Map getThreads() {
        return this.threads;
    }

    public void setThreads(Map threads) {
        throw new UnsupportedOperationException();
    }

    public int getMaxLockTime() {
        return this.maxLockTime;
    }

    public void setMaxLockTime(int maxLockTime) {
        this.maxLockTime = maxLockTime;
    }

    public int getLockBufferTime() {
        return this.lockBufferTime;
    }

    public void setLockBufferTime(int lockBufferTime) {
        this.lockBufferTime = lockBufferTime;
    }

    public int getLockMonitorInterval() {
        return this.lockMonitorInterval;
    }

    public void setLockMonitorInterval(int lockMonitorInterval) {
        this.lockMonitorInterval = lockMonitorInterval;
    }

    public int getNbrOfThreads() {
        return this.nbrOfThreads;
    }

    public void setNbrOfThreads(int nbrOfThreads) {
        this.nbrOfThreads = nbrOfThreads;
    }

    static {
        log = LogFactory.getLog((Class)JobExecutor.class);
    }
}

