/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPReply;

public final class FTPExample {
    public static final String USAGE = "Usage: ftp [-s] [-b] <hostname> <username> <password> <remote file> <local file>\n\nDefault behavior is to download a file and use ASCII transfer mode.\n\t-s store file on server (upload)\n\t-b use binary transfer mode\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String[] args) {
        int base = 0;
        boolean storeFile = false;
        boolean binaryTransfer = false;
        boolean error = false;
        for (base = 0; base < args.length; ++base) {
            if (args[base].startsWith("-s")) {
                storeFile = true;
                continue;
            }
            if (!args[base].startsWith("-b")) break;
            binaryTransfer = true;
        }
        if (args.length - base != 5) {
            System.err.println(USAGE);
            System.exit(1);
        }
        String server = args[base++];
        String username = args[base++];
        String password = args[base++];
        String remote = args[base++];
        String local = args[base];
        FTPClient ftp = new FTPClient();
        ftp.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out)));
        try {
            ftp.connect(server);
            System.out.println("Connected to " + server + ".");
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion(reply)) {
                ftp.disconnect();
                System.err.println("FTP server refused connection.");
                System.exit(1);
            }
        }
        catch (IOException e) {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException f) {
                    // empty catch block
                }
            }
            System.err.println("Could not connect to server.");
            e.printStackTrace();
            System.exit(1);
        }
        try {
            if (!ftp.login(username, password)) {
                ftp.logout();
                error = true;
            } else {
                System.out.println("Remote system is " + ftp.getSystemName());
                if (binaryTransfer) {
                    ftp.setFileType(2);
                }
                ftp.enterLocalPassiveMode();
                if (storeFile) {
                    FileInputStream input = new FileInputStream(local);
                    ftp.storeFile(remote, input);
                    ((InputStream)input).close();
                } else {
                    FileOutputStream output = new FileOutputStream(local);
                    ftp.retrieveFile(remote, output);
                    ((OutputStream)output).close();
                }
                ftp.logout();
            }
        }
        catch (FTPConnectionClosedException e) {
            error = true;
            System.err.println("Server closed connection.");
            e.printStackTrace();
        }
        catch (IOException e) {
            error = true;
            e.printStackTrace();
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException f) {}
            }
        }
        System.exit(error ? 1 : 0);
    }
}

