/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.InvalidAttributeValueException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class AMOrgTemplateImpl
extends AMObjectImpl
implements AMTemplate {
    String serviceName;
    ServiceSchema serviceSchema = null;
    ServiceConfig serviceConfig = null;
    String orgDN;
    Map modAttributes = new HashMap();

    public AMOrgTemplateImpl(SSOToken ssoToken, String DN2, String serviceName, ServiceConfig sc, String orgDN) throws AMException, SSOException {
        super(ssoToken, DN2, 13);
        this.serviceName = serviceName;
        this.serviceConfig = sc;
        this.orgDN = orgDN;
        if (this.serviceConfig == null) {
            throw new AMException(AMSDKBundle.getString("485"), "485");
        }
        try {
            ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, ssoToken);
            this.serviceSchema = ssm.getSchema(SchemaType.ORGANIZATION);
            if (this.serviceSchema == null) {
                debug.error("AMOrgTemplateImpl:AMOrgTemplateImpl: " + AMSDKBundle.getString("484"));
                throw new AMException(AMSDKBundle.getString("484"), "484");
            }
        }
        catch (SMSException smsex) {
            debug.error("AMTemplateImpl:AMTemplateImpl", (Throwable)smsex);
            throw new AMException(AMSDKBundle.getString("484"), "484");
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Set getAttributeSchemas() throws AMException, SSOException {
        return this.serviceSchema.getAttributeSchemas();
    }

    public int getPriority() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setPriority(int priority) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getType() {
        return 302;
    }

    public Set getPolicyNames() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setAttributes(Map attributes) {
        this.modAttributes.putAll(attributes);
    }

    public void store() throws AMException, SSOException {
        Map attributes = this.modAttributes;
        this.modAttributes = new HashMap();
        try {
            this.serviceConfig.setAttributes(attributes);
        }
        catch (ServiceNotFoundException ex) {
            Object[] args = new Object[]{this.serviceName};
            throw new AMException(AMSDKBundle.getString("481", args), "481", args);
        }
        catch (InvalidAttributeValueException ex) {
            Object[] args = ex.getMessageArgs();
            debug.error("Store exception from SMS: " + ex, (Throwable)ex);
            throw new AMException(AMSDKBundle.getString("975", args), "975", args);
        }
        catch (SMSException ex) {
            Object[] args = new Object[]{this.serviceName};
            debug.error("Store exception from SMS: " + ex, (Throwable)ex);
            throw new AMException(AMSDKBundle.getString("486", args), "486", args);
        }
    }

    public Set getAttribute(String attributeName) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        Map attributes = this.serviceConfig.getAttributes();
        if (attributeName != null && attributes != null) {
            return (Set)attributes.get(attributeName);
        }
        return new HashSet();
    }

    public String getStringAttribute(String attributeName) throws AMException, SSOException {
        Set values = this.getAttribute(attributeName);
        if (values != null && values.size() == 1) {
            return (String)values.iterator().next();
        }
        if (values == null || values.isEmpty()) {
            return "";
        }
        throw new AMException(AMSDKBundle.getString("150"), "150");
    }

    public Map getAttributes(Set attributeNames) throws AMException, SSOException {
        Map attributes = this.serviceConfig.getAttributes();
        if (attributeNames != null && attributes != null) {
            HashMap resultMap = new HashMap();
            Iterator iter = attributeNames.iterator();
            while (iter.hasNext()) {
                String attrName = (String)iter.next();
                Object attrVal = attributes.get(attrName);
                if (attrVal == null) continue;
                resultMap.put(attrName, attrVal);
            }
            return resultMap;
        }
        return attributes;
    }

    public void delete(boolean recursive) throws AMException, SSOException {
        this.modAttributes = new HashMap();
        try {
            ServiceConfigManager scm = new ServiceConfigManager(this.serviceName, this.token);
            scm.removeOrganizationConfiguration(this.orgDN, null, false);
        }
        catch (ServiceNotFoundException ex) {
            Object[] args = new Object[]{this.serviceName};
            throw new AMException(AMSDKBundle.getString("481", args), "481", args);
        }
        catch (SMSException ex) {
            Object[] args = new Object[]{this.serviceName};
            throw new AMException(AMSDKBundle.getString("913", args), "913", args);
        }
    }

    public boolean isExists() throws SSOException {
        return true;
    }
}

