/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMEntityImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMOrganizationImpl;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMResourceImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.sdk.AMUserImpl;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class AMPeopleContainerImpl
extends AMObjectImpl
implements AMPeopleContainer {
    public AMPeopleContainerImpl(SSOToken ssoToken, String DN2) {
        super(ssoToken, DN2, 5);
    }

    public Set createUsers(Set userNames) throws AMException, SSOException {
        HashSet<AMUserImpl> usersSet = new HashSet<AMUserImpl>();
        String parentOrgDN = this.getOrganizationDN();
        AMOrganizationImpl parentOrg = new AMOrganizationImpl(this.token, parentOrgDN);
        Set serviceNames = parentOrg.getOrgTypeAttributes("iPlanetAMAdminConsoleService", "iplanet-am-required-services");
        Set objectClasses = null;
        if (serviceNames != null && !serviceNames.isEmpty()) {
            objectClasses = AMServiceUtils.getServiceObjectClasses(this.token, serviceNames);
        }
        Iterator iter = userNames.iterator();
        while (iter.hasNext()) {
            StringBuffer userDNSB = new StringBuffer();
            userDNSB.append(AMNamingAttrManager.getNamingAttr(1)).append("=").append((String)iter.next()).append(",").append(this.entryDN);
            AMUserImpl user = new AMUserImpl(this.token, userDNSB.toString());
            if (objectClasses != null && !objectClasses.isEmpty()) {
                user.setAttribute("objectclass", objectClasses);
            }
            user.create();
            usersSet.add(user);
        }
        return usersSet;
    }

    public Set createUsers(Map usersMap) throws AMException, SSOException {
        String parentOrgDN = this.getOrganizationDN();
        AMOrganizationImpl parentOrg = new AMOrganizationImpl(this.token, parentOrgDN);
        Set serviceNames = parentOrg.getOrgTypeAttributes("iPlanetAMAdminConsoleService", "iplanet-am-required-services");
        return this.createUsers(usersMap, serviceNames);
    }

    public Set createUsers(Map usersMap, Set serviceNames) throws AMException, SSOException {
        HashSet<AMUserImpl> usersSet = new HashSet<AMUserImpl>();
        Set objectClasses = null;
        if (serviceNames != null && !serviceNames.isEmpty()) {
            objectClasses = AMServiceUtils.getServiceObjectClasses(this.token, serviceNames);
        }
        Iterator iter = usersMap.keySet().iterator();
        while (iter.hasNext()) {
            String userName = (String)iter.next();
            String userDN = AMNamingAttrManager.getNamingAttr(1) + "=" + userName + "," + this.entryDN;
            AMUserImpl user = new AMUserImpl(this.token, userDN);
            Map userMap = (Map)usersMap.get(userName);
            user.setAttributes(userMap);
            if (objectClasses != null && objectClasses.size() > 0) {
                Set existingOC = (Set)userMap.get("objectclass");
                if (existingOC != null && !existingOC.isEmpty()) {
                    objectClasses = AMCommonUtils.combineOCs(objectClasses, existingOC);
                }
                user.setAttribute("objectclass", objectClasses);
            }
            user.create();
            usersSet.add(user);
        }
        return usersSet;
    }

    public AMUser createUser(String uid, Map attrMap, Map serviceNameAndAttrs) throws AMException, SSOException {
        String parentOrgDN = this.getOrganizationDN();
        AMOrganizationImpl parentOrg = new AMOrganizationImpl(this.token, parentOrgDN);
        HashSet<String> serviceNames = parentOrg.getOrgTypeAttributes("iPlanetAMAdminConsoleService", "iplanet-am-required-services");
        if (serviceNames == Collections.EMPTY_SET) {
            serviceNames = new HashSet<String>();
        }
        Set assignServiceNames = serviceNameAndAttrs.keySet();
        Set registered = null;
        registered = this.dsServices.getRegisteredServiceNames(null, this.getOrganizationDN());
        Iterator it = assignServiceNames.iterator();
        while (it.hasNext()) {
            String tmpS = (String)it.next();
            if (registered.contains(tmpS)) continue;
            Object[] args = new Object[]{tmpS};
            throw new AMException(AMSDKBundle.getString("459", args, this.locale), "459", args);
        }
        it = assignServiceNames.iterator();
        while (it.hasNext()) {
            String tmp = (String)it.next();
            if (serviceNames.contains(tmp)) continue;
            serviceNames.add(tmp);
        }
        Set objectClasses = null;
        if (serviceNames != null && !serviceNames.isEmpty()) {
            objectClasses = AMServiceUtils.getServiceObjectClasses(this.token, serviceNames);
            Set userOCs = (Set)attrMap.get("objectclass");
            objectClasses = AMCommonUtils.combineOCs(userOCs, objectClasses);
        }
        String userDN = AMNamingAttrManager.getNamingAttr(1) + "=" + uid + "," + this.entryDN;
        AMUserImpl user = new AMUserImpl(this.token, userDN);
        user.setAttributes(attrMap);
        it = assignServiceNames.iterator();
        while (it.hasNext()) {
            String thisService = (String)it.next();
            Map sAttrMap = (Map)serviceNameAndAttrs.get(thisService);
            try {
                ServiceSchemaManager ssm = new ServiceSchemaManager(thisService, this.token);
                ServiceSchema ss = ssm.getSchema(SchemaType.USER);
                sAttrMap = ss.validateAndInheritDefaults(sAttrMap, true);
                sAttrMap = AMCommonUtils.removeEmptyValues(sAttrMap);
                user.setAttributes(sAttrMap);
            }
            catch (SMSException se) {
                debug.error("AMPeopleContainerImpl: data validation failed-> " + thisService, (Throwable)se);
                Object[] args = new Object[]{thisService};
                throw new AMException(AMSDKBundle.getString("976", args, this.locale), "976", args);
            }
        }
        if (objectClasses != null && !objectClasses.isEmpty()) {
            user.setAttribute("objectclass", objectClasses);
        }
        user.create();
        return user;
    }

    public void deleteUsers(Set users) throws AMException, SSOException {
        Iterator iter = users.iterator();
        while (iter.hasNext()) {
            String userDN = (String)iter.next();
            AMUserImpl user = new AMUserImpl(this.token, userDN);
            user.delete();
        }
    }

    public long getNumberOfUsers() throws AMException, SSOException {
        return this.getUserDNs().size();
    }

    public Set getUserDNs() throws AMException, SSOException {
        return this.search(1, this.getSearchFilter(1));
    }

    public Set createSubPeopleContainers(Set peopleContainerNames) throws AMException, SSOException {
        Iterator iter = peopleContainerNames.iterator();
        HashSet<AMPeopleContainerImpl> peopleContainers = new HashSet<AMPeopleContainerImpl>();
        while (iter.hasNext()) {
            StringBuffer peopleContainerDNSB = new StringBuffer();
            peopleContainerDNSB.append(AMNamingAttrManager.getNamingAttr(5)).append("=").append((String)iter.next()).append(",").append(this.entryDN);
            AMPeopleContainerImpl peopleContainerImpl = new AMPeopleContainerImpl(this.token, peopleContainerDNSB.toString());
            peopleContainerImpl.create();
            peopleContainers.add(peopleContainerImpl);
        }
        return peopleContainers;
    }

    public Set createSubPeopleContainers(Map peopleContainersMap) throws AMException, SSOException {
        Iterator iter = peopleContainersMap.keySet().iterator();
        HashSet<AMPeopleContainerImpl> peopleContainers = new HashSet<AMPeopleContainerImpl>();
        while (iter.hasNext()) {
            String peopleContainerName = (String)iter.next();
            StringBuffer peopleContainerDNSB = new StringBuffer();
            peopleContainerDNSB.append(AMNamingAttrManager.getNamingAttr(5)).append("=").append(peopleContainerName).append(",").append(this.entryDN);
            Map attributes = (Map)peopleContainersMap.get(peopleContainerName);
            AMPeopleContainerImpl peopleContainerImpl = new AMPeopleContainerImpl(this.token, peopleContainerDNSB.toString());
            peopleContainerImpl.setAttributes(attributes);
            peopleContainerImpl.create();
            peopleContainers.add(peopleContainerImpl);
        }
        return peopleContainers;
    }

    public Set getSubPeopleContainerDNs(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(5));
    }

    public long getNumberOfSubPeopleContainers() throws AMException, SSOException {
        return this.getSubPeopleContainerDNs(1).size();
    }

    public void deleteSubPeopleContainers(Set peopleContainers) throws AMException, SSOException {
        Iterator iter = peopleContainers.iterator();
        while (iter.hasNext()) {
            String peopleContainerDN = (String)iter.next();
            AMPeopleContainerImpl peopleContainer = new AMPeopleContainerImpl(this.token, peopleContainerDN);
            peopleContainer.delete();
        }
    }

    public Set searchUsers(String wildcard, int level) throws AMException, SSOException {
        return this.searchUsers(wildcard, null, level);
    }

    public AMSearchResults searchUsers(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchUsers(wildcard, null, searchControl);
    }

    public Set searchUsers(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1), wildcard, avPairs, level);
    }

    public AMSearchResults searchUsers(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1), wildcard, avPairs, searchControl);
    }

    public AMSearchResults searchUsers(String wildcard, AMSearchControl searchControl, String avfilter) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1), wildcard, searchControl, avfilter);
    }

    public AMSearchResults searchUsers(AMSearchControl searchControl, String avfilter) throws AMException, SSOException {
        return this.searchObjects(this.getSearchFilter(1), searchControl, avfilter);
    }

    public Set searchUsers(String wildcard, int level, String userSearchTemplate, Map avPairs) throws AMException, SSOException {
        if (AMCompliance.isComplianceUserDeletionEnabled() && AMCompliance.isAncestorOrgDeleted(this.token, this.entryDN, 5)) {
            if (debug.warningEnabled()) {
                debug.warning("AMOrganization.searchUser: ancestor org is deleted for: " + this.entryDN + " :returning empty set");
            }
            return Collections.EMPTY_SET;
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1, userSearchTemplate), wildcard, avPairs, level);
    }

    public Set createResources(Set resourceNames) throws AMException, SSOException {
        HashSet<AMResourceImpl> resSet = new HashSet<AMResourceImpl>();
        Iterator iter = resourceNames.iterator();
        while (iter.hasNext()) {
            String userDN = AMNamingAttrManager.getNamingAttr(21) + "=" + (String)iter.next() + "," + this.entryDN;
            AMResourceImpl user = new AMResourceImpl(this.token, userDN);
            user.create();
            resSet.add(user);
        }
        return resSet;
    }

    public Set searchResources(String wildcard, int level, String resourceSearchTemplate, Map avPairs) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(21), this.getSearchFilter(21, resourceSearchTemplate), wildcard, avPairs, level);
    }

    public void deleteResources(Set resources) throws AMException, SSOException {
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            String rDN = (String)iter.next();
            AMResourceImpl resource = new AMResourceImpl(this.token, rDN);
            resource.delete();
        }
    }

    public Set searchSubPeopleContainers(String wildcard, int level) throws AMException, SSOException {
        return this.searchSubPeopleContainers(wildcard, null, level);
    }

    public Set searchSubPeopleContainers(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(5), this.getSearchFilter(5), wildcard, avPairs, level);
    }

    public AMSearchResults searchUsers(String wildcard, Map avPairs, String userSearchTemplate, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1, userSearchTemplate), wildcard, avPairs, searchControl);
    }

    public Set createResources(Map resourceMap) throws AMException, SSOException {
        if (resourceMap == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<AMResourceImpl> resSet = new HashSet<AMResourceImpl>();
        Iterator iter = resourceMap.keySet().iterator();
        while (iter.hasNext()) {
            String rDN = (String)iter.next();
            String userDN = AMNamingAttrManager.getNamingAttr(21) + "=" + rDN + "," + this.entryDN;
            AMResourceImpl user = new AMResourceImpl(this.token, userDN);
            Map attrMap = (Map)resourceMap.get(rDN);
            user.setAttributes(attrMap);
            user.create();
            resSet.add(user);
        }
        return resSet;
    }

    public AMSearchResults searchResources(String wildcard, Map avPairs, String rSearchTemplate, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(21), this.getSearchFilter(21, rSearchTemplate), wildcard, avPairs, searchControl);
    }

    public Set createEntities(String stype, Set entities) throws AMException, SSOException {
        HashSet<AMEntityImpl> resultSet = new HashSet<AMEntityImpl>();
        if (stype.equalsIgnoreCase("user")) {
            Set uSet = this.createUsers(entities);
            Iterator it = uSet.iterator();
            while (it.hasNext()) {
                AMUser u = (AMUser)it.next();
                AMEntityImpl e = new AMEntityImpl(this.token, u.getDN());
                resultSet.add(e);
            }
            return resultSet;
        }
        String type = (String)AMCommonUtils.supportedTypes.get(stype.toLowerCase());
        if (type == null) {
            throw new AMException(AMSDKBundle.getString("117", this.locale), "117");
        }
        int createType = Integer.parseInt(type);
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            String rDN = (String)it.next();
            String userDN = AMNamingAttrManager.getNamingAttr(createType) + "=" + rDN + "," + this.entryDN;
            AMEntityImpl user = new AMEntityImpl(this.token, userDN);
            user.create(stype);
            resultSet.add(user);
        }
        return resultSet;
    }

    public void deleteEntities(Set resources) throws AMException, SSOException {
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            String rDN = (String)iter.next();
            AMEntityImpl resource = new AMEntityImpl(this.token, rDN);
            resource.delete();
        }
    }

    public Set searchEntities(String wildcard, int level, String eSearchTemplate, Map avPairs) throws AMException, SSOException {
        if (eSearchTemplate == null) {
            eSearchTemplate = "BasicEntitySearch";
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1, eSearchTemplate), wildcard, avPairs, level);
    }

    public AMSearchResults searchEntities(String wildcard, Map avPairs, String eSearchTemplate, AMSearchControl searchControl) throws AMException, SSOException {
        if (eSearchTemplate == null) {
            eSearchTemplate = "BasicEntitySearch";
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1, eSearchTemplate), wildcard, avPairs, searchControl);
    }

    public Set createEntities(String stype, Map entities) throws AMException, SSOException {
        if (stype.equalsIgnoreCase("user")) {
            Set uSet = this.createUsers(entities);
            HashSet<AMEntityImpl> resultSet = new HashSet<AMEntityImpl>();
            Iterator it = uSet.iterator();
            while (it.hasNext()) {
                AMUser u = (AMUser)it.next();
                AMEntityImpl e = new AMEntityImpl(this.token, u.getDN());
                resultSet.add(e);
            }
            return resultSet;
        }
        String type = (String)AMCommonUtils.supportedTypes.get(stype.toLowerCase());
        if (type == null) {
            throw new AMException(AMSDKBundle.getString("117", this.locale), "117");
        }
        int createType = Integer.parseInt(type);
        HashSet<AMEntityImpl> entitySet = new HashSet<AMEntityImpl>();
        Iterator iter = entities.keySet().iterator();
        while (iter.hasNext()) {
            String userName = (String)iter.next();
            String userDN = AMNamingAttrManager.getNamingAttr(createType) + "=" + userName + "," + this.entryDN;
            AMEntityImpl user = new AMEntityImpl(this.token, userDN);
            Map userMap = (Map)entities.get(userName);
            user.setAttributes(userMap);
            user.create(stype);
            entitySet.add(user);
        }
        return entitySet;
    }

    public AMSearchResults searchEntities(String wildcard, AMSearchControl searchControl, String avfilter, String eSearchTemplate) throws AMException, SSOException {
        if (eSearchTemplate == null) {
            eSearchTemplate = "BasicEntitySearch";
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1, eSearchTemplate), wildcard, searchControl, avfilter);
    }
}

