/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMEventManagerException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.services.ldap.event.EventService;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.sun.identity.shared.debug.Debug;
import java.util.Map;

class EventManager {
    protected static final int EVENT_SCOPE = 2;
    protected static String EVENT_BASE_NODE = AMStoreConnection.getAMSdkBaseDN();
    protected static final String ACI_EVENT_LISTENER_CLASS = "com.iplanet.am.sdk.ldap.ACIEventListener";
    protected static final String ENTRY_EVENT_LISTENER_CLASS = "com.iplanet.am.sdk.ldap.EntryEventListener";
    protected static final String[] PSEARCH_LISTENERS = new String[]{"com.iplanet.am.sdk.ldap.ACIEventListener", "com.iplanet.am.sdk.ldap.EntryEventListener"};
    private static Debug debug = Debug.getInstance((String)"amEventService");

    protected EventManager() throws AMEventManagerException {
    }

    protected static Debug getDebug() {
        return debug;
    }

    protected void addListeners(Map listeners) throws AMEventManagerException {
        EventService eventService = null;
        try {
            if (debug.messageEnabled()) {
                debug.message("EventManager.start() - Getting EventService instance");
            }
            eventService = EventService.getEventService();
        }
        catch (Exception e) {
            debug.error("EventManager.start() Unable to get EventService ", (Throwable)e);
            throw new AMEventManagerException(AMSDKBundle.getString("501"), "501");
        }
        if (eventService != null) {
            int count = PSEARCH_LISTENERS.length;
            for (int i = 0; i < count; ++i) {
                IDSEventListener pSearchListener = eventService.getIDSListeners(PSEARCH_LISTENERS[i]);
                if (pSearchListener == null) continue;
                pSearchListener.setListeners(listeners);
                debug.message("EventManager.start() - Added listeners to pSearch Listener: " + PSEARCH_LISTENERS[i]);
            }
        }
    }
}

