/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdm;

import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ClientTypesManager;
import com.iplanet.services.cdm.clientschema.AMClientCapData;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.iplanet.services.cdm.clientschema.AMClientDataListener;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DefaultClientTypesManager
implements ClientTypesManager,
AMClientDataListener {
    private static String CLASS = "DefaultClientTypesManager: ";
    protected static final String CDM_SERVICE_NAME = "iPlanetAMClientDetection";
    private static final String CDM_DEFAULT_CLIENT_TYPES_ATTR = "iplanet-am-client-detection-default-client-type";
    private static Debug debug = Debug.getInstance((String)"amClientDetection");
    private static SSOToken internalToken = null;
    private static String defaultClientType = null;
    private static Map internalClientData = new Hashtable();
    private static Map externalClientData = new Hashtable();
    private static Map mergedClientData = new Hashtable();
    private static Map userAgentMap = new Hashtable();
    private static Map clientTypeMap = new Hashtable();
    private static Set updatedClients = new HashSet();
    private static Map partialMatchMap = new Hashtable();
    private static Map loadedClientsMap = new Hashtable();
    private static Map loadedInternalClients = new Hashtable();
    private static Map loadedExternalClients = new Hashtable();
    private static Map baseProfiles = new TreeMap();
    private static final String PARENT_ID = "parentId";
    private static final String CLIENT_TYPE = "clientType";
    private static final String USER_AGENT = "userAgent";
    private static AMClientCapData intCapInstance = null;
    private static AMClientCapData extCapInstance = null;
    private static boolean isInitialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initManager() {
        Map map = userAgentMap;
        synchronized (map) {
            if (!isInitialized) {
                isInitialized = true;
                long st = System.currentTimeMillis();
                this.initMinimalInternalClientTypesData();
                this.initMinimalExternalClientTypesData();
                this.mergeInternalWithExternal();
                this.loadMaps();
                long end = System.currentTimeMillis();
                if (debug.messageEnabled()) {
                    debug.message(CLASS + "Load AllClients Time (ms) = " + (end - st));
                }
                intCapInstance.addListener(this);
                extCapInstance.addListener(this);
            }
        }
    }

    private static String getDefaultClientTypeFromService() throws SMSException, SSOException {
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(CDM_SERVICE_NAME, internalToken);
        ServiceSchema gsc = serviceSchemaManager.getGlobalSchema();
        Map data = gsc.getAttributeDefaults();
        String defaultCT = (String)((Set)data.get(CDM_DEFAULT_CLIENT_TYPES_ATTR)).toArray()[0];
        return defaultCT;
    }

    private static SSOToken getInternalToken() throws SSOException {
        return (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    }

    private void initMinimalInternalClientTypesData() {
        Set clients = intCapInstance.getMinimalClientInfo();
        Iterator iter = clients.iterator();
        while (iter.hasNext()) {
            Map clientData = (Map)iter.next();
            String clientType = this.getClientType(clientData);
            if (clientType == null || clientType.length() <= 0) {
                debug.error(CLASS + "Found clientType == NULL in internal DB");
                continue;
            }
            internalClientData.put(clientType, clientData);
            Set parentIdSet = (Set)clientData.get(PARENT_ID);
            if (parentIdSet == null || !parentIdSet.contains(clientType)) continue;
            TreeMap t1 = new TreeMap();
            TreeMap t2 = new TreeMap();
            t1.put(clientType, t2);
            baseProfiles.put(clientType, t1);
            if (!debug.messageEnabled()) continue;
            debug.message(CLASS + "BaseProfile: " + clientType);
        }
    }

    private void initMinimalExternalClientTypesData() {
        Set clients = extCapInstance.getMinimalClientInfo();
        Iterator iter = clients.iterator();
        while (iter.hasNext()) {
            Map clientData = (Map)iter.next();
            String clientType = this.getClientType(clientData);
            if (clientType != null && clientType.length() > 0) {
                Map mMap = this.mergeWithInternal(clientType, clientData);
                if (mMap != null) {
                    clientData = mMap;
                }
                externalClientData.put(clientType, clientData);
                continue;
            }
            debug.error(CLASS + "Found clientType == NULL in external DB");
        }
    }

    private String getClientType(Map m) {
        return this.getFirstString((Set)m.get(CLIENT_TYPE));
    }

    private Map mergeWithParent(Map cMap) {
        String ct = this.getClientType(cMap);
        String parentId = this.getParentID(cMap);
        Map rMap = cMap;
        Map pMap = null;
        OrderedSet os = new OrderedSet();
        while (parentId != null && !ct.equals(parentId)) {
            pMap = (Map)mergedClientData.get(parentId);
            if (pMap == null) {
                debug.error(CLASS + "clientdata null for: " + parentId);
                rMap = null;
                break;
            }
            rMap = this.mergeMap(pMap, cMap);
            os.add((Object)parentId);
            cMap = rMap;
            ct = this.getClientType(pMap);
            parentId = this.getParentID(pMap);
        }
        if (rMap != null) {
            rMap.put(PARENT_ID, os);
        }
        return rMap;
    }

    private Map mergeWithInternal(String ct, Map dMap) {
        Map rMap = null;
        Map sMap = (Map)internalClientData.get(ct);
        if (sMap != null) {
            rMap = this.mergeMap(sMap, dMap);
        }
        return rMap;
    }

    private Map mergeMap(Map baseHash, Map mergeHash) {
        Map results = null;
        if (baseHash != null) {
            results = new HashMap(baseHash);
        }
        if (mergeHash != null) {
            if (results != null) {
                results.putAll(mergeHash);
            } else {
                results = mergeHash;
            }
        }
        return results;
    }

    private void mergeInternalWithExternal() {
        mergedClientData = this.mergeMap(internalClientData, externalClientData);
    }

    protected void loadMaps() {
        Set clientTypes = mergedClientData.keySet();
        Iterator keys = clientTypes.iterator();
        String clientType = null;
        Map clientDataMap = null;
        while (keys.hasNext()) {
            clientType = (String)keys.next();
            clientDataMap = (Map)mergedClientData.get(clientType);
            this.setParentStyles(clientDataMap);
        }
        keys = clientTypes.iterator();
        while (keys.hasNext()) {
            clientType = (String)keys.next();
            clientDataMap = (Map)mergedClientData.get(clientType);
            this.addToClientMap(clientType, clientDataMap);
        }
    }

    protected Client addToClientMap(String ct, Map cMap) {
        return this.addToClientMap(ct, cMap, true);
    }

    protected Client addToClientMap(String ct, Map cMap, boolean addToStyles) {
        Client client = new Client(ct, cMap);
        String userAgent = client.getProperty(USER_AGENT);
        if (userAgent != null) {
            userAgentMap.put(userAgent, ct);
        }
        clientTypeMap.put(ct, client);
        if (addToStyles) {
            this.storeInProfilesMap(client);
        }
        return client;
    }

    protected void removeFromClientMap(String ct, Client c) {
        clientTypeMap.remove(ct);
        mergedClientData.remove(ct);
        String ua = null;
        if (c != null && (ua = c.getProperty(USER_AGENT)) != null) {
            userAgentMap.remove(ua);
        }
        this.removeFromProfilesMap(ct, c);
    }

    protected void storeInProfilesMap(Client client) {
        Set parentSet = client.getProperties(PARENT_ID);
        String clientType = client.getClientType();
        Map m = this.getStylesProfileMap(clientType, parentSet);
        if (m != null) {
            m.put(clientType, client);
        }
    }

    private void handleParentChange(String ct, Map nMap) {
        Client oClient = (Client)clientTypeMap.get(ct);
        if (oClient == null) {
            this.addToClientMap(ct, nMap);
            mergedClientData.put(ct, nMap);
            return;
        }
        Set oParents = oClient.getProperties(PARENT_ID);
        String oParent = this.getFirstString(oParents);
        String nParentId = this.getParentID(nMap);
        if (!nParentId.equals(oParent)) {
            this.removeFromProfilesMap(ct, oClient);
            nMap = this.mergeWithParent(nMap);
            if (nMap != null) {
                this.addToClientMap(ct, nMap);
            }
        }
        mergedClientData.put(ct, nMap);
    }

    protected void removeFromProfilesMap(String ct, Client c) {
        if (c == null) {
            return;
        }
        Set parentSet = c.getProperties(PARENT_ID);
        Map m = this.getStylesProfileMap(ct, parentSet);
        if (m != null) {
            m.remove(ct);
        }
    }

    protected Map getStylesProfileMap(String ct, Set p) {
        String base = null;
        String style = null;
        if (ct == null || p == null) {
            return null;
        }
        Iterator itr = p.iterator();
        while (itr.hasNext()) {
            style = base;
            base = (String)itr.next();
        }
        if (style == null) {
            style = base;
        }
        Map m = null;
        Map profMap = (Map)baseProfiles.get(base);
        if (profMap != null) {
            if (profMap.containsKey(ct)) {
                profMap = null;
            } else {
                m = (Map)profMap.get(style);
                if (m != null) {
                    profMap = m;
                }
            }
        }
        return profMap;
    }

    private String getFirstString(Set set) {
        String retVal = null;
        if (set != null && set.iterator().hasNext()) {
            retVal = (String)set.iterator().next();
        }
        return retVal;
    }

    protected Client addToIndexes(String ct, Map cMap) {
        return this.addToIndexes(ct, cMap, true);
    }

    protected Client addToIndexes(String ct, Map cMap, boolean addtoStyles) {
        mergedClientData.put(ct, cMap);
        Client client = this.addToClientMap(ct, cMap, addtoStyles);
        String ua = client.getProperty(USER_AGENT);
        if (ua != null) {
            partialMatchMap.remove(ua);
            if (partialMatchMap.containsValue(ct)) {
                Iterator itr = partialMatchMap.values().iterator();
                while (itr.hasNext()) {
                    String cType = (String)itr.next();
                    if (cType == null || !cType.equals(ct)) continue;
                    itr.remove();
                }
            }
        }
        return client;
    }

    public Client getFromUserAgentMap(String ua) {
        String clientType = ua != null ? (String)userAgentMap.get(ua) : null;
        Client c = null;
        if (clientType != null) {
            c = this.getClientInstance(clientType);
        }
        return c;
    }

    public Set userAgentSet() {
        Set keys = userAgentMap.keySet();
        return keys;
    }

    public String getPartiallyMatchedClient(String ua) {
        String ct = (String)partialMatchMap.get(ua);
        return ct;
    }

    public void addToPartialMatchMap(String ua, String clientType) {
        partialMatchMap.put(ua, clientType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client addClient(SSOToken token, String clientType, Map cMap, boolean store) throws AMClientCapException {
        Client client = null;
        if (cMap == null || cMap.size() == 0) {
            return client;
        }
        if (debug.messageEnabled()) {
            debug.message(CLASS + "Adding new Client: " + cMap);
        }
        if (store) {
            Map map = internalClientData;
            synchronized (map) {
                intCapInstance.addClient(token, cMap);
                cMap = this.mergeWithParent(cMap);
                internalClientData.put(clientType, cMap);
            }
        } else {
            cMap = this.mergeWithParent(cMap);
        }
        client = this.addToIndexes(clientType, cMap, store);
        if (!store) {
            loadedClientsMap.put(clientType, client);
        }
        return client;
    }

    public boolean canCreateClients() {
        return intCapInstance.canCreateInternalClients();
    }

    public Map getAllClientInstances() {
        return clientTypeMap;
    }

    public Set getAllClientTypes() {
        return clientTypeMap.keySet();
    }

    public Client getClientInstance(String clientType) {
        if (clientType.equals("default")) {
            clientType = defaultClientType;
        }
        Client client = null;
        client = (Client)loadedClientsMap.get(clientType);
        if (client == null) {
            client = this.loadClient(clientType);
        }
        return client;
    }

    public Client getClientInstance(String clientType, SSOToken token) {
        return this.getClientInstance(clientType);
    }

    public Map getClientTypeData(String clientType) {
        if (clientType.equals("default")) {
            clientType = defaultClientType;
        }
        if (mergedClientData.get(clientType) == null) {
            this.loadClient(clientType);
        }
        Map map = (Map)mergedClientData.get(clientType);
        return map;
    }

    protected Client loadClient(String clientType) {
        Client client = null;
        long st = System.currentTimeMillis();
        Map iMap = this.loadInternalClient(clientType);
        Map eMap = this.loadExternalClient(clientType);
        if (iMap == null && eMap == null) {
            return client;
        }
        Map mergedMap = this.mergeMap(iMap, eMap);
        String ct = clientType;
        String parentID = this.getParentID(mergedMap);
        OrderedSet os = new OrderedSet();
        while (parentID != null && !ct.equals(parentID)) {
            os.add((Object)parentID);
            Map pMap = this.loadInternalClient(parentID);
            if (pMap == null) break;
            mergedMap = this.mergeMap(pMap, mergedMap);
            ct = this.getClientType(pMap);
            parentID = this.getParentID(pMap);
        }
        if (os.size() > 0) {
            mergedMap.put(PARENT_ID, os);
        }
        mergedClientData.put(clientType, mergedMap);
        client = new Client(clientType, mergedMap);
        loadedClientsMap.put(clientType, client);
        long end = System.currentTimeMillis();
        if (debug.messageEnabled()) {
            debug.message(CLASS + "Load Client " + clientType + " Time (ms) = " + (end - st));
        }
        return client;
    }

    protected Map loadInternalClient(String clientType) {
        Map iMap = (Map)loadedInternalClients.get(clientType);
        if (iMap == null) {
            iMap = intCapInstance.getProperties(clientType);
            if (iMap == null) {
                return null;
            }
            loadedInternalClients.put(clientType, iMap);
            internalClientData.put(clientType, iMap);
        }
        return iMap;
    }

    protected Map loadExternalClient(String clientType) {
        Map eMap = (Map)loadedExternalClients.get(clientType);
        if (eMap == null) {
            eMap = extCapInstance.getProperties(clientType);
            if (eMap == null) {
                return null;
            }
            loadedExternalClients.put(clientType, eMap);
            externalClientData.put(clientType, eMap);
        }
        return eMap;
    }

    private String getParentID(Map clientData) {
        Set cParents = (Set)clientData.get(PARENT_ID);
        String parentId = this.getFirstString(cParents);
        return parentId;
    }

    public String getDefaultClientType() {
        return defaultClientType;
    }

    public void updateClientData() throws ClientException {
    }

    public void store(SSOToken token) throws SMSException, SSOException {
    }

    public void setDirty(String ct, Map data) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientChanged(String clientType, int dbType, int opType) {
        if (debug.messageEnabled()) {
            debug.message(CLASS + "clientChanged() Notification: " + "clientType = " + clientType + " :DB = " + dbType + " : Op = " + opType);
        }
        if (clientType == null || clientType.length() == 0) {
            return;
        }
        if (opType == 1) {
            if (dbType == 1) {
                if (!internalClientData.containsKey(clientType)) {
                    Map iMap = intCapInstance.loadMinimalClient(clientType);
                    Map oMap = (Map)mergedClientData.get(clientType);
                    Map mMap = this.mergeMap(oMap, iMap);
                    this.handleParentChange(clientType, mMap);
                    this.unloadClient(clientType);
                }
            } else if (dbType == 2) {
                Set set = updatedClients;
                synchronized (set) {
                    if (!externalClientData.containsKey(clientType)) {
                        Map eMap = extCapInstance.loadMinimalClient(clientType);
                        Map oMap = (Map)mergedClientData.get(clientType);
                        Map mMap = this.mergeMap(oMap, eMap);
                        this.handleParentChange(clientType, mMap);
                        this.unloadClient(clientType);
                    }
                }
            }
        } else if (opType == 4) {
            Set set = updatedClients;
            synchronized (set) {
                if (updatedClients.contains(clientType)) {
                    updatedClients.remove(clientType);
                } else {
                    Map cMap = extCapInstance.loadMinimalClient(clientType);
                    Map oMap = (Map)mergedClientData.get(clientType);
                    Map mMap = this.mergeMap(oMap, cMap);
                    this.handleParentChange(clientType, mMap);
                    this.unloadClient(clientType);
                }
            }
        } else if (opType == 2) {
            if (externalClientData.containsKey(clientType)) {
                this.removeFromMaps(clientType);
            }
        } else {
            debug.warning(CLASS + "clientChanged(): unknown OpType");
        }
    }

    public Set getBaseProfileNames() {
        return baseProfiles.keySet();
    }

    public Set getStyles(String baseProfileName) {
        Set styles = null;
        Map styleMap = (Map)baseProfiles.get(baseProfileName);
        if (styleMap != null) {
            styles = styleMap.keySet();
        }
        return styles;
    }

    public Map getClients(String baseProfileName, String style) {
        Map cMap = null;
        Map styleMap = (Map)baseProfiles.get(baseProfileName);
        if (styleMap != null) {
            cMap = (Map)styleMap.get(style);
        }
        return cMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addClientExternal(SSOToken token, Map props) throws AMClientCapException {
        Map map = externalClientData;
        synchronized (map) {
            extCapInstance.addClient(token, props);
            String ct = this.getClientType(props);
            Map eMap = this.mergeWithParent(props);
            externalClientData.put(ct, eMap);
            this.addToIndexes(ct, eMap);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int modifyClientExternal(SSOToken token, Map props) throws AMClientCapException {
        if (props == null || props.size() == 0) {
            return 0;
        }
        Set set = updatedClients;
        synchronized (set) {
            extCapInstance.modifyClient(token, props);
            String ct = this.getClientType(props);
            if (!externalClientData.containsKey(ct)) {
                externalClientData.put(ct, props);
            } else {
                updatedClients.add(ct);
            }
            Map oMap = (Map)mergedClientData.get(ct);
            props = this.mergeMap(oMap, props);
            this.handleParentChange(ct, props);
            this.unloadClient(ct);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeClientExternal(SSOToken token, String clientType) throws AMClientCapException {
        Map map = externalClientData;
        synchronized (map) {
            extCapInstance.removeClient(token, clientType);
            this.removeFromMaps(clientType);
        }
        return 0;
    }

    protected void removeFromMaps(String clientType) {
        Client client = (Client)clientTypeMap.get(clientType);
        externalClientData.remove(clientType);
        Map map = (Map)internalClientData.get(clientType);
        if (map == null) {
            this.removeFromClientMap(clientType, client);
        } else {
            this.handleParentChange(clientType, map);
        }
        this.unloadClient(clientType);
    }

    protected void setParentStyles(Map clientData) {
        if (clientData == null) {
            return;
        }
        Set cParents = (Set)clientData.get(PARENT_ID);
        String parentId = this.getFirstString(cParents);
        String clientType = this.getClientType(clientData);
        Map parentMap = (Map)mergedClientData.get(parentId);
        if (parentMap == null) {
            debug.error("ParentMap for clientType = " + clientType + ", parentId = " + parentId + " was null");
            return;
        }
        if (baseProfiles.containsKey(parentId)) {
            Map s;
            if (clientData.get(USER_AGENT) == null && (s = (Map)baseProfiles.get(parentId)).get(clientType) == null) {
                s.put(clientType, new TreeMap());
                if (debug.messageEnabled()) {
                    debug.message(CLASS + "Creating Style: " + clientType + " : Parent : " + parentId);
                }
            }
        } else {
            OrderedSet os = new OrderedSet();
            os.add((Object)parentId);
            Set pParents = (Set)parentMap.get(PARENT_ID);
            os.addAll(pParents);
            clientData.put(PARENT_ID, os);
        }
    }

    private void unloadClient(String clientType) {
        loadedInternalClients.remove(clientType);
        loadedExternalClients.remove(clientType);
        loadedClientsMap.remove(clientType);
    }

    static {
        try {
            internalToken = DefaultClientTypesManager.getInternalToken();
            defaultClientType = DefaultClientTypesManager.getDefaultClientTypeFromService();
            try {
                intCapInstance = AMClientCapData.getInternalInstance();
            }
            catch (AMClientCapException ce) {
                debug.error(CLASS + "Unable to get instance of InternalData");
            }
            try {
                extCapInstance = AMClientCapData.getExternalInstance();
            }
            catch (AMClientCapException ce) {
                debug.error(CLASS + "Unable to get instance of ExternalData");
            }
        }
        catch (Throwable t) {
            debug.error(CLASS + "init() failed: ", t);
        }
        isInitialized = false;
    }
}

