/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.cert;

import com.iplanet.security.x509.X500Name;
import com.sun.identity.authentication.modules.cert.CertAuthPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.X509CertificateCallback;
import com.sun.identity.security.cert.AMCRLStore;
import com.sun.identity.security.cert.AMCertPath;
import com.sun.identity.security.cert.AMCertStore;
import com.sun.identity.security.cert.AMLDAPCertStoreParameters;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.internet.MimeUtility;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.LDAPUrl;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.OtherName;
import sun.security.x509.RFC822Name;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class Cert
extends AMLoginModule {
    private static Locale locale = null;
    private ResourceBundle bundle = null;
    private String userTokenId = null;
    private X509Certificate thecert = null;
    private String amAuthCert_serverHost;
    private String amAuthCert_startSearchLoc;
    private String amAuthCert_securityType;
    private String amAuthCert_principleUser;
    private String amAuthCert_principlePasswd;
    private String amAuthCert_useSSL;
    private String amAuthCert_userProfileMapper;
    private String amAuthCert_altUserProfileMapper;
    private String amAuthCert_subjectAltExtMapper;
    private String amAuthCert_chkCRL;
    private String amAuthCert_validateCA;
    private String amAuthCert_chkAttrCRL = null;
    private String amAuthCert_uriParamsCRL = null;
    private String amAuthCert_chkCertInLDAP;
    private String amAuthCert_chkAttrCertInLDAP = null;
    private String amAuthCert_emailAddrTag;
    private int amAuthCert_serverPort = 389;
    private static boolean portal_gw_cert_auth_enabled = false;
    private Set portalGateways = null;
    private String certParamName = null;
    private boolean ocspEnabled = false;
    private AMLDAPCertStoreParameters ldapParam = null;
    private Map options;
    private CertAuthPrincipal userPrincipal;
    private CallbackHandler callbackHandler;
    static final int ldap_version = 3;
    private static final String amAuthCert = "amAuthCert";
    private static Debug debug = null;
    static String UPNOID = "1.3.6.1.4.1.311.20.2.3";

    public void init(Subject subject, Map sharedState, Map options) {
        if (debug == null) {
            debug = Debug.getInstance((String)amAuthCert);
        }
        Locale locale = this.getLoginLocale();
        this.bundle = amCache.getResBundle(amAuthCert, locale);
        this.callbackHandler = this.getCallbackHandler();
        this.options = options;
        if (debug.messageEnabled()) {
            debug.message("Cert Auth resbundle locale=" + locale);
            debug.message("Cert auth init() done");
        }
    }

    private void initAuthConfig() throws AuthLoginException {
        if (this.options != null) {
            String ocspChk;
            debug.message("Certificate: getting attributes.");
            String authLevel = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-auth-level");
            if (authLevel != null) {
                try {
                    int tmp = Integer.parseInt(authLevel);
                    this.setAuthLevel(tmp);
                }
                catch (Exception e) {
                    debug.error("Invalid auth level " + authLevel, (Throwable)e);
                }
            }
            this.amAuthCert_securityType = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-security-type");
            this.amAuthCert_principleUser = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-principal-user");
            this.amAuthCert_principlePasswd = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-principal-passwd");
            this.amAuthCert_useSSL = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-use-ssl");
            this.amAuthCert_userProfileMapper = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-user-profile-mapper");
            this.amAuthCert_altUserProfileMapper = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-user-profile-mapper-other");
            this.amAuthCert_subjectAltExtMapper = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-user-profile-mapper-ext");
            this.amAuthCert_chkCRL = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-check-crl");
            if (this.amAuthCert_chkCRL.equalsIgnoreCase("true")) {
                this.amAuthCert_chkAttrCRL = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-attr-check-crl");
                if (this.amAuthCert_chkAttrCRL == null || this.amAuthCert_chkAttrCRL.equals("")) {
                    throw new AuthLoginException(amAuthCert, "noCRLAttr", null);
                }
            }
            this.amAuthCert_validateCA = CollectionHelper.getMapAttr((Map)this.options, (String)"sunAMValidateCACert");
            this.amAuthCert_uriParamsCRL = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-param-get-crl");
            this.amAuthCert_chkCertInLDAP = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-check-cert-in-ldap");
            if (this.amAuthCert_chkCertInLDAP.equalsIgnoreCase("true")) {
                this.amAuthCert_chkAttrCertInLDAP = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-attr-check-ldap");
                if (this.amAuthCert_chkAttrCertInLDAP == null || this.amAuthCert_chkAttrCertInLDAP.equals("")) {
                    throw new AuthLoginException(amAuthCert, "noLDAPAttr", null);
                }
            }
            this.ocspEnabled = (ocspChk = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-check-ocsp")) != null && ocspChk.equalsIgnoreCase("true");
            String gwCertAuth = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-gw-cert-auth-enabled");
            this.certParamName = CollectionHelper.getMapAttr((Map)this.options, (String)"sunAMHttpParamName");
            String client = this.getLoginState("process").getClient();
            portal_gw_cert_auth_enabled = false;
            if (gwCertAuth == null || gwCertAuth.equals("") || gwCertAuth.equalsIgnoreCase("none")) {
                if (debug.messageEnabled()) {
                    debug.message("iplanet-am-auth-cert-gw-cert-auth-enabled = " + gwCertAuth);
                }
            } else if (gwCertAuth.equalsIgnoreCase("any")) {
                portal_gw_cert_auth_enabled = true;
            } else {
                this.portalGateways = (Set)this.options.get("iplanet-am-auth-cert-gw-cert-auth-enabled");
                if (client != null && this.portalGateways.contains(client)) {
                    portal_gw_cert_auth_enabled = true;
                } else if (debug.messageEnabled()) {
                    debug.message("gateway list does not contain client");
                    Iterator clientIter = this.portalGateways.iterator();
                    while (clientIter.hasNext()) {
                        String clientStr = (String)clientIter.next();
                        debug.message("client list entry = " + clientStr);
                    }
                }
            }
            this.amAuthCert_emailAddrTag = this.bundle.getString("emailAddrTag");
            this.amAuthCert_serverHost = CollectionHelper.getServerMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-ldap-provider-url");
            if (this.amAuthCert_serverHost == null && (this.amAuthCert_chkCertInLDAP.equalsIgnoreCase("true") || this.amAuthCert_chkCRL.equalsIgnoreCase("true"))) {
                debug.error("Fatal error: LDAP Server and Port misconfigured");
                throw new AuthLoginException(amAuthCert, "wrongLDAPServer", null);
            }
            if (this.amAuthCert_serverHost != null) {
                try {
                    LDAPUrl ldapUrl = new LDAPUrl("ldap://" + this.amAuthCert_serverHost);
                    this.amAuthCert_serverPort = ldapUrl.getPort();
                    this.amAuthCert_serverHost = ldapUrl.getHost();
                }
                catch (Exception e) {
                    throw new AuthLoginException(amAuthCert, "wrongLDAPServer", null);
                }
            }
            this.amAuthCert_startSearchLoc = CollectionHelper.getServerMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-start-search-loc");
            if (this.amAuthCert_startSearchLoc == null && (this.amAuthCert_chkCertInLDAP.equalsIgnoreCase("true") || this.amAuthCert_chkCRL.equalsIgnoreCase("true"))) {
                debug.error("Fatal error: LDAP Start Search DN is not configured");
                throw new AuthLoginException(amAuthCert, "wrongStartDN", null);
            }
            if (this.amAuthCert_startSearchLoc != null) {
                try {
                    X500Name baseDN = new X500Name(this.amAuthCert_startSearchLoc);
                }
                catch (Exception e) {
                    debug.error("Fatal error: LDAP Start Search DN misconfigured");
                    throw new AuthLoginException(amAuthCert, "wrongStartDN", null);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("\nldapProviderUrl=" + this.amAuthCert_serverHost + "\n\tamAuthCert_serverPort = " + this.amAuthCert_serverPort + "\n\tstartSearchLoc=" + this.amAuthCert_startSearchLoc + "\n\tsecurityType=" + this.amAuthCert_securityType + "\n\tprincipleUser=" + this.amAuthCert_principleUser + "\n\tauthLevel=" + authLevel + "\n\tuseSSL=" + this.amAuthCert_useSSL + "\n\tocspEnable=" + this.ocspEnabled + "\n\tuserProfileMapper=" + this.amAuthCert_userProfileMapper + "\n\tsubjectAltExtMapper=" + this.amAuthCert_subjectAltExtMapper + "\n\taltUserProfileMapper=" + this.amAuthCert_altUserProfileMapper + "\n\tchkCRL=" + this.amAuthCert_chkCRL + "\n\tchkAttrCRL=" + this.amAuthCert_chkAttrCRL + "\n\tchkCertInLDAP=" + this.amAuthCert_chkCertInLDAP + "\n\tchkAttrCertInLDAP=" + this.amAuthCert_chkAttrCertInLDAP + "\n\temailAddr=" + this.amAuthCert_emailAddrTag + "\n\tgw-cert-auth-enabled=" + portal_gw_cert_auth_enabled + "\n\tclient=" + client);
            }
        } else {
            debug.error("options is null");
            throw new AuthLoginException(amAuthCert, "CERTex", null);
        }
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        X509Certificate ldapcert;
        this.initAuthConfig();
        try {
            HttpServletRequest servletRequest = this.getHttpServletRequest();
            if (servletRequest != null) {
                X509Certificate[] allCerts = (X509Certificate[])servletRequest.getAttribute("javax.servlet.request.X509Certificate");
                if (allCerts == null || allCerts.length == 0) {
                    debug.message("Certificate: checking for cert passed in the URL.");
                    if (!portal_gw_cert_auth_enabled) {
                        debug.error("Certificate: cert passed in URL not enabled for this client");
                        throw new AuthLoginException(amAuthCert, "noURLCertAuth", null);
                    }
                    this.thecert = this.getPortalStyleCert(servletRequest);
                } else {
                    if (debug.messageEnabled()) {
                        debug.message("Certificate: got all certs from HttpServletRequest =" + allCerts.length);
                    }
                    this.thecert = allCerts[0];
                }
            } else {
                this.thecert = this.sendCallback();
            }
            if (this.thecert == null) {
                debug.message(">>>>>>>>>>>>>> Certificate: no cert passed in.");
                throw new AuthLoginException(amAuthCert, "noCert", null);
            }
            this.getTokenFromCert(this.thecert);
            this.storeUsernamePasswd(this.userTokenId, null);
            if (debug.messageEnabled()) {
                debug.message("in Certificate. userTokenId=" + this.userTokenId + " from getTokenFromCert");
            }
        }
        catch (AuthLoginException e) {
            this.setFailureID(this.userTokenId);
            debug.error("Certificate:  exiting validate with exception", (Throwable)e);
            throw new AuthLoginException(amAuthCert, "noCert", null);
        }
        if (debug.messageEnabled()) {
            debug.message("Got client cert =\n" + this.thecert.toString());
        }
        if (this.amAuthCert_chkCertInLDAP.equalsIgnoreCase("false") && this.amAuthCert_chkCRL.equalsIgnoreCase("false") && !this.ocspEnabled) {
            return -1;
        }
        if (this.ldapParam == null) {
            this.setLdapStoreParam();
        }
        if (this.amAuthCert_chkCertInLDAP.equalsIgnoreCase("true") && (ldapcert = AMCertStore.getRegisteredCertificate((AMLDAPCertStoreParameters)this.ldapParam, (X509Certificate)this.thecert, (String)this.amAuthCert_chkAttrCertInLDAP)) == null) {
            debug.error("X509Certificate: getRegCertificate is null");
            this.setFailureID(this.userTokenId);
            throw new AuthLoginException(amAuthCert, "CertNoReg", null);
        }
        int ret = this.doRevocationValidation(this.thecert);
        if (ret != -1) {
            debug.error("X509Certificate:CRL / OCSP verify failed.");
            this.setFailureID(this.userTokenId);
            throw new AuthLoginException(amAuthCert, "CertVerifyFailed", null);
        }
        return -1;
    }

    private int doRevocationValidation(X509Certificate cert) {
        boolean crlEnabled = this.amAuthCert_chkCRL.equalsIgnoreCase("true");
        boolean validateCA = this.amAuthCert_validateCA.equalsIgnoreCase("true");
        int ret = 0;
        try {
            X509Certificate[] certs;
            AMCertPath certpath;
            Vector<X509CRL> crls = new Vector<X509CRL>();
            if (crlEnabled) {
                X509CRL crl = AMCRLStore.getCRL((AMLDAPCertStoreParameters)this.ldapParam, (X509Certificate)cert, (String)this.amAuthCert_chkAttrCRL);
                if (crl != null) {
                    crls.add(crl);
                }
                if (debug.messageEnabled()) {
                    debug.message("Cert.doRevocationValidation: crls size = " + crls.size());
                    if (crls.size() > 0) {
                        debug.message("CRL = " + crls.toString());
                    }
                }
            }
            if (!(certpath = new AMCertPath(crls)).verify(certs = new X509Certificate[]{cert}, crlEnabled, this.ocspEnabled)) {
                debug.error("CertPath:verify failed.");
                return ret;
            }
            if (debug.messageEnabled()) {
                debug.message("CertPath:verify success.");
            }
            ret = -1;
        }
        catch (Exception e) {
            debug.error("Cert.doRevocationValidation: verify failed.", (Throwable)e);
            return ret;
        }
        if (ret == -1 && crlEnabled && validateCA && !AMCertStore.isRootCA((X509Certificate)cert)) {
            ret = this.doRevocationValidation(AMCertStore.getIssuerCertificate((AMLDAPCertStoreParameters)this.ldapParam, (X509Certificate)cert, (String)this.amAuthCert_chkAttrCertInLDAP));
        }
        return ret;
    }

    private void setLdapStoreParam() throws AuthLoginException {
        try {
            this.ldapParam = AMCertStore.setLdapStoreParam((String)this.amAuthCert_serverHost, (int)this.amAuthCert_serverPort, (String)this.amAuthCert_principleUser, (String)this.amAuthCert_principlePasswd, (String)this.amAuthCert_startSearchLoc, (String)this.amAuthCert_uriParamsCRL, (boolean)this.amAuthCert_useSSL.equalsIgnoreCase("true"));
        }
        catch (Exception e) {
            debug.error("validate.SSLSocketFactory", (Throwable)e);
            this.setFailureID(this.userTokenId);
            throw new AuthLoginException(amAuthCert, "sslSokFactoryFail", null);
        }
    }

    private void getTokenFromCert(X509Certificate cert) throws AuthLoginException {
        if (!this.amAuthCert_subjectAltExtMapper.equalsIgnoreCase("none")) {
            this.getTokenFromSubjectAltExt(cert);
        }
        if (!this.amAuthCert_userProfileMapper.equalsIgnoreCase("none") && this.userTokenId == null) {
            this.getTokenFromSubjectDN(cert);
        }
    }

    private void getTokenFromSubjectAltExt(X509Certificate cert) throws AuthLoginException {
        try {
            X509CertImpl certImpl = new X509CertImpl(cert.getEncoded());
            X509CertInfo cinfo = new X509CertInfo(certImpl.getTBSCertificate());
            CertificateExtensions exts = (CertificateExtensions)cinfo.get("extensions");
            SubjectAlternativeNameExtension altNameExt = (SubjectAlternativeNameExtension)exts.get("SubjectAlternativeName");
            if (altNameExt != null) {
                GeneralNames names = (GeneralNames)altNameExt.get("subject_name");
                GeneralName generalname = null;
                ObjectIdentifier upnoid = new ObjectIdentifier(UPNOID);
                Iterator<GeneralName> itr = names.iterator();
                while (this.userTokenId == null && itr.hasNext()) {
                    generalname = itr.next();
                    if (generalname == null) continue;
                    if (this.amAuthCert_subjectAltExtMapper.equalsIgnoreCase("UPN") && generalname.getType() == 0) {
                        OtherName othername = (OtherName)generalname.getName();
                        if (!upnoid.equals(othername.getOID())) continue;
                        byte[] nval = othername.getNameValue();
                        DerValue derValue = new DerValue(nval);
                        this.userTokenId = derValue.getData().getUTF8String();
                        continue;
                    }
                    if (!this.amAuthCert_subjectAltExtMapper.equalsIgnoreCase("RFC822Name") || generalname.getType() != 1) continue;
                    RFC822Name email = (RFC822Name)generalname.getName();
                    this.userTokenId = email.getName();
                }
            }
        }
        catch (Exception e) {
            debug.error("Certificate - Error in getTokenFromSubjectAltExt = ", (Throwable)e);
            throw new AuthLoginException(amAuthCert, "CertNoReg", null);
        }
    }

    private void getTokenFromSubjectDN(X509Certificate cert) throws AuthLoginException {
        try {
            X500Principal subjectPrincipal = cert.getSubjectX500Principal();
            X500Name certDN = new X500Name(subjectPrincipal.getEncoded());
            if (debug.messageEnabled()) {
                debug.message("getTokenFromCert: Subject DN : " + certDN.getName());
            }
            if (this.amAuthCert_userProfileMapper.equalsIgnoreCase("subject DN")) {
                this.userTokenId = certDN.getName();
            }
            if (this.amAuthCert_userProfileMapper.equalsIgnoreCase("subject UID")) {
                this.userTokenId = certDN.getAttributeValue("uid");
            }
            if (this.amAuthCert_userProfileMapper.equalsIgnoreCase("subject CN")) {
                this.userTokenId = certDN.getCommonName();
            }
            if (this.amAuthCert_userProfileMapper.equalsIgnoreCase(this.amAuthCert_emailAddrTag)) {
                this.userTokenId = certDN.getEmail();
                if (this.userTokenId == null) {
                    this.userTokenId = certDN.getAttributeValue("mail");
                }
            }
            if (this.amAuthCert_userProfileMapper.equalsIgnoreCase("DER Certificate")) {
                this.userTokenId = String.valueOf(cert.getTBSCertificate());
            }
            if (this.amAuthCert_userProfileMapper.equals("other")) {
                this.userTokenId = certDN.getAttributeValue(this.amAuthCert_altUserProfileMapper);
            }
            if (debug.messageEnabled()) {
                debug.message("getTokenFromCert: " + this.amAuthCert_userProfileMapper + this.userTokenId);
            }
            return;
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("Certificate - Error in getTokenFromSubjectDN = ", (Throwable)e);
            }
            throw new AuthLoginException(amAuthCert, "CertNoReg", null);
        }
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new CertAuthPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    public X509Certificate getCertificate() {
        return this.thecert;
    }

    public String getChkAttrCRL() {
        return this.amAuthCert_chkAttrCRL;
    }

    public Debug getDebug() {
        return debug;
    }

    public String getUriParamsCRL() {
        return this.amAuthCert_uriParamsCRL;
    }

    public String getStartSearchLoc() {
        return this.amAuthCert_startSearchLoc;
    }

    private X509Certificate sendCallback() throws AuthLoginException {
        if (this.callbackHandler == null) {
            throw new AuthLoginException(amAuthCert, "NoCallbackHandler", null);
        }
        X509Certificate cert = null;
        try {
            Callback[] callbacks = new Callback[]{new X509CertificateCallback(this.bundle.getString("certificate"))};
            this.callbackHandler.handle(callbacks);
            X509CertificateCallback xcb = (X509CertificateCallback)callbacks[0];
            byte[] signature = xcb.getSignature();
            if (portal_gw_cert_auth_enabled || !xcb.getReqSignature() || xcb.getReqSignature() && signature != null) {
                cert = xcb.getCertificate();
            }
            return cert;
        }
        catch (IllegalArgumentException ill) {
            debug.message("message type missing");
            throw new AuthLoginException(amAuthCert, "IllegalArgs", null);
        }
        catch (IOException ioe) {
            throw new AuthLoginException(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw new AuthLoginException(amAuthCert, "NoCallbackHandler", null);
        }
    }

    private X509Certificate getPortalStyleCert(HttpServletRequest request) throws AuthLoginException {
        String certParam = null;
        if (this.certParamName != null && this.certParamName.length() > 0) {
            debug.message("getPortalStyleCert: checking cert in HTTP header");
            StringTokenizer tok = new StringTokenizer(this.certParamName, ",");
            while (tok.hasMoreTokens()) {
                String key = tok.nextToken();
                certParam = request.getHeader(key);
                if (certParam == null) continue;
                certParam = certParam.trim();
                String begincert = "-----BEGIN CERTIFICATE-----";
                String endcert = "-----END CERTIFICATE-----";
                int idx = certParam.indexOf(endcert);
                if (idx == -1) continue;
                certParam = certParam.substring(begincert.length(), idx);
                certParam = certParam.trim();
            }
        } else {
            debug.message("getPortalStyleCert: checking cert in userCert param");
            Hashtable requestHash = this.getLoginState("getPortalStyleCert()").getRequestParamHash();
            if (requestHash != null && (certParam = (String)requestHash.get("IDToken0")) == null) {
                certParam = (String)requestHash.get("Login.Token0");
            }
        }
        if (debug.messageEnabled()) {
            debug.message("in Certificate. validate certParam: " + certParam);
        }
        if (certParam == null || certParam.equals("")) {
            debug.message("Certificate: no cert from HttpServletRequest");
            throw new AuthLoginException(amAuthCert, "noCert", null);
        }
        byte[] certbytes = certParam.getBytes();
        debug.message("in Certificate: got certbytes");
        ByteArrayInputStream barray = new ByteArrayInputStream(certbytes);
        InputStream carray = null;
        try {
            carray = MimeUtility.decode((InputStream)barray, (String)"base64");
        }
        catch (Exception e) {
            debug.error("CertificateFromParameter(decode): exception", (Throwable)e);
            throw new AuthLoginException(amAuthCert, "CERTex", null);
        }
        debug.message("Certificate: CertificateFactory.getInstance.");
        CertificateFactory cf = null;
        X509Certificate userCert = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            userCert = (X509Certificate)cf.generateCertificate(carray);
        }
        catch (Exception e) {
            debug.error("CertificateFromParameter(X509Cert): exception ", (Throwable)e);
            throw new AuthLoginException(amAuthCert, "CERTex", null);
        }
        if (userCert == null) {
            throw new AuthLoginException(amAuthCert, "CERTex", null);
        }
        if (debug.messageEnabled()) {
            debug.message("X509Certificate: principal is: " + userCert.getSubjectDN().getName() + "\nissuer DN:" + userCert.getIssuerDN().getName() + "\nserial number:" + String.valueOf(userCert.getSerialNumber()) + "\nsubject dn:" + userCert.getSubjectDN().getName());
        }
        return userCert;
    }

    public void destroyModuleState() {
        this.userPrincipal = null;
        this.userTokenId = null;
    }

    public void nullifyUsedVars() {
        this.bundle = null;
        this.thecert = null;
        this.options = null;
        this.callbackHandler = null;
        this.amAuthCert_serverHost = null;
        this.amAuthCert_startSearchLoc = null;
        this.amAuthCert_securityType = null;
        this.amAuthCert_principleUser = null;
        this.amAuthCert_principlePasswd = null;
        this.amAuthCert_useSSL = null;
        this.amAuthCert_userProfileMapper = null;
        this.amAuthCert_altUserProfileMapper = null;
        this.amAuthCert_chkCRL = null;
        this.amAuthCert_chkAttrCRL = null;
        this.amAuthCert_uriParamsCRL = null;
        this.amAuthCert_chkCertInLDAP = null;
        this.amAuthCert_chkAttrCertInLDAP = null;
        this.amAuthCert_emailAddrTag = null;
        this.portalGateways = null;
    }
}

