/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AMLoginContext;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.service.AuthenticationPrincipalDataRetriever;
import com.sun.identity.authentication.service.AuthenticationPrincipalDataRetrieverFactory;
import com.sun.identity.authentication.service.SSOTokenPrincipal;
import com.sun.identity.authentication.spi.AMPostAuthProcessInterface;
import com.sun.identity.authentication.spi.AuthenticationException;
import com.sun.identity.authentication.util.AMAuthUtils;
import com.sun.identity.common.DNUtils;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.CookieUtils;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.ServiceConfig;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import netscape.ldap.util.DN;

public class LoginState {
    private static final boolean urlRewriteInPath = Boolean.valueOf(SystemProperties.get("com.sun.identity.cookieRewritingInPath", ""));
    private static AuthD ad = AuthD.getAuth();
    private static Debug debug = AuthD.debug;
    private static String pCookieName = AuthUtils.getPersistentCookieName();
    private static Set userAttributes = new HashSet();
    Callback[] receivedCallbackInfo;
    Callback[] prevCallback;
    Callback[] submittedCallbackInfo;
    HashMap callbacksPerState = new HashMap();
    InternalSession session = null;
    HttpSession hsession = null;
    HttpServletRequest servletRequest;
    HttpServletResponse servletResponse;
    String orgName;
    String userOrg;
    String orgDN = null;
    int loginStatus = 2;
    Hashtable requestHash;
    boolean requestType;
    Set aliasAttrNames = null;
    public boolean inetDomainStatus = true;
    String userContainerDN = null;
    boolean nullUserContainerDN = false;
    boolean dnByUserContainer = false;
    String userNamingAttr = null;
    public Set defaultRoles = null;
    boolean dynamicProfileCreation = false;
    boolean ignoreUserProfile = false;
    boolean createWithAlias = false;
    boolean persistentCookieMode = false;
    public String persistentCookieTime = null;
    public boolean persistentCookieOn = false;
    public String defaultAuthLevel = "0";
    Subject subject;
    String token = null;
    String userDN = null;
    int maxSession;
    int idleTime;
    int cacheTime;
    int authLevel = 0;
    int moduleAuthLevel = Integer.MIN_VALUE;
    String client = null;
    String authMethName = "";
    String pAuthMethName = null;
    String queryOrg = null;
    SessionID sid;
    boolean cookieSupported = true;
    boolean cookieSet = false;
    String filePath;
    boolean userEnabled = true;
    boolean isAdmin;
    boolean isApp = false;
    AMIdentity amIdentityRole = null;
    Set tokenSet;
    AuthContext.IndexType indexType;
    String indexName = null;
    AuthContext.IndexType prevIndexType = null;
    Set userAliasList = null;
    boolean hasAdminToken = false;
    String gotoURL = null;
    String gotoOnFailURL = null;
    String failureLoginURL = null;
    String successLoginURL = null;
    String moduleSuccessLoginURL = null;
    String moduleFailureLoginURL = null;
    Set orgSuccessLoginURLSet = null;
    String clientOrgSuccessLoginURL = null;
    String defaultOrgSuccessLoginURL = null;
    String clientOrgFailureLoginURL = null;
    String defaultOrgFailureLoginURL = null;
    Set orgFailureLoginURLSet = null;
    Map requestMap = new HashMap();
    public boolean userIDGeneratorEnabled;
    public String userIDGeneratorClassName;
    Set domainAuthenticators = null;
    Set moduleInstances = null;
    private InternalSession oldSession = null;
    private SSOToken oldSSOToken = null;
    private boolean forceAuth;
    private boolean cookieTimeToLiveEnabledFlag = false;
    private int cookieTimeToLive = 0;
    boolean sessionUpgrade = false;
    String loginURL = null;
    long pageTimeOut = 60L;
    long lastCallbackSent = 0L;
    AMIdentity amIdentityUser = null;
    private boolean enableModuleBasedAuth = true;
    public boolean loginFailureLockoutMode = false;
    public boolean loginFailureLockoutStoreInDS = true;
    public String accountLife = null;
    public long loginFailureLockoutDuration = 0L;
    public int loginFailureLockoutMultiplier = 0;
    public long loginFailureLockoutTime = 300000L;
    public int loginFailureLockoutCount = 5;
    public String loginLockoutNotification = null;
    public String loginLockoutAttrName = null;
    public String loginLockoutAttrValue = null;
    public int loginLockoutUserWarning = 3;
    public int userWarningCount = 0;
    String errorCode = null;
    String errorMessage = null;
    String errorTemplate = null;
    String moduleErrorTemplate = null;
    String lockoutMsg = null;
    boolean timedOut = false;
    public String failureTokenId = null;
    String principalList = null;
    String pCookieUserName = null;
    private ISLocaleContext localeContext = new ISLocaleContext();
    X509Certificate cert = null;
    String defaultUserSuccessURL;
    String clientUserSuccessURL;
    Set userSuccessURLSet = Collections.EMPTY_SET;
    String clientUserFailureURL;
    String defaultUserFailureURL;
    Set userFailureURLSet = Collections.EMPTY_SET;
    String clientSuccessRoleURL;
    String defaultSuccessRoleURL;
    Set successRoleURLSet = Collections.EMPTY_SET;
    String clientFailureRoleURL;
    String defaultFailureRoleURL;
    Set failureRoleURLSet = Collections.EMPTY_SET;
    String userAuthConfig = "";
    String orgAuthConfig = null;
    String orgAdminAuthConfig = null;
    String roleAuthConfig = null;
    Set orgPostLoginClassSet = Collections.EMPTY_SET;
    Map serviceAttributesMap = new HashMap();
    String moduleErrorMessage = null;
    String defaultSuccessURL = null;
    String defaultFailureURL = null;
    String tempDefaultURL = null;
    String sessionSuccessURL = null;
    Set postLoginInstanceSet = null;
    boolean isLocaleSet = false;
    boolean cookieDetect = false;
    HashMap userCreationAttributes = null;
    Set externalAliasList = null;
    Set successModuleSet = new HashSet();
    Set failureModuleSet = new HashSet();
    String failureModuleList = "";
    String fqdnFailureLoginURL = null;
    Map moduleMap = null;
    Map roleAttributeMap = null;
    Boolean foundPCookie = null;
    long pCookieTimeCreated;
    Set identityTypes = Collections.EMPTY_SET;
    Set userSessionMapping = Collections.EMPTY_SET;
    Hashtable idRepoHash = new Hashtable();
    AMIdentityRepository amIdRepo = null;
    private static boolean messageEnabled;
    private static String serverURL;
    int compositeAdviceType;
    String compositeAdvice;
    String qualifiedOrgDN = null;
    static final int POSTPROCESS_SUCCESS = 1;
    static final int POSTPROCESS_FAILURE = 2;
    static final int POSTPROCESS_LOGOUT = 3;
    boolean forwardSuccess = false;
    boolean postProcessInSession = false;
    boolean modulesInSession = false;

    public HttpServletRequest getHttpServletRequest() {
        return this.servletRequest;
    }

    public void setHttpServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public InternalSession getSession() {
        if (this.session == null || this.session.getState() == 2 || this.session.getState() == 3) {
            if (messageEnabled) {
                debug.message("Session is null OR INACTIVE OR DESTROYED :" + this.session);
            }
            return null;
        }
        return this.session;
    }

    public HttpSession getHttpSession() {
        return this.hsession;
    }

    public void setSession(InternalSession sess) {
        this.session = sess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceivedCallback(Callback[] callback, AMLoginContext amLoginContext) {
        AMLoginContext aMLoginContext = amLoginContext;
        synchronized (aMLoginContext) {
            this.submittedCallbackInfo = null;
            this.receivedCallbackInfo = callback;
            this.prevCallback = callback;
            amLoginContext.notify();
        }
    }

    public void setReceivedCallback_NoThread(Callback[] callback) {
        this.submittedCallbackInfo = null;
        this.receivedCallbackInfo = callback;
        this.prevCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubmittedCallback(Callback[] callback, AMLoginContext amLoginContext) {
        AMLoginContext aMLoginContext = amLoginContext;
        synchronized (aMLoginContext) {
            this.receivedCallbackInfo = null;
            this.prevCallback = this.receivedCallbackInfo;
            this.submittedCallbackInfo = callback;
            amLoginContext.notify();
        }
    }

    public void setSubmittedCallback_NoThread(Callback[] callback) {
        this.receivedCallbackInfo = null;
        this.prevCallback = this.receivedCallbackInfo;
        this.submittedCallbackInfo = callback;
    }

    public Callback[] getReceivedInfo() {
        return this.receivedCallbackInfo;
    }

    public Callback[] getSubmittedInfo() {
        return this.submittedCallbackInfo;
    }

    public String getOrgDN() {
        if (this.orgDN == null) {
            try {
                this.orgDN = ad.getOrgDN(this.userOrg);
            }
            catch (Exception e) {
                debug.message("Error getting orgDN: ", (Throwable)e);
            }
        }
        return this.orgDN;
    }

    public String getOrgName() {
        if (this.orgName == null) {
            this.orgName = DNUtils.DNtoName(this.getOrgDN());
        }
        return this.orgName;
    }

    public int getLoginStatus() {
        return this.loginStatus;
    }

    public synchronized void setLoginStatus(int loginStatus) {
        this.loginStatus = loginStatus;
    }

    public void setParamHash(Hashtable requestHash) {
        this.requestHash = requestHash;
        if (requestHash != null) {
            Enumeration hashKeys = requestHash.keys();
            while (hashKeys.hasMoreElements()) {
                Object key = hashKeys.nextElement();
                Object value = requestHash.get(key);
                this.requestMap.put(key, value);
            }
        }
    }

    public void setRequestType(boolean requestType) {
        this.requestType = requestType;
    }

    public boolean isNewRequest() {
        return this.requestType;
    }

    public boolean isDynamicProfileCreationEnabled() {
        return this.dynamicProfileCreation;
    }

    public void populateOrgProfile() throws AuthException {
        try {
            this.inetDomainStatus = ad.getInetDomainStatus(this.getOrgDN());
            if (!this.inetDomainStatus) {
                this.logFailed(AuthUtils.getErrorVal("109", "Error_Message"), "ORGINACTIVE");
                throw new AuthException("109", null);
            }
            OrganizationConfigManager orgConfigMgr = ad.getOrgConfigManager(this.getOrgDN());
            ServiceConfig svcConfig = orgConfigMgr.getServiceConfig("iPlanetAMAuthService");
            Map attrs = svcConfig.getAttributes();
            this.aliasAttrNames = (Set)attrs.get("iplanet-am-auth-alias-attr-name");
            if (AuthD.revisionNumber >= 30) {
                this.identityTypes = (Set)attrs.get("sunAMIdentityType");
            } else {
                this.identityTypes = new HashSet();
                Set containerDNs = (Set)attrs.get("iplanet-am-auth-user-container");
                this.getContainerDN(containerDNs);
            }
            this.userSessionMapping = (Set)attrs.get("sunAMUserAttributesSessionMapping");
            this.userNamingAttr = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-user-naming-attr", (String)"uid");
            this.defaultRoles = (Set)attrs.get("iplanet-am-auth-default-role");
            String tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-dynamic-profile-creation");
            if (tmp.equalsIgnoreCase("true")) {
                this.dynamicProfileCreation = true;
            } else if (tmp.equalsIgnoreCase("ignore")) {
                this.ignoreUserProfile = true;
            } else if (tmp.equalsIgnoreCase("createAlias")) {
                this.createWithAlias = true;
                this.dynamicProfileCreation = true;
            }
            tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-persistent-cookie-mode");
            if (tmp.equalsIgnoreCase("true")) {
                this.persistentCookieMode = true;
            }
            tmp = null;
            this.persistentCookieTime = tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-persistent-cookie-time");
            AMAuthenticationManager authManager = new AMAuthenticationManager(ad.getSSOAuthSession(), this.getOrgDN());
            this.domainAuthenticators = authManager.getAllowedModuleNames();
            if (this.domainAuthenticators == null) {
                this.domainAuthenticators = Collections.EMPTY_SET;
            }
            this.defaultAuthLevel = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-default-auth-level", (String)LoginState.ad.defaultAuthLevel);
            this.localeContext.setOrgLocale(this.getOrgDN());
            this.orgSuccessLoginURLSet = (Set)attrs.get("iplanet-am-auth-login-success-url");
            if (this.orgSuccessLoginURLSet == null) {
                this.orgSuccessLoginURLSet = Collections.EMPTY_SET;
            }
            this.clientOrgSuccessLoginURL = this.getRedirectUrl(this.orgSuccessLoginURLSet);
            this.defaultOrgSuccessLoginURL = this.tempDefaultURL;
            this.orgFailureLoginURLSet = (Set)attrs.get("iplanet-am-auth-login-failure-url");
            if (this.orgFailureLoginURLSet == null) {
                this.orgFailureLoginURLSet = Collections.EMPTY_SET;
            }
            this.clientOrgFailureLoginURL = this.getRedirectUrl(this.orgFailureLoginURLSet);
            this.defaultOrgFailureLoginURL = this.tempDefaultURL;
            this.orgAuthConfig = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-org-config");
            this.orgAdminAuthConfig = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-admin-auth-module");
            this.orgPostLoginClassSet = (Set)attrs.get("iplanet-am-auth-post-login-process-class");
            if (this.orgPostLoginClassSet == null) {
                this.orgPostLoginClassSet = Collections.EMPTY_SET;
            }
            if ((tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"sunEnableModuleBasedAuth")) != null && tmp.equalsIgnoreCase("false")) {
                this.enableModuleBasedAuth = false;
            }
            if ((tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-login-failure-lockout-mode")) != null && tmp.equalsIgnoreCase("true")) {
                this.loginFailureLockoutMode = true;
            }
            if ((tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"sunStoreInvalidAttemptsInDS")) != null && tmp.equalsIgnoreCase("false")) {
                this.loginFailureLockoutStoreInDS = false;
            }
            if ((tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-lockout-duration")) != null) {
                try {
                    this.loginFailureLockoutDuration = Long.parseLong(tmp);
                }
                catch (NumberFormatException e) {
                    debug.error("auth-lockout-duration bad format.");
                }
                this.loginFailureLockoutDuration *= 60000L;
            }
            if ((tmp = Misc.getMapAttr(attrs, "sunLockoutDurationMultiplier")) != null) {
                try {
                    this.loginFailureLockoutMultiplier = Integer.parseInt(tmp);
                }
                catch (NumberFormatException e) {
                    AuthD.debug.error("auth-lockout-multiplier bad format.");
                }
            }
            if ((tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-login-failure-count")) != null) {
                try {
                    this.loginFailureLockoutCount = Integer.parseInt(tmp);
                }
                catch (NumberFormatException e) {
                    debug.error("auth-lockout-count bad format.");
                }
            }
            if ((tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-login-failure-duration")) != null) {
                try {
                    this.loginFailureLockoutTime = Long.parseLong(tmp);
                }
                catch (NumberFormatException e) {
                    debug.error("auth-login-failure-duration bad format.");
                }
                this.loginFailureLockoutTime *= 60000L;
            }
            if ((tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-lockout-warn-user")) != null) {
                try {
                    this.loginLockoutUserWarning = Integer.parseInt(tmp);
                }
                catch (NumberFormatException e) {
                    debug.error("auth-lockout-warn-user bad format.");
                }
            }
            this.loginLockoutNotification = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-lockout-email-address");
            tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-username-generator-enabled");
            if (tmp != null) {
                this.userIDGeneratorEnabled = Boolean.valueOf(tmp);
            }
            this.userIDGeneratorClassName = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-username-generator-class");
            this.loginLockoutAttrName = tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-lockout-attribute-name");
            this.loginLockoutAttrValue = tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-lockout-attribute-value");
            if (messageEnabled) {
                debug.message("Getting Org Profile: " + this.orgDN + "\nlocale->" + this.localeContext.getLocale() + "\ncharset->" + this.localeContext.getMIMECharset() + "\ndynamicProfileCreation->" + this.dynamicProfileCreation + "\ndefaultAuthLevel->" + this.defaultAuthLevel + "\norgSucessLoginURLSet->" + this.orgSuccessLoginURLSet + "\norgFailureLoginURLSet->" + this.orgFailureLoginURLSet + "\nclientSuccessLoginURL ->" + this.clientOrgSuccessLoginURL + "\ndefaultSuccessLoginURL ->" + this.defaultOrgSuccessLoginURL + "\norgPostLoginClassSet ->" + this.orgPostLoginClassSet + "\norgAuthConfig ->" + this.orgAuthConfig + "\norgAdminAuthConfig ->" + this.orgAdminAuthConfig + "\nclientFailureLoginURL ->" + this.clientOrgFailureLoginURL + "\ndefaultFailureLoginURL ->" + this.defaultOrgFailureLoginURL + "\nenableModuleBasedAuth ->" + this.enableModuleBasedAuth + "\nloginFailureLockoutMode->" + this.loginFailureLockoutMode + "\nloginFailureLockoutStoreInDS->" + this.loginFailureLockoutStoreInDS + "\nloginFailureLockoutCount->" + this.loginFailureLockoutCount + "\nloginFailureLockoutTime->" + this.loginFailureLockoutTime + "\nloginLockoutUserWarning->" + this.loginLockoutUserWarning + "\nloginLockoutNotification->" + this.loginLockoutNotification + "\npersistentCookieMode->" + this.persistentCookieMode + "\nidentityTypes->" + this.identityTypes + "\naliasAttrNames ->" + this.aliasAttrNames);
            }
        }
        catch (AuthException ae) {
            debug.error("Error in populateOrgProfile", (Throwable)((Object)ae));
            throw new AuthException((Throwable)((Object)ae));
        }
        catch (Exception ex) {
            debug.error("Error in populateOrgProfile", (Throwable)ex);
            throw new AuthException("102", null);
        }
    }

    public void populateGlobalProfile() throws AuthException {
        Map attrs = AuthUtils.getGlobalAttributes("iPlanetAMAuthService");
        String tmpPostProcess = Misc.getMapAttr(attrs, "sunAMAuthKeepPostProcessInstances");
        this.postProcessInSession = Boolean.parseBoolean(tmpPostProcess);
        String tmpModules = Misc.getMapAttr(attrs, "sunAMAuthKeepAuthModuleIntances");
        this.modulesInSession = Boolean.parseBoolean(tmpModules);
        if (messageEnabled) {
            debug.message("LoginState.populateGlobalProfile: Getting Global Profile: \npostProcessInSession ->" + this.postProcessInSession + "\nmodulesInSession ->" + this.modulesInSession);
        }
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public int getMaxSession() {
        return this.maxSession;
    }

    public int getIdleTime() {
        return this.idleTime;
    }

    public int getCacheTime() {
        return this.cacheTime;
    }

    public String getUserDN() {
        if (messageEnabled) {
            debug.message("getUserDN: " + this.userDN);
        }
        return this.userDN;
    }

    public int getAuthLevel() {
        return this.authLevel;
    }

    public void setClient(String remoteAddr) {
        this.client = remoteAddr;
    }

    public String getClient() {
        String clientHost;
        block9: {
            if (this.client != null) {
                return this.client;
            }
            clientHost = "";
            try {
                String cli = null;
                if (this.requestHash != null) {
                    cli = (String)this.requestHash.get("client");
                }
                if (messageEnabled) {
                    debug.message("getClient : servletRequest is : " + this.client);
                    debug.message("getClient : cli is : " + cli);
                }
                if (cli == null || cli.length() == 0) {
                    if (this.servletRequest != null) {
                        clientHost = this.servletRequest.getRemoteAddr();
                    } else {
                        InetAddress localHost = InetAddress.getLocalHost();
                        clientHost = localHost.getHostAddress();
                    }
                }
            }
            catch (Exception e) {
                if (!messageEnabled) break block9;
                debug.message("Error getting clienty Type ", (Throwable)e);
            }
        }
        if (messageEnabled) {
            debug.message("Client is : " + clientHost);
        }
        this.client = clientHost;
        return clientHost;
    }

    public String tokenToDN(String token0) {
        try {
            String token = token0.toLowerCase();
            int pipe = token.indexOf("|");
            if (pipe != -1) {
                token = token.substring(0, pipe);
            }
            if (Misc.isDescendantOf(token, this.getOrgDN())) {
                return token;
            }
            if (ad.isSuperAdmin(token)) {
                return token;
            }
            String applicationUser = "amService-".toLowerCase();
            if (token.startsWith(applicationUser)) {
                return "cn=" + token + ",ou=DSAME Users," + SMSEntry.getRootSuffix();
            }
            String id = token;
            id = DNUtils.DNtoName(token);
            StringBuffer s = new StringBuffer(200);
            s.append(this.userNamingAttr).append("=").append(id).append(",").append(this.userContainerDN);
            this.dnByUserContainer = true;
            String userDN = s.toString();
            if (messageEnabled) {
                debug.message("token=" + token0 + ", id=" + id + ", DN=" + userDN);
            }
            return userDN;
        }
        catch (Exception e) {
            debug.error("tokenToDN : " + e.getMessage());
            return token0;
        }
    }

    public String getClientType() {
        return this.servletRequest != null ? AuthUtils.getClientType(this.servletRequest) : AuthUtils.getDefaultClientType();
    }

    public boolean activateSession(Subject subject, AuthContextLocal ac) {
        return this.activateSession(subject, ac, null);
    }

    public boolean activateSession(Subject subject, AuthContextLocal ac, Object loginContext) {
        try {
            if (messageEnabled) {
                debug.message("activateSession - Token is : " + this.token);
                debug.message("activateSession - userDN is : " + this.userDN);
            }
            boolean activated = false;
            try {
                this.setSuccessLoginURL(this.indexType, this.indexName);
                if (AuthD.isHttpSessionUsed()) {
                    this.session = AuthD.newSession(this.getOrgDN(), null);
                    this.sid = this.session.getID();
                    if (this.hsession != null) {
                        this.hsession.removeAttribute("authContextObject");
                        this.hsession.invalidate();
                        this.hsession = null;
                    }
                } else {
                    this.session.removeObject("authContextObject");
                }
                this.subject = this.addSSOTokenPrincipal(subject);
                this.setSessionProperties(this.session);
                if (this.modulesInSession && loginContext != null) {
                    this.session.setObject("sunAMAuthLoginContext", loginContext);
                }
                activated = this.session.activate(this.userDN);
            }
            catch (AuthException e) {
                return false;
            }
            if (messageEnabled) {
                debug.message("Activating session: " + this.session);
            }
            return activated;
        }
        catch (Exception e) {
            debug.error("Error activating session: ");
            return false;
        }
    }

    public void setSessionProperties(InternalSession session) throws AuthException {
        String cookieSupport;
        if (messageEnabled) {
            debug.message("LoginState getSession = " + session + " \nrequest token = " + this.token);
        }
        if (this.token == null) {
            throw new AuthException("102", null);
        }
        String string = cookieSupport = this.cookieSupported ? "true" : "false";
        if (this.userDN == null) {
            this.userDN = this.getUserDN(this.amIdentityUser);
        }
        String oldUserDN = null;
        if (this.oldSession != null) {
            oldUserDN = this.oldSession.getProperty("Principal");
        }
        if (messageEnabled) {
            debug.message("userDN is : " + this.userDN);
            debug.message("oldUserDN is : " + oldUserDN);
            debug.message("sessonUpgrade is : " + this.sessionUpgrade);
        }
        Date authInstantDate = new Date();
        String authInstant = DateUtils.toUTCDateFormat((Date)authInstantDate);
        String moduleAuthTime = null;
        if (this.sessionUpgrade) {
            try {
                this.oldSSOToken = SSOTokenManager.getInstance().createSSOToken(this.oldSession.getID().toString());
            }
            catch (SSOException ssoExp) {
                debug.error("LoginState.setSessionProperties: Cannot get oldSSOToken.");
            }
            HashMap<String, String> moduleTimeMap = null;
            if (this.oldSSOToken != null) {
                moduleTimeMap = AMAuthUtils.getModuleAuthTimeMap(this.oldSSOToken);
            }
            if (moduleTimeMap == null) {
                moduleTimeMap = new HashMap<String, String>();
            }
            StringTokenizer tokenizer = new StringTokenizer(this.authMethName, "|");
            while (tokenizer.hasMoreTokens()) {
                String moduleName = tokenizer.nextToken();
                moduleTimeMap.put(moduleName, authInstant);
            }
            Set entrySet = moduleTimeMap.entrySet();
            boolean firstElement = true;
            Iterator iter = entrySet.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String moduleName = (String)entry.getKey();
                String authTime = (String)entry.getValue();
                StringBuffer sb = new StringBuffer();
                if (!firstElement) {
                    sb.append("|");
                }
                firstElement = false;
                if (moduleAuthTime == null) {
                    moduleAuthTime = sb.append(moduleName).append("+").append(authTime).toString();
                    continue;
                }
                moduleAuthTime = moduleAuthTime + sb.append(moduleName).append("+").append(authTime);
            }
        }
        if (this.sessionUpgrade && oldUserDN != null && DNUtils.normalizeDN(this.userDN).equals(DNUtils.normalizeDN(oldUserDN))) {
            this.sessionUpgrade();
        } else {
            this.sessionUpgrade = false;
        }
        if (this.forceAuth && this.sessionUpgrade) {
            session = this.oldSession;
        }
        String userProfile = "Required";
        if (this.dynamicProfileCreation) {
            userProfile = "Create";
        } else if (this.ignoreUserProfile) {
            userProfile = "Ignore";
        } else if (this.createWithAlias) {
            userProfile = "CreateWithAlias";
        }
        session.putProperty("UserProfile", userProfile);
        String defaultLoginURL = null;
        if (this.loginURL != null) {
            int questionMark = this.loginURL.indexOf("?");
            defaultLoginURL = this.loginURL;
            if (questionMark != -1) {
                defaultLoginURL = this.loginURL.substring(0, questionMark);
            }
            session.putProperty("loginURL", defaultLoginURL);
            session.putProperty("FullLoginURL", this.loginURL);
        }
        this.sessionSuccessURL = ad.processURL(this.successLoginURL, this.servletRequest);
        this.sessionSuccessURL = this.encodeURL(this.sessionSuccessURL, this.servletResponse, true);
        if (this.sessionSuccessURL != null) {
            session.putProperty("successURL", this.sessionSuccessURL);
        }
        String univId = null;
        if (this.amIdentityUser != null) {
            univId = IdUtils.getUniversalId(this.amIdentityUser);
        }
        if (messageEnabled) {
            debug.message("setSessionProperties Principal = " + this.userDN + "\n" + "UserId = " + this.token + "\n" + "client = " + this.getClient() + "\n" + "Organization = " + this.orgDN + "\n" + "locale = " + this.localeContext.getLocale() + "\n" + "charset = " + this.localeContext.getMIMECharset() + "\n" + "idleTime = " + this.idleTime + "\n" + "cacheTime = " + this.cacheTime + "\n" + "maxSession = " + this.maxSession + "\n" + "AuthLevel = " + this.authLevel + "\n" + "AuthType = " + this.authMethName + "\n" + "Subject = " + this.subject.toString() + "\n" + "UniversalId = " + univId + "\n" + "cookieSupport = " + cookieSupport + "\n" + "principals = " + this.principalList + "\n" + "defaultLoginURL = " + defaultLoginURL + "\n" + "successURL = " + this.sessionSuccessURL + "\n" + "IndexType = " + this.indexType + "\n" + "UserProfile = " + userProfile + "\n" + "AuthInstant = " + authInstant + "\n" + "ModuleAuthTime = " + moduleAuthTime);
        }
        try {
            Map attrMap;
            AuthenticationPrincipalDataRetriever principalDataRetriever;
            String finalAuthConfig;
            if (this.isApplicationModule(this.authMethName) && ad.isSpecialUser(this.userDN) || this.isAgent(this.amIdentityUser)) {
                debug.message("setSessionProperties for non-expiring session");
                session.setClientID(this.token);
                session.setExpire(false);
                session.setType(1);
            } else {
                debug.message("request: in putProperty stuff");
                session.setClientID(this.userDN);
                session.setMaxSessionTime(this.maxSession);
                session.setMaxIdleTime(this.idleTime);
                session.setMaxCachingTime(this.cacheTime);
            }
            session.setClientDomain(this.getOrgDN());
            session.setType(0);
            if (this.client != null) {
                session.putProperty("Host", this.client);
            }
            if (!this.sessionUpgrade) {
                session.putProperty("AuthLevel", new Integer(this.authLevel).toString());
                session.putProperty("AuthType", this.authMethName);
            }
            session.putProperty("Principal", this.userDN);
            session.putProperty("UserId", this.token);
            session.putProperty("UserToken", this.token);
            session.putProperty("Organization", this.getOrgDN());
            session.putProperty("Locale", this.localeContext.getLocale().toString());
            session.putProperty("CharSet", this.localeContext.getMIMECharset());
            session.putProperty("clientType", this.getClientType());
            session.putProperty("cookieSupport", cookieSupport);
            session.putProperty("authInstant", authInstant);
            if (moduleAuthTime != null && moduleAuthTime.length() != 0) {
                session.putProperty("moduleAuthTime", moduleAuthTime);
            }
            if (this.principalList != null) {
                session.putProperty("Principals", this.principalList);
            }
            if (this.indexType != null) {
                session.putProperty("IndexType", this.indexType.toString());
            }
            if (univId != null) {
                session.putProperty("sun.am.UniversalIdentifier", univId);
            }
            if (this.indexType == AuthContext.IndexType.ROLE && this.indexName != null && !this.sessionUpgrade) {
                session.putProperty("Role", this.indexName);
            }
            if (!this.sessionUpgrade && (finalAuthConfig = this.getAuthConfigName(this.indexType, this.indexName)) != null && finalAuthConfig.length() != 0) {
                session.putProperty("Service", finalAuthConfig);
            }
            if (this.userSessionMapping != null && !this.userSessionMapping.isEmpty()) {
                Iterator tmpIterator = this.userSessionMapping.iterator();
                while (tmpIterator.hasNext()) {
                    Set userAttrValueSet;
                    String mapping = (String)tmpIterator.next();
                    if (mapping == null || mapping.length() == 0) continue;
                    StringTokenizer tokenizer = new StringTokenizer(mapping, "|");
                    String userAttribute = null;
                    String sessionAttribute = null;
                    if (tokenizer.hasMoreTokens()) {
                        userAttribute = tokenizer.nextToken();
                    }
                    if (tokenizer.hasMoreTokens()) {
                        sessionAttribute = tokenizer.nextToken();
                    }
                    if (userAttribute == null || userAttribute.length() == 0 || (userAttrValueSet = this.amIdentityUser.getAttribute(userAttribute)) == null || userAttrValueSet.isEmpty()) continue;
                    Iterator valueIter = userAttrValueSet.iterator();
                    StringBuffer strBuffValues = new StringBuffer();
                    while (valueIter.hasNext()) {
                        String userAttrValue = (String)valueIter.next();
                        if (strBuffValues.length() == 0) {
                            strBuffValues.append(userAttrValue);
                            continue;
                        }
                        strBuffValues.append("|").append(userAttrValue);
                    }
                    if (sessionAttribute != null) {
                        session.putProperty("am.protected." + sessionAttribute, strBuffValues.toString());
                        continue;
                    }
                    session.putProperty("am.protected." + userAttribute, strBuffValues.toString());
                }
            }
            if ((principalDataRetriever = AuthenticationPrincipalDataRetrieverFactory.getPrincipalDataRetriever()) != null && (attrMap = principalDataRetriever.getAttrMapForAuthenticationModule(this.subject)) != null && !attrMap.isEmpty()) {
                Set entrySet = attrMap.entrySet();
                Iterator iter = entrySet.iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String attrName = (String)entry.getKey();
                    String attrValue = (String)entry.getValue();
                    session.putProperty(attrName, attrValue);
                    if (!messageEnabled) continue;
                    debug.message("AttrMap for SAML : " + attrName + " , " + attrValue);
                }
            }
        }
        catch (Exception e) {
            debug.error("Exception in setSession ", (Throwable)e);
            throw new AuthException(e);
        }
    }

    public boolean getInetDomainStatus() {
        return this.inetDomainStatus;
    }

    public void setQueryOrg(String queryOrg) {
        this.queryOrg = queryOrg;
    }

    public String getQueryOrg() {
        return this.queryOrg;
    }

    public void setLocale(String locale) {
        this.localeContext.setUserLocale(locale);
        this.isLocaleSet = true;
    }

    public String getLocale() {
        if (!this.isLocaleSet) {
            return AuthD.platLocale;
        }
        return this.localeContext.getLocale().toString();
    }

    void destroySession() {
        if (this.session != null) {
            AuthUtils.removeAuthContext(this.sid);
            ad.destroySession(this.sid);
            this.sid = null;
            this.session = null;
        }
        if (ad.isHttpSessionUsed() && this.hsession != null) {
            this.hsession.removeAttribute("authContextObject");
            this.hsession.invalidate();
            this.hsession = null;
        }
    }

    public void persistentCookieArgExists() {
        String arg = (String)this.requestHash.get("iPSPCookie");
        if (arg != null && arg.length() != 0) {
            this.persistentCookieOn = arg.equalsIgnoreCase("yes");
        }
    }

    public SessionID getSid() {
        return this.sid;
    }

    public void setSid(SessionID aSid) {
        this.sid = aSid;
    }

    public boolean getForceFlag() {
        return this.forceAuth;
    }

    public void setForceAuth(boolean force) {
        this.forceAuth = force;
    }

    public void enableCookieTimeToLive(boolean flag) {
        this.cookieTimeToLiveEnabledFlag = flag;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("LoginState.enableCookieTimeToLive():enable=" + this.cookieTimeToLiveEnabledFlag);
        }
    }

    public boolean isCookieTimeToLiveEnabled() {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("LoginState.isCookieTimeToLiveEnabled():enabled=" + this.cookieTimeToLiveEnabledFlag);
        }
        return this.cookieTimeToLiveEnabledFlag;
    }

    public void setCookieTimeToLive(int timeToLive) {
        this.cookieTimeToLive = timeToLive;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("LoginState.setCookieTimeToLive():cookieTimeToLive=" + this.cookieTimeToLive);
        }
    }

    public int getCookieTimeToLive() {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("LoginState.getCookieTimeToLive():cookieTimeToLive=" + this.cookieTimeToLive);
        }
        return this.cookieTimeToLive;
    }

    public String getUserDomain(HttpServletRequest request, SessionID sid, Hashtable requestHash) {
        String userOrg = null;
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken ssoToken = manager.createSSOToken(request);
            if (!this.sessionUpgrade && !requestHash.isEmpty() && manager.isValidToken(ssoToken)) {
                userOrg = ssoToken.getProperty("Organization");
                debug.message("User org from existing valid session");
            }
        }
        catch (Exception e) {
            debug.message("ERROR in getUserDomain - " + e.toString());
        }
        if (userOrg == null) {
            userOrg = AuthUtils.newSessionArgExists(requestHash, sid) && sid.toString().length() > 0 ? sid.getSessionDomain() : AuthUtils.getDomainNameByRequest(request, requestHash);
        }
        if (messageEnabled) {
            debug.message("returning from getUserDomain : " + userOrg);
        }
        return userOrg;
    }

    public AuthContextLocal createAuthContext(HttpServletRequest request, HttpServletResponse response, SessionID sid, Hashtable requestHash) throws AuthException {
        this.loginURL = AuthUtils.constructLoginURL(request);
        this.forwardSuccess = AuthUtils.forwardSuccessExists(request);
        this.setRequestLocale(request);
        if (messageEnabled) {
            debug.message("locale : " + this.localeContext.getLocale());
        }
        this.userOrg = this.getUserDomain(request, sid, requestHash);
        if (messageEnabled) {
            debug.message("createAuthContext: userOrg is : " + this.userOrg);
        }
        if (this.userOrg == null || this.userOrg.length() == 0) {
            debug.message("domain is null, error condtion");
            this.logFailed(LoginState.ad.bundle.getString("invalidDomain"), "INVALIDDOMAIN");
            throw new AuthException("108", null);
        }
        if (messageEnabled) {
            debug.message("AuthUtil:getAuthContext:Creating new AuthContextLocal & LoginState");
        }
        AuthContextLocal authContext = new AuthContextLocal(this.userOrg);
        this.requestType = true;
        this.servletRequest = request;
        this.servletResponse = response;
        this.requestHash = requestHash;
        this.client = this.getClient();
        this.sid = sid;
        if (messageEnabled) {
            debug.message("requestType : " + this.requestType);
            debug.message("client : " + this.client);
            debug.message("sid : " + sid);
        }
        try {
            this.createSession(request, authContext);
        }
        catch (Exception e) {
            debug.error("Exception creating session .. :", (Throwable)e);
            throw new AuthException(e);
        }
        String cookieSupport = AuthUtils.getCookieSupport(this.getClientType());
        this.cookieDetect = AuthUtils.getCookieDetect(cookieSupport);
        if (cookieSupport != null && cookieSupport.equals("false")) {
            this.cookieSupported = false;
        }
        if (messageEnabled) {
            debug.message("cookieSupport is : " + cookieSupport);
            debug.message("cookieDetect is .. : " + this.cookieDetect);
            debug.message("cookieSupported is .. : " + this.cookieSupported);
        }
        if (AuthUtils.isClientDetectionEnabled() && this.cookieDetect) {
            this.cookieSet = true;
        }
        this.setGoToURL();
        this.setGoToOnFailURL();
        this.amIdRepo = ad.getAMIdentityRepository(this.getOrgDN());
        this.persistentCookieArgExists();
        this.populateOrgProfile();
        this.populateGlobalProfile();
        return authContext;
    }

    void createSession(HttpServletRequest req, AuthContextLocal authContext) throws AuthException {
        debug.message("LoginState: createSession: Creating new session: ");
        SessionID sid = null;
        if (ad.isHttpSessionUsed()) {
            debug.message("Save authContext in HttpSession");
            if (req != null) {
                this.hsession = req.getSession();
                sid = new SessionID(this.hsession.getId());
                this.hsession.setAttribute("authContextObject", (Object)authContext);
            }
        } else {
            debug.message("Save authContext in InternalSession");
            this.session = AuthD.newSession(this.getOrgDN(), null);
            sid = this.session.getID();
            this.session.setObject("authContextObject", authContext);
        }
        this.sid = sid;
        if (debug.messageEnabled()) {
            debug.message("LoginState:createSession: New session/sid=" + sid);
            debug.message("LoginState:New session: ac=" + authContext);
        }
    }

    public SSOToken getSSOToken() throws SSOException {
        if (this.session != null && this.session.getState() == 2) {
            return null;
        }
        try {
            SSOTokenManager ssoManager = SSOTokenManager.getInstance();
            SSOToken ssoToken = ssoManager.createSSOToken(this.session.getID().toString());
            return ssoToken;
        }
        catch (SSOException ex) {
            debug.error("Error retrieving SSOToken :", (Throwable)((Object)ex));
            throw new SSOException("amAuth", "102", null);
        }
    }

    public String encodeURL(String url, HttpServletResponse response) {
        return this.encodeURL(url, response, false);
    }

    public String encodeURL(String url, HttpServletResponse response, boolean useAMCookie) {
        if (messageEnabled) {
            debug.message("in encodeURL");
            debug.message("cookieDetect : " + this.cookieDetect);
            debug.message("cookieSupported : " + this.cookieSupported);
        }
        if (!this.cookieDetect && this.cookieSupported) {
            return url;
        }
        if (this.session == null) {
            return url;
        }
        String cookieName = AuthUtils.getCookieName();
        if (!useAMCookie && this.session.getState() == 0) {
            cookieName = AuthUtils.getAuthCookieName();
        }
        String encodedURL = url;
        encodedURL = urlRewriteInPath ? this.session.encodeURL(url, (short)2, false, cookieName) : this.session.encodeURL(url, (short)0, false, cookieName);
        if (messageEnabled) {
            debug.message("AuthRequest encodeURL : URL=" + url + ", Rewritten URL=" + encodedURL);
        }
        return encodedURL;
    }

    public String getFileName(String fileName) {
        String templateFile = AuthUtils.getFileName(fileName, this.getLocale(), this.getOrgDN(), this.servletRequest, ad.getServletContext(), this.indexType, this.indexName);
        return templateFile;
    }

    public boolean createUserProfile(String token, Set aliasList) {
        try {
            Map sattrs;
            if (!this.dynamicProfileCreation) {
                debug.message("Error this user requires a profile to login");
                return false;
            }
            if (this.isApplicationModule(this.authMethName)) {
                debug.message("No profile created for Application module");
                return false;
            }
            if (messageEnabled) {
                debug.message("Creating user entry: " + token);
                debug.message("aliasList : " + aliasList);
            }
            if (this.userCreationAttributes == null) {
                this.userCreationAttributes = new HashMap();
            }
            Map aliasMap = Collections.EMPTY_MAP;
            if (aliasList != null && !aliasList.isEmpty()) {
                debug.message("Adding alias list to user profile");
                if (this.externalAliasList != null && !this.externalAliasList.isEmpty()) {
                    aliasList.addAll(this.externalAliasList);
                }
                aliasMap.put("iplanet-am-user-alias-list", aliasList);
            }
            if (!aliasMap.isEmpty()) {
                this.userCreationAttributes.putAll(aliasMap);
            }
            if (messageEnabled) {
                debug.message("userCreationAttributes is : " + this.userCreationAttributes);
            }
            this.amIdentityUser = this.createUserIdentity(token, this.userCreationAttributes, this.defaultRoles);
            this.userDN = this.getUserDN(this.amIdentityUser);
            Map p = this.amIdentityUser.getAttributes();
            if (this.amIdentityRole != null && (sattrs = this.amIdentityRole.getServiceAttributes("iPlanetAMSessionService")) != null && !sattrs.isEmpty()) {
                p.putAll(sattrs);
            }
            this.populateUserAttributes(p, true, null);
            return true;
        }
        catch (Exception ex) {
            debug.error("Cannot create user profile for: " + token);
            if (messageEnabled) {
                debug.message("Stack trace: ", (Throwable)ex);
            }
            return false;
        }
    }

    private String[] getDefaultSessionAttributes(String orgDN) {
        String defaultMaxSession = ad.getDefaultMaxSessionTime();
        String defaultIdleTime = ad.getDefaultMaxIdleTime();
        String defaultCacheTime = ad.getDefaultMaxCachingTime();
        Map map = ad.getOrgServiceAttributes(orgDN, "iPlanetAMSessionService");
        if (!map.isEmpty()) {
            if (map.containsKey("iplanet-am-session-max-session-time")) {
                defaultMaxSession = (String)((Set)map.get("iplanet-am-session-max-session-time")).iterator().next();
            }
            if (map.containsKey("iplanet-am-session-max-idle-time")) {
                defaultIdleTime = (String)((Set)map.get("iplanet-am-session-max-idle-time")).iterator().next();
            }
            if (map.containsKey("iplanet-am-session-max-caching-time")) {
                defaultCacheTime = (String)((Set)map.get("iplanet-am-session-max-caching-time")).iterator().next();
            }
        }
        String[] attrs = new String[]{defaultMaxSession, defaultIdleTime, defaultCacheTime};
        return attrs;
    }

    void populateUserAttributes(Map p, boolean loginStatus, AMIdentity amIdentity) throws AMException {
        String[] sessionAttrs = this.getDefaultSessionAttributes(this.getOrgDN());
        if (messageEnabled) {
            debug.message("default max session time: " + sessionAttrs[0] + "\ndefault max idle time: " + sessionAttrs[1] + "\ndefault max caching time: " + sessionAttrs[2]);
        }
        try {
            this.userAuthConfig = CollectionHelper.getMapAttr((Map)p, (String)"iplanet-am-user-auth-config", null);
            if (!loginStatus) {
                this.userFailureURLSet = (Set)p.get("iplanet-am-user-failure-url");
                this.clientUserFailureURL = this.getRedirectUrl(this.userFailureURLSet);
                this.defaultUserFailureURL = this.tempDefaultURL;
                this.failureRoleURLSet = (Set)p.get("iplanet-am-auth-login-failure-url");
                this.clientFailureRoleURL = this.getRedirectUrl(this.failureRoleURLSet);
                this.defaultFailureRoleURL = this.tempDefaultURL;
                return;
            }
            this.maxSession = CollectionHelper.getIntMapAttr((Map)p, (String)"iplanet-am-session-max-session-time", (String)sessionAttrs[0], (Debug)debug);
            this.idleTime = CollectionHelper.getIntMapAttr((Map)p, (String)"iplanet-am-session-max-idle-time", (String)sessionAttrs[1], (Debug)debug);
            this.cacheTime = CollectionHelper.getIntMapAttr((Map)p, (String)"iplanet-am-session-max-caching-time", (String)sessionAttrs[2], (Debug)debug);
            String tmp = CollectionHelper.getMapAttr((Map)p, (String)"inetuserstatus", (String)"active");
            if (amIdentity != null) {
                tmp = amIdentity.isActive() ? "active" : "inactive";
            }
            String tmp1 = CollectionHelper.getMapAttr((Map)p, (String)"iplanet-am-user-login-status", (String)"active");
            String tmp2 = CollectionHelper.getMapAttr((Map)p, (String)"nsaccountlock", (String)"false");
            if (messageEnabled) {
                debug.message("entity status is : " + tmp);
                debug.message("user-login-status is : " + tmp1);
                debug.message("nsaccountlock is : " + tmp2);
            }
            if (!(tmp1.equalsIgnoreCase("active") && tmp.equalsIgnoreCase("active") && tmp2.equalsIgnoreCase("false"))) {
                this.userEnabled = false;
            }
            String ulocale = CollectionHelper.getMapAttr((Map)p, (String)"preferredlocale", null);
            this.localeContext.setUserLocale(ulocale);
            this.userAliasList = (Set)p.get("iplanet-am-user-alias-list");
            if (this.aliasAttrNames != null && !this.aliasAttrNames.isEmpty()) {
                Iterator it = this.aliasAttrNames.iterator();
                while (it.hasNext()) {
                    String attrName = (String)it.next();
                    Set attrVals = (Set)p.get(attrName);
                    if (attrVals == null) continue;
                    if (this.userAliasList == null) {
                        this.userAliasList = new HashSet();
                    }
                    this.userAliasList.addAll(attrVals);
                }
            }
            this.accountLife = CollectionHelper.getMapAttr((Map)p, (String)"iplanet-am-user-account-life");
            this.userSuccessURLSet = (Set)p.get("iplanet-am-user-success-url");
            this.clientUserSuccessURL = this.getRedirectUrl(this.userSuccessURLSet);
            this.defaultUserSuccessURL = this.tempDefaultURL;
            this.successRoleURLSet = (Set)p.get("iplanet-am-auth-login-success-url");
            this.clientSuccessRoleURL = this.getRedirectUrl(this.successRoleURLSet);
            this.defaultSuccessRoleURL = this.tempDefaultURL;
            if (messageEnabled) {
                debug.message("Populate User attributes\n  idle->" + this.idleTime + "\n  cache->" + this.cacheTime + "\n  max->" + this.maxSession + "\n  userLoginEnabled->" + this.userEnabled + "\n  charset->" + this.localeContext.getMIMECharset() + "\n  locale->" + this.localeContext.getLocale().toString() + "\n  userAlias->  :" + this.userAliasList + "\n  userSuccessURLSet-> :" + this.userSuccessURLSet + "\n  clientUserSuccessURL->  :" + this.clientUserSuccessURL + "\n  defaultUserSuccessURL->  :" + this.defaultUserSuccessURL + "\n  userFailureURLSet-> :" + this.userFailureURLSet + "\n  clientUserFailureURL->  :" + this.clientUserFailureURL + "\n  defaultUserFailureURL->  :" + this.defaultUserFailureURL + "\n  clientSuccessRoleURL ->  :" + this.clientSuccessRoleURL + "\n  defaultSuccessRoleURL ->  :" + this.defaultSuccessRoleURL + "\n  clientFailureRoleURL ->  :" + this.clientFailureRoleURL + "\n  defaultFailureRoleURL ->  :" + this.defaultFailureRoleURL + "\n  userAuthConfig -> : " + this.userAuthConfig + "\n  accountLife->" + this.accountLife);
            }
        }
        catch (Exception e) {
            if (messageEnabled) {
                debug.message("Eception in populateUserAttributes : ", (Throwable)e);
            }
            throw new AMException(e.getMessage(), e.toString());
        }
    }

    public boolean getUserProfile(String token, boolean populate) throws AuthException {
        try {
            return this.getUserProfile(token, populate, true);
        }
        catch (Exception e) {
            if (messageEnabled) {
                debug.message("getUserProfile(string,boolean)", (Throwable)e);
            }
            throw new AuthException(e);
        }
    }

    public boolean getUserProfile(String user, boolean populate, boolean loginStatus) throws AuthException {
        block35: {
            if (user == null || user.length() == 0) {
                throw new AuthException("102", null);
            }
            IdType idt = null;
            try {
                AMIdentity amIdentity;
                if (messageEnabled) {
                    debug.message("In getUserProfile : Search for user " + user);
                }
                Set amIdentitySet = Collections.EMPTY_SET;
                IdSearchResults searchResults = null;
                if (ad.isSuperAdmin(user)) {
                    amIdentity = ad.getIdentity(IdType.USER, user, this.getOrgDN());
                    amIdentitySet = new HashSet<AMIdentity>();
                    amIdentitySet.add(amIdentity);
                } else {
                    block34: {
                        try {
                            if (messageEnabled) {
                                debug.message("LoginState: gettingIdentity using IdUtil.getIdentity: " + user + " Org: " + this.getOrgDN());
                            }
                            if ((amIdentity = IdUtils.getIdentity(ad.getSSOAuthSession(), user, this.getOrgDN())) != null && amIdentity.getAttributes() != null) {
                                amIdentitySet = new HashSet();
                                amIdentitySet.add(amIdentity);
                                idt = amIdentity.getType();
                                if (messageEnabled) {
                                    debug.message("LoginState: getIdentity using IdUtil.getIdentity: " + amIdentity);
                                }
                            }
                        }
                        catch (IdRepoException e) {
                            if (messageEnabled) {
                                debug.message("LoginState: getting identity Got IdRepException in IdUtils.getIdentity", (Throwable)e);
                            }
                        }
                        catch (SSOException se) {
                            if (!messageEnabled) break block34;
                            debug.message("LoginState: getting identity Got SSOException in IdUtils.getIdentity", (Throwable)((Object)se));
                        }
                    }
                    if (amIdentitySet == Collections.EMPTY_SET || !this.identityTypes.contains(idt.getName())) {
                        if (messageEnabled) {
                            debug.message("LoginState: getIdentity performing IdRepo search to obtain AMIdentity");
                        }
                        String userTokenID = DNUtils.DNtoName(user);
                        if (messageEnabled) {
                            debug.message("Search for Identity " + userTokenID);
                        }
                        HashSet tmpIdentityTypes = new HashSet(this.identityTypes);
                        if (this.identityTypes.contains("user")) {
                            tmpIdentityTypes.remove("user");
                            searchResults = this.searchIdentity(IdUtils.getType("user"), userTokenID);
                            if (searchResults != null) {
                                amIdentitySet = searchResults.getSearchResults();
                            }
                        }
                        if (amIdentitySet.isEmpty()) {
                            Iterator identityIterator = tmpIdentityTypes.iterator();
                            while (identityIterator.hasNext()) {
                                String strIdType = (String)identityIterator.next();
                                searchResults = this.searchIdentity(IdUtils.getType(strIdType), userTokenID);
                                if (searchResults != null) {
                                    amIdentitySet = searchResults.getSearchResults();
                                }
                                if (amIdentitySet.isEmpty()) continue;
                                break;
                            }
                        }
                    }
                }
                if (messageEnabled) {
                    debug.message("result is :" + amIdentitySet);
                }
                if (amIdentitySet.isEmpty()) {
                    return false;
                }
                if (amIdentitySet.size() > 1) {
                    debug.error("getUserProfile : Multiple matches found for user '" + this.token + "' in org " + this.orgDN + "\nPlease make sure user is unique within the login " + "organization, and contact your admin to fix the problem");
                    throw new AuthException("102", null);
                }
                this.amIdentityUser = (AMIdentity)amIdentitySet.iterator().next();
                this.userDN = this.getUserDN(this.amIdentityUser);
                idt = this.amIdentityUser.getType();
                if (messageEnabled) {
                    debug.message("userDN is : " + this.userDN);
                    debug.message("userID(token) is : " + this.token);
                    debug.message("idType is : " + idt);
                }
                if (populate) {
                    Map basicAttrs = null;
                    Map serviceAttrs = null;
                    basicAttrs = searchResults != null ? (Map)searchResults.getResultAttributes().get(this.amIdentityUser) : this.amIdentityUser.getAttributes();
                    if (this.amIdentityRole != null) {
                        debug.message("retrieving session service from role");
                        serviceAttrs = this.amIdentityRole.getServiceAttributes("iPlanetAMSessionService");
                    } else if (idt.equals(IdType.USER)) {
                        debug.message("retrieving session service from user");
                        serviceAttrs = this.amIdentityUser.getServiceAttributes("iPlanetAMSessionService");
                    }
                    if (serviceAttrs != null && !serviceAttrs.isEmpty()) {
                        basicAttrs.putAll(serviceAttrs);
                    }
                    this.populateUserAttributes(basicAttrs, loginStatus, this.amIdentityUser);
                }
                return true;
            }
            catch (SSOException ex) {
                debug.error("SSOException");
                if (messageEnabled) {
                    debug.message("Stack trace: ", (Throwable)((Object)ex));
                }
            }
            catch (AMException ex) {
                debug.error("No aliases for: " + this.aliasAttrNames + "=" + this.token);
                if (messageEnabled) {
                    debug.message("Stack trace: ", (Throwable)ex);
                }
            }
            catch (IdRepoException ee) {
                if (!messageEnabled) break block35;
                debug.error("IdReporException ", (Throwable)ee);
            }
        }
        return false;
    }

    public void populateDefaultUserAttributes() throws AMException {
        String[] sessionAttrs = this.getDefaultSessionAttributes(this.getOrgDN());
        try {
            this.maxSession = Integer.parseInt(sessionAttrs[0]);
        }
        catch (Exception e) {
            this.maxSession = 120;
        }
        try {
            this.idleTime = Integer.parseInt(sessionAttrs[1]);
        }
        catch (Exception e) {
            this.idleTime = 30;
        }
        try {
            this.cacheTime = Integer.parseInt(sessionAttrs[2]);
        }
        catch (Exception e) {
            this.cacheTime = 3;
        }
        this.userEnabled = true;
        if (messageEnabled) {
            debug.message("Populate Default User attributes\n  idle->" + this.idleTime + "\n  cache->" + this.cacheTime + "\n  max->" + this.maxSession + "\n  userLoginEnabled->" + this.userEnabled + "\n  clientUserSuccessURL ->" + this.clientUserSuccessURL + "\n  defaultUserSuccessURL ->" + this.defaultUserSuccessURL + "\n  clientUserFailureURL ->" + this.clientUserFailureURL + "\n  defaultUserFailureURL ->" + this.defaultUserFailureURL + "\n  clientSuccessRoleURL ->" + this.clientSuccessRoleURL + "\n  defaultSuccessRoleURL ->" + this.defaultSuccessRoleURL + "\n  clientFailureRoleURL ->" + this.clientFailureRoleURL + "\n  defaultFailureRoleURL ->" + this.defaultFailureRoleURL + "\n  userAuthConfig ->" + this.userAuthConfig + "\n  charset->" + this.localeContext.getMIMECharset() + "\n  locale->" + this.localeContext.getLocale().toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean searchUserProfile(Subject subject, AuthContext.IndexType indexType, String indexName) throws AuthException {
        this.tokenSet = this.getTokenFromPrincipal(subject);
        if (messageEnabled) {
            debug.message("in searchUserProfile");
            debug.message("indexType is.. :" + indexType);
            debug.message("indexName is.. :" + indexName);
            debug.message("Subject is.. :" + subject);
            debug.message("token is.. :" + this.token);
            debug.message("tokenSet is.. :" + this.tokenSet);
            debug.message("pCookieUserName is.. :" + this.pCookieUserName);
            debug.message("ignoreUserProfile.. :" + this.ignoreUserProfile);
            debug.message("userDN is.. :" + this.userDN);
        }
        try {
            boolean gotUserProfile = true;
            if (this.ignoreUserProfile && !this.isApplicationModule(indexName) || this.isApplicationModule(indexName) && ad.isSuperAdmin(this.userDN)) {
                this.amIdentityUser = ad.isSuperAdmin(this.userDN) ? ad.getIdentity(IdType.USER, this.userDN, this.getOrgDN()) : new AMIdentity(null, this.userDN, IdType.USER, this.getOrgDN(), null);
                this.userDN = this.getUserDN(this.amIdentityUser);
                this.populateDefaultUserAttributes();
                return true;
            }
            if (indexType == AuthContext.IndexType.USER || this.pCookieUserName != null) {
                if (this.token == null && this.pCookieUserName != null) {
                    this.token = this.pCookieUserName;
                }
                if (this.token == null) {
                    return false;
                }
                this.getUserProfile(this.token, true);
                Map aliasFound = this.searchUserAliases(this.token, this.tokenSet);
                if (!this.checkAliasList(aliasFound)) {
                    if (!this.createWithAlias) throw new AuthException("107", null);
                    if (this.amIdentityUser == null) {
                        this.addAliasToUserProfile(this.amIdentityUser, aliasFound);
                    } else {
                        this.addAliasToUserProfile(this.token, aliasFound);
                    }
                }
            } else {
                boolean gotProfile = true;
                if (this.tokenSet.isEmpty()) {
                    debug.message("tokenset empty");
                    throw new AuthException("102", null);
                }
                if (this.tokenSet.size() == 1) {
                    debug.message("tokenset size is 1");
                    gotUserProfile = this.getCreateUserProfile(true);
                    if (!this.userEnabled) {
                        this.setFailedUserId(this.token);
                        throw new AuthException("104", null);
                    }
                    if (ad.isSuperAdmin(this.userDN)) {
                        return true;
                    }
                    if (gotUserProfile && indexType == AuthContext.IndexType.ROLE) {
                        boolean userRoleFound = this.getUserForRole(this.getIdentityRole(indexName, this.getOrgDN()));
                        if (messageEnabled) {
                            debug.message("userRoleFound: " + userRoleFound);
                        }
                        if (!userRoleFound) {
                            this.logFailed(AuthUtils.getErrorVal("113", "Error_Message"), "USERNOTFOUND");
                            throw new AuthException("113", null);
                        }
                    }
                } else {
                    debug.message("came here !! multiple modules , users ");
                    String validToken = null;
                    gotUserProfile = false;
                    boolean foundUserAlias = false;
                    boolean userRoleFound = true;
                    HashMap<String, Boolean> userEnabledMap = new HashMap<String, Boolean>();
                    HashMap<String, Boolean> userRoleFoundMap = new HashMap<String, Boolean>();
                    Map foundAliasMap = new HashMap();
                    HashMap<String, Boolean> gotUserProfileMap = new HashMap<String, Boolean>();
                    Boolean boolValFalse = Boolean.FALSE;
                    String aliasToken = null;
                    Iterator tokenIterator = this.tokenSet.iterator();
                    while (tokenIterator.hasNext()) {
                        this.token = (String)tokenIterator.next();
                        if (messageEnabled) {
                            debug.message("BEGIN WHILE: Token is.. : " + this.token);
                        }
                        gotUserProfile = this.getUserProfile(this.token, true);
                        gotUserProfileMap.put(this.token, gotUserProfile);
                        if (messageEnabled) {
                            debug.message("gotUserProfile : " + gotUserProfile);
                        }
                        if (!gotUserProfile) continue;
                        if (validToken == null) {
                            validToken = this.token;
                        }
                        userEnabledMap.put(this.token, this.userEnabled);
                        if (indexType == AuthContext.IndexType.ROLE) {
                            userRoleFound = this.getUserForRole(this.getIdentityRole(indexName, this.getOrgDN()));
                            userRoleFoundMap.put(this.token, userRoleFound);
                        }
                        if (!(foundUserAlias = this.getFoundUserAlias(foundAliasMap = this.searchUserAliases(this.token, this.tokenSet)))) continue;
                        aliasToken = this.token;
                        if (!messageEnabled) break;
                        debug.message("found aliases exiting while:" + foundAliasMap);
                        break;
                    }
                    if (messageEnabled) {
                        debug.message("Alias Token is : " + aliasToken);
                        debug.message("Profile Token :" + validToken);
                        debug.message("Token is : " + this.token);
                    }
                    if (aliasToken != null) {
                        this.token = aliasToken;
                    }
                    if (!this.hasAdminToken) {
                        boolean userEnabled = this.getUserEnabled(userEnabledMap);
                        if (!userEnabled) {
                            this.setFailedUserId(DNUtils.DNtoName(this.token));
                            throw new AuthException("104", null);
                        }
                        if (indexType == AuthContext.IndexType.ROLE) {
                            userRoleFound = this.getUserRoleFound(userRoleFoundMap);
                            if (!userRoleFound) {
                                this.logFailed(AuthUtils.getErrorVal("113", "Error_Message"), "USERNOTFOUND");
                                throw new AuthException("113", null);
                            }
                            if (messageEnabled) {
                                debug.message("userRoleFound:" + userRoleFound);
                            }
                        }
                        gotUserProfile = this.getGotUserProfile(gotUserProfileMap);
                        if (messageEnabled) {
                            debug.message("userEnabled : " + userEnabled);
                        }
                        if (gotUserProfile && !foundUserAlias) {
                            if (!this.createWithAlias) throw new AuthException("107", null);
                            if (messageEnabled) {
                                debug.message("dynamicProfileCreation : " + this.dynamicProfileCreation);
                                debug.message("foundUserAliasMap : " + foundAliasMap);
                                debug.message("foundUserAliasMap : " + foundUserAlias);
                            }
                            this.addAliasToUserProfile(validToken, foundAliasMap);
                        }
                        if (this.createWithAlias && !gotUserProfile) {
                            gotUserProfile = this.createUserProfileForTokens(this.tokenSet, gotUserProfileMap);
                        }
                    }
                }
            }
            if (!messageEnabled) return gotUserProfile;
            debug.message("LoginState:searchUserProfile:returning: " + gotUserProfile);
            return gotUserProfile;
        }
        catch (AuthException e) {
            throw new AuthException((Throwable)((Object)e));
        }
        catch (Exception e) {
            debug.error("Error retrieving profile", (Throwable)e);
            throw new AuthException(e);
        }
    }

    boolean getCreateUserProfile(boolean populate) throws AuthException {
        boolean gotProfile = false;
        gotProfile = this.userDN != null ? this.getUserProfile(this.userDN, populate) : this.getUserProfile(this.token, populate);
        if (!gotProfile && !ad.isSuperAdmin(this.userDN)) {
            gotProfile = this.createUserProfile(this.token, null);
        }
        return gotProfile;
    }

    boolean createUserProfileForTokens(Set tokenSet, Map gotUserProfileMap) {
        HashSet tokensList = new HashSet();
        String token = null;
        Iterator tokenIterator = tokenSet.iterator();
        while (tokenIterator.hasNext() && !ad.isSuperAdmin(token = (String)tokenIterator.next())) {
            while (tokenIterator.hasNext()) {
                Object alias = tokenIterator.next();
                if (messageEnabled) {
                    debug.message("alias list add token:" + (String)alias);
                }
                tokensList.add(alias);
            }
        }
        if (messageEnabled) {
            debug.message("Tokens List is.. :" + tokensList);
        }
        try {
            boolean profileCreated = this.createUserProfile(token, tokensList);
            return profileCreated;
        }
        catch (Exception e) {
            debug.error("Cannot create user profile for: " + token);
            if (messageEnabled) {
                debug.message("Stack trace: ", (Throwable)e);
            }
            return false;
        }
    }

    Map searchUserAliases(String userToken, Set tokenSet) {
        HashMap<String, Boolean> foundUserAliasMap = new HashMap<String, Boolean>();
        if (messageEnabled) {
            debug.message("userAliastList is.. :" + this.userAliasList);
            debug.message("userToken is.. :" + userToken);
            debug.message("tokenSet is.. :" + tokenSet);
        }
        if (tokenSet != null && !tokenSet.isEmpty()) {
            Iterator tokenIterator = tokenSet.iterator();
            while (tokenIterator.hasNext()) {
                String authToken = (String)tokenIterator.next();
                if (this.userAliasList != null && !this.userAliasList.isEmpty()) {
                    if (messageEnabled) {
                        debug.message("AuthToken is : " + authToken);
                        debug.message("userToken is : " + userToken);
                    }
                    if (authToken != null && authToken.equalsIgnoreCase(userToken) && !foundUserAliasMap.containsKey(authToken)) {
                        foundUserAliasMap.put(authToken, Boolean.TRUE);
                        continue;
                    }
                    if (this.userAliasList.contains(authToken)) {
                        foundUserAliasMap.put(authToken, Boolean.TRUE);
                        continue;
                    }
                    foundUserAliasMap.put(authToken, Boolean.FALSE);
                    continue;
                }
                if (authToken != null && authToken.equalsIgnoreCase(userToken)) {
                    foundUserAliasMap.put(authToken, Boolean.TRUE);
                    continue;
                }
                foundUserAliasMap.put(authToken, Boolean.FALSE);
            }
            if (messageEnabled) {
                debug.message("searchUserAliases: foundUserAliasMap : " + foundUserAliasMap);
            }
        }
        return foundUserAliasMap;
    }

    Set getTokenFromPrincipal(Subject subject) {
        Set<Principal> principal = subject.getPrincipals();
        HashSet<String> tokenSet = new HashSet<String>();
        StringBuffer pList = new StringBuffer();
        Iterator<Principal> p = principal.iterator();
        while (p.hasNext()) {
            this.token = p.next().getName();
            if (this.token != null && !this.containsToken(pList, this.token)) {
                pList.append(this.token).append("|");
                String tmpDN = DNUtils.normalizeDN(this.token);
                if (tmpDN != null) {
                    this.userDN = tmpDN;
                    this.token = DNUtils.DNtoName(this.token);
                } else if (tmpDN == null && this.userDN == null) {
                    this.userDN = this.token;
                }
            }
            if (!tokenSet.contains(this.token)) {
                tokenSet.add(this.token);
            }
            if (!messageEnabled) continue;
            debug.message("principal name is... :" + this.token);
        }
        this.principalList = pList.toString();
        if (this.principalList != null) {
            this.principalList = this.principalList.substring(0, this.principalList.length() - 1);
        }
        if (messageEnabled) {
            debug.message("Principal List is :" + this.principalList);
        }
        return tokenSet;
    }

    public boolean isUserEnabled() {
        return this.userEnabled;
    }

    public void setAuthLevel(String authLevel) {
        if (authLevel == null) {
            this.authLevel = 0;
        } else {
            try {
                this.authLevel = Integer.parseInt(authLevel);
            }
            catch (NumberFormatException e) {
                this.authLevel = 0;
            }
        }
        if (this.authLevel < this.moduleAuthLevel) {
            this.authLevel = this.moduleAuthLevel;
        }
        if (messageEnabled) {
            debug.message("AuthLevel is set to : " + this.authLevel);
        }
    }

    public AMIdentity getIdentityRole(String roleName, String orgDN) {
        if (this.amIdentityRole == null) {
            this.amIdentityRole = this.searchIdentityRole(roleName, orgDN);
        }
        return this.amIdentityRole;
    }

    AMIdentity searchIdentityRole(String role, String orgDN) {
        if (messageEnabled) {
            debug.message("rolename : " + role);
        }
        if (role == null) {
            return null;
        }
        AMIdentity amIdRole = null;
        try {
            amIdRole = this.getRole(role);
        }
        catch (Exception e) {
            debug.error("getRole: Error : ", (Throwable)e);
        }
        return amIdRole;
    }

    public void setAuthModuleName(String authMethName) {
        if (messageEnabled) {
            debug.message("authethName" + authMethName);
            debug.message("pAuthMethName " + this.pAuthMethName);
        }
        StringBuffer sb = null;
        if (this.pAuthMethName != null && this.pAuthMethName.length() > 0) {
            sb = new StringBuffer().append(this.pAuthMethName);
        }
        if (authMethName != null && authMethName.length() > 0) {
            if (sb != null) {
                sb.append("|").append(authMethName);
            } else {
                sb = new StringBuffer().append(authMethName);
            }
        }
        if (sb != null) {
            this.authMethName = sb.toString();
        }
        if (messageEnabled) {
            debug.message("setAuthModuleName: " + this.authMethName);
        }
    }

    public boolean getUserForRole(AMIdentity amIdentityRole) {
        boolean foundUser;
        block3: {
            Object val = null;
            foundUser = false;
            try {
                if (this.amIdentityUser.isMember(amIdentityRole)) {
                    foundUser = true;
                }
            }
            catch (Exception e) {
                if (!messageEnabled) break block3;
                debug.message("Error getRoleName : ", (Throwable)e);
            }
        }
        return foundUser;
    }

    void setIndexType(AuthContext.IndexType indexType) {
        this.indexType = indexType;
    }

    void setPreviousIndexType(AuthContext.IndexType prevIndexType) {
        this.prevIndexType = this.indexType;
    }

    public boolean isPersistentCookieOn() {
        return this.persistentCookieOn;
    }

    public boolean getPersistentCookieMode() {
        return this.persistentCookieMode;
    }

    void setToken(String token) {
        this.token = token;
    }

    public Hashtable getRequestParamHash() {
        return this.requestHash;
    }

    boolean getUserEnabled(Map userEnabledMap) {
        Boolean boolValFalse = Boolean.FALSE;
        this.userEnabled = !userEnabledMap.containsValue(boolValFalse);
        return this.userEnabled;
    }

    boolean getUserRoleFound(Map userRoleFoundMap) {
        boolean userRoleFound = true;
        Boolean boolValFalse = Boolean.FALSE;
        if (userRoleFoundMap.containsValue(boolValFalse)) {
            userRoleFound = false;
        }
        return userRoleFound;
    }

    boolean getFoundUserAlias(Map foundAliasMap) {
        if (messageEnabled) {
            debug.message("foundAliasMap :" + foundAliasMap);
        }
        boolean foundUserAlias = true;
        Boolean boolValFalse = Boolean.FALSE;
        if (foundAliasMap == null || foundAliasMap.isEmpty() || foundAliasMap.containsValue(boolValFalse)) {
            foundUserAlias = false;
        }
        if (messageEnabled) {
            debug.message("foundUserAlias : " + foundUserAlias);
        }
        return foundUserAlias;
    }

    boolean getGotUserProfile(Map gotUserProfileMap) {
        if (messageEnabled) {
            debug.message("GotUserProfileMAP is: " + gotUserProfileMap);
        }
        boolean gotUserProfile = false;
        Boolean boolValTrue = Boolean.TRUE;
        if (gotUserProfileMap.containsValue(boolValTrue)) {
            gotUserProfile = true;
        }
        if (messageEnabled) {
            debug.message("gotUserProfile :" + gotUserProfile);
        }
        return gotUserProfile;
    }

    void addAliasToUserProfile(String token, Map foundUserAliasMap) throws AuthException {
        if (messageEnabled) {
            debug.message("Token : " + token);
        }
        AMIdentity amIdentityUser = ad.getIdentity(IdType.USER, token, this.getOrgDN());
        this.addAliasToUserProfile(amIdentityUser, foundUserAliasMap);
    }

    void addAliasToUserProfile(AMIdentity amIdentity, Map foundUserAliasMap) {
        if (messageEnabled) {
            debug.message("foundUserAliasMap : " + foundUserAliasMap);
        }
        try {
            if (foundUserAliasMap != null && !foundUserAliasMap.isEmpty()) {
                Set aliasKeySet = foundUserAliasMap.keySet();
                Iterator aliasIterator = aliasKeySet.iterator();
                while (aliasIterator.hasNext()) {
                    String token1 = (String)aliasIterator.next();
                    if (this.token == null || this.token.equalsIgnoreCase(token1) || this.userAliasList.contains(token1)) continue;
                    this.userAliasList.add(token1);
                }
                debug.message("Adding alias list to user profile");
                HashMap<String, Set> aliasMap = new HashMap<String, Set>();
                if (this.externalAliasList != null && !this.externalAliasList.isEmpty()) {
                    this.userAliasList.addAll(this.externalAliasList);
                }
                aliasMap.put("iplanet-am-user-alias-list", this.userAliasList);
                amIdentity.setAttributes(aliasMap);
                amIdentity.store();
            }
        }
        catch (Exception e) {
            debug.error("Exception : " + e.getMessage(), (Throwable)e);
        }
    }

    boolean checkAliasList(Map userAliasList) {
        if (messageEnabled) {
            debug.message("UserAliasList is.. : " + userAliasList);
        }
        boolean aliasFound = true;
        Set aliasKeySet = userAliasList.keySet();
        Iterator aliasIterator = aliasKeySet.iterator();
        while (aliasIterator.hasNext()) {
            Boolean val;
            String newToken;
            Object token1 = aliasIterator.next();
            if (messageEnabled) {
                debug.message("Token is.. : " + (String)token1);
            }
            if (ad.isSuperAdmin(newToken = this.tokenToDN((String)token1)) || !(val = (Boolean)userAliasList.get(token1)).toString().equals("false")) continue;
            aliasFound = false;
            break;
        }
        return aliasFound;
    }

    public String searchPersistentCookie() {
        try {
            String username = null;
            String cookieValue = CookieUtils.getCookieValueFromReq((HttpServletRequest)this.servletRequest, (String)pCookieName);
            if (cookieValue != null) {
                username = this.parsePersistentCookie(cookieValue);
            }
            return username;
        }
        catch (Exception e) {
            if (messageEnabled) {
                debug.message("ERROR searchPersistentCookie ", (Throwable)e);
            }
            return null;
        }
    }

    private String parsePersistentCookie(String cookieValue) {
        try {
            SessionID oldSessionID;
            this.foundPCookie = Boolean.FALSE;
            String encodedInvalidCookie = (String)AccessController.doPrivileged(new EncodeAction("inPersistentCookie"));
            if (cookieValue == null || cookieValue.length() == 0 || cookieValue.equals(encodedInvalidCookie)) {
                return null;
            }
            String decode_cookieValue = (String)AccessController.doPrivileged(new DecodeAction(cookieValue));
            int domainIndex = decode_cookieValue.indexOf("%");
            if (domainIndex == -1) {
                return null;
            }
            String usernameStr = decode_cookieValue.substring(0, domainIndex);
            String tmpstr = decode_cookieValue.substring(domainIndex + 1);
            int authMethIndex = tmpstr.indexOf("%");
            if (authMethIndex == -1) {
                return null;
            }
            String domainStr = tmpstr.substring(0, authMethIndex);
            String tmpstr2 = tmpstr.substring(authMethIndex + 1);
            int tmpIndex = tmpstr2.indexOf("%");
            if (tmpIndex == -1) {
                return null;
            }
            String authMethStr = tmpstr2.substring(0, tmpIndex);
            tmpstr = tmpstr2.substring(tmpIndex + 1);
            if ((tmpIndex = tmpstr.indexOf("%")) == -1) {
                return null;
            }
            int maxSession = Integer.parseInt(tmpstr.substring(0, tmpIndex));
            tmpstr2 = tmpstr.substring(tmpIndex + 1);
            if ((tmpIndex = tmpstr2.indexOf("%")) == -1) {
                return null;
            }
            int idleTime = Integer.parseInt(tmpstr2.substring(0, tmpIndex));
            if ((tmpIndex = (tmpstr2 = tmpstr2.substring(tmpIndex + 1)).indexOf("%")) == -1) {
                return null;
            }
            int cacheTime = Integer.parseInt(tmpstr2.substring(0, tmpIndex));
            if ((tmpIndex = (tmpstr2 = tmpstr2.substring(tmpIndex + 1)).indexOf("%")) == -1) {
                return null;
            }
            String oldSidString = tmpstr2.substring(0, tmpIndex);
            this.pCookieTimeCreated = Long.parseLong(tmpstr2.substring(tmpIndex + 1));
            if (messageEnabled) {
                debug.message("pCookieTimeCreated : " + this.pCookieTimeCreated);
            }
            if (!this.sessionUpgrade && (oldSessionID = new SessionID(oldSidString)) != null) {
                AuthUtils.removeAuthContext(oldSessionID);
            }
            if (!this.getOrgName().equals(domainStr)) {
                this.userOrg = this.orgName = domainStr;
            }
            Object authModuleName = null;
            if (messageEnabled) {
                debug.message("authMethStr: " + authMethStr);
            }
            this.pAuthMethName = authMethStr;
            if (messageEnabled) {
                debug.message("Found valid PC : username=" + usernameStr + "\ndomainname=" + domainStr + "\nauthMethod=" + this.pAuthMethName + "\nmaxSession=" + maxSession + "\nidleTime=" + idleTime + "\ncacheTime=" + cacheTime + "\norgDN=" + this.orgDN);
            }
            this.foundPCookie = Boolean.TRUE;
            return usernameStr;
        }
        catch (Exception e) {
            if (messageEnabled) {
                debug.message("ERROR:parsePersistentCookie : ", (Throwable)e);
            }
            return null;
        }
    }

    public static String encodePCookie() {
        return (String)AccessController.doPrivileged(new EncodeAction("inPersistentCookie"));
    }

    public Cookie setPersistentCookie(String cookieDomain) throws SSOException, AMException {
        String maxage_str = this.persistentCookieTime;
        Cookie pCookie = null;
        if (maxage_str != null) {
            int maxAge;
            try {
                maxAge = Integer.parseInt(maxage_str);
                if (this.foundPCookie != null && this.foundPCookie.booleanValue()) {
                    long timeRem = System.currentTimeMillis() - this.pCookieTimeCreated;
                    maxAge -= new Long(timeRem / 1000L).intValue();
                }
            }
            catch (Exception Ex2) {
                maxAge = 0;
            }
            if (messageEnabled) {
                debug.message("Add Cookie: maxage=" + maxAge);
                debug.message("Add Cookie: maxage_str=" + maxage_str);
            }
            if (maxAge > 0) {
                String cookiestr = this.getUserDN(this.amIdentityUser) + "%" + this.getOrgName() + "%" + this.authMethName + "%" + Integer.toString(this.maxSession) + "%" + Integer.toString(this.idleTime) + "%" + Integer.toString(this.cacheTime) + "%" + this.sid.toString() + "%" + System.currentTimeMillis();
                String pCookieValue = (String)AccessController.doPrivileged(new EncodeAction(cookiestr));
                pCookie = AuthUtils.createPersistentCookie(AuthUtils.getPersistentCookieName(), pCookieValue, maxAge, cookieDomain);
                if (messageEnabled) {
                    debug.message("Add PCookie = " + cookiestr);
                }
            } else if (messageEnabled) {
                debug.message("Persistent Cookie Mode configured for domain " + this.orgName + ", but no persistentCookieTime = " + maxage_str);
            }
        }
        return pCookie;
    }

    public Cookie setlbCookie(String cookieDomain, boolean persist) throws SSOException, AMException {
        String cookieName = AuthUtils.getlbCookieName();
        String cookieValue = AuthUtils.getlbCookieValue();
        String maxage_str = this.persistentCookieTime;
        Cookie lbCookie = null;
        if (maxage_str != null && persist) {
            int maxAge;
            try {
                maxAge = Integer.parseInt(maxage_str);
            }
            catch (Exception Ex2) {
                maxAge = 0;
            }
            if (messageEnabled) {
                debug.message("Add Load Balance Cookie: maxage=" + maxAge);
            }
            if (maxAge > 0) {
                lbCookie = AuthUtils.createPersistentCookie(cookieName, cookieValue, maxAge, cookieDomain);
                debug.message("Add Load Balance Cookie!");
            } else {
                debug.message("No Load Balance Cookie set!");
            }
        } else {
            lbCookie = AuthUtils.createPersistentCookie(cookieName, cookieValue, -1, cookieDomain);
        }
        return lbCookie;
    }

    public AuthContext.IndexType getIndexType() {
        return this.indexType;
    }

    public AuthContext.IndexType getPreviousIndexType() {
        return this.prevIndexType;
    }

    void setGoToURL() {
        String arg = (String)this.requestHash.get("goto");
        if (arg != null && arg.length() != 0) {
            String encoded = this.servletRequest.getParameter("encoded");
            this.gotoURL = encoded != null && encoded.equals("true") ? AuthUtils.getBase64DecodedValue(arg) : arg;
        }
    }

    void setGoToOnFailURL() {
        String arg = (String)this.requestHash.get("gotoOnFail");
        if (arg != null && arg.length() != 0) {
            String encoded = this.servletRequest.getParameter("encoded");
            this.gotoOnFailURL = encoded != null && encoded.equals("true") ? AuthUtils.getBase64DecodedValue(arg) : arg;
        }
    }

    public String getSuccessLoginURL() {
        String currentGoto;
        String post_process_goto = null;
        if (this.session != null) {
            post_process_goto = this.session.getProperty("PostProcessSuccessURL");
        }
        if (post_process_goto != null && post_process_goto.length() > 0) {
            return post_process_goto;
        }
        String string = currentGoto = this.servletRequest == null ? null : this.servletRequest.getParameter("goto");
        if (messageEnabled) {
            AuthD.debug.message("currentGoto : " + currentGoto);
        }
        String fqdnURL = null;
        if (currentGoto != null && currentGoto.length() != 0 && !currentGoto.equalsIgnoreCase("null")) {
            String encoded = this.servletRequest.getParameter("encoded");
            if (encoded != null && encoded.equals("true")) {
                currentGoto = AuthUtils.getBase64DecodedValue(currentGoto);
            }
            fqdnURL = ad.processURL(currentGoto, this.servletRequest);
        } else if (fqdnURL == null || fqdnURL.length() == 0) {
            fqdnURL = ad.processURL(this.successLoginURL, this.servletRequest);
        }
        String encodedSuccessURL = this.encodeURL(fqdnURL, this.servletResponse, true);
        if (messageEnabled) {
            AuthD.debug.message("get fqdnURL : " + fqdnURL);
            AuthD.debug.message("get successLoginURL : " + this.successLoginURL);
            AuthD.debug.message("get encodedSuccessURL : " + encodedSuccessURL);
        }
        return encodedSuccessURL;
    }

    public String getConfiguredSuccessLoginURL() {
        String encodedSuccessURL = this.encodeURL(ad.processURL(this.successLoginURL, this.servletRequest), this.servletResponse, true);
        if (messageEnabled) {
            debug.message("getSuccessLoginURL : " + this.successLoginURL);
            debug.message("getSuccessLoginURL (encoded) : " + encodedSuccessURL);
        }
        return encodedSuccessURL;
    }

    String getSuccessURLForRole() {
        String roleURL;
        block2: {
            roleURL = null;
            try {
                Map roleAttrMap = this.getRoleServiceAttributes();
                roleURL = this.getRoleURLFromAttribute(roleAttrMap, "iplanet-am-auth-login-success-url");
            }
            catch (Exception e) {
                if (!messageEnabled) break block2;
                debug.message("Execption:getSuccessURLForRole : ", (Throwable)e);
            }
        }
        return roleURL;
    }

    String getFailureURLForRole() {
        String roleFailureURL;
        block2: {
            roleFailureURL = null;
            try {
                Map roleAttrMap = this.getRoleServiceAttributes();
                roleFailureURL = this.getRoleURLFromAttribute(roleAttrMap, "iplanet-am-auth-login-failure-url");
            }
            catch (Exception e) {
                if (!messageEnabled) break block2;
                debug.message("Error retrieving url ");
                debug.message("Exception : ", (Throwable)e);
            }
        }
        return roleFailureURL;
    }

    Map getRoleServiceAttributes() throws Exception {
        try {
            if (this.roleAttributeMap == null) {
                if (AuthD.revisionNumber < 30) {
                    this.roleAttributeMap = this.amIdentityRole.getServiceAttributes("iPlanetAMAuthConfiguration");
                } else {
                    Map roleServiceAttrMap = this.amIdentityRole.getServiceAttributes("iPlanetAMAuthConfiguration");
                    String serviceName = (String)((Set)roleServiceAttrMap.get("iplanet-am-auth-configuration")).iterator().next();
                    if (serviceName != null && !serviceName.equals("[Empty]")) {
                        this.roleAuthConfig = serviceName;
                        this.roleAttributeMap = this.getServiceAttributes(serviceName);
                    }
                }
            }
            if (this.roleAttributeMap == null) {
                this.roleAttributeMap = Collections.EMPTY_MAP;
            }
            if (messageEnabled) {
                debug.message("Returning Service Attributes: " + this.roleAttributeMap);
                debug.message("for Role : " + this.amIdentityRole.getName());
            }
            return this.roleAttributeMap;
        }
        catch (Exception e) {
            debug.error("Error getting Role Attributes : ", (Throwable)e);
            throw new Exception("102");
        }
    }

    String getSuccessURLForService(String indexName) {
        String successServiceURL;
        block5: {
            successServiceURL = null;
            try {
                if (this.serviceAttributesMap != null && this.serviceAttributesMap.isEmpty()) {
                    this.serviceAttributesMap = this.getServiceAttributes(indexName);
                }
                if (messageEnabled) {
                    debug.message("AttributeMAP is.. :" + this.serviceAttributesMap);
                }
                successServiceURL = this.getServiceURLFromAttribute(this.serviceAttributesMap, "iplanet-am-auth-login-success-url");
                if (messageEnabled) {
                    debug.message("service successURL : " + successServiceURL);
                }
            }
            catch (Exception e) {
                if (!messageEnabled) break block5;
                debug.message("Error retrieving url ");
                debug.message("Exception : ", (Throwable)e);
            }
        }
        return successServiceURL;
    }

    String getFailureURLForService(String indexName) {
        String serviceFailureURL;
        block4: {
            serviceFailureURL = null;
            try {
                if (this.serviceAttributesMap.isEmpty()) {
                    this.serviceAttributesMap = this.getServiceAttributes(indexName);
                }
                serviceFailureURL = this.getServiceURLFromAttribute(this.serviceAttributesMap, "iplanet-am-auth-login-failure-url");
                if (messageEnabled) {
                    debug.message("Service failureURL: " + serviceFailureURL);
                }
            }
            catch (Exception e) {
                if (!messageEnabled) break block4;
                debug.message("Error retrieving url ");
                debug.message("Exception : ", (Throwable)e);
            }
        }
        return serviceFailureURL;
    }

    Map getServiceAttributes(String indexName) throws Exception {
        try {
            Map attributeDataMap = AMAuthConfigUtils.getNamedConfig(indexName, this.getOrgDN(), ad.getSSOAuthSession());
            return attributeDataMap;
        }
        catch (Exception e) {
            if (messageEnabled) {
                debug.message("Error getting service attribute: ");
                debug.message(" Exception : " + e.getMessage());
            }
            throw new Exception(e.getMessage());
        }
    }

    AMPostAuthProcessInterface getPostLoginProcessInstance(String className) {
        if (messageEnabled) {
            debug.message("postLoginProcess Class Name is : " + className);
        }
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            AMPostAuthProcessInterface loginPostProcessInstance = (AMPostAuthProcessInterface)Class.forName(className).newInstance();
            return loginPostProcessInstance;
        }
        catch (ClassNotFoundException ce) {
            if (messageEnabled) {
                debug.message("Class not Found :", (Throwable)ce);
            }
            return null;
        }
        catch (Exception e) {
            if (messageEnabled) {
                debug.message("Error: ", (Throwable)e);
            }
            return null;
        }
    }

    public void setSuccessLoginURL(String url) {
        if (messageEnabled) {
            debug.message("URL : from modle  : " + url);
        }
        this.moduleSuccessLoginURL = url;
    }

    public void setFailureLoginURL(String url) {
        this.moduleFailureLoginURL = url;
    }

    public void setSuccessLoginURL(AuthContext.IndexType indexType, String indexName) {
        String successURL;
        if (messageEnabled) {
            debug.message("moduleSucessLoginURL : " + this.moduleSuccessLoginURL);
        }
        if (this.moduleSuccessLoginURL != null && this.moduleSuccessLoginURL.length() != 0) {
            this.successLoginURL = this.moduleSuccessLoginURL;
            return;
        }
        String defSuccessURL = null;
        if (this.clientUserSuccessURL != null && this.clientUserSuccessURL.length() != 0) {
            this.successLoginURL = this.clientUserSuccessURL;
            if (this.successLoginURL != null) {
                return;
            }
        }
        defSuccessURL = this.defaultUserSuccessURL;
        if (indexType == AuthContext.IndexType.ROLE) {
            successURL = this.getSuccessURLForRole();
            if (successURL != null && successURL.length() != 0) {
                this.successLoginURL = successURL;
                return;
            }
            if (defSuccessURL == null || defSuccessURL.length() == 0) {
                defSuccessURL = this.tempDefaultURL;
            }
        }
        if (indexType == AuthContext.IndexType.SERVICE) {
            successURL = this.getSuccessURLForService(indexName);
            if (successURL != null && successURL.length() != 0) {
                this.successLoginURL = successURL;
                return;
            }
            if (defSuccessURL == null || defSuccessURL.length() == 0) {
                defSuccessURL = this.tempDefaultURL;
            }
        }
        if (this.clientSuccessRoleURL != null && this.clientSuccessRoleURL.length() != 0) {
            this.successLoginURL = this.clientSuccessRoleURL;
            return;
        }
        if (defSuccessURL == null || defSuccessURL.length() == 0) {
            defSuccessURL = this.defaultSuccessRoleURL;
        }
        if (this.clientOrgSuccessLoginURL != null && this.clientOrgSuccessLoginURL.length() != 0) {
            this.successLoginURL = this.clientOrgSuccessLoginURL;
            return;
        }
        if (defSuccessURL == null || defSuccessURL.length() == 0) {
            defSuccessURL = this.defaultOrgSuccessLoginURL;
        }
        if (indexType == AuthContext.IndexType.SERVICE || indexType == AuthContext.IndexType.ROLE) {
            this.defaultSuccessURL = this.getRedirectUrl(LoginState.ad.defaultServiceSuccessURLSet);
        } else {
            this.defaultSuccessURL = this.getRedirectUrl(LoginState.ad.defaultSuccessURLSet);
            LoginState.ad.defaultSuccessURL = this.tempDefaultURL;
        }
        if (this.defaultSuccessURL != null && this.defaultSuccessURL.length() != 0) {
            this.successLoginURL = this.defaultSuccessURL;
            return;
        }
        if (defSuccessURL == null || defSuccessURL.length() == 0) {
            defSuccessURL = this.tempDefaultURL;
        }
        this.successLoginURL = defSuccessURL;
        if (messageEnabled) {
            debug.message("SUCCESS Login url : " + this.successLoginURL);
        }
    }

    public void setFailureLoginURL(AuthContext.IndexType indexType, String indexName) {
        String failureURL;
        String defFailureURL;
        block22: {
            if (this.moduleFailureLoginURL != null && this.moduleFailureLoginURL.length() != 0) {
                this.failureLoginURL = this.moduleFailureLoginURL;
                return;
            }
            if (this.gotoOnFailURL != null && this.gotoOnFailURL.length() != 0) {
                this.failureLoginURL = this.gotoOnFailURL;
                return;
            }
            if (messageEnabled) {
                debug.message("failureTokenId in setFailureLoginURL = " + this.failureTokenId);
            }
            defFailureURL = null;
            if (this.failureTokenId != null) {
                try {
                    this.getUserProfile(this.failureTokenId, true, false);
                    if (this.clientUserFailureURL != null && this.clientUserFailureURL.length() != 0) {
                        this.failureLoginURL = this.clientUserFailureURL;
                        return;
                    }
                    defFailureURL = this.defaultUserFailureURL;
                }
                catch (Exception e) {
                    if (!messageEnabled) break block22;
                    debug.message("Error retreiving profile for : " + this.failureTokenId, (Throwable)e);
                }
            }
        }
        if (indexType == AuthContext.IndexType.ROLE) {
            failureURL = this.getFailureURLForRole();
            if (failureURL != null && failureURL.length() != 0) {
                this.failureLoginURL = failureURL;
                return;
            }
            if (defFailureURL == null || defFailureURL.length() == 0) {
                defFailureURL = this.tempDefaultURL;
            }
        }
        if (indexType == AuthContext.IndexType.SERVICE) {
            failureURL = this.getFailureURLForService(indexName);
            if (failureURL != null && failureURL.length() != 0) {
                this.failureLoginURL = failureURL;
                return;
            }
            if (defFailureURL == null || defFailureURL.length() == 0) {
                defFailureURL = this.tempDefaultURL;
            }
        }
        if (this.clientFailureRoleURL != null && this.clientFailureRoleURL.length() != 0) {
            this.failureLoginURL = this.clientFailureRoleURL;
            return;
        }
        if (defFailureURL == null || defFailureURL.length() == 0) {
            defFailureURL = this.defaultFailureRoleURL;
        }
        if (this.clientOrgFailureLoginURL != null && this.clientOrgFailureLoginURL.length() != 0) {
            this.failureLoginURL = this.clientOrgFailureLoginURL;
            return;
        }
        if (defFailureURL == null || defFailureURL.length() == 0) {
            defFailureURL = this.defaultOrgFailureLoginURL;
        }
        if (indexType == AuthContext.IndexType.SERVICE || indexType == AuthContext.IndexType.ROLE) {
            this.defaultFailureURL = this.getRedirectUrl(LoginState.ad.defaultServiceFailureURLSet);
        } else {
            this.defaultFailureURL = this.getRedirectUrl(LoginState.ad.defaultFailureURLSet);
            LoginState.ad.defaultFailureURL = this.tempDefaultURL;
        }
        if (this.defaultFailureURL != null && this.defaultFailureURL.length() != 0) {
            this.failureLoginURL = this.defaultFailureURL;
            return;
        }
        if (defFailureURL == null || defFailureURL.length() == 0) {
            defFailureURL = this.tempDefaultURL;
        }
        this.failureLoginURL = defFailureURL;
        if (messageEnabled) {
            debug.message("defaultFailureURL : " + this.failureLoginURL);
        }
    }

    public String getFailureLoginURL() {
        if (this.fqdnFailureLoginURL == null || this.fqdnFailureLoginURL.length() == 0) {
            this.fqdnFailureLoginURL = ad.processURL(this.failureLoginURL, this.servletRequest);
        }
        return this.fqdnFailureLoginURL;
    }

    String getRoleURLFromAttribute(Map roleAttrMap, String attrName) {
        try {
            Set roleURLSet = (Set)roleAttrMap.get(attrName);
            return this.getRedirectUrl(roleURLSet);
        }
        catch (Exception e) {
            if (messageEnabled) {
                debug.message("Error getting role attribute ", (Throwable)e);
            }
            return null;
        }
    }

    String getServiceURLFromAttribute(Map attributeMap, String attrName) {
        Set serviceURLSet = (Set)attributeMap.get(attrName);
        String serviceURL = this.getRedirectUrl(serviceURLSet);
        if (messageEnabled) {
            debug.message("attr map: " + attributeMap + "\nserviceURL : " + serviceURL);
        }
        return serviceURL;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.servletResponse;
    }

    protected void setHttpServletResponse(HttpServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    public synchronized void setPersistentCookieOn() {
        this.persistentCookieOn = true;
    }

    public Callback[] getRecdCallback() {
        return this.prevCallback;
    }

    public synchronized void setPrevCallback(Callback[] prevCallback) {
        this.prevCallback = prevCallback;
    }

    protected String getAccountLife() {
        return this.accountLife;
    }

    protected String getUserToken() {
        return this.token;
    }

    protected boolean getEnableModuleBasedAuth() {
        return this.enableModuleBasedAuth;
    }

    protected boolean getLoginFailureLockoutMode() {
        return this.loginFailureLockoutMode;
    }

    protected boolean getLoginFailureLockoutStoreInDS() {
        return this.loginFailureLockoutStoreInDS;
    }

    protected long getLoginFailureLockoutTime() {
        return this.loginFailureLockoutTime;
    }

    protected int getLoginFailureLockoutCount() {
        return this.loginFailureLockoutCount;
    }

    protected String getLoginLockoutNotification() {
        return this.loginLockoutNotification;
    }

    protected int getLoginLockoutUserWarning() {
        return this.loginLockoutUserWarning;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorTemplate(String errorTemplate) {
        this.errorTemplate = errorTemplate;
    }

    public String getErrorTemplate() {
        return this.errorTemplate;
    }

    public void setModuleErrorTemplate(String moduleErrorTemplate) {
        this.moduleErrorTemplate = moduleErrorTemplate;
    }

    public String getModuleErrorTemplate() {
        return this.moduleErrorTemplate;
    }

    public void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setLockoutMsg(String lockoutMsg) {
        if (messageEnabled) {
            debug.message("setLockoutMsg :" + lockoutMsg);
        }
        this.lockoutMsg = lockoutMsg;
    }

    public String getLockoutMsg() {
        return this.lockoutMsg;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public AuthContextLocal createAuthContext(SessionID sid, String orgName, HttpServletRequest req) throws AuthException {
        this.userOrg = this.getDomainNameByOrg(orgName);
        if (messageEnabled) {
            debug.message("createAuthContext: userOrg is : " + this.userOrg);
        }
        if (this.userOrg == "" || this.userOrg == null) {
            debug.error("domain is null, error condtion");
            this.logFailed(LoginState.ad.bundle.getString("invalidDomain"), "INVALIDDOMAIN");
            throw new AuthException("108", null);
        }
        if (messageEnabled) {
            debug.message("AuthUtil::getAuthContext::Creating new AuthContextLocal & LoginState");
        }
        AuthContextLocal authContext = new AuthContextLocal(this.userOrg);
        this.requestType = true;
        this.sid = sid;
        if (messageEnabled) {
            debug.message("requestType : " + this.requestType);
            debug.message("sid : " + sid);
            debug.message("orgName passed: " + orgName);
        }
        try {
            this.createSession(req, authContext);
        }
        catch (Exception e) {
            debug.error("Exception creating session .. :", (Throwable)e);
            throw new AuthException("102", null);
        }
        this.amIdRepo = ad.getAMIdentityRepository(this.getOrgDN());
        this.populateOrgProfile();
        this.isLocaleSet = false;
        return authContext;
    }

    public boolean setModuleAuthLevel(int authLevel) {
        boolean levelSet = false;
        this.moduleAuthLevel = authLevel;
        if (this.authLevel < this.moduleAuthLevel) {
            this.authLevel = this.moduleAuthLevel;
            levelSet = true;
        }
        if (messageEnabled) {
            debug.message("spi authLevel :" + authLevel);
            debug.message("module configuration authLevel :" + this.authLevel);
            debug.message("levelSet :" + levelSet);
        }
        return levelSet;
    }

    public String getDomainNameByOrg(String orgName) {
        String orgDN;
        block2: {
            orgDN = null;
            try {
                orgDN = AuthUtils.getOrganizationDN(orgName, false, null);
            }
            catch (Exception e) {
                if (!messageEnabled) break block2;
                debug.message("Incorrect orgName passed:" + orgName, (Throwable)e);
            }
        }
        return orgDN;
    }

    public Set getModuleInstances() {
        block5: {
            try {
                if (this.moduleInstances != null && !this.moduleInstances.isEmpty()) {
                    return this.moduleInstances;
                }
                this.moduleInstances = this.domainAuthenticators;
                if (messageEnabled) {
                    debug.message("moduleInstances are : " + this.moduleInstances);
                }
            }
            catch (Exception e) {
                if (!messageEnabled) break block5;
                debug.message("Error getting moduleInstances ", (Throwable)e);
            }
        }
        if (this.moduleInstances == null) {
            this.moduleInstances = Collections.EMPTY_SET;
        }
        return this.moduleInstances;
    }

    public Set getDomainAuthenticators() {
        return this.domainAuthenticators;
    }

    public void setX509Certificate(X509Certificate cert) {
        this.cert = cert;
    }

    public X509Certificate getX509Certificate(HttpServletRequest servletrequest) {
        Object obj;
        X509Certificate[] allCerts;
        if (servletrequest != null && servletrequest.isSecure() && (allCerts = (X509Certificate[])(obj = servletrequest.getAttribute("javax.servlet.request.X509Certificate"))) != null && allCerts.length != 0) {
            if (debug.messageEnabled()) {
                debug.message("LoginState.getX509Certificate :length of cert array " + allCerts.length);
            }
            this.cert = allCerts[0];
        }
        return this.cert;
    }

    public void logSuccess() {
        try {
            String logSuccess = LoginState.ad.bundle.getString("loginSuccess");
            ArrayList<String> dataList = new ArrayList<String>();
            dataList.add(logSuccess);
            StringBuffer messageId = new StringBuffer();
            messageId.append("LOGIN_SUCCESS");
            if (this.indexType != null) {
                messageId.append("_").append(this.indexType.toString().toUpperCase());
                dataList.add(this.indexType.toString());
                if (this.indexName != null) {
                    dataList.add(this.indexName);
                }
            }
            String[] data = dataList.toArray(new String[0]);
            String contextId = null;
            SSOToken localSSOToken = this.getSSOToken();
            if (localSSOToken != null) {
                contextId = localSSOToken.getProperty("AMCtxId");
            }
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (this.client != null) {
                props.put("IPAddr", this.client);
            }
            if (this.userDN != null) {
                props.put("LoginID", this.userDN);
            }
            if (this.orgDN != null) {
                props.put("Domain", this.orgDN);
            }
            if (this.authMethName != null) {
                props.put("ModuleName", this.authMethName);
            }
            if (this.session != null) {
                props.put("LoginIDSid", this.sid.toString());
            }
            if (contextId != null) {
                props.put("ContextID", contextId);
            }
            ad.logIt(data, 0, messageId.toString(), props);
        }
        catch (Exception e) {
            debug.message("Error creating logSuccess message", (Throwable)e);
        }
    }

    public void logFailed(String str) {
        this.logFailed(str, null);
    }

    public void logFailed(String str, String error) {
        try {
            String logFailed = str;
            if (str == null) {
                logFailed = LoginState.ad.bundle.getString("loginFailed");
            }
            ArrayList<String> dataList = new ArrayList<String>();
            dataList.add(logFailed);
            StringBuffer messageId = new StringBuffer();
            messageId.append("LOGIN_FAILED");
            if (this.indexType != null && this.indexType != AuthContext.IndexType.COMPOSITE_ADVICE) {
                messageId.append("_").append(this.indexType.toString().toUpperCase());
                dataList.add(this.indexType.toString());
                if (this.indexName != null) {
                    dataList.add(this.indexName);
                }
            }
            if (error != null) {
                messageId.append("_").append(error);
            }
            String[] data = dataList.toArray(new String[0]);
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (this.client != null) {
                props.put("IPAddr", this.client);
            }
            if (this.userDN != null) {
                props.put("LoginID", this.userDN);
            } else if (this.failureTokenId != null) {
                props.put("LoginID", this.failureTokenId);
            }
            if (this.orgDN != null) {
                props.put("Domain", this.orgDN);
            }
            if (this.failureModuleList != null && this.failureModuleList.length() > 0) {
                props.put("ModuleName", this.failureModuleList);
            }
            if (this.session != null) {
                props.put("LoginIDSid", this.sid.toString());
            }
            ad.logIt(data, 1, messageId.toString(), props);
        }
        catch (Exception e) {
            debug.error("Error creating logFailed message", (Throwable)e);
        }
    }

    public void logLogout() {
        try {
            String logLogout = LoginState.ad.bundle.getString("logout");
            ArrayList<String> dataList = new ArrayList<String>();
            dataList.add(logLogout);
            StringBuffer messageId = new StringBuffer();
            messageId.append("LOGOUT");
            if (this.indexType != null) {
                messageId.append("_").append(this.indexType.toString().toUpperCase());
                dataList.add(this.indexType.toString());
                if (this.indexName != null) {
                    dataList.add(this.indexName);
                }
            }
            String[] data = dataList.toArray(new String[0]);
            String contextId = null;
            SSOToken localSSOToken = this.getSSOToken();
            if (localSSOToken != null) {
                contextId = localSSOToken.getProperty("AMCtxId");
            }
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (this.client != null) {
                props.put("IPAddr", this.client);
            }
            if (this.userDN != null) {
                props.put("LoginID", this.userDN);
            }
            if (this.orgDN != null) {
                props.put("Domain", this.orgDN);
            }
            if (this.authMethName != null) {
                props.put("ModuleName", this.authMethName);
            }
            if (this.session != null) {
                props.put("LoginIDSid", this.sid.toString());
            }
            if (contextId != null) {
                props.put("ContextID", contextId);
            }
            ad.logIt(data, 0, messageId.toString(), props);
        }
        catch (Exception e) {
            debug.error("Error creating logout message", (Throwable)e);
        }
    }

    public String getLoginLockoutAttrName() {
        return this.loginLockoutAttrName;
    }

    public String getLoginLockoutAttrValue() {
        return this.loginLockoutAttrValue;
    }

    public long getLoginFailureLockoutDuration() {
        return this.loginFailureLockoutDuration;
    }

    public int getLoginFailureLockoutMultiplier() {
        return this.loginFailureLockoutMultiplier;
    }

    public void setOldSession(InternalSession oldSession) {
        this.oldSession = oldSession;
    }

    public InternalSession getOldSession() {
        return this.oldSession;
    }

    public void setSessionUpgrade(boolean sessionUpgrade) {
        this.sessionUpgrade = sessionUpgrade;
    }

    public boolean isSessionUpgrade() {
        return this.sessionUpgrade;
    }

    void sessionUpgrade() {
        String prevRoleName;
        String prevServiceName;
        if (this.oldSession == null) {
            return;
        }
        this.upgradeAllProperties(this.oldSession);
        int prevAuthLevel = 0;
        String upgradeAuthLevel = null;
        String strPrevAuthLevel = AMAuthUtils.getDataFromRealmQualifiedData(this.oldSession.getProperty("AuthLevel"));
        try {
            prevAuthLevel = Integer.parseInt(strPrevAuthLevel);
        }
        catch (NumberFormatException e) {
            debug.error("AuthLevel from session property bad format");
        }
        if (messageEnabled) {
            debug.message("prevAuthLevel : " + prevAuthLevel);
        }
        upgradeAuthLevel = prevAuthLevel > this.authLevel ? new Integer(prevAuthLevel).toString() : new Integer(this.authLevel).toString();
        if (this.qualifiedOrgDN != null && this.qualifiedOrgDN.length() != 0) {
            upgradeAuthLevel = AMAuthUtils.toRealmQualifiedAuthnData(DNMapper.orgNameToRealmName(this.qualifiedOrgDN), upgradeAuthLevel);
        }
        String upgradeServiceName = prevServiceName = this.oldSession.getProperty("Service");
        String newServiceName = null;
        newServiceName = this.getAuthConfigName(this.indexType, this.indexName);
        if (newServiceName != null && newServiceName.length() != 0) {
            if (this.qualifiedOrgDN != null && this.qualifiedOrgDN.length() != 0) {
                newServiceName = AMAuthUtils.toRealmQualifiedAuthnData(DNMapper.orgNameToRealmName(this.qualifiedOrgDN), newServiceName);
            }
            if (prevServiceName != null) {
                upgradeServiceName = prevServiceName;
                if (newServiceName != null && prevServiceName.indexOf(newServiceName) == -1) {
                    upgradeServiceName = newServiceName + "|" + prevServiceName;
                }
            } else {
                upgradeServiceName = newServiceName;
            }
        }
        String upgradeRoleName = prevRoleName = this.oldSession.getProperty("Role");
        if (this.indexType == AuthContext.IndexType.ROLE) {
            if (prevRoleName != null) {
                upgradeRoleName = prevRoleName;
                if (this.indexName != null && prevRoleName.indexOf(this.indexName) == -1) {
                    upgradeRoleName = this.indexName + "|" + prevRoleName;
                }
            } else {
                upgradeRoleName = this.indexName;
            }
        }
        String prevModuleList = this.oldSession.getProperty("AuthType");
        String newModuleList = this.authMethName;
        if (this.qualifiedOrgDN != null && this.qualifiedOrgDN.length() != 0) {
            newModuleList = this.getRealmQualifiedModulesList(DNMapper.orgNameToRealmName(this.qualifiedOrgDN), this.authMethName);
        }
        if (messageEnabled) {
            debug.message("newModuleList : " + newModuleList);
            debug.message("prevModuleList : " + prevModuleList);
        }
        String upgradeModuleList = null;
        StringBuffer sb = new StringBuffer();
        sb.append(newModuleList);
        upgradeModuleList = prevModuleList != newModuleList ? this.parsePropertyList(prevModuleList, newModuleList) : sb.toString();
        if (messageEnabled) {
            debug.message("oldAuthLevel : " + prevAuthLevel);
            debug.message("newAuthLevel : " + this.authLevel);
            debug.message("upgradeAuthLevel : " + upgradeAuthLevel);
            debug.message("prevServiceName : " + prevServiceName);
            debug.message("upgradeServiceName : " + upgradeServiceName);
            debug.message("preRoleName : " + prevRoleName);
            debug.message("upgradeRoleName : " + upgradeRoleName);
            debug.message("prevModuleList: " + prevModuleList);
            debug.message("newModuleList: " + newModuleList);
            debug.message("upgradeModuleList: " + upgradeModuleList);
        }
        this.updateSessionProperty("AuthLevel", upgradeAuthLevel);
        this.updateSessionProperty("AuthType", upgradeModuleList);
        this.updateSessionProperty("Service", upgradeServiceName);
        this.updateSessionProperty("Role", upgradeRoleName);
        this.session.setIsSessionUpgrade(true);
    }

    void updateSessionProperty(String property, String value) {
        if (value == null) {
            return;
        }
        if (!this.forceAuth) {
            this.session.putProperty(property, value);
        } else {
            this.oldSession.putProperty(property, value);
        }
    }

    String getRealmQualifiedModulesList(String realm, String oldModulesList) {
        if (messageEnabled) {
            debug.message("getRealmQualifiedModulesList:realm : " + realm);
            debug.message("getRealmQualifiedModulesList:oldModulesList : " + oldModulesList);
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(oldModulesList, "|");
        while (st.hasMoreTokens()) {
            String module = st.nextToken();
            sb.append(AMAuthUtils.toRealmQualifiedAuthnData(realm, module)).append("|");
        }
        String realmQualifiedModulesList = sb.toString();
        int i = realmQualifiedModulesList.lastIndexOf("|");
        if (i != -1) {
            realmQualifiedModulesList = realmQualifiedModulesList.substring(0, i);
        }
        if (messageEnabled) {
            debug.message("RealmQualifiedModulesList is : " + realmQualifiedModulesList);
        }
        return realmQualifiedModulesList;
    }

    String parsePropertyList(String oldProperty, String newProperty) {
        if (messageEnabled) {
            debug.message("oldProperty : " + oldProperty);
            debug.message("newProperty : " + newProperty);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(newProperty);
        StringTokenizer st = new StringTokenizer(oldProperty, "|");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (newProperty.indexOf(s) != -1) continue;
            sb.append("|").append(s);
        }
        String propertyList = sb.toString();
        if (messageEnabled) {
            debug.message("propertyList is : " + propertyList);
        }
        return propertyList;
    }

    void upgradeAllProperties(InternalSession oldSession) {
        Enumeration allProperties = oldSession.getPropertyNames();
        while (allProperties.hasMoreElements()) {
            String key = (String)allProperties.nextElement();
            String value = oldSession.getProperty(key);
            this.updateSessionProperty(key, value);
        }
    }

    void setCookieSet(boolean flag) {
        this.cookieSet = flag;
    }

    boolean isCookieSet() {
        return this.cookieSet;
    }

    void setCookieSupported(boolean flag) {
        this.cookieSupported = flag;
    }

    boolean isCookieSupported() {
        return this.cookieSupported;
    }

    void postProcess(AuthContext.IndexType indexType, String indexName, int type) {
        this.setPostLoginInstances(indexType, indexName);
        if (this.postProcessInSession && this.postLoginInstanceSet != null && !this.postLoginInstanceSet.isEmpty()) {
            if (messageEnabled) {
                debug.message("LoginState.setPostLoginInstances : Setting post process class in session " + this.postLoginInstanceSet);
            }
            this.session.setObject("sunAMAuthPostProcessInstanceSet", this.postLoginInstanceSet);
        }
        AMPostAuthProcessInterface postLoginInstance = null;
        if (this.postLoginInstanceSet != null && !this.postLoginInstanceSet.isEmpty()) {
            Iterator iter = this.postLoginInstanceSet.iterator();
            while (iter.hasNext()) {
                postLoginInstance = (AMPostAuthProcessInterface)iter.next();
                this.executePostProcessSPI(postLoginInstance, type);
            }
        }
    }

    void executePostProcessSPI(AMPostAuthProcessInterface postProcessInstance, int type) {
        block10: {
            try {
                switch (type) {
                    case 1: {
                        postProcessInstance.onLoginSuccess(this.requestMap, this.servletRequest, this.servletResponse, this.getSSOToken());
                        break;
                    }
                    case 2: {
                        postProcessInstance.onLoginFailure(this.requestMap, this.servletRequest, this.servletResponse);
                        break;
                    }
                    case 3: {
                        postProcessInstance.onLogout(this.servletRequest, this.servletResponse, this.getSSOToken());
                        break;
                    }
                    default: {
                        if (messageEnabled) {
                            AuthD.debug.message("executePostProcessSPI: invalid input type: " + type);
                        }
                        break;
                    }
                }
            }
            catch (AuthenticationException ae) {
                if (messageEnabled) {
                    AuthD.debug.message("Error ", (Throwable)((Object)ae));
                }
            }
            catch (Exception e) {
                if (!messageEnabled) break block10;
                AuthD.debug.message("Error ", (Throwable)e);
            }
        }
    }

    void setPostLoginInstances(AuthContext.IndexType indexType, String indexName) {
        AMPostAuthProcessInterface postProcessInstance = null;
        String postLoginClassName = null;
        Set postLoginClassSet = Collections.EMPTY_SET;
        if (indexType == AuthContext.IndexType.ROLE) {
            postLoginClassSet = this.getRolePostLoginClassSet();
        } else if (indexType == AuthContext.IndexType.SERVICE) {
            if (indexName.equals("adminconsoleservice")) {
                if (AuthD.revisionNumber >= 30 && this.orgAdminAuthConfig != null && !this.orgAdminAuthConfig.equals("[Empty]")) {
                    postLoginClassSet = this.getServicePostLoginClassSet(this.orgAdminAuthConfig);
                }
            } else {
                postLoginClassSet = this.getServicePostLoginClassSet(indexName);
            }
        } else if (indexType == AuthContext.IndexType.USER && AuthD.revisionNumber >= 30 && this.userAuthConfig != null && !this.userAuthConfig.equals("[Empty]")) {
            postLoginClassSet = this.getServicePostLoginClassSet(this.userAuthConfig);
        }
        if ((postLoginClassSet == null || postLoginClassSet.isEmpty()) && this.orgPostLoginClassSet != null && !this.orgPostLoginClassSet.isEmpty()) {
            postLoginClassSet = this.orgPostLoginClassSet;
        } else if (AuthD.revisionNumber >= 30 && indexType == null && this.orgAuthConfig != null && !this.orgAuthConfig.equals("[Empty]")) {
            postLoginClassSet = this.getServicePostLoginClassSet(this.orgAuthConfig);
        }
        if (messageEnabled) {
            debug.message("postLoginClassSet = " + postLoginClassSet);
        }
        if (postLoginClassSet != null && !postLoginClassSet.isEmpty()) {
            this.postLoginInstanceSet = new HashSet();
            StringBuffer sb = new StringBuffer();
            Iterator iter = postLoginClassSet.iterator();
            while (iter.hasNext()) {
                postLoginClassName = (String)iter.next();
                if (sb.length() > 0) {
                    sb.append("|");
                }
                if (messageEnabled) {
                    debug.message("setPostLoginInstances : " + postLoginClassName);
                    debug.message("setPostLoginInstances : " + postLoginClassSet.size());
                }
                if ((postProcessInstance = this.getPostLoginProcessInstance(postLoginClassName)) == null) continue;
                this.postLoginInstanceSet.add(postProcessInstance);
                sb.append(postLoginClassName);
            }
            this.session.putProperty("PostAuthProcessInstance", sb.toString());
        }
    }

    Set getRolePostLoginClassSet() {
        Set postLoginClassSet;
        block4: {
            postLoginClassSet = null;
            try {
                Map roleAttrMap = this.getRoleServiceAttributes();
                postLoginClassSet = (Set)roleAttrMap.get("iplanet-am-auth-post-login-process-class");
                if (postLoginClassSet == null) {
                    postLoginClassSet = Collections.EMPTY_SET;
                }
                if (messageEnabled) {
                    debug.message("Role Post Login Class Set : " + postLoginClassSet);
                }
            }
            catch (Exception e) {
                if (!messageEnabled) break block4;
                debug.message("Error get role class set ", (Throwable)e);
            }
        }
        return postLoginClassSet;
    }

    Set getServicePostLoginClassSet(String indexName) {
        Set postLoginClassSet;
        block6: {
            postLoginClassSet = null;
            try {
                if (this.serviceAttributesMap != null && this.serviceAttributesMap.isEmpty()) {
                    this.serviceAttributesMap = this.getServiceAttributes(indexName);
                }
                if (messageEnabled) {
                    debug.message("Service Attributes are . :" + this.serviceAttributesMap);
                }
                if ((postLoginClassSet = (Set)this.serviceAttributesMap.get("iplanet-am-auth-post-login-process-class")) == null) {
                    postLoginClassSet = Collections.EMPTY_SET;
                }
                if (messageEnabled) {
                    debug.message("postLoginClassName: " + postLoginClassSet);
                }
            }
            catch (Exception e) {
                if (!messageEnabled) break block6;
                debug.message("Error get service post login class name " + e.getMessage());
            }
        }
        return postLoginClassSet;
    }

    void setModuleErrorMessage(String message) {
        this.moduleErrorMessage = message;
    }

    public String getModuleErrorMessage() {
        return this.moduleErrorMessage;
    }

    public String getLoginURL() {
        return this.loginURL;
    }

    public boolean isForwardSuccess() {
        return this.forwardSuccess;
    }

    public synchronized void setPageTimeOut(long pageTimeOut) {
        if (messageEnabled) {
            debug.message("Setting page timeout :" + pageTimeOut);
        }
        this.pageTimeOut = pageTimeOut;
    }

    public long getPageTimeOut() {
        if (messageEnabled) {
            debug.message("Returning page timeout :" + this.pageTimeOut);
        }
        return this.pageTimeOut;
    }

    public void setLastCallbackSent(long lastCallbackSent) {
        if (messageEnabled) {
            debug.message("setting Last Callback Sent :" + lastCallbackSent);
        }
        this.lastCallbackSent = lastCallbackSent;
    }

    public long getLastCallbackSent() {
        if (messageEnabled) {
            debug.message("Returning Last Callback Sent :" + this.lastCallbackSent);
        }
        return this.lastCallbackSent;
    }

    private String getRedirectUrl(Set urls) {
        String clientURL = null;
        this.tempDefaultURL = null;
        if (urls != null && !urls.isEmpty()) {
            String defaultURL = null;
            Iterator iter = urls.iterator();
            while (iter.hasNext()) {
                String url = (String)iter.next();
                if (messageEnabled) {
                    debug.message("URL is : " + url);
                }
                if (url == null || url.length() <= 0) continue;
                int i = url.indexOf("|");
                if (i != -1) {
                    if (clientURL != null) continue;
                    clientURL = AuthUtils.getClientURLFromString(url, i, this.servletRequest);
                    continue;
                }
                if (defaultURL != null && defaultURL.length() != 0) continue;
                defaultURL = url;
            }
            this.tempDefaultURL = defaultURL;
            if (messageEnabled) {
                debug.message("defaultURL : " + defaultURL);
                debug.message("tempDefaultURL : " + this.tempDefaultURL);
            }
        }
        return clientURL;
    }

    public boolean ignoreProfile() {
        return this.ignoreUserProfile;
    }

    boolean containsToken(StringBuffer principalBuffer, String token) {
        block5: {
            String principalString = principalBuffer.toString();
            if (debug.messageEnabled()) {
                debug.message("principalString : " + principalString);
            }
            if (principalString == null) {
                return false;
            }
            try {
                StringTokenizer st = new StringTokenizer(principalString, "|");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    if (!s.equals(token)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                if (!debug.warningEnabled()) break block5;
                debug.warning("getToken: ", (Throwable)e);
            }
        }
        return false;
    }

    private Set mergeSet(Set set1, Set set2) {
        if (set1 == null || set1.isEmpty()) {
            if (set2 == null || set2.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            return set2;
        }
        if (set2 == null || set2.isEmpty()) {
            return set1;
        }
        HashSet returnSet = new HashSet(set1);
        returnSet.addAll(set2);
        return returnSet;
    }

    private Map toAvPairMap(Set names, String token) {
        if (token == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap map = new HashMap();
        HashSet<String> set = new HashSet<String>();
        set.add(token);
        if (names == null || names.isEmpty()) {
            return map;
        }
        Iterator it = names.iterator();
        while (it.hasNext()) {
            map.put((String)it.next(), set);
        }
        return map;
    }

    public void setFailedUserId(String userID) {
        if (messageEnabled) {
            debug.message("setting userID : " + userID);
        }
        this.failureTokenId = userID;
    }

    void updateSessionForFailover() {
        InternalSession intSess = this.getSession();
        intSess.setIsISStored(true);
    }

    public Callback[] getCallbacksPerState(String pageState) {
        Callback[] rtnCallbacks = null;
        rtnCallbacks = (Callback[])this.callbacksPerState.get(pageState);
        return rtnCallbacks;
    }

    public void setCallbacksPerState(String pageState, Callback[] callbacks) {
        this.callbacksPerState.put(pageState, callbacks);
    }

    public void setPCookieUserName(String indexName) {
        this.pCookieUserName = indexName;
        if (messageEnabled) {
            debug.message("Setting Pcookie user name : " + this.pCookieUserName);
        }
    }

    public void setCookieDetect(boolean cookieDetect) {
        this.cookieDetect = cookieDetect;
    }

    public boolean isCookieDetect() {
        return this.cookieDetect;
    }

    private Subject addSSOTokenPrincipal(Subject subject) {
        if (subject == null) {
            subject = new Subject();
        }
        String sidStr = this.sid.toString();
        if (messageEnabled) {
            debug.message("sid string is.. " + sidStr);
        }
        SSOTokenPrincipal ssoTokenPrincipal = new SSOTokenPrincipal(sidStr);
        subject.getPrincipals().add(ssoTokenPrincipal);
        if (messageEnabled) {
            debug.message("Subject is.. :" + subject);
        }
        return subject;
    }

    public void setUserCreationAttributes(Map attributeValuePairs) {
        if (messageEnabled) {
            debug.message("attributeValuePairs : " + attributeValuePairs);
        }
        if (attributeValuePairs != null && !attributeValuePairs.isEmpty()) {
            if (this.userCreationAttributes == null) {
                this.userCreationAttributes = new HashMap();
            }
            if (attributeValuePairs.containsKey("iplanet-am-user-alias-list")) {
                this.externalAliasList = (HashSet)attributeValuePairs.get("iplanet-am-user-alias-list");
                if (messageEnabled) {
                    debug.message("externalAliasList:" + this.externalAliasList);
                }
                attributeValuePairs.remove("iplanet-am-user-alias-list");
            }
            this.userCreationAttributes.putAll(attributeValuePairs);
        }
    }

    public void setSuccessModuleName(String moduleName) {
        this.successModuleSet.add(moduleName);
        if (messageEnabled) {
            debug.message("Module name is .. " + moduleName);
            debug.message("successModuleSet is : " + this.successModuleSet);
        }
    }

    protected Set getSuccessModuleSet() {
        if (messageEnabled) {
            debug.message("getSuccessModuleSet : " + this.successModuleSet);
        }
        return this.successModuleSet;
    }

    private boolean isApplicationModule(String moduleName) {
        boolean isApp = moduleName != null && moduleName.equalsIgnoreCase("Application");
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("is Application Module : " + isApp);
        }
        return isApp;
    }

    public void setFailureModuleName(String moduleName) {
        this.failureModuleSet.add(moduleName);
        if (messageEnabled) {
            debug.message("Module name is .. " + moduleName);
            debug.message("failureModuleSet is : " + this.failureModuleSet);
        }
    }

    public Set getFailureModuleSet() {
        return this.failureModuleSet;
    }

    public void setFailureModuleList(String failureModuleList) {
        this.failureModuleList = failureModuleList;
        if (messageEnabled) {
            debug.message("failureModulelist :" + failureModuleList);
        }
    }

    public boolean isAgent(AMIdentity amIdentityUser) {
        boolean isAgent;
        block3: {
            isAgent = false;
            try {
                if (amIdentityUser != null && amIdentityUser.getType().equals(IdType.AGENT)) {
                    isAgent = true;
                    debug.message("user is of type 'Agent'");
                }
            }
            catch (Exception e) {
                if (!messageEnabled) break block3;
                debug.message("Error isAgent : " + e.toString());
            }
        }
        return isAgent;
    }

    protected void setModuleMap(Map moduleMap) {
        this.moduleMap = moduleMap;
    }

    protected String getModuleName(String localizedModuleName) {
        return (String)this.moduleMap.get(localizedModuleName);
    }

    public void nullifyUsedVars() {
        this.receivedCallbackInfo = null;
        this.prevCallback = null;
        this.submittedCallbackInfo = null;
        this.callbacksPerState = null;
        this.requestHash = null;
        this.aliasAttrNames = null;
        this.defaultRoles = null;
        this.token = null;
        this.tokenSet = null;
        this.prevIndexType = null;
        this.userAliasList = null;
        Object requestMap = null;
        this.accountLife = null;
        this.loginLockoutNotification = null;
        this.loginLockoutAttrName = null;
        this.loginLockoutAttrValue = null;
        this.lockoutMsg = null;
        this.principalList = null;
        this.cert = null;
        this.userCreationAttributes = null;
        this.externalAliasList = null;
        this.failureModuleSet = null;
        this.failureModuleList = "";
        this.moduleMap = null;
        if (!this.persistentCookieOn || !this.persistentCookieMode || this.foundPCookie != null && !this.foundPCookie.booleanValue()) {
            this.userContainerDN = null;
            this.userNamingAttr = null;
        }
    }

    public void setRequestLocale(HttpServletRequest request) {
        this.localeContext.setLocale(request);
        this.isLocaleSet = true;
    }

    public boolean isSessionInvalid() {
        return this.session == null || this.session.getState() == 0 || this.session.getState() == 3;
    }

    public AMIdentity getRole(String roleName) throws AuthException {
        try {
            this.amIdentityRole = ad.getIdentity(IdType.ROLE, roleName, this.getOrgDN());
        }
        catch (AuthException ae) {
            debug.message("role not found or is not a static role");
        }
        if (this.amIdentityRole == null) {
            this.amIdentityRole = ad.getIdentity(IdType.FILTEREDROLE, roleName, this.getOrgDN());
        }
        return this.amIdentityRole;
    }

    public String getRoleUniversalId(String roleName) {
        String roleUnivId;
        block2: {
            roleUnivId = null;
            try {
                AMIdentity amIdentity = this.getRole(roleName);
                roleUnivId = IdUtils.getUniversalId(amIdentity);
            }
            catch (Exception ae) {
                if (!messageEnabled) break block2;
                debug.message("Error getting role : " + ae.getMessage());
            }
        }
        return roleUnivId;
    }

    public String getUserDN(AMIdentity amIdentityUser) {
        String returnUserDN = null;
        if (this.principalList != null) {
            if (this.principalList.indexOf("|") != -1) {
                StringTokenizer st = new StringTokenizer(this.principalList, "|");
                while (st.hasMoreTokens()) {
                    String sToken = st.nextToken();
                    if (!DN.isDN((String)sToken)) continue;
                    returnUserDN = sToken;
                    break;
                }
            } else if (DN.isDN((String)this.principalList)) {
                returnUserDN = this.principalList;
            }
        }
        if (returnUserDN == null || returnUserDN.length() == 0) {
            returnUserDN = amIdentityUser != null ? IdUtils.getDN(amIdentityUser) : (this.userDN != null ? this.userDN : this.tokenToDN(this.principalList));
        }
        return returnUserDN;
    }

    void getContainerDN(Set containerDNs) throws AuthException {
        String userOrgDN = null;
        String agentContainerDN = null;
        if (containerDNs == null || containerDNs.isEmpty()) {
            debug.message("Container DNs is null");
            this.nullUserContainerDN = true;
        } else {
            Iterator it = containerDNs.iterator();
            while (it.hasNext()) {
                String containerName = (String)it.next();
                try {
                    if (Misc.isDescendantOf(containerName, this.getOrgDN())) {
                        int containerType = ad.getSDK().getAMObjectType(containerName);
                        if (messageEnabled) {
                            debug.message("Container Type = " + containerType);
                            debug.message("Container Name = " + containerName);
                        }
                        if (containerType == 3 && agentContainerDN == null) {
                            agentContainerDN = containerName;
                            this.identityTypes.add("agent");
                        } else if (containerType == 2 && userOrgDN == null) {
                            userOrgDN = containerName;
                            this.identityTypes.add("agent");
                            this.identityTypes.add("user");
                        } else if (containerType == 5 && this.userContainerDN == null) {
                            this.userContainerDN = containerName;
                            this.identityTypes.add("user");
                        }
                    }
                    if (this.userContainerDN == null || agentContainerDN == null || userOrgDN == null) continue;
                    break;
                }
                catch (Exception e) {
                    debug.error("Container - " + containerName + " is INVALID :- ", (Throwable)e);
                }
            }
        }
        if (this.userContainerDN == null) {
            try {
                this.userContainerDN = AMStoreConnection.getNamingAttribute(5) + "=" + AdminInterfaceUtils.defaultPeopleContainerName() + "," + this.getOrgDN();
                this.identityTypes.add("user");
            }
            catch (AMException aec) {
                debug.message("Cannot get userContainer DN");
            }
        }
        if (this.userContainerDN == null && agentContainerDN == null) {
            debug.message("No Valid Container in the list");
            throw new AuthException("102", null);
        }
        if (messageEnabled) {
            debug.message("agentContainerDN = " + agentContainerDN);
            debug.message("userContainerDN = " + this.userContainerDN);
            debug.message("userOrgDN set in PC atrr = " + userOrgDN);
        }
    }

    IdSearchResults searchIdentity(IdType idType, String userTokenID) throws IdRepoException, SSOException {
        IdSearchResults searchResults;
        block19: {
            Set result;
            IdSearchControl idsc;
            boolean isRecursive;
            Map avPairs;
            String pattern;
            int maxTime;
            int maxResults;
            Set returnSet;
            block18: {
                if (messageEnabled) {
                    debug.message("In searchAutehnticatedUser: idType " + idType);
                    debug.message("In getUserProfile : Search for user " + userTokenID);
                }
                searchResults = null;
                returnSet = this.mergeSet(this.aliasAttrNames, userAttributes);
                maxResults = 2;
                maxTime = 0;
                pattern = null;
                avPairs = null;
                isRecursive = true;
                idsc = new IdSearchControl();
                idsc.setRecursive(isRecursive);
                idsc.setTimeOut(maxTime);
                idsc.setAllReturnAttributes(true);
                if (messageEnabled) {
                    debug.message("alias attr=" + this.aliasAttrNames + ", attr=" + userAttributes + ",merge=" + returnSet);
                }
                if (messageEnabled) {
                    debug.message("Search for Identity " + userTokenID);
                }
                result = Collections.EMPTY_SET;
                try {
                    idsc.setMaxResults(0);
                    searchResults = this.amIdRepo.searchIdentities(idType, userTokenID, idsc);
                    if (searchResults != null) {
                        result = searchResults.getSearchResults();
                    }
                }
                catch (SSOException sso) {
                    if (messageEnabled) {
                        debug.message("SSOException Error searching Identity  with username " + sso.getMessage());
                    }
                }
                catch (IdRepoException e) {
                    if (!messageEnabled) break block18;
                    debug.message("IdRepoException : Error searching  Identities with username : " + e.getMessage());
                }
            }
            if (result.isEmpty() && this.aliasAttrNames != null && !this.aliasAttrNames.isEmpty()) {
                if (messageEnabled) {
                    debug.message("No identity found, try Alias attrname.");
                }
                pattern = "*";
                avPairs = this.toAvPairMap(this.aliasAttrNames, userTokenID);
                if (messageEnabled) {
                    debug.message("Search for Filter (avPairs) :" + avPairs);
                    debug.message("userTokenID : " + userTokenID);
                    debug.message("userDN : " + this.userDN);
                    debug.message("idType :" + idType);
                    debug.message("pattern :" + pattern);
                    debug.message("isRecursive :" + isRecursive);
                    debug.message("maxResults :" + maxResults);
                    debug.message("maxTime :" + maxTime);
                    debug.message("returnSet :" + returnSet);
                }
                Set resultAlias = Collections.EMPTY_SET;
                try {
                    idsc.setMaxResults(maxResults);
                    idsc.setSearchModifiers(IdSearchOpModifier.OR, avPairs);
                    searchResults = this.amIdRepo.searchIdentities(idType, pattern, idsc);
                    if (searchResults != null) {
                        resultAlias = searchResults.getSearchResults();
                    }
                    if (resultAlias.isEmpty() && this.userDN != null && !this.userDN.equalsIgnoreCase(userTokenID)) {
                        avPairs = this.toAvPairMap(this.aliasAttrNames, this.userDN);
                        if (messageEnabled) {
                            debug.message("Search for Filter (avPairs) with userDN : " + avPairs);
                        }
                        idsc.setMaxResults(maxResults);
                        idsc.setSearchModifiers(IdSearchOpModifier.OR, avPairs);
                        searchResults = this.amIdRepo.searchIdentities(idType, pattern, idsc);
                    }
                }
                catch (SSOException sso) {
                    if (messageEnabled) {
                        debug.message("SSOException : Error searching Identities with aliasattrname : " + sso.getMessage());
                    }
                }
                catch (IdRepoException e) {
                    if (!messageEnabled) break block19;
                    debug.message("IdRepoException : Error searching Identities : " + e.getMessage());
                }
            }
        }
        return searchResults;
    }

    public AMIdentity createUserIdentity(String userName, Map userAttributes, Set userRoles) throws IdRepoException, SSOException {
        AMIdentity amIdentityUser = this.amIdRepo.createIdentity(IdType.USER, userName, userAttributes);
        if (userRoles != null && !userRoles.isEmpty()) {
            Iterator iter = userRoles.iterator();
            while (iter.hasNext()) {
                String trole = (String)iter.next();
                try {
                    if (trole.length() == 0) continue;
                    this.amIdentityRole = this.getRole(trole);
                    this.amIdentityRole.addMember(amIdentityUser);
                }
                catch (Exception e) {
                    debug.message("createUserProfile():invalid role: ", (Throwable)e);
                }
            }
        }
        return amIdentityUser;
    }

    public String getUserUniversalId(String userName) {
        AMIdentity amIdUser = this.amIdentityUser;
        String universalId = null;
        try {
            if (amIdUser == null) {
                amIdUser = ad.getIdentity(IdType.USER, userName, this.getOrgDN());
            }
            universalId = IdUtils.getUniversalId(this.amIdentityUser);
        }
        catch (Exception e) {
            debug.message("Error getting Identity for user :" + e.getMessage());
        }
        if (messageEnabled) {
            debug.message("getUserUniversalId:universalId : " + universalId);
        }
        return universalId;
    }

    public void setCompositeAdviceType(int type) {
        this.compositeAdviceType = type;
    }

    public int getCompositeAdviceType() {
        return this.compositeAdviceType;
    }

    public void setCompositeAdvice(String compositeAdvice) {
        this.compositeAdvice = compositeAdvice;
    }

    public String getCompositeAdvice() {
        return this.compositeAdvice;
    }

    public void setQualifiedOrgDN(String qualifiedOrgDN) {
        this.qualifiedOrgDN = qualifiedOrgDN;
    }

    String getAuthConfigName(AuthContext.IndexType indexType, String indexName) {
        String finalAuthConfigName = null;
        if (indexType == AuthContext.IndexType.ROLE) {
            finalAuthConfigName = this.roleAuthConfig;
        } else if (indexType == AuthContext.IndexType.SERVICE) {
            if (indexName.equals("adminconsoleservice")) {
                if (AuthD.revisionNumber >= 30 && this.orgAdminAuthConfig != null && !this.orgAdminAuthConfig.equals("[Empty]")) {
                    finalAuthConfigName = this.orgAdminAuthConfig;
                }
            } else {
                finalAuthConfigName = indexName;
            }
        } else if (indexType == AuthContext.IndexType.USER && AuthD.revisionNumber >= 30) {
            if (this.userAuthConfig != null && !this.userAuthConfig.equals("[Empty]")) {
                finalAuthConfigName = this.userAuthConfig;
            }
        } else if (AuthD.revisionNumber >= 30 && indexType == null && this.orgAuthConfig != null && !this.orgAuthConfig.equals("[Empty]")) {
            finalAuthConfigName = this.orgAuthConfig;
        }
        if (messageEnabled) {
            debug.message("getAuthConfigName:finalAuthConfigName = " + finalAuthConfigName);
        }
        return finalAuthConfigName;
    }

    static {
        serverURL = null;
        userAttributes.add("iplanet-am-auth-login-success-url");
        userAttributes.add("iplanet-am-auth-login-failure-url");
        userAttributes.add("iplanet-am-user-alias-list");
        userAttributes.add("iplanet-am-session-max-session-time");
        userAttributes.add("iplanet-am-session-max-idle-time");
        userAttributes.add("iplanet-am-session-max-caching-time");
        userAttributes.add("inetuserstatus");
        userAttributes.add("nsaccountlock");
        userAttributes.add("preferredlocale");
        userAttributes.add("iplanet-am-user-login-status");
        userAttributes.add("iplanet-am-user-account-life");
        userAttributes.add("iplanet-am-user-success-url");
        userAttributes.add("iplanet-am-user-failure-url");
        userAttributes.add("iplanet-am-auth-post-login-process-class");
        messageEnabled = debug.messageEnabled();
        String proto = SystemProperties.get("com.iplanet.distAuth.server.protocol");
        String host = null;
        String port = null;
        if (proto != null && proto.length() != 0) {
            host = SystemProperties.get("com.iplanet.distAuth.server.host");
            port = SystemProperties.get("com.iplanet.distAuth.server.port");
        } else {
            proto = SystemProperties.get("com.iplanet.am.server.protocol");
            host = SystemProperties.get("com.iplanet.am.server.host");
            port = SystemProperties.get("com.iplanet.am.server.port");
        }
        serverURL = proto + "://" + host + ":" + port;
    }
}

