/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IDefinition;
import com.sun.identity.cli.SubCommand;
import com.sun.identity.cli.stubs.ICLIStub;
import com.sun.identity.cli.stubs.SubCommandStub;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public abstract class CLIDefinitionBase
implements IDefinition {
    private List subCommands = new ArrayList();
    private String definitionClass;
    private String logName;
    protected ResourceBundle rb;

    public CLIDefinitionBase(String definitionClass) throws CLIException {
        this.definitionClass = definitionClass;
        ICLIStub defObject = this.getDefinitionObject();
        this.rb = ResourceBundle.getBundle(defObject.getResourceBundleName());
        this.logName = defObject.getLogName();
        this.getCommands(defObject);
    }

    private ICLIStub getDefinitionObject() throws CLIException {
        try {
            Class<?> clazz = Class.forName(this.definitionClass);
            return (ICLIStub)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CLIException(e, 4);
        }
        catch (IllegalAccessException e) {
            throw new CLIException(e, 7);
        }
        catch (InstantiationException e) {
            throw new CLIException(e, 7);
        }
    }

    private void getCommands(ICLIStub defObject) throws CLIException {
        List subCommandStubs = defObject.getSubCommandStubs();
        Iterator i = subCommandStubs.iterator();
        while (i.hasNext()) {
            SubCommandStub stub = (SubCommandStub)i.next();
            String subcmdName = stub.name;
            subcmdName = subcmdName.replace('_', '-');
            this.subCommands.add(new SubCommand(this, this.rb, subcmdName, stub.mandatoryOptions, stub.optionalOptions, stub.aliasOptions, stub.implClassName, stub.webSupport));
        }
    }

    public List getSubCommands() {
        return this.subCommands;
    }

    public String getLogName() {
        return this.logName;
    }

    public SubCommand getSubCommand(String name) {
        SubCommand result = null;
        Iterator i = this.subCommands.iterator();
        while (i.hasNext() && result == null) {
            SubCommand cmd = (SubCommand)i.next();
            if (!cmd.getName().equals(name)) continue;
            result = cmd;
        }
        return result;
    }
}

